/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.classindex;

import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.NotImplementedException;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.Transaction;
import com.db4o.internal.TransactionParticipant;
import com.db4o.internal.TreeInt;
import com.db4o.internal.classindex.AbstractClassIndexStrategy;
import com.db4o.internal.classindex.ClassIndex;
import com.db4o.internal.classindex.ClassIndexClient;

public class OldClassIndexStrategy
extends AbstractClassIndexStrategy
implements TransactionParticipant {
    private ClassIndex _index;
    private final Hashtable4 _perTransaction = new Hashtable4();

    public OldClassIndexStrategy(ClassMetadata yapClass) {
        super(yapClass);
    }

    @Override
    public void read(ObjectContainerBase stream, int indexID) {
        this._index = this.createClassIndex(stream);
        if (indexID > 0) {
            this._index.setID(indexID);
        }
        this._index.setStateDeactivated();
    }

    private ClassIndex getActiveIndex(Transaction transaction) {
        if (null != this._index) {
            this._index.ensureActive(transaction);
        }
        return this._index;
    }

    @Override
    public int entryCount(Transaction transaction) {
        if (this._index != null) {
            return this._index.entryCount(transaction);
        }
        return 0;
    }

    @Override
    public void initialize(ObjectContainerBase stream) {
        this._index = this.createClassIndex(stream);
    }

    @Override
    public void purge() {
        if (this._index != null && !this._index.isDirty()) {
            this._index.clear();
            this._index.setStateDeactivated();
        }
    }

    @Override
    public int write(Transaction transaction) {
        if (this._index == null) {
            return 0;
        }
        this._index.write(transaction);
        return this._index.getID();
    }

    private void flushContext(final Transaction transaction) {
        TransactionState context = this.getState(transaction);
        final ClassIndex index = this.getActiveIndex(transaction);
        context.traverseAdded(new Visitor4(){

            @Override
            public void visit(Object a_object) {
                index.add(OldClassIndexStrategy.this.idFromValue(a_object));
            }
        });
        context.traverseRemoved(new Visitor4(){

            @Override
            public void visit(Object a_object) {
                int id = OldClassIndexStrategy.this.idFromValue(a_object);
                ObjectReference yo = transaction.referenceForId(id);
                if (yo != null) {
                    transaction.removeReference(yo);
                }
                index.remove(id);
            }
        });
    }

    private void writeIndex(Transaction transaction) {
        this._index.setStateDirty();
        this._index.write(transaction);
    }

    @Override
    protected void internalAdd(Transaction transaction, int id) {
        this.getState(transaction).add(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionState getState(Transaction transaction) {
        Hashtable4 hashtable4 = this._perTransaction;
        synchronized (hashtable4) {
            TransactionState context = (TransactionState)this._perTransaction.get(transaction);
            if (null == context) {
                context = new TransactionState();
                this._perTransaction.put(transaction, (Object)context);
                ((LocalTransaction)transaction).enlist(this);
            }
            return context;
        }
    }

    private Tree getAll(Transaction transaction) {
        ClassIndex ci = this.getActiveIndex(transaction);
        if (ci == null) {
            return null;
        }
        final Tree.ByRef tree = new Tree.ByRef(Tree.deepClone(ci.getRoot(), null));
        TransactionState context = this.getState(transaction);
        context.traverseAdded(new Visitor4(){

            @Override
            public void visit(Object obj) {
                tree.value = Tree.add(tree.value, new TreeInt(OldClassIndexStrategy.this.idFromValue(obj)));
            }
        });
        context.traverseRemoved(new Visitor4(){

            @Override
            public void visit(Object obj) {
                tree.value = Tree.removeLike(tree.value, (TreeInt)obj);
            }
        });
        return tree.value;
    }

    @Override
    protected void internalRemove(Transaction transaction, int id) {
        this.getState(transaction).remove(id);
    }

    @Override
    public void traverseAll(Transaction transaction, final Visitor4 command) {
        Tree tree = this.getAll(transaction);
        if (tree != null) {
            tree.traverse(new Visitor4(){

                @Override
                public void visit(Object obj) {
                    command.visit(new Integer(OldClassIndexStrategy.this.idFromValue(obj)));
                }
            });
        }
    }

    public int idFromValue(Object value) {
        return ((TreeInt)value)._key;
    }

    private ClassIndex createClassIndex(ObjectContainerBase stream) {
        if (stream.isClient()) {
            return new ClassIndexClient(this._yapClass);
        }
        return new ClassIndex(this._yapClass);
    }

    @Override
    public void dontDelete(Transaction transaction, int id) {
        this.getState(transaction).dontDelete(id);
    }

    @Override
    public void commit(Transaction trans) {
        if (null != this._index) {
            this.flushContext(trans);
            this.writeIndex(trans);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(Transaction transaction) {
        Hashtable4 hashtable4 = this._perTransaction;
        synchronized (hashtable4) {
            this._perTransaction.remove(transaction);
        }
    }

    @Override
    public void rollback(Transaction transaction) {
    }

    @Override
    public void defragReference(ClassMetadata yapClass, DefragmentContextImpl context, int classIndexID) {
    }

    @Override
    public int id() {
        return this._index.getID();
    }

    @Override
    public Iterator4 allSlotIDs(Transaction trans) {
        throw new NotImplementedException();
    }

    @Override
    public void defragIndex(DefragmentContextImpl context) {
    }

    static final class TransactionState {
        private Tree i_addToClassIndex;
        private Tree i_removeFromClassIndex;

        TransactionState() {
        }

        public void add(int id) {
            this.i_removeFromClassIndex = Tree.removeLike(this.i_removeFromClassIndex, new TreeInt(id));
            this.i_addToClassIndex = Tree.add(this.i_addToClassIndex, new TreeInt(id));
        }

        public void remove(int id) {
            this.i_addToClassIndex = Tree.removeLike(this.i_addToClassIndex, new TreeInt(id));
            this.i_removeFromClassIndex = Tree.add(this.i_removeFromClassIndex, new TreeInt(id));
        }

        public void dontDelete(int id) {
            this.i_removeFromClassIndex = Tree.removeLike(this.i_removeFromClassIndex, new TreeInt(id));
        }

        void traverse(Tree node, Visitor4 visitor) {
            if (node != null) {
                node.traverse(visitor);
            }
        }

        public void traverseAdded(Visitor4 visitor4) {
            this.traverse(this.i_addToClassIndex, visitor4);
        }

        public void traverseRemoved(Visitor4 visitor4) {
            this.traverse(this.i_removeFromClassIndex, visitor4);
        }
    }
}

