/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.async.SplitFileSegmentKeys;
import freenet.keys.NodeCHK;
import freenet.support.Logger;
import freenet.support.io.StorageFormatException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;

public class SimpleBlockChooser {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private final int blocks;
    private final boolean[] completed;
    private int completedCount;
    private final int[] retries;
    protected final int maxRetries;
    private final Random random;
    static final int VERSION = 1;

    public SimpleBlockChooser(int blocks, Random random, int maxRetries) {
        this.maxRetries = maxRetries;
        this.blocks = blocks;
        this.random = random;
        this.completed = new boolean[blocks];
        this.retries = new int[blocks];
    }

    public synchronized int chooseKey() {
        int max = this.getMaxBlockNumber();
        int[] candidates = new int[max];
        int count = 0;
        int minRetryCount = Integer.MAX_VALUE;
        for (int i = 0; i < max; ++i) {
            int retry = this.retries[i];
            if (retry > this.maxRetries && this.maxRetries != -1 || retry > minRetryCount || !this.checkValid(i)) continue;
            if (retry < minRetryCount) {
                count = 0;
                candidates[count++] = i;
                minRetryCount = retry;
                continue;
            }
            if (retry != minRetryCount) continue;
            candidates[count++] = i;
        }
        if (count == 0) {
            return -1;
        }
        return candidates[this.random.nextInt(count)];
    }

    public boolean onNonFatalFailure(int blockNo) {
        return this.isFatalRetries(this.innerOnNonFatalFailure(blockNo));
    }

    private boolean isFatalRetries(int retries) {
        if (this.maxRetries == -1) {
            return false;
        }
        return retries > this.maxRetries;
    }

    protected synchronized int innerOnNonFatalFailure(int blockNo) {
        int n = blockNo;
        int n2 = this.retries[n] + 1;
        this.retries[n] = n2;
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onSuccess(int blockNo) {
        SimpleBlockChooser simpleBlockChooser = this;
        synchronized (simpleBlockChooser) {
            if (this.completed[blockNo]) {
                return false;
            }
            this.completed[blockNo] = true;
            ++this.completedCount;
            if (this.completedCount < this.blocks) {
                if (logMINOR) {
                    Logger.minor(this, "Completed blocks: " + this.completedCount + "/" + this.blocks);
                }
                return true;
            }
        }
        this.onCompletedAll();
        return true;
    }

    public synchronized void onUnSuccess(int blockNo) {
        if (!this.completed[blockNo]) {
            return;
        }
        this.completed[blockNo] = false;
        --this.completedCount;
    }

    protected void onCompletedAll() {
    }

    protected boolean checkValid(int chosen) {
        return !this.completed[chosen];
    }

    protected int getMaxBlockNumber() {
        return this.blocks;
    }

    public synchronized void replaceSuccesses(boolean[] used) {
        for (int i = 0; i < this.blocks; ++i) {
            if (used[i] && !this.completed[i]) {
                this.onSuccess(i);
                continue;
            }
            if (used[i] || !this.completed[i]) continue;
            this.onUnSuccess(i);
        }
    }

    public synchronized int successCount() {
        return this.completedCount;
    }

    public synchronized int getRetries(int blockNumber) {
        return this.retries[blockNumber];
    }

    public synchronized int getBlockNumber(SplitFileSegmentKeys keys, NodeCHK key) {
        return keys.getBlockNumber(key, this.completed);
    }

    public synchronized boolean hasSucceeded(int blockNumber) {
        return this.completed[blockNumber];
    }

    public void writeRetries(DataOutputStream dos) throws IOException {
        if (this.maxRetries == -1) {
            return;
        }
        for (int retry : this.retries) {
            dos.writeInt(retry);
        }
    }

    public void readRetries(DataInputStream dis) throws IOException {
        if (this.maxRetries == -1) {
            return;
        }
        for (int i = 0; i < this.blocks; ++i) {
            this.retries[i] = dis.readInt();
        }
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeInt(1);
        for (boolean b : this.completed) {
            dos.writeBoolean(b);
        }
        dos.writeInt(this.maxRetries);
        this.writeRetries(dos);
    }

    public void read(DataInputStream dis) throws StorageFormatException, IOException {
        if (dis.readInt() != 1) {
            throw new StorageFormatException("Bad version in block chooser");
        }
        for (int i = 0; i < this.completed.length; ++i) {
            this.completed[i] = dis.readBoolean();
            if (!this.completed[i]) continue;
            ++this.completedCount;
        }
        if (dis.readInt() != this.maxRetries) {
            throw new StorageFormatException("Max retries has changed");
        }
        this.readRetries(dis);
    }

    public synchronized int countFailedBlocks() {
        if (this.maxRetries == -1) {
            return 0;
        }
        int total = 0;
        for (int i = 0; i < this.retries.length; ++i) {
            if (this.completed[i] || this.retries[i] <= this.maxRetries) continue;
            ++total;
        }
        return total;
    }

    public synchronized boolean[] copyDownloadedBlocks() {
        return (boolean[])this.completed.clone();
    }

    public synchronized int countFetchable() {
        int x = 0;
        for (int i = 0; i < this.blocks; ++i) {
            if (this.retries[x] >= this.maxRetries || !this.checkValid(x) || this.completed[x]) continue;
            ++x;
        }
        return x;
    }

    public synchronized boolean hasSucceededAll() {
        return this.completedCount == this.blocks;
    }

    static {
        Logger.registerClass(SimpleBlockChooser.class);
    }
}

