/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.client.FailureCodeTracker;
import freenet.client.InsertException;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.keys.FreenetURI;
import freenet.node.Node;
import freenet.support.SimpleFieldSet;
import java.io.Serializable;
import java.net.MalformedURLException;

public class PutFailedMessage
extends FCPMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    final InsertException.InsertExceptionMode code;
    final String codeDescription;
    final String extraDescription;
    final String shortCodeDescription;
    final FailureCodeTracker tracker;
    final FreenetURI expectedURI;
    final String identifier;
    final boolean global;
    final boolean isFatal;

    public PutFailedMessage(InsertException e, String identifier, boolean global) {
        this.code = e.getMode();
        this.codeDescription = InsertException.getMessage(this.code);
        this.shortCodeDescription = InsertException.getShortMessage(this.code);
        this.extraDescription = e.extra;
        this.tracker = e.errorCodes;
        this.expectedURI = e.uri;
        this.identifier = identifier;
        this.global = global;
        this.isFatal = InsertException.isFatal(this.code);
    }

    public PutFailedMessage(SimpleFieldSet fs, boolean useVerboseFields) throws MalformedURLException {
        this.identifier = fs.get("Identifier");
        if (this.identifier == null) {
            throw new NullPointerException();
        }
        this.global = fs.getBoolean("Global", false);
        this.code = InsertException.InsertExceptionMode.getByCode(Integer.parseInt(fs.get("Code")));
        if (useVerboseFields) {
            this.codeDescription = fs.get("CodeDescription");
            this.isFatal = fs.getBoolean("Fatal", false);
            this.shortCodeDescription = fs.get("ShortCodeDescription");
        } else {
            this.codeDescription = InsertException.getMessage(this.code);
            this.isFatal = InsertException.isFatal(this.code);
            this.shortCodeDescription = InsertException.getShortMessage(this.code);
        }
        this.extraDescription = fs.get("ExtraDescription");
        String euri = fs.get("ExpectedURI");
        this.expectedURI = euri != null && euri.length() > 0 ? new FreenetURI(euri) : null;
        SimpleFieldSet trackerSubset = fs.subset("Errors");
        this.tracker = trackerSubset != null ? new FailureCodeTracker(true, trackerSubset) : null;
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        return this.getFieldSet(true);
    }

    public SimpleFieldSet getFieldSet(boolean verbose) {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        if (this.identifier == null) {
            throw new NullPointerException();
        }
        fs.putSingle("Identifier", this.identifier);
        fs.put("Global", this.global);
        fs.put("Code", this.code.code);
        if (verbose) {
            fs.putSingle("CodeDescription", this.codeDescription);
        }
        if (this.extraDescription != null) {
            fs.putSingle("ExtraDescription", this.extraDescription);
        }
        if (this.tracker != null) {
            fs.tput("Errors", this.tracker.toFieldSet(verbose));
        }
        if (verbose) {
            fs.put("Fatal", this.isFatal);
        }
        if (verbose) {
            fs.putSingle("ShortCodeDescription", this.shortCodeDescription);
        }
        if (this.expectedURI != null) {
            fs.putSingle("ExpectedURI", this.expectedURI.toString());
        }
        return fs;
    }

    @Override
    public String getName() {
        return "PutFailed";
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "PutFailed goes from server to client not the other way around", this.identifier, this.global);
    }

    public String getShortFailedMessage() {
        return this.shortCodeDescription;
    }

    public String getLongFailedMessage() {
        if (this.extraDescription != null) {
            return this.shortCodeDescription + ": " + this.extraDescription;
        }
        return this.shortCodeDescription;
    }
}

