/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.FetchWaiter;
import freenet.client.HighLevelSimpleClient;
import freenet.client.InsertBlock;
import freenet.client.InsertException;
import freenet.client.async.ClientGetter;
import freenet.clients.http.PageNode;
import freenet.clients.http.RedirectException;
import freenet.clients.http.ToadletContainer;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.keys.FreenetURI;
import freenet.l10n.NodeL10n;
import freenet.node.RequestClient;
import freenet.support.HTMLEncoder;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import freenet.support.api.Bucket;
import freenet.support.api.HTTPRequest;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URI;

public abstract class Toadlet {
    public static final String HANDLE_METHOD_PREFIX = "handleMethod";
    final HighLevelSimpleClient client;
    ToadletContainer container;
    private String supportedMethodsCache;

    public abstract void handleMethodGET(URI var1, HTTPRequest var2, ToadletContext var3) throws ToadletContextClosedException, IOException, RedirectException;

    public abstract String path();

    public Toadlet showAsToadlet(ToadletContext context) {
        return this.showAsToadlet();
    }

    @Deprecated
    public Toadlet showAsToadlet() {
        return this;
    }

    public boolean allowPOSTWithoutPassword() {
        return false;
    }

    protected Toadlet(HighLevelSimpleClient client) {
        this.client = client;
    }

    private static String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("Toadlet." + key, new String[]{pattern}, new String[]{value});
    }

    private static String l10n(String key) {
        return NodeL10n.getBase().getString("Toadlet." + key);
    }

    public final String findSupportedMethods() {
        if (this.supportedMethodsCache == null) {
            Method[] methlist = this.getClass().getMethods();
            StringBuilder sb = new StringBuilder();
            for (Method m : methlist) {
                String name = m.getName();
                if (!name.startsWith(HANDLE_METHOD_PREFIX)) continue;
                sb.append(name.substring(HANDLE_METHOD_PREFIX.length()));
                sb.append(", ");
            }
            if (sb.length() >= 2) {
                sb.deleteCharAt(sb.length() - 1);
                sb.deleteCharAt(sb.length() - 1);
            }
            this.supportedMethodsCache = sb.toString();
        }
        return this.supportedMethodsCache;
    }

    FetchResult fetch(FreenetURI uri, long maxSize, RequestClient clientContext, FetchContext fctx) throws FetchException {
        FetchWaiter fw = new FetchWaiter(clientContext);
        ClientGetter getter = this.client.fetch(uri, 1L, fw, fctx);
        return fw.waitForCompletion();
    }

    FetchContext getFetchContext(long maxSize, String schemeHostAndPort) {
        return this.client.getFetchContext(maxSize, schemeHostAndPort);
    }

    FreenetURI insert(InsertBlock insert, String filenameHint, boolean getCHKOnly) throws InsertException {
        insert.desiredURI.checkInsertURI();
        return this.client.insert(insert, getCHKOnly, filenameHint);
    }

    protected void writeReply(ToadletContext ctx, int code, String mimeType, String desc, byte[] data, int offset, int length) throws ToadletContextClosedException, IOException {
        ctx.sendReplyHeaders(code, desc, null, mimeType, length);
        ctx.writeData(data, offset, length);
    }

    protected void writeReply(ToadletContext ctx, int code, String mimeType, String desc, Bucket data) throws ToadletContextClosedException, IOException {
        this.writeReply(ctx, code, mimeType, desc, null, data);
    }

    protected void writeReply(ToadletContext context, int code, String mimeType, String desc, MultiValueTable<String, String> headers, Bucket data) throws ToadletContextClosedException, IOException {
        context.sendReplyHeaders(code, desc, headers, mimeType, data.size());
        context.writeData(data);
    }

    protected void writeReply(ToadletContext ctx, int code, String mimeType, String desc, String reply) throws ToadletContextClosedException, IOException {
        this.writeReply(ctx, code, mimeType, desc, null, reply, false);
    }

    protected void writeHTMLReply(ToadletContext ctx, int code, String desc, String reply) throws ToadletContextClosedException, IOException {
        this.writeReply(ctx, code, "text/html; charset=utf-8", desc, null, reply, false);
    }

    protected void writeTextReply(ToadletContext ctx, int code, String desc, String reply) throws ToadletContextClosedException, IOException {
        this.writeReply(ctx, code, "text/plain; charset=utf-8", desc, null, reply, true);
    }

    protected void writeHTMLReply(ToadletContext ctx, int code, String desc, MultiValueTable<String, String> headers, String reply) throws ToadletContextClosedException, IOException {
        this.writeHTMLReply(ctx, code, desc, headers, reply, false);
    }

    protected void writeHTMLReply(ToadletContext ctx, int code, String desc, MultiValueTable<String, String> headers, String reply, boolean forceDisableJavascript) throws ToadletContextClosedException, IOException {
        this.writeReply(ctx, code, "text/html; charset=utf-8", desc, headers, reply, forceDisableJavascript);
    }

    protected void writeTextReply(ToadletContext ctx, int code, String desc, MultiValueTable<String, String> headers, String reply) throws ToadletContextClosedException, IOException {
        this.writeReply(ctx, code, "text/plain; charset=utf-8", desc, headers, reply, true);
    }

    protected void writeReply(ToadletContext context, int code, String mimeType, String desc, MultiValueTable<String, String> headers, String reply) throws ToadletContextClosedException, IOException {
        this.writeReply(context, code, mimeType, desc, headers, reply, false);
    }

    protected void writeReply(ToadletContext context, int code, String mimeType, String desc, MultiValueTable<String, String> headers, String reply, boolean forceDisableJavascript) throws ToadletContextClosedException, IOException {
        byte[] buffer = reply.getBytes("UTF-8");
        this.writeReply(context, code, mimeType, desc, headers, buffer, 0, buffer.length, forceDisableJavascript);
    }

    private void writeReply(ToadletContext context, int code, String mimeType, String desc, MultiValueTable<String, String> headers, byte[] buffer, int startIndex, int length, boolean forceDisableJavascript) throws ToadletContextClosedException, IOException {
        context.sendReplyHeaders(code, desc, headers, mimeType, (long)length, forceDisableJavascript);
        context.writeData(buffer, startIndex, length);
    }

    static void writePermanentRedirect(ToadletContext ctx, String msg, String location) throws ToadletContextClosedException, IOException {
        byte[] buf;
        MultiValueTable<String, String> mvt = new MultiValueTable<String, String>();
        mvt.put("Location", location);
        msg = msg == null ? "" : HTMLEncoder.encode(msg);
        String redirDoc = "<html><head><title>" + msg + "</title></head><body><h1>" + Toadlet.l10n("permRedirectWithReason", "reason", msg) + "</h1><a href=\"" + HTMLEncoder.encode(location) + "\">" + Toadlet.l10n("clickHere") + "</a></body></html>";
        try {
            buf = redirDoc.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
        }
        ctx.sendReplyHeaders(301, "Moved Permanently", mvt, "text/html; charset=UTF-8", buf.length);
        ctx.writeData(buf, 0, buf.length);
    }

    protected void writeTemporaryRedirect(ToadletContext ctx, String msg, String location) throws ToadletContextClosedException, IOException {
        byte[] buf;
        MultiValueTable<String, String> mvt = new MultiValueTable<String, String>();
        mvt.put("Location", location);
        msg = msg == null ? "" : HTMLEncoder.encode(msg);
        String redirDoc = "<html><head><title>" + msg + "</title></head><body><h1>" + Toadlet.l10n("tempRedirectWithReason", "reason", msg) + "</h1><a href=\"" + HTMLEncoder.encode(location) + "\">" + Toadlet.l10n("clickHere") + "</a></body></html>";
        try {
            buf = redirDoc.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
        }
        ctx.sendReplyHeaders(302, "Found", mvt, "text/html; charset=UTF-8", buf.length);
        ctx.writeData(buf, 0, buf.length);
    }

    protected void sendErrorPage(ToadletContext ctx, int code, String desc, String message) throws ToadletContextClosedException, IOException {
        this.sendErrorPage(ctx, code, desc, new HTMLNode("#", message));
    }

    protected void sendErrorPage(ToadletContext ctx, int code, String desc, HTMLNode message) throws ToadletContextClosedException, IOException {
        PageNode page = ctx.getPageMaker().getPageNode(desc, ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        HTMLNode infoboxContent = ctx.getPageMaker().getInfobox("infobox-error", desc, contentNode, null, true);
        infoboxContent.addChild(message);
        infoboxContent.addChild("br");
        infoboxContent.addChild("a", "href", ".", Toadlet.l10n("returnToPrevPage"));
        infoboxContent.addChild("br");
        Toadlet.addHomepageLink(infoboxContent);
        this.writeHTMLReply(ctx, code, desc, pageNode.generate());
    }

    protected void sendErrorPage(ToadletContext ctx, String desc, String message, Throwable t) throws ToadletContextClosedException, IOException {
        PageNode page = ctx.getPageMaker().getPageNode(desc, ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        HTMLNode infoboxContent = ctx.getPageMaker().getInfobox("infobox-error", desc, contentNode, null, true);
        infoboxContent.addChild("#", message);
        infoboxContent.addChild("br");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(t);
        t.printStackTrace(pw);
        pw.close();
        infoboxContent.addChild("pre", sw.toString());
        infoboxContent.addChild("br");
        infoboxContent.addChild("a", "href", ".", Toadlet.l10n("returnToPrevPage"));
        Toadlet.addHomepageLink(infoboxContent);
        this.writeHTMLReply(ctx, 500, desc, pageNode.generate());
    }

    void sendUnauthorizedPage(ToadletContext ctx) throws ToadletContextClosedException, IOException {
        this.sendErrorPage(ctx, 403, NodeL10n.getBase().getString("Toadlet.unauthorizedTitle"), NodeL10n.getBase().getString("Toadlet.unauthorized"));
    }

    protected void writeInternalError(Throwable t, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        Logger.error(this, "Caught " + t, t);
        String msg = "<html><head><title>" + NodeL10n.getBase().getString("Toadlet.internalErrorTitle") + "</title></head><body><h1>" + NodeL10n.getBase().getString("Toadlet.internalErrorPleaseReport") + "</h1><pre>";
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        while (t != null) {
            t.printStackTrace(pw);
            t = t.getCause();
        }
        pw.flush();
        msg = msg + sw.toString() + "</pre></body></html>";
        this.writeHTMLReply(ctx, 500, "Internal Error", msg);
    }

    protected static void addHomepageLink(HTMLNode content) {
        content.addChild("a", new String[]{"href", "title"}, new String[]{"/", Toadlet.l10n("homepage")}, Toadlet.l10n("returnToNodeHomepage"));
    }

    protected HighLevelSimpleClient getClientImpl() {
        return this.client;
    }
}

