/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs.messages;

import com.db4o.config.QueryEvaluationMode;
import com.db4o.foundation.IntIterator4;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.cs.LazyClientObjectSetStub;
import com.db4o.internal.cs.ServerMessageDispatcher;
import com.db4o.internal.cs.messages.MsgD;
import com.db4o.internal.cs.messages.MsgObject;
import com.db4o.internal.query.result.AbstractQueryResult;

public abstract class MsgQuery
extends MsgObject {
    private static final int ID_AND_SIZE = 2;
    private static int nextID;

    protected final void writeQueryResult(AbstractQueryResult queryResult, QueryEvaluationMode evaluationMode) {
        int queryResultId = 0;
        int maxCount = 0;
        if (evaluationMode == QueryEvaluationMode.IMMEDIATE) {
            maxCount = queryResult.size();
        } else {
            queryResultId = MsgQuery.generateID();
            maxCount = this.config().prefetchObjectCount();
        }
        MsgD message = QUERY_RESULT.getWriterForLength(this.transaction(), this.bufferLength(maxCount));
        StatefulBuffer writer = message.payLoad();
        writer.writeInt(queryResultId);
        IntIterator4 idIterator = queryResult.iterateIDs();
        writer.writeIDs(idIterator, maxCount);
        if (queryResultId > 0) {
            ServerMessageDispatcher serverThread = this.serverMessageDispatcher();
            serverThread.mapQueryResultToID(new LazyClientObjectSetStub(queryResult, idIterator), queryResultId);
        }
        this.write(message);
    }

    private int bufferLength(int maxCount) {
        return 4 * (maxCount + 2);
    }

    private static synchronized int generateID() {
        if (++nextID < 0) {
            nextID = 1;
        }
        return nextID;
    }

    protected AbstractQueryResult newQueryResult(QueryEvaluationMode mode) {
        return this.stream().newQueryResult(this.transaction(), mode);
    }
}

