/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.io;

import com.onionnetworks.util.AsyncPersistentProps;
import com.onionnetworks.util.Range;
import com.onionnetworks.util.RangeSet;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;

public class Journal
extends AsyncPersistentProps {
    public static final String FILE_PROP = "file";
    public static final String BYTES_PROP = "bytes";
    File f;
    RangeSet written;

    public Journal(File f) throws IOException {
        super(f);
        String bytes = this.getProperty(BYTES_PROP);
        if (bytes != null) {
            try {
                this.written = RangeSet.parse(bytes);
            }
            catch (ParseException e) {
                throw new IOException("Corrupt journal.");
            }
        } else {
            this.written = new RangeSet();
        }
        String file = this.getProperty(FILE_PROP);
        if (file != null) {
            this.f = new File(file);
        }
    }

    public void setTargetFile(File f) {
        this.f = f;
        this.setProperty(FILE_PROP, f.getAbsolutePath());
    }

    public File getTargetFile() {
        return this.f;
    }

    public void addByteRange(Range r) {
        this.written.add(r);
        this.setProperty(BYTES_PROP, this.written.toString());
    }

    public RangeSet getByteRanges() {
        return this.written;
    }
}

