/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.FailureCodeTracker;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ChosenBlock;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutState;
import freenet.client.async.ClientRequester;
import freenet.client.async.PersistentJob;
import freenet.client.async.PutCompletionCallback;
import freenet.crypt.RandomSource;
import freenet.keys.CHKEncodeException;
import freenet.keys.ClientCHKBlock;
import freenet.keys.ClientKey;
import freenet.keys.ClientKeyBlock;
import freenet.keys.ClientSSK;
import freenet.keys.ClientSSKBlock;
import freenet.keys.FreenetURI;
import freenet.keys.InsertableClientSSK;
import freenet.keys.KeyBlock;
import freenet.keys.KeyDecodeException;
import freenet.keys.KeyEncodeException;
import freenet.keys.KeyVerifyException;
import freenet.keys.SSKBlock;
import freenet.keys.SSKEncodeException;
import freenet.node.KeysFetchingLocally;
import freenet.node.LowLevelPutException;
import freenet.node.NodeClientCore;
import freenet.node.RequestClient;
import freenet.node.RequestScheduler;
import freenet.node.SendableInsert;
import freenet.node.SendableRequestItem;
import freenet.node.SendableRequestItemKey;
import freenet.node.SendableRequestSender;
import freenet.store.KeyCollisionException;
import freenet.support.Fields;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.compress.InvalidCompressionCodecException;
import freenet.support.io.BucketTools;
import freenet.support.io.ResumeFailedException;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Arrays;

public class SingleBlockInserter
extends SendableInsert
implements ClientPutState,
Serializable {
    private static final long serialVersionUID = 1L;
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private Bucket sourceData;
    final short compressionCodec;
    final FreenetURI uri;
    private ClientKey resultingKey;
    final PutCompletionCallback cb;
    final BaseClientPutter parent;
    final InsertContext ctx;
    private int retries;
    private final FailureCodeTracker errors;
    private boolean finished;
    private final boolean dontSendEncoded;
    final int token;
    private final Object tokenObject;
    final boolean isMetadata;
    final int sourceLength;
    private int consecutiveRNFs = 0;
    private boolean isSSK;
    private boolean freeData;
    private int completedInserts;
    final int extraInserts;
    final byte[] cryptoKey;
    final byte cryptoAlgorithm;

    public SingleBlockInserter(BaseClientPutter parent, Bucket data, short compressionCodec, FreenetURI uri, InsertContext ctx, boolean realTimeFlag, PutCompletionCallback cb, boolean isMetadata, int sourceLength, int token, boolean addToParent, boolean dontSendEncoded, Object tokenObject, ClientContext context, boolean persistent, boolean freeData, int extraInserts, byte cryptoAlgorithm, byte[] cryptoKey) {
        super(persistent, realTimeFlag);
        this.tokenObject = tokenObject;
        this.token = token;
        this.parent = parent;
        this.dontSendEncoded = dontSendEncoded;
        this.retries = 0;
        this.finished = false;
        this.ctx = ctx;
        this.freeData = freeData;
        this.errors = new FailureCodeTracker(true);
        this.cb = cb;
        this.uri = uri;
        this.compressionCodec = compressionCodec;
        this.sourceData = data;
        if (this.sourceData == null) {
            throw new NullPointerException();
        }
        this.isMetadata = isMetadata;
        this.sourceLength = sourceLength;
        this.isSSK = uri.getKeyType().toUpperCase().equals("SSK");
        if (addToParent) {
            parent.addMustSucceedBlocks(1);
            parent.notifyClients(context);
        }
        this.extraInserts = extraInserts;
        this.cryptoAlgorithm = cryptoAlgorithm;
        this.cryptoKey = cryptoKey;
    }

    protected ClientKeyBlock innerEncode(RandomSource random) throws InsertException {
        try {
            return SingleBlockInserter.innerEncode(random, this.uri, this.sourceData, this.isMetadata, this.compressionCodec, this.sourceLength, this.ctx.compressorDescriptor, this.cryptoAlgorithm, this.cryptoKey);
        }
        catch (KeyEncodeException e) {
            Logger.error(SingleBlockInserter.class, "Caught " + e, (Throwable)e);
            throw new InsertException(InsertException.InsertExceptionMode.INTERNAL_ERROR, e, null);
        }
        catch (MalformedURLException e) {
            throw new InsertException(InsertException.InsertExceptionMode.INVALID_URI, e, null);
        }
        catch (IOException e) {
            Logger.error(SingleBlockInserter.class, "Caught " + e + " encoding data " + this.sourceData, (Throwable)e);
            throw new InsertException(InsertException.InsertExceptionMode.BUCKET_ERROR, e, null);
        }
        catch (InvalidCompressionCodecException e) {
            throw new InsertException(InsertException.InsertExceptionMode.INTERNAL_ERROR, e, null);
        }
    }

    protected static ClientKeyBlock innerEncode(RandomSource random, FreenetURI uri, Bucket sourceData, boolean isMetadata, short compressionCodec, int sourceLength, String compressorDescriptor, byte cryptoAlgorithm, byte[] cryptoKey) throws InsertException, CHKEncodeException, IOException, SSKEncodeException, MalformedURLException, InvalidCompressionCodecException {
        String uriType = uri.getKeyType();
        if (uriType.equals("CHK")) {
            return ClientCHKBlock.encode(sourceData, isMetadata, compressionCodec == -1, compressionCodec, sourceLength, compressorDescriptor, cryptoKey, cryptoAlgorithm);
        }
        if (uriType.equals("SSK") || uriType.equals("KSK")) {
            InsertableClientSSK ik = InsertableClientSSK.create(uri);
            return ik.encode(sourceData, isMetadata, compressionCodec == -1, compressionCodec, sourceLength, random, compressorDescriptor);
        }
        throw new InsertException(InsertException.InsertExceptionMode.INVALID_URI, "Unknown keytype " + uriType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEncode(final ClientKey key, final ClientContext context) {
        SingleBlockInserter singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.finished) {
                return;
            }
            if (this.resultingKey != null) {
                return;
            }
            this.resultingKey = key;
        }
        if (!this.persistent) {
            context.mainExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    SingleBlockInserter.this.cb.onEncode(key, SingleBlockInserter.this, context);
                }
            }, "Got URI");
        } else {
            context.jobRunner.queueNormalOrDrop(new PersistentJob(){

                @Override
                public boolean run(ClientContext context) {
                    SingleBlockInserter.this.cb.onEncode(key, SingleBlockInserter.this, context);
                    return false;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClientKeyBlock encode(ClientContext context, boolean calledByCB) throws InsertException {
        boolean shouldSend;
        ClientKeyBlock block;
        SingleBlockInserter singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.finished) {
                return null;
            }
            if (this.sourceData == null) {
                Logger.error(this, "Source data is null on " + this + " but not finished!");
                return null;
            }
            block = this.innerEncode(context.random);
            shouldSend = this.resultingKey == null;
            this.resultingKey = block.getClientKey();
        }
        if (logMINOR) {
            Logger.minor(this, "Encoded " + this.resultingKey.getURI() + " for " + this + " shouldSend=" + shouldSend + " dontSendEncoded=" + this.dontSendEncoded);
        }
        if (shouldSend && !this.dontSendEncoded) {
            this.cb.onEncode(block.getClientKey(), this, context);
        }
        return block;
    }

    @Override
    public short getPriorityClass() {
        return this.parent.getPriorityClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(LowLevelPutException e, SendableRequestItem keyNum, ClientContext context) {
        SingleBlockInserter singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.finished) {
                return;
            }
        }
        if (this.parent.isCancelled()) {
            this.fail(new InsertException(InsertException.InsertExceptionMode.CANCELLED), context);
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "onFailure() on " + e + " for " + this);
        }
        switch (e.code) {
            case 5: {
                this.fail(new InsertException(InsertException.InsertExceptionMode.COLLISION), context);
                return;
            }
            case 1: {
                this.fail(new InsertException(InsertException.InsertExceptionMode.INTERNAL_ERROR), context);
                return;
            }
            case 3: {
                this.errors.inc(InsertException.InsertExceptionMode.REJECTED_OVERLOAD);
                break;
            }
            case 2: {
                this.errors.inc(InsertException.InsertExceptionMode.ROUTE_NOT_FOUND);
                break;
            }
            case 4: {
                this.errors.inc(InsertException.InsertExceptionMode.ROUTE_REALLY_NOT_FOUND);
                break;
            }
            default: {
                Logger.error(this, "Unknown LowLevelPutException code: " + e.code);
                this.errors.inc(InsertException.InsertExceptionMode.INTERNAL_ERROR);
            }
        }
        if (e.code == 2 || e.code == 4) {
            ++this.consecutiveRNFs;
            if (logMINOR) {
                Logger.minor(this, "Consecutive RNFs: " + this.consecutiveRNFs + " / " + this.ctx.consecutiveRNFsCountAsSuccess);
            }
            if (this.consecutiveRNFs >= this.ctx.consecutiveRNFsCountAsSuccess) {
                if (logMINOR) {
                    Logger.minor(this, "Consecutive RNFs: " + this.consecutiveRNFs + " - counting as success");
                }
                this.onSuccess(keyNum, this.getKeyNoEncode(), context);
                return;
            }
        } else {
            this.consecutiveRNFs = 0;
        }
        if (logMINOR) {
            Logger.minor(this, "Failed: " + e);
        }
        ++this.retries;
        if (this.retries > this.ctx.maxInsertRetries && this.ctx.maxInsertRetries != -1) {
            this.fail(InsertException.construct(this.persistent ? this.errors.clone() : this.errors), context);
            return;
        }
        this.clearWakeupTime(context);
    }

    private void fail(InsertException e, ClientContext context) {
        this.fail(e, false, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fail(InsertException e, boolean forceFatal, ClientContext context) {
        SingleBlockInserter singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.finished) {
                return;
            }
            this.finished = true;
        }
        if (e.isFatal() || forceFatal) {
            this.parent.fatallyFailedBlock(context);
        } else {
            this.parent.failedBlock(context);
        }
        this.unregister(context, this.getPriorityClass());
        if (this.freeData) {
            this.sourceData.free();
            this.sourceData = null;
        }
        this.cb.onFailure(e, this, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientKeyBlock getBlock(ClientContext context, boolean calledByCB) {
        try {
            SingleBlockInserter singleBlockInserter = this;
            synchronized (singleBlockInserter) {
                if (this.finished) {
                    return null;
                }
            }
            return this.encode(context, calledByCB);
        }
        catch (InsertException e) {
            this.cb.onFailure(e, this, context);
            return null;
        }
        catch (Throwable t) {
            Logger.error(this, "Caught " + t, t);
            this.cb.onFailure(new InsertException(InsertException.InsertExceptionMode.INTERNAL_ERROR, t, null), this, context);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(ClientContext context) throws InsertException {
        SingleBlockInserter singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.finished) {
                if (logMINOR) {
                    Logger.minor(this, "Finished already: " + this);
                }
                return;
            }
        }
        if (this.ctx.getCHKOnly || this.ctx.earlyEncode) {
            this.tryEncode(context);
        }
        if (this.ctx.getCHKOnly) {
            this.onSuccess(null, this.getKeyNoEncode(), context);
        } else {
            this.getScheduler(context).registerInsert(this, this.persistent);
        }
    }

    @Override
    public boolean isSSK() {
        return this.isSSK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FreenetURI getURI(ClientContext context) {
        SingleBlockInserter singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.resultingKey != null) {
                return this.resultingKey.getURI();
            }
        }
        this.getBlock(context, true);
        singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            return this.resultingKey.getURI();
        }
    }

    public synchronized FreenetURI getURINoEncode() {
        return this.resultingKey == null ? null : this.resultingKey.getURI();
    }

    public synchronized ClientKey getKeyNoEncode() {
        return this.resultingKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(SendableRequestItem keyNum, ClientKey key, ClientContext context) {
        this.onEncode(key, context);
        if (logMINOR) {
            Logger.minor(this, "Succeeded (" + this + "): " + this.token);
        }
        if (this.parent.isCancelled()) {
            this.fail(new InsertException(InsertException.InsertExceptionMode.CANCELLED), context);
            return;
        }
        boolean shouldSendKey = false;
        SingleBlockInserter singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.extraInserts > 0 && !this.ctx.getCHKOnly && ++this.completedInserts <= this.extraInserts) {
                if (logMINOR) {
                    Logger.minor(this, "Completed inserts " + this.completedInserts + " of extra inserts " + this.extraInserts + " on " + this);
                }
                return;
            }
            if (this.finished) {
                Logger.normal(this, "Block already completed: " + this);
                return;
            }
            this.finished = true;
            if (this.resultingKey == null) {
                shouldSendKey = true;
                this.resultingKey = key;
            } else if (!this.resultingKey.equals(key)) {
                Logger.error(this, "Different key: " + this.resultingKey + " -> " + key + " for " + this);
            }
        }
        if (this.freeData) {
            this.sourceData.free();
            this.sourceData = null;
        }
        this.parent.completedBlock(false, context);
        this.unregister(context, this.getPriorityClass());
        if (logMINOR) {
            Logger.minor(this, "Calling onSuccess for " + this.cb);
        }
        if (shouldSendKey) {
            this.cb.onEncode(key, this, context);
        }
        this.cb.onSuccess(this, context);
    }

    @Override
    public BaseClientPutter getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(ClientContext context) {
        SingleBlockInserter singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.finished) {
                return;
            }
            this.finished = true;
        }
        if (this.freeData) {
            this.sourceData.free();
            this.sourceData = null;
        }
        super.unregister(context, this.getPriorityClass());
        this.cb.onFailure(new InsertException(InsertException.InsertExceptionMode.CANCELLED), this, context);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.finished;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.finished;
    }

    @Override
    public SendableRequestSender getSender(ClientContext context) {
        String compress = this.ctx.compressorDescriptor;
        return new MySendableRequestSender(compress, this);
    }

    @Override
    public RequestClient getClient() {
        return this.parent.getClient();
    }

    @Override
    public ClientRequester getClientRequest() {
        return this.parent;
    }

    @Override
    public Object getToken() {
        return this.tokenObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryEncode(ClientContext context) {
        SingleBlockInserter singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.resultingKey != null) {
                return;
            }
            if (this.finished) {
                return;
            }
        }
        try {
            this.encode(context, false);
        }
        catch (InsertException e) {
            this.fail(e, context);
        }
        catch (Throwable t) {
            Logger.error(this, "Caught " + t, t);
        }
    }

    @Override
    public synchronized long countSendableKeys(ClientContext context) {
        if (this.finished) {
            return 0L;
        }
        return 1L;
    }

    @Override
    public synchronized long countAllKeys(ClientContext context) {
        return this.countSendableKeys(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendableRequestItem chooseKey(KeysFetchingLocally ignored, ClientContext context) {
        try {
            SingleBlockInserter singleBlockInserter = this;
            synchronized (singleBlockInserter) {
                if (this.finished) {
                    return null;
                }
                BlockItemKey key = new BlockItemKey(this, this.hashCode());
                if (ignored.hasInsert(key)) {
                    return null;
                }
                return this.getBlockItem(key, context);
            }
        }
        catch (InsertException e) {
            this.fail(e, context);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getWakeupTime(ClientContext context, long now) {
        KeysFetchingLocally keysFetching = this.getScheduler(context).fetchingKeys();
        SingleBlockInserter singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.finished) {
                return -1L;
            }
            BlockItemKey key = new BlockItemKey(this, this.hashCode());
            if (keysFetching.hasInsert(key)) {
                return Long.MAX_VALUE;
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockItem getBlockItem(BlockItemKey key, ClientContext context) throws InsertException {
        try {
            SingleBlockInserter singleBlockInserter = this;
            synchronized (singleBlockInserter) {
                if (this.finished) {
                    return null;
                }
            }
            if (this.persistent && this.sourceData == null) {
                Logger.error(this, "getBlockItem(): sourceData = null", (Throwable)new Exception("error"));
                this.fail(new InsertException(InsertException.InsertExceptionMode.INTERNAL_ERROR), context);
                return null;
            }
            Bucket data = this.sourceData.createShadow();
            FreenetURI u = this.uri;
            if (u.getKeyType().equals("CHK")) {
                u = FreenetURI.EMPTY_CHK_URI;
            }
            if (data == null) {
                data = context.tempBucketFactory.makeBucket(this.sourceData.size());
                BucketTools.copy(this.sourceData, data);
            }
            InsertContext.CompatibilityMode cmode = this.ctx.getCompatibilityMode();
            return new BlockItem(key, data, this.isMetadata, this.compressionCodec, this.sourceLength, u, this.persistent, this.cryptoAlgorithm, this.cryptoKey);
        }
        catch (IOException e) {
            throw new InsertException(InsertException.InsertExceptionMode.BUCKET_ERROR, e, null);
        }
    }

    @Override
    public boolean canWriteClientCache() {
        boolean retval = this.ctx.canWriteClientCache;
        return retval;
    }

    @Override
    public boolean localRequestOnly() {
        boolean retval = this.ctx.localRequestOnly;
        return retval;
    }

    @Override
    public boolean forkOnCacheable() {
        boolean retval = this.ctx.forkOnCacheable;
        return retval;
    }

    @Override
    public void onEncode(SendableRequestItem token, ClientKey key, ClientContext context) {
        this.onEncode(key, context);
    }

    @Override
    public void innerOnResume(ClientContext context) throws InsertException, ResumeFailedException {
        this.sourceData.onResume(context);
        if (this.cb != this.parent) {
            this.cb.onResume(context);
        }
        if (this.resultingKey != null) {
            this.cb.onEncode(this.resultingKey, this, context);
        }
        this.schedule(context);
    }

    @Override
    public void onShutdown(ClientContext context) {
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
    }

    private static class BlockItem
    implements SendableRequestItem {
        private final Bucket copyBucket;
        final BlockItemKey key;
        private final FreenetURI uri;
        private final boolean persistent;
        private final boolean isMetadata;
        private final short compressionCodec;
        private final int sourceLength;
        public byte cryptoAlgorithm;
        public byte[] cryptoKey;

        BlockItem(BlockItemKey key, Bucket bucket, boolean meta, short codec, int srclen, FreenetURI u, boolean persistent, byte cryptoAlgorithm, byte[] cryptoKey) {
            this.key = key;
            this.copyBucket = bucket;
            this.uri = u;
            this.isMetadata = meta;
            this.compressionCodec = codec;
            this.sourceLength = srclen;
            this.persistent = persistent;
            this.cryptoAlgorithm = cryptoAlgorithm;
            this.cryptoKey = cryptoKey;
        }

        @Override
        public void dump() {
            this.copyBucket.free();
        }

        @Override
        public SendableRequestItemKey getKey() {
            return this.key;
        }
    }

    private static class BlockItemKey
    implements SendableRequestItemKey {
        private final int hashCode;
        private final SingleBlockInserter parent;

        BlockItemKey(SingleBlockInserter parent, int hashCode) {
            this.parent = parent;
            this.hashCode = hashCode;
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof BlockItemKey && ((BlockItemKey)o).parent == this.parent;
        }
    }

    static class MySendableRequestSender
    implements SendableRequestSender {
        final String compressorDescriptor;
        final SingleBlockInserter orig;

        MySendableRequestSender(String compress, SingleBlockInserter orig) {
            this.compressorDescriptor = compress;
            this.orig = orig;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean send(NodeClientCore core, RequestScheduler sched, ClientContext context, ChosenBlock req) {
            ClientKey k;
            block33: {
                k = null;
                if (logMINOR) {
                    Logger.minor(this, "Starting request");
                }
                BlockItem block = (BlockItem)req.token;
                try {
                    ClientKey key;
                    KeyBlock b;
                    ClientKeyBlock encodedBlock;
                    try {
                        encodedBlock = SingleBlockInserter.innerEncode(context.random, block.uri, block.copyBucket, block.isMetadata, block.compressionCodec, block.sourceLength, this.compressorDescriptor, block.cryptoAlgorithm, block.cryptoKey);
                        b = encodedBlock.getBlock();
                    }
                    catch (CHKEncodeException e) {
                        throw new LowLevelPutException(1, e.toString() + ":" + e.getMessage(), e);
                    }
                    catch (SSKEncodeException e) {
                        throw new LowLevelPutException(1, e.toString() + ":" + e.getMessage(), e);
                    }
                    catch (MalformedURLException e) {
                        throw new LowLevelPutException(1, e.toString() + ":" + e.getMessage(), e);
                    }
                    catch (InsertException e) {
                        throw new LowLevelPutException(1, e.toString() + ":" + e.getMessage(), e);
                    }
                    catch (IOException e) {
                        throw new LowLevelPutException(1, e.toString() + ":" + e.getMessage(), e);
                    }
                    catch (InvalidCompressionCodecException e) {
                        throw new LowLevelPutException(1, e.toString() + ":" + e.getMessage(), e);
                    }
                    if (b == null) {
                        Logger.error(this, "Asked to send empty block", (Throwable)new Exception("error"));
                        boolean e = false;
                        return e;
                    }
                    k = key = encodedBlock.getClientKey();
                    context.getJobRunner(block.persistent).queueNormalOrDrop(new PersistentJob(){

                        @Override
                        public boolean run(ClientContext context) {
                            orig.onEncode(key, context);
                            return true;
                        }
                    });
                    if (req.localRequestOnly) {
                        try {
                            core.node.store(b, false, req.canWriteClientCache, true, false);
                            break block33;
                        }
                        catch (KeyCollisionException e) {
                            LowLevelPutException failed = new LowLevelPutException(5);
                            KeyBlock collided = core.node.fetch(k.getNodeKey(), true, req.canWriteClientCache, false, false, null);
                            if (collided == null) {
                                Logger.error(this, "Collided but no key?!");
                                try {
                                    core.node.store(b, false, req.canWriteClientCache, true, false);
                                }
                                catch (KeyCollisionException e2) {
                                    Logger.error(this, "Collided but no key and still collided!");
                                    throw new LowLevelPutException(1, "Collided, can't find block, but still collides!", e);
                                }
                            }
                            failed.setCollidedBlock(collided);
                            throw failed;
                        }
                    }
                    core.realPut(b, req.canWriteClientCache, req.forkOnCacheable, false, false, req.realTimeFlag);
                }
                catch (LowLevelPutException e) {
                    if (logMINOR) {
                        Logger.minor(this, "Caught " + e, (Throwable)e);
                    }
                    if (e.code == 5) {
                        byte[] inserting;
                        byte[] data;
                        ClientSSKBlock collided;
                        block34: {
                            collided = ClientSSKBlock.construct((SSKBlock)e.getCollidedBlock(), (ClientSSK)k);
                            data = collided.memoryDecode(true);
                            inserting = BucketTools.toByteArray(block.copyBucket);
                            if (collided.isMetadata() != block.isMetadata || collided.getCompressionCodec() != block.compressionCodec || !Arrays.equals(data, inserting)) break block34;
                            if (logMINOR) {
                                Logger.minor(this, "Collided with identical data");
                            }
                            req.onInsertSuccess(k, context);
                            boolean bl = true;
                            return bl;
                        }
                        try {
                            if (logMINOR) {
                                Logger.minor(this, "Apparently real collision: collided.isMetadata=" + collided.isMetadata() + " block.isMetadata=" + block.isMetadata + " collided.codec=" + collided.getCompressionCodec() + " block.codec=" + block.compressionCodec + " collided.datalength=" + data.length + " block.datalength=" + inserting.length + " H(collided)=" + Fields.hashCode(data) + " H(inserting)=" + Fields.hashCode(inserting));
                            }
                        }
                        catch (KeyVerifyException e1) {
                            Logger.error(this, "Caught " + e1 + " when checking collision!", (Throwable)e1);
                        }
                        catch (KeyDecodeException e1) {
                            Logger.error(this, "Caught " + e1 + " when checking collision!", (Throwable)e1);
                        }
                        catch (IOException e1) {
                            Logger.error(this, "Caught " + e1 + " when checking collision!", (Throwable)e1);
                        }
                    }
                    req.onFailure(e, context);
                    if (logMINOR) {
                        Logger.minor(this, "Request failed for " + e);
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    block.copyBucket.free();
                }
            }
            if (logMINOR) {
                Logger.minor(this, "Request succeeded");
            }
            req.onInsertSuccess(k, context);
            return true;
        }

        @Override
        public boolean sendIsBlocking() {
            return true;
        }
    }
}

