/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.clients.http.Cookie;
import freenet.clients.http.FProxyFetchInProgress;
import freenet.clients.http.HTTPRequestImpl;
import freenet.clients.http.PageMaker;
import freenet.clients.http.PermanentRedirectException;
import freenet.clients.http.ReceivedCookie;
import freenet.clients.http.RedirectException;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContainer;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.clients.http.annotation.AllowData;
import freenet.clients.http.bookmark.BookmarkManager;
import freenet.l10n.NodeL10n;
import freenet.node.useralerts.UserAlertManager;
import freenet.support.HTMLEncoder;
import freenet.support.HTMLNode;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import freenet.support.TimeUtil;
import freenet.support.URIPreEncoder;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.api.HTTPRequest;
import freenet.support.io.BucketTools;
import freenet.support.io.FileUtil;
import freenet.support.io.LineReadingInputStream;
import freenet.support.io.TooLongException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringJoiner;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class ToadletContextImpl
implements ToadletContext {
    private static final Class<?>[] HANDLE_PARAMETERS = new Class[]{URI.class, HTTPRequest.class, ToadletContext.class};
    private static final String METHODS_MUST_HAVE_DATA = "POST";
    private static final String METHODS_CANNOT_HAVE_DATA = "GET";
    private static final String METHODS_RESTRICTED_MODE = "GET POST";
    private final MultiValueTable<String, String> headers;
    private ArrayList<ReceivedCookie> cookies;
    private ArrayList<Cookie> replyCookies;
    private final OutputStream sockOutputStream;
    private final PageMaker pagemaker;
    private final BucketFactory bf;
    private final ToadletContainer container;
    private final UserAlertManager userAlertManager;
    private final BookmarkManager bookmarkManager;
    private final InetAddress remoteAddr;
    private Exception firstReplySendingException;
    private volatile Toadlet activeToadlet;
    private final String uniqueId;
    private URI uri;
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private boolean closed;
    private boolean shouldDisconnect;
    static TimeZone TZ_UTC;

    public ToadletContextImpl(Socket sock, MultiValueTable<String, String> headers, BucketFactory bf, PageMaker pageMaker, ToadletContainer container, UserAlertManager userAlertManager, BookmarkManager bookmarkManager, URI uri, long uniqueID) throws IOException {
        this.headers = headers;
        this.cookies = null;
        this.replyCookies = null;
        this.closed = false;
        this.uri = uri;
        this.sockOutputStream = sock.getOutputStream();
        this.remoteAddr = sock.getInetAddress();
        if (logDEBUG) {
            Logger.debug(this, "Connection from " + this.remoteAddr);
        }
        this.bf = bf;
        this.pagemaker = pageMaker;
        this.container = container;
        this.userAlertManager = userAlertManager;
        this.bookmarkManager = bookmarkManager;
        this.uniqueId = String.valueOf(Math.random());
    }

    private void close() {
        this.closed = true;
    }

    private void sendMethodNotAllowed(String method, boolean shouldDisconnect) throws ToadletContextClosedException, IOException {
        if (this.closed) {
            throw new ToadletContextClosedException();
        }
        MultiValueTable<String, String> mvt = new MultiValueTable<String, String>();
        mvt.put("Allow", "GET, PUT");
        ToadletContextImpl.sendError(this.sockOutputStream, 405, "Method Not Allowed", ToadletContextImpl.l10n("methodNotAllowed"), shouldDisconnect, mvt);
    }

    private static String l10n(String key) {
        return NodeL10n.getBase().getString("ToadletContextImpl." + key);
    }

    private static String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("ToadletContextImpl." + key, new String[]{pattern}, new String[]{value});
    }

    private static void sendError(OutputStream os, int code, String httpReason, String message, boolean shouldDisconnect, MultiValueTable<String, String> mvt) throws IOException {
        ToadletContextImpl.sendHTMLError(os, code, httpReason, "<html><head><title>" + message + "</title></head><body><h1>" + message + "</h1></body>", shouldDisconnect, mvt);
    }

    private static void sendHTMLError(OutputStream os, int code, String httpReason, String htmlMessage, boolean disconnect, MultiValueTable<String, String> mvt) throws IOException {
        if (mvt == null) {
            mvt = new MultiValueTable();
        }
        byte[] messageBytes = htmlMessage.getBytes("UTF-8");
        ToadletContextImpl.sendReplyHeaders(os, code, httpReason, mvt, "text/html; charset=UTF-8", messageBytes.length, null, disconnect, false, false);
        os.write(messageBytes);
    }

    private void sendNoToadletError(boolean shouldDisconnect) throws ToadletContextClosedException, IOException {
        if (this.closed) {
            throw new ToadletContextClosedException();
        }
        ToadletContextImpl.sendError(this.sockOutputStream, 404, "Not Found", ToadletContextImpl.l10n("noSuchToadlet"), shouldDisconnect, null);
    }

    private static void sendURIParseError(OutputStream os, boolean shouldDisconnect, Throwable e) throws IOException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.close();
        String message = "<html><head><title>" + ToadletContextImpl.l10n("uriParseErrorTitle") + "</title></head><body><p>" + HTMLEncoder.encode(e.getMessage()) + "</p><pre>\n" + sw.toString();
        ToadletContextImpl.sendHTMLError(os, 400, "Bad Request", message, shouldDisconnect, null);
    }

    @Override
    public void sendReplyHeaders(int code, String desc, MultiValueTable<String, String> mvt, String mimeType, long length) throws ToadletContextClosedException, IOException {
        this.sendReplyHeaders(code, desc, mvt, mimeType, length, false);
    }

    @Override
    public void sendReplyHeaders(int code, String desc, MultiValueTable<String, String> mvt, String mimeType, long length, boolean forceDisableJavascript) throws ToadletContextClosedException, IOException {
        boolean enableJavascript = !forceDisableJavascript && this.container.isFProxyJavascriptEnabled();
        this.sendReplyHeaders(code, desc, mvt, mimeType, length, null, false, false, enableJavascript);
    }

    @Override
    @Deprecated
    public void sendReplyHeaders(int code, String desc, MultiValueTable<String, String> mvt, String mimeType, long length, Date mTime) throws ToadletContextClosedException, IOException {
        if (mTime != null) {
            this.sendReplyHeadersStatic(code, desc, mvt, mimeType, length, mTime);
        } else {
            this.sendReplyHeaders(code, desc, mvt, mimeType, length);
        }
    }

    @Override
    public void sendReplyHeadersStatic(int replyCode, String replyDescription, MultiValueTable<String, String> mvt, String mimeType, long contentLength, Date mTime) throws ToadletContextClosedException, IOException {
        if (mTime == null) {
            throw new IllegalArgumentException();
        }
        this.sendReplyHeaders(replyCode, replyDescription, mvt, mimeType, contentLength, mTime, false, false, false);
    }

    @Override
    public void sendReplyHeadersFProxy(int replyCode, String replyDescription, MultiValueTable<String, String> mvt, String mimeType, long contentLength) throws ToadletContextClosedException, IOException {
        boolean enableJavascript = false;
        if (this.container.isFProxyWebPushingEnabled() && this.container.isFProxyJavascriptEnabled()) {
            enableJavascript = true;
        }
        this.sendReplyHeaders(replyCode, replyDescription, mvt, mimeType, contentLength, null, false, true, enableJavascript);
    }

    private void sendReplyHeaders(int replyCode, String replyDescription, MultiValueTable<String, String> mvt, String mimeType, long contentLength, Date mTime, boolean isOutlinkConfirmationPage, boolean allowFrames, boolean enableJavascript) throws ToadletContextClosedException, IOException {
        if (this.closed) {
            throw new ToadletContextClosedException();
        }
        if (this.firstReplySendingException != null) {
            throw new IllegalStateException("Already sent headers!", this.firstReplySendingException);
        }
        this.firstReplySendingException = new Exception();
        if (this.replyCookies != null) {
            if (mvt == null) {
                mvt = new MultiValueTable();
            }
            for (Cookie cookie : this.replyCookies) {
                String cookieHeader = cookie.encodeToHeaderValue();
                mvt.put("set-cookie", cookieHeader);
                if (!logMINOR) continue;
                Logger.minor(this, "set-cookie: " + cookieHeader);
            }
        }
        ToadletContextImpl.sendReplyHeaders(this.sockOutputStream, replyCode, replyDescription, mvt, mimeType, contentLength, mTime, this.shouldDisconnect, enableJavascript, allowFrames);
    }

    @Override
    public PageMaker getPageMaker() {
        return this.pagemaker;
    }

    @Override
    public String getFormPassword() {
        return this.container.getFormPassword();
    }

    @Override
    public boolean checkFormPassword(HTTPRequest request) throws ToadletContextClosedException, IOException {
        return this.checkFormPassword(request, "/");
    }

    @Override
    public boolean checkFormPassword(HTTPRequest request, String redirectTo) throws ToadletContextClosedException, IOException {
        if (!this.hasFormPassword(request)) {
            MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
            headers.put("Location", redirectTo);
            this.sendReplyHeaders(302, "Found", headers, null, 0L);
            return false;
        }
        return true;
    }

    @Override
    public boolean checkFullAccess(Toadlet toadlet) throws ToadletContextClosedException, IOException {
        if (this.isAllowedFullAccess()) {
            return true;
        }
        toadlet.sendUnauthorizedPage(this);
        return false;
    }

    @Override
    public boolean hasFormPassword(HTTPRequest request) throws IOException {
        byte[] compareBytes;
        String pass = request.getPartAsStringFailsafe("formPassword", 32);
        byte[] inputBytes = pass.getBytes("UTF-8");
        if (!MessageDigest.isEqual(inputBytes, compareBytes = this.getFormPassword().getBytes("UTF-8"))) {
            if (logMINOR) {
                Logger.minor(this, "Bad formPassword: " + pass);
            }
            return false;
        }
        return true;
    }

    @Override
    public UserAlertManager getAlertManager() {
        return this.userAlertManager;
    }

    @Override
    public BookmarkManager getBookmarkManager() {
        return this.bookmarkManager;
    }

    @Override
    public MultiValueTable<String, String> getHeaders() {
        return this.headers;
    }

    private void parseCookies() throws ParseException {
        if (this.cookies != null) {
            return;
        }
        int cookieAmount = this.headers.countAll("cookie");
        if (cookieAmount == 0) {
            return;
        }
        this.cookies = new ArrayList(cookieAmount + 1);
        for (String cookieHeader : this.headers.iterateAll("cookie")) {
            ArrayList<ReceivedCookie> parsedCookies = ReceivedCookie.parseHeader(cookieHeader);
            this.cookies.addAll(parsedCookies);
        }
    }

    @Override
    public ReceivedCookie getCookie(URI domain, URI path, String name) throws ParseException {
        this.parseCookies();
        if (this.cookies == null) {
            return null;
        }
        name = name.toLowerCase();
        for (ReceivedCookie cookie : this.cookies) {
            try {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
            catch (RuntimeException e) {
                Logger.error(this, "Error in cookie", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void setCookie(Cookie newCookie) {
        if (this.replyCookies == null) {
            this.replyCookies = new ArrayList(4);
        }
        this.replyCookies.add(newCookie);
    }

    static void sendReplyHeaders(OutputStream sockOutputStream, int replyCode, String replyDescription, MultiValueTable<String, String> mvt, String mimeType, long contentLength, Date mTime, boolean disconnect, boolean allowScripts, boolean allowFrames) throws IOException {
        String cacheControl;
        String expiresTime;
        boolean allowCaching;
        if (mvt == null) {
            mvt = new MultiValueTable();
        }
        if (mimeType != null) {
            if (mimeType.equalsIgnoreCase("text/html")) {
                mvt.put("content-type", mimeType + "; charset=UTF-8");
            } else {
                mvt.put("content-type", mimeType);
            }
        }
        if (contentLength >= 0L) {
            mvt.put("content-length", Long.toString(contentLength));
        }
        if (allowCaching = mTime != null) {
            expiresTime = TimeUtil.makeHTTPDate(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(30L));
            cacheControl = "public, max-age=" + String.valueOf(2592000);
        } else {
            expiresTime = "Thu, 01 Jan 1970 00:00:00 GMT";
            cacheControl = "private, max-age=0, must-revalidate, no-cache, no-store, post-check=0, pre-check=0";
            mvt.put("pragma", "no-cache");
        }
        mvt.put("expires", expiresTime);
        mvt.put("cache-control", cacheControl);
        String nowString = TimeUtil.makeHTTPDate(System.currentTimeMillis());
        String lastModString = mTime == null ? nowString : TimeUtil.makeHTTPDate(mTime.getTime());
        mvt.put("last-modified", lastModString);
        mvt.put("date", nowString);
        if (disconnect) {
            mvt.put("connection", "close");
        } else {
            mvt.put("connection", "keep-alive");
        }
        String contentSecurityPolicy = ToadletContextImpl.generateCSP(allowScripts, allowFrames);
        mvt.put("content-security-policy", contentSecurityPolicy);
        mvt.put("x-content-security-policy", contentSecurityPolicy);
        mvt.put("x-webkit-csp", contentSecurityPolicy);
        mvt.put("x-frame-options", allowFrames ? "SAMEORIGIN" : "DENY");
        StringBuilder buf = new StringBuilder(1024);
        buf.append("HTTP/1.1 ");
        buf.append(replyCode);
        buf.append(' ');
        buf.append(replyDescription);
        buf.append("\r\n");
        Enumeration<String> e = mvt.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            Object[] list = mvt.getArray(key);
            key = ToadletContextImpl.fixKey(key);
            for (int i = 0; i < list.length; ++i) {
                String val = (String)list[i];
                buf.append(key);
                buf.append(": ");
                buf.append(val);
                buf.append("\r\n");
            }
        }
        buf.append("\r\n");
        sockOutputStream.write(buf.toString().getBytes("US-ASCII"));
    }

    private static String generateCSP(boolean allowScripts, boolean allowFrames) {
        StringBuilder sb = new StringBuilder();
        sb.append("default-src 'self' blob:; script-src ");
        sb.append(allowScripts ? "'self' 'unsafe-inline'; options inline-script" : ToadletContextImpl.generateRestrictedScriptSrc());
        sb.append("; frame-src ");
        sb.append(allowFrames ? "'self'" : "'none'");
        sb.append("; object-src 'none'");
        sb.append("; style-src 'self' 'unsafe-inline'");
        return sb.toString();
    }

    private static String generateRestrictedScriptSrc() {
        String[] allowedScriptHashes = new String[]{"sha256-kglOvopjCg9Et+Z7jBUnNbj1Rk9KWnmda4XnYrbYxsE="};
        if (allowedScriptHashes.length == 0) {
            return "'none'";
        }
        StringJoiner stringJoiner = new StringJoiner("' '", "'", "'");
        for (String source : allowedScriptHashes) {
            stringJoiner.add(source);
        }
        return stringJoiner.toString();
    }

    public static Date parseHTTPDate(String httpDate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        sdf.setTimeZone(TZ_UTC);
        return sdf.parse(httpDate);
    }

    private static String fixKey(String key) {
        StringBuilder sb = new StringBuilder(key.length());
        int prev = 0;
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (i == 0 || prev == 45) {
                c = Character.toUpperCase(c);
            }
            sb.append(c);
            prev = c;
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void handle(Socket sock, ToadletContainer container, PageMaker pageMaker, UserAlertManager userAlertManager, BookmarkManager bookmarkManager) {
        try {
            is = new BufferedInputStream(sock.getInputStream(), 4096);
            lis = new LineReadingInputStream(is);
            while (true) {
                if ((firstLine = lis.readLine(32768, 128, false)) == null) {
                    sock.close();
                    return;
                }
                if (firstLine.equals("")) continue;
                if (ToadletContextImpl.logMINOR) {
                    Logger.minor(ToadletContextImpl.class, "first line: " + firstLine);
                }
                if ((split = firstLine.split(" ")).length != 3) {
                    throw new ParseException("Could not parse request line (split.length=" + split.length + "): " + firstLine, -1);
                }
                if (!split[2].startsWith("HTTP/1.")) {
                    throw new ParseException("Unrecognized protocol " + split[2], -1);
                }
                try {
                    uri = URIPreEncoder.encodeURI(split[1]).normalize();
                    if (ToadletContextImpl.logMINOR) {
                        Logger.minor(ToadletContextImpl.class, "URI: " + uri + " path " + uri.getPath() + " host " + uri.getHost() + " frag " + uri.getFragment() + " port " + uri.getPort() + " query " + uri.getQuery() + " scheme " + uri.getScheme());
                    }
                }
                catch (URISyntaxException e) {
                    ToadletContextImpl.sendURIParseError(sock.getOutputStream(), true, e);
                    return;
                }
                method = split[0];
                headers = new MultiValueTable<String, String>();
                while (true) {
                    if ((line = lis.readLine(32768, 128, false)) == null) {
                        sock.close();
                        return;
                    }
                    if (line.length() == 0) break;
                    index = line.indexOf(58);
                    if (index < 0) {
                        throw new ParseException("Missing ':' in request header field", -1);
                    }
                    before = line.substring(0, index).toLowerCase();
                    after = line.substring(index + 1);
                    after = after.trim();
                    headers.put(before, after);
                }
                disconnect = ToadletContextImpl.shouldDisconnectAfterHandled(split[2].equals("HTTP/1.0"), headers) != false || container.enablePersistentConnections() == false;
                allowPost = container.allowPosts();
                bf = container.getBucketFactory();
                ctx = new ToadletContextImpl(sock, headers, bf, pageMaker, container, userAlertManager, bookmarkManager, uri, container.generateUniqueID());
                ctx.shouldDisconnect = disconnect;
                slen = headers.get("content-length");
                if ("POST".contains(method)) {
                    if (slen == null) {
                        ctx.shouldDisconnect = true;
                        ctx.sendReplyHeaders(400, "Bad Request", null, null, -1L);
                        return;
                    }
                } else if ("GET".contains(method) && slen != null) {
                    ctx.shouldDisconnect = true;
                    ctx.sendReplyHeaders(400, "Bad Request", null, null, -1L);
                    return;
                }
                if (slen == null) ** GOTO lbl75
                try {
                    len = Integer.parseInt(slen);
                    if (len < 0L) {
                        throw new NumberFormatException("content-length less than 0");
                    }
                }
                catch (NumberFormatException e) {
                    ctx.shouldDisconnect = true;
                    ctx.sendReplyHeaders(400, "Bad Request", null, null, -1L);
                    return;
                }
                if (allowPost && (!container.publicGatewayMode() || ctx.isAllowedFullAccess())) {
                    data = bf.makeBucket(len);
                    BucketTools.copyFrom(data, is, len);
                } else {
                    FileUtil.skipFully(is, len);
                    if (method.equals("POST")) {
                        ctx.sendMethodNotAllowed("POST", true);
                    } else {
                        ToadletContextImpl.sendError(sock.getOutputStream(), 403, "Forbidden", "Content not allowed in this configuration", true, null);
                    }
                    ctx.close();
                    return;
lbl75:
                    // 1 sources

                    data = null;
                }
                if (!container.enableExtendedMethodHandling() && !"GET POST".contains(method)) {
                    ToadletContextImpl.sendError(sock.getOutputStream(), 403, "Forbidden", "Method not allowed in this configuration", true, null);
                    return;
                }
                try {
                    redirect = true;
                    while (redirect) {
                        redirect = false;
                        try {
                            t = container.findToadlet(uri);
                        }
                        catch (PermanentRedirectException e) {
                            Toadlet.writePermanentRedirect(ctx, "Found elsewhere", e.newuri.toASCIIString());
                            break;
                        }
                        if (t == null) {
                            ctx.sendNoToadletError(ctx.shouldDisconnect);
                            break;
                        }
                        if (!t.findSupportedMethods().contains(method)) {
                            ctx.sendMethodNotAllowed(method, ctx.shouldDisconnect);
                            break;
                        }
                        req = new HTTPRequestImpl(uri, data, ctx, method);
                        if (method.equals("POST") && !t.allowPOSTWithoutPassword() && !ctx.checkFormPassword(req, t.path())) break;
                        if (ctx.isAllowedFullAccess()) {
                            ctx.getPageMaker().parseMode(req, container);
                        }
                        try {
                            ToadletContextImpl.callToadletMethod(t, method, uri, req, ctx, data, sock, redirect);
                        }
                        catch (RedirectException re) {
                            uri = re.newuri;
                            redirect = true;
                        }
                        finally {
                            req.freeParts();
                        }
                    }
                    if (!ctx.shouldDisconnect) continue;
                    sock.close();
                    return;
                }
                finally {
                    if (data == null) continue;
                    data.free();
                    continue;
                }
                break;
            }
        }
        catch (ParseException e) {
            try {
                ToadletContextImpl.sendError(sock.getOutputStream(), 400, "Bad Request", ToadletContextImpl.l10n("parseErrorWithError", "error", e.getMessage()), true, null);
            }
            catch (IOException lis) {}
        }
        catch (TooLongException e) {
            try {
                ToadletContextImpl.sendError(sock.getOutputStream(), 400, "Bad Request", ToadletContextImpl.l10n("headersLineTooLong"), true, null);
            }
            catch (IOException lis) {}
        }
        catch (IOException e) {
        }
        catch (ToadletContextClosedException e) {
            Logger.error(ToadletContextImpl.class, "ToadletContextClosedException while handling connection!");
        }
        catch (Throwable t) {
            Logger.error(ToadletContextImpl.class, "Caught error: " + t + " handling socket", t);
            try {
                msg = "<html><head><title>" + NodeL10n.getBase().getString("Toadlet.internalErrorTitle") + "</title></head><body><h1>" + NodeL10n.getBase().getString("Toadlet.internalErrorPleaseReport") + "</h1><pre>";
                sw = new StringWriter();
                pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                pw.flush();
                msg = msg + sw.toString() + "</pre></body></html>";
                messageBytes = msg.getBytes("UTF-8");
                ToadletContextImpl.sendReplyHeaders(sock.getOutputStream(), 500, "Internal failure", null, "text/html; charset=UTF-8", messageBytes.length, null, true, false, false);
                sock.getOutputStream().write(messageBytes);
            }
            catch (IOException var6_15) {
                // empty catch block
            }
        }
    }

    private static void callToadletMethod(Toadlet t, String method, URI uri, HTTPRequestImpl req, ToadletContextImpl ctx, Bucket data, Socket sock, boolean methodIsConfigurable) throws Throwable {
        String methodName = "handleMethod" + method;
        if (METHODS_CANNOT_HAVE_DATA.equals(method)) {
            if (data != null) {
                ToadletContextImpl.sendError(sock.getOutputStream(), 400, "Bad Request", "Content not allowed", true, null);
                ctx.close();
                return;
            }
            ctx.setActiveToadlet(t);
            t.handleMethodGET(uri, req, ctx);
            return;
        }
        try {
            Class<?> c = t.getClass();
            Method m = c.getMethod(methodName, HANDLE_PARAMETERS);
            if (methodIsConfigurable) {
                AllowData anno = m.getAnnotation(AllowData.class);
                if (anno == null) {
                    if (data != null) {
                        ToadletContextImpl.sendError(sock.getOutputStream(), 400, "Bad Request", "Content not allowed", true, null);
                        ctx.close();
                        return;
                    }
                } else if (anno.value() && data == null) {
                    ToadletContextImpl.sendError(sock.getOutputStream(), 400, "Bad Request", "Missing Content", true, null);
                    ctx.close();
                    return;
                }
            }
            ctx.setActiveToadlet(t);
            Object[] arglist = new Object[]{uri, req, ctx};
            m.invoke((Object)t, arglist);
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
    }

    private void setActiveToadlet(Toadlet t) {
        this.activeToadlet = t;
    }

    @Override
    public Toadlet activeToadlet() {
        return this.activeToadlet;
    }

    private static boolean shouldDisconnectAfterHandled(boolean isHTTP10, MultiValueTable<String, String> headers) {
        String connection = headers.get("connection");
        if (connection != null) {
            if (connection.equalsIgnoreCase("close")) {
                return true;
            }
            if (connection.equalsIgnoreCase("keep-alive")) {
                return false;
            }
        }
        return isHTTP10;
    }

    @Override
    public void writeData(byte[] data, int offset, int length) throws ToadletContextClosedException, IOException {
        if (this.closed) {
            throw new ToadletContextClosedException();
        }
        this.sockOutputStream.write(data, offset, length);
    }

    @Override
    public void writeData(byte[] data) throws ToadletContextClosedException, IOException {
        this.writeData(data, 0, data.length);
    }

    @Override
    public void writeData(Bucket data) throws ToadletContextClosedException, IOException {
        if (this.closed) {
            throw new ToadletContextClosedException();
        }
        BucketTools.copyTo(data, this.sockOutputStream, Long.MAX_VALUE);
        data.free();
    }

    @Override
    public BucketFactory getBucketFactory() {
        return this.bf;
    }

    @Override
    public HTMLNode addFormChild(HTMLNode parentNode, String target, String name) {
        return this.container.addFormChild(parentNode, target, name);
    }

    @Override
    public boolean isAllowedFullAccess() {
        return this.container.isAllowedFullAccess(this.remoteAddr);
    }

    @Override
    public boolean isAdvancedModeEnabled() {
        return this.container.isAdvancedModeEnabled();
    }

    @Override
    public boolean doRobots() {
        return this.container.doRobots();
    }

    @Override
    public void forceDisconnect() {
        this.shouldDisconnect = true;
    }

    @Override
    public ToadletContainer getContainer() {
        return this.container;
    }

    @Override
    public boolean disableProgressPage() {
        return this.container.disableProgressPage();
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public FProxyFetchInProgress.REFILTER_POLICY getReFilterPolicy() {
        return this.container.getReFilterPolicy();
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
        TZ_UTC = TimeZone.getTimeZone("UTC");
    }
}

