/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.crypt.BlockCipher;
import freenet.crypt.HMAC;
import freenet.crypt.PCFBMode;
import freenet.io.comm.DMT;
import freenet.io.comm.Message;
import freenet.io.comm.Peer;
import freenet.io.xfer.PacketThrottle;
import freenet.node.BasePeerNode;
import freenet.node.BlockedTooLongException;
import freenet.node.DecodingMessageGroup;
import freenet.node.MessageFragment;
import freenet.node.MessageItem;
import freenet.node.MessageWrapper;
import freenet.node.NPFPacket;
import freenet.node.NewPacketFormatKeyContext;
import freenet.node.Node;
import freenet.node.PacketFormat;
import freenet.node.PacketSender;
import freenet.node.PeerMessageQueue;
import freenet.node.PeerNode;
import freenet.node.SessionKey;
import freenet.support.Fields;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SparseBitmap;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class NewPacketFormat
implements PacketFormat {
    private static final int HMAC_LENGTH = 10;
    private static final int NUM_SEQNUMS_TO_WATCH_FOR = 1024;
    private static final int MAX_RECEIVE_BUFFER_SIZE = 262144;
    private static final int MSG_WINDOW_SIZE = 65536;
    private static final int NUM_MESSAGE_IDS = 0x10000000;
    static final long NUM_SEQNUMS = 0x80000000L;
    private static final long MAX_MSGID_BLOCK_TIME = TimeUnit.MINUTES.toMillis(10L);
    private static final int MAX_ACKS = 500;
    static boolean DO_KEEPALIVES = true;
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private final BasePeerNode pn;
    private final List<Map<Integer, MessageWrapper>> startedByPrio;
    private int nextMessageID;
    private int messageWindowPtrAcked;
    private final SparseBitmap ackedMessages = new SparseBitmap();
    private final HashMap<Integer, PartiallyReceivedBuffer> receiveBuffers = new HashMap();
    private final HashMap<Integer, SparseBitmap> receiveMaps = new HashMap();
    private int messageWindowPtrReceived;
    private final SparseBitmap receivedMessages = new SparseBitmap();
    private int receiveBufferUsed = 0;
    private int sendBufferUsed = 0;
    private final Object sendBufferLock = new Object();
    private final Object receiveBufferSizeLock = new Object();
    private long timeLastSentPacket;
    private long timeLastSentPayload;
    private int pingCounter;
    public static final int MAX_MESSAGE_SIZE = 4096;
    private long blockedSince = -1L;

    NewPacketFormat(BasePeerNode pn, int ourInitialMsgID, int theirInitialMsgID) {
        this.pn = pn;
        this.startedByPrio = new ArrayList<Map<Integer, MessageWrapper>>(6);
        for (int i = 0; i < 6; ++i) {
            this.startedByPrio.add(new HashMap());
        }
        ourInitialMsgID = (ourInitialMsgID & Integer.MAX_VALUE) % 0x10000000;
        theirInitialMsgID = (theirInitialMsgID & Integer.MAX_VALUE) % 0x10000000;
        this.nextMessageID = ourInitialMsgID;
        this.messageWindowPtrAcked = ourInitialMsgID;
        this.messageWindowPtrReceived = theirInitialMsgID;
    }

    @Override
    public boolean handleReceivedPacket(byte[] buf, int offset, int length, long now, Peer replyTo) {
        NPFPacket packet = null;
        SessionKey s = null;
        for (int i = 0; i < 3; ++i) {
            s = i == 0 ? this.pn.getCurrentKeyTracker() : (i == 1 ? this.pn.getPreviousKeyTracker() : this.pn.getUnverifiedKeyTracker());
            if (s == null || (packet = this.tryDecipherPacket(buf, offset, length, s)) == null) continue;
            if (!logDEBUG) break;
            Logger.debug(this, "Decrypted packet with tracker " + i);
            break;
        }
        if (packet == null) {
            if (logMINOR) {
                Logger.minor(this, "Could not decrypt received packet");
            }
            return false;
        }
        this.pn.receivedPacket(false, true);
        this.pn.verified(s);
        this.pn.maybeRekey();
        this.pn.reportIncomingBytes(length);
        List<byte[]> finished = this.handleDecryptedPacket(packet, s);
        if (logMINOR && !finished.isEmpty()) {
            Logger.minor(this, "Decoded messages: " + finished.size());
        }
        DecodingMessageGroup group = this.pn.startProcessingDecryptedMessages(finished.size());
        for (byte[] buffer : finished) {
            group.processDecryptedMessage(buffer, 0, buffer.length, 0);
        }
        group.complete();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<byte[]> handleDecryptedPacket(NPFPacket packet, SessionKey sessionKey) {
        List<byte[]> l;
        LinkedList<byte[]> fullyReceived = new LinkedList<byte[]>();
        NewPacketFormatKeyContext keyContext = sessionKey.packetContext;
        Iterator iterator = packet.getAcks().iterator();
        while (iterator.hasNext()) {
            int ack = (Integer)iterator.next();
            keyContext.ack(ack, this.pn, sessionKey);
        }
        boolean dontAck = false;
        boolean wakeUp = false;
        if (packet.getError() || packet.getFragments().size() == 0) {
            if (logMINOR) {
                Logger.minor(this, "Not acking because " + (packet.getError() ? "error" : "no fragments"));
            }
            dontAck = true;
        }
        if ((l = packet.getLossyMessages()) != null && !l.isEmpty()) {
            ArrayList lossyMessages = new ArrayList(l.size());
            for (byte[] buf : l) {
                Message msg = Message.decodeMessageLax(buf, this.pn, 0);
                if (msg == null) {
                    lossyMessages.clear();
                    break;
                }
                if (!msg.getSpec().isLossyPacketMessage()) {
                    lossyMessages.clear();
                    break;
                }
                lossyMessages.add(msg);
            }
            if (logMINOR && lossyMessages.size() > 0) {
                Logger.minor(this, "Successfully parsed " + lossyMessages.size() + " lossy packet messages");
            }
            Iterator<Object> iterator2 = lossyMessages.iterator();
            while (iterator2.hasNext()) {
                Message msg = (Message)iterator2.next();
                this.pn.handleMessage(msg);
            }
        }
        for (MessageFragment fragment : packet.getFragments()) {
            Object object;
            int upperBound2;
            if (this.messageWindowPtrReceived + 65536 > 0x10000000) {
                upperBound2 = (this.messageWindowPtrReceived + 65536) % 0x10000000;
                if (fragment.messageID > upperBound2 && fragment.messageID < this.messageWindowPtrReceived) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "Received message " + fragment.messageID + " outside window, acking");
                    continue;
                }
            } else {
                upperBound2 = this.messageWindowPtrReceived + 65536;
                if (fragment.messageID < this.messageWindowPtrReceived || fragment.messageID >= upperBound2) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "Received message " + fragment.messageID + " outside window, acking");
                    continue;
                }
            }
            SparseBitmap upperBound2 = this.receivedMessages;
            synchronized (upperBound2) {
                if (this.receivedMessages.contains(fragment.messageID, fragment.messageID)) {
                    continue;
                }
            }
            PartiallyReceivedBuffer recvBuffer = this.receiveBuffers.get(fragment.messageID);
            SparseBitmap recvMap = this.receiveMaps.get(fragment.messageID);
            if (recvBuffer == null) {
                if (logMINOR) {
                    Logger.minor(this, "Message id " + fragment.messageID + ": Creating buffer");
                }
                recvBuffer = new PartiallyReceivedBuffer(this);
                if (fragment.firstFragment) {
                    if (!recvBuffer.setMessageLength(fragment.messageLength)) {
                        dontAck = true;
                        continue;
                    }
                } else {
                    object = this.receiveBufferSizeLock;
                    synchronized (object) {
                        if (this.receiveBufferUsed + fragment.fragmentLength > 262144) {
                            if (logMINOR) {
                                Logger.minor(this, "Could not create buffer, would excede max size");
                            }
                            dontAck = true;
                            continue;
                        }
                    }
                }
                recvMap = new SparseBitmap();
                this.receiveBuffers.put(fragment.messageID, recvBuffer);
                this.receiveMaps.put(fragment.messageID, recvMap);
            } else if (fragment.firstFragment && !recvBuffer.setMessageLength(fragment.messageLength)) {
                dontAck = true;
                continue;
            }
            if (!recvBuffer.add(fragment.fragmentData, fragment.fragmentOffset)) {
                dontAck = true;
                continue;
            }
            if (fragment.fragmentLength == 0) {
                Logger.warning(this, "Received fragment of length 0");
                continue;
            }
            recvMap.add(fragment.fragmentOffset, fragment.fragmentOffset + fragment.fragmentLength - 1);
            if (recvBuffer.messageLength != -1 && recvMap.contains(0, recvBuffer.messageLength - 1)) {
                this.receiveBuffers.remove(fragment.messageID);
                this.receiveMaps.remove(fragment.messageID);
                object = this.receivedMessages;
                synchronized (object) {
                    if (this.receivedMessages.contains(fragment.messageID, fragment.messageID)) {
                        continue;
                    }
                    this.receivedMessages.add(fragment.messageID, fragment.messageID);
                    int oldWindow = this.messageWindowPtrReceived;
                    while (this.receivedMessages.contains(this.messageWindowPtrReceived, this.messageWindowPtrReceived)) {
                        ++this.messageWindowPtrReceived;
                        if (this.messageWindowPtrReceived != 0x10000000) continue;
                        this.messageWindowPtrReceived = 0;
                    }
                    if (this.messageWindowPtrReceived < oldWindow) {
                        this.receivedMessages.remove(oldWindow, 0xFFFFFFF);
                        this.receivedMessages.remove(0, this.messageWindowPtrReceived);
                    } else {
                        this.receivedMessages.remove(oldWindow, this.messageWindowPtrReceived);
                    }
                }
                object = this.sendBufferLock;
                synchronized (object) {
                    this.receiveBufferUsed -= recvBuffer.messageLength;
                    if (logDEBUG) {
                        Logger.debug(this, "Removed " + recvBuffer.messageLength + " from buffer. Total is now " + this.receiveBufferUsed);
                    }
                }
                fullyReceived.add(recvBuffer.buffer);
                if (!logMINOR) continue;
                Logger.minor(this, "Message id " + fragment.messageID + ": Completed");
                continue;
            }
            if (!logDEBUG) continue;
            Logger.debug(this, "Message id " + fragment.messageID + ": " + recvMap);
        }
        if (!dontAck) {
            boolean addedAck;
            int seqno = packet.getSequenceNumber();
            int acksQueued = keyContext.queueAck(seqno);
            boolean bl = addedAck = acksQueued >= 0;
            if (acksQueued > 500) {
                wakeUp = true;
            }
            if (addedAck) {
                if (!wakeUp) {
                    Object object = this.sendBufferLock;
                    synchronized (object) {
                        if (this.receiveBufferUsed > 131072) {
                            wakeUp = true;
                        }
                    }
                }
                if (wakeUp) {
                    this.pn.wakeUpSender();
                }
            }
        }
        return fullyReceived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NPFPacket tryDecipherPacket(byte[] buf, int offset, int length, SessionKey sessionKey) {
        int highestReceivedSeqNum;
        NewPacketFormatKeyContext keyContext = sessionKey.packetContext;
        if (keyContext.seqNumWatchList == null) {
            if (logMINOR) {
                Logger.minor(this, "Creating watchlist starting at " + keyContext.watchListOffset);
            }
            keyContext.seqNumWatchList = new byte[1024][4];
            int seqNum = keyContext.watchListOffset;
            for (int i = 0; i < keyContext.seqNumWatchList.length; ++i) {
                keyContext.seqNumWatchList[i] = NewPacketFormat.encryptSequenceNumber(seqNum++, sessionKey);
                if (seqNum >= 0) continue;
                seqNum = 0;
            }
        }
        NewPacketFormat i = this;
        synchronized (i) {
            highestReceivedSeqNum = keyContext.highestReceivedSeqNum;
        }
        int oldHighestReceived = (int)((0L + (long)keyContext.watchListOffset + (long)(keyContext.seqNumWatchList.length / 2)) % 0x80000000L);
        if (this.seqNumGreaterThan(highestReceivedSeqNum, oldHighestReceived, 31)) {
            int moveBy = highestReceivedSeqNum > oldHighestReceived ? highestReceivedSeqNum - oldHighestReceived : (int)(0x80000000L - (long)oldHighestReceived) + highestReceivedSeqNum;
            if (moveBy > keyContext.seqNumWatchList.length) {
                Logger.warning(this, "Moving watchlist pointer by " + moveBy);
            } else if (moveBy < 0) {
                Logger.warning(this, "Tried moving watchlist pointer by " + moveBy);
                moveBy = 0;
            } else if (logDEBUG) {
                Logger.debug(this, "Moving watchlist pointer by " + moveBy);
            }
            int seqNum = (int)((0L + (long)keyContext.watchListOffset + (long)keyContext.seqNumWatchList.length) % 0x80000000L);
            for (int i2 = keyContext.watchListPointer; i2 < keyContext.watchListPointer + moveBy; ++i2) {
                keyContext.seqNumWatchList[i2 % keyContext.seqNumWatchList.length] = NewPacketFormat.encryptSequenceNumber(seqNum++, sessionKey);
                if (seqNum >= 0) continue;
                seqNum = 0;
            }
            keyContext.watchListPointer = (keyContext.watchListPointer + moveBy) % keyContext.seqNumWatchList.length;
            keyContext.watchListOffset = (int)((0L + (long)keyContext.watchListOffset + (long)moveBy) % 0x80000000L);
        }
        for (int i3 = 0; i3 < keyContext.seqNumWatchList.length; ++i3) {
            NPFPacket p;
            int index = (keyContext.watchListPointer + i3) % keyContext.seqNumWatchList.length;
            if (!Fields.byteArrayEqual(buf, keyContext.seqNumWatchList[index], offset + 10, 0, keyContext.seqNumWatchList[index].length)) continue;
            int sequenceNumber = (int)((0L + (long)keyContext.watchListOffset + (long)i3) % 0x80000000L);
            if (logDEBUG) {
                Logger.debug(this, "Received packet matches sequence number " + sequenceNumber);
            }
            if ((p = this.decipherFromSeqnum(buf, offset, length, sessionKey, sequenceNumber)) == null) continue;
            if (logMINOR) {
                Logger.minor(this, "Received packet " + p.getSequenceNumber() + " on " + sessionKey);
            }
            return p;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NPFPacket decipherFromSeqnum(byte[] buf, int offset, int length, SessionKey sessionKey, int sequenceNumber) {
        BlockCipher ivCipher = sessionKey.ivCipher;
        byte[] IV = new byte[ivCipher.getBlockSize() / 8];
        System.arraycopy(sessionKey.ivNonce, 0, IV, 0, IV.length);
        IV[IV.length - 4] = (byte)(sequenceNumber >>> 24);
        IV[IV.length - 3] = (byte)(sequenceNumber >>> 16);
        IV[IV.length - 2] = (byte)(sequenceNumber >>> 8);
        IV[IV.length - 1] = (byte)sequenceNumber;
        ivCipher.encipher(IV, IV);
        byte[] payload = Arrays.copyOfRange(buf, offset + 10, offset + length);
        byte[] hash = Arrays.copyOfRange(buf, offset, offset + 10);
        byte[] localHash = Arrays.copyOf(HMAC.macWithSHA256(sessionKey.hmacKey, payload), 10);
        if (!MessageDigest.isEqual(hash, localHash)) {
            if (logMINOR) {
                Logger.minor(this, "Failed to validate the HMAC using TrackerID=" + sessionKey.trackerID);
            }
            return null;
        }
        PCFBMode payloadCipher = PCFBMode.create(sessionKey.incommingCipher, IV);
        payloadCipher.blockDecipher(payload, 0, payload.length);
        NPFPacket p = NPFPacket.create(payload, this.pn);
        NewPacketFormatKeyContext keyContext = sessionKey.packetContext;
        NewPacketFormat newPacketFormat = this;
        synchronized (newPacketFormat) {
            if (this.seqNumGreaterThan(sequenceNumber, keyContext.highestReceivedSeqNum, 31)) {
                keyContext.highestReceivedSeqNum = sequenceNumber;
            }
        }
        return p;
    }

    private boolean seqNumGreaterThan(long i1, long i2, int serialBits) {
        long halfValue = (long)Math.pow(2.0, serialBits - 1);
        return i1 < i2 && i2 - i1 > halfValue || i1 > i2 && i1 - i2 < halfValue;
    }

    static byte[] encryptSequenceNumber(int seqNum, SessionKey sessionKey) {
        byte[] seqNumBytes = new byte[]{(byte)(seqNum >>> 24), (byte)(seqNum >>> 16), (byte)(seqNum >>> 8), (byte)seqNum};
        BlockCipher ivCipher = sessionKey.ivCipher;
        byte[] IV = new byte[ivCipher.getBlockSize() / 8];
        System.arraycopy(sessionKey.ivNonce, 0, IV, 0, IV.length);
        System.arraycopy(seqNumBytes, 0, IV, IV.length - seqNumBytes.length, seqNumBytes.length);
        ivCipher.encipher(IV, IV);
        PCFBMode cipher = PCFBMode.create(sessionKey.incommingCipher, IV);
        cipher.blockEncipher(seqNumBytes, 0, seqNumBytes.length);
        return seqNumBytes;
    }

    @Override
    public boolean maybeSendPacket(long now, boolean ackOnly) throws BlockedTooLongException {
        SessionKey sessionKey = this.pn.getPreviousKeyTracker();
        if (sessionKey != null && this.maybeSendPacket(true, sessionKey)) {
            return true;
        }
        sessionKey = this.pn.getUnverifiedKeyTracker();
        if (sessionKey != null && this.maybeSendPacket(true, sessionKey)) {
            return true;
        }
        sessionKey = this.pn.getCurrentKeyTracker();
        if (sessionKey == null) {
            Logger.warning(this, "No key for encrypting hash");
            return false;
        }
        return this.maybeSendPacket(ackOnly, sessionKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean maybeSendPacket(boolean ackOnly, SessionKey sessionKey) throws BlockedTooLongException {
        int maxPacketSize = this.pn.getMaxPacketSize();
        NewPacketFormatKeyContext keyContext = sessionKey.packetContext;
        NPFPacket packet = this.createPacket(maxPacketSize - 10, this.pn.getMessageQueue(), sessionKey, ackOnly);
        if (packet == null) {
            return false;
        }
        int paddedLen = packet.getLength() + 10;
        if (this.pn.shouldPadDataPackets()) {
            int packetLength = paddedLen;
            if (logDEBUG) {
                Logger.debug(this, "Pre-padding length: " + packetLength);
            }
            if (packetLength < 64) {
                paddedLen = 64 + this.pn.paddingGen().nextInt(32);
            } else {
                paddedLen = (packetLength + 63) / 64 * 64;
                if (paddedLen < maxPacketSize) {
                    paddedLen += this.pn.paddingGen().nextInt(Math.min(64, maxPacketSize - paddedLen));
                } else if (packetLength <= maxPacketSize && paddedLen > maxPacketSize) {
                    paddedLen = maxPacketSize;
                }
            }
        }
        byte[] data = new byte[paddedLen];
        packet.toBytes(data, 10, this.pn.paddingGen());
        BlockCipher ivCipher = sessionKey.ivCipher;
        byte[] IV = new byte[ivCipher.getBlockSize() / 8];
        System.arraycopy(sessionKey.ivNonce, 0, IV, 0, IV.length);
        System.arraycopy(data, 10, IV, IV.length - 4, 4);
        ivCipher.encipher(IV, IV);
        PCFBMode payloadCipher = PCFBMode.create(sessionKey.outgoingCipher, IV);
        payloadCipher.blockEncipher(data, 10, paddedLen - 10);
        byte[] text = new byte[paddedLen - 10];
        System.arraycopy(data, 10, text, 0, text.length);
        byte[] hash = HMAC.macWithSHA256(sessionKey.hmacKey, text);
        System.arraycopy(hash, 0, data, 0, 10);
        try {
            if (logMINOR) {
                String fragments = null;
                for (MessageFragment frag : packet.getFragments()) {
                    fragments = fragments == null ? String.valueOf(frag.messageID) : fragments + ", " + frag.messageID;
                    fragments = fragments + " (" + frag.fragmentOffset + "->" + (frag.fragmentOffset + frag.fragmentLength - 1) + ")";
                }
                Logger.minor(this, "Sending packet " + packet.getSequenceNumber() + " (" + data.length + " bytes) with fragments " + fragments + " and " + packet.getAcks().size() + " acks on " + this);
            }
            this.pn.sendEncryptedPacket(data);
        }
        catch (Peer.LocalAddressException e) {
            Logger.error(this, "Caught exception while sending packet", (Throwable)e);
            return false;
        }
        packet.onSent(data.length, this.pn);
        if (packet.getFragments().size() > 0) {
            keyContext.sent(packet.getSequenceNumber(), packet.getLength());
        }
        long now = System.currentTimeMillis();
        this.pn.sentPacket();
        this.pn.reportOutgoingBytes(data.length);
        if (this.pn.shouldThrottle()) {
            this.pn.sentThrottledBytes(data.length);
        }
        if (packet.getFragments().size() == 0) {
            this.pn.onNotificationOnlyPacketSent(data.length);
        }
        NewPacketFormat newPacketFormat = this;
        synchronized (newPacketFormat) {
            if (this.timeLastSentPacket < now) {
                this.timeLastSentPacket = now;
            }
            if (packet.getFragments().size() > 0 && this.timeLastSentPayload < now) {
                this.timeLastSentPayload = now;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NPFPacket createPacket(int maxPacketSize, PeerMessageQueue messageQueue, SessionKey sessionKey, boolean ackOnly) throws BlockedTooLongException {
        Object item;
        int numAcks;
        this.checkForLostPackets();
        NPFPacket packet = new NPFPacket();
        SentPacket sentPacket = new SentPacket(this, sessionKey);
        boolean mustSend = false;
        long now = System.currentTimeMillis();
        NewPacketFormatKeyContext keyContext = sessionKey.packetContext;
        NewPacketFormatKeyContext.AddedAcks moved = keyContext.addAcks(packet, maxPacketSize, now);
        if (moved != null && moved.anyUrgentAcks) {
            if (logDEBUG) {
                Logger.debug(this, "Must send because urgent acks");
            }
            mustSend = true;
        }
        if ((numAcks = packet.countAcks()) > 500) {
            mustSend = true;
        }
        if (numAcks > 0 && logDEBUG) {
            Logger.debug(this, "Added acks for " + this + " for " + this.pn.shortToString());
        }
        byte[] haveAddedStatsBulk = null;
        byte[] haveAddedStatsRT = null;
        if (!ackOnly) {
            boolean addedFragments = false;
            while (true) {
                byte[] buf;
                boolean addStatsBulk = false;
                boolean addStatsRT = false;
                Object object = this.sendBufferLock;
                synchronized (object) {
                    block16: for (Map<Integer, MessageWrapper> started : this.startedByPrio) {
                        Iterator<MessageWrapper> it = started.values().iterator();
                        while (it.hasNext() && packet.getLength() < maxPacketSize) {
                            MessageFragment frag;
                            MessageWrapper wrapper = it.next();
                            while (packet.getLength() < maxPacketSize && (frag = wrapper.getMessageFragment(maxPacketSize - packet.getLength())) != null) {
                                mustSend = true;
                                addedFragments = true;
                                packet.addMessageFragment(frag);
                                sentPacket.addFragment(frag);
                                if (!wrapper.allSent()) continue;
                                if (haveAddedStatsBulk == null && wrapper.getItem().sendLoadBulk) {
                                    addStatsBulk = true;
                                    break block16;
                                }
                                if (haveAddedStatsRT != null || !wrapper.getItem().sendLoadRT) continue;
                                addStatsRT = true;
                                break block16;
                            }
                        }
                    }
                }
                if (!addStatsBulk && !addStatsRT) break;
                if (addStatsBulk && (item = this.pn.makeLoadStats(false, false, true)) != null) {
                    haveAddedStatsBulk = buf = ((MessageItem)item).getData();
                    packet.addLossyMessage(buf, maxPacketSize);
                }
                if (!addStatsRT || (item = this.pn.makeLoadStats(true, false, true)) == null) continue;
                haveAddedStatsRT = buf = ((MessageItem)item).getData();
                packet.addLossyMessage(buf, maxPacketSize);
            }
            if (addedFragments && logDEBUG) {
                Logger.debug(this, "Added fragments for " + this + " (must send)");
            }
        }
        if (!mustSend && packet.getLength() >= maxPacketSize * 4 / 5) {
            if (logDEBUG) {
                Logger.debug(this, "Must send because packet is big on acks alone");
            }
            mustSend = true;
        }
        if (!ackOnly && !mustSend && (messageQueue.mustSendNow(now) || messageQueue.mustSendSize(packet.getLength(), maxPacketSize))) {
            if (logDEBUG) {
                Logger.debug(this, "Must send because of message queue");
            }
            mustSend = true;
        }
        if (!mustSend && numAcks > 0) {
            int maxSendBufferSize = this.maxSendBufferSize();
            Object addStatsBulk = this.sendBufferLock;
            synchronized (addStatsBulk) {
                if (this.sendBufferUsed > maxSendBufferSize / 2) {
                    if (logDEBUG) {
                        Logger.debug(this, "Must send because other side buffer size is " + this.sendBufferUsed);
                    }
                    mustSend = true;
                }
            }
        }
        boolean checkedCanSend = false;
        boolean cantSend = false;
        boolean mustSendKeepalive = false;
        if (DO_KEEPALIVES) {
            item = this;
            synchronized (item) {
                if (!mustSend && now - this.timeLastSentPacket > Node.KEEPALIVE_INTERVAL) {
                    mustSend = true;
                }
                if (!ackOnly && now - this.timeLastSentPayload > Node.KEEPALIVE_INTERVAL && packet.getFragments().isEmpty()) {
                    mustSendKeepalive = true;
                }
            }
        }
        if (mustSendKeepalive) {
            if (!checkedCanSend) {
                cantSend = !this.canSend(sessionKey);
            }
            checkedCanSend = true;
            if (!cantSend) {
                mustSend = true;
            }
        }
        if (!mustSend) {
            if (moved != null) {
                moved.abort();
            }
            return null;
        }
        boolean sendStatsBulk = false;
        boolean sendStatsRT = false;
        if (!ackOnly) {
            sendStatsBulk = this.pn.grabSendLoadStatsASAP(false);
            sendStatsRT = this.pn.grabSendLoadStatsASAP(true);
            if (sendStatsBulk || sendStatsRT) {
                if (!checkedCanSend) {
                    cantSend = !this.canSend(sessionKey);
                }
                checkedCanSend = true;
                if (cantSend) {
                    if (sendStatsBulk) {
                        this.pn.setSendLoadStatsASAP(false);
                    }
                    if (sendStatsRT) {
                        this.pn.setSendLoadStatsASAP(true);
                    }
                } else {
                    mustSend = true;
                }
            }
        }
        if (ackOnly && numAcks == 0) {
            return null;
        }
        if (!ackOnly && !cantSend) {
            MessageItem item2;
            if (sendStatsBulk && (item2 = this.pn.makeLoadStats(false, true, false)) != null) {
                if (haveAddedStatsBulk != null) {
                    packet.removeLossyMessage(haveAddedStatsBulk);
                }
                messageQueue.pushfrontPrioritizedMessageItem(item2);
                haveAddedStatsBulk = item2.buf;
            }
            if (sendStatsRT && (item2 = this.pn.makeLoadStats(true, true, false)) != null) {
                if (haveAddedStatsRT != null) {
                    packet.removeLossyMessage(haveAddedStatsRT);
                }
                messageQueue.pushfrontPrioritizedMessageItem(item2);
                haveAddedStatsRT = item2.buf;
            }
            block19: for (int i = 0; i < this.startedByPrio.size(); ++i) {
                do {
                    byte[] buf;
                    MessageItem item3;
                    boolean addStatsBulk = false;
                    boolean addStatsRT = false;
                    while (packet.getLength() + 10 < maxPacketSize) {
                        MessageWrapper wrapper;
                        MessageFragment frag;
                        int messageID;
                        if (!checkedCanSend) {
                            cantSend = !this.canSend(sessionKey);
                        }
                        checkedCanSend = false;
                        if (cantSend) break;
                        boolean wasGeneratedPing = false;
                        MessageItem item4 = messageQueue.grabQueuedMessageItem(i);
                        if (item4 == null) {
                            Message msg;
                            if (!mustSendKeepalive || !packet.noFragments()) continue block19;
                            NewPacketFormat newPacketFormat = this;
                            synchronized (newPacketFormat) {
                                msg = DMT.createFNPPing(this.pingCounter++);
                            }
                            item4 = new MessageItem(msg, null, null);
                            item4.setDeadline(now + PacketSender.MAX_COALESCING_DELAY);
                            wasGeneratedPing = true;
                        }
                        if ((messageID = this.getMessageID()) == -1) {
                            Logger.error(this, "No availiable message ID, requeuing and sending packet (we already checked didn't we???)");
                            if (wasGeneratedPing) break block19;
                            messageQueue.pushfrontPrioritizedMessageItem(item4);
                            break block19;
                        }
                        if (logDEBUG) {
                            Logger.debug(this, "Allocated " + messageID + " for " + item4 + " for " + this);
                        }
                        if ((frag = (wrapper = new MessageWrapper(item4, messageID)).getMessageFragment(maxPacketSize - packet.getLength())) == null) {
                            messageQueue.pushfrontPrioritizedMessageItem(item4);
                            continue block19;
                        }
                        packet.addMessageFragment(frag);
                        sentPacket.addFragment(frag);
                        Map<Integer, MessageWrapper> queue = this.startedByPrio.get(item4.getPriority());
                        Object object = this.sendBufferLock;
                        synchronized (object) {
                            this.sendBufferUsed += item4.buf.length;
                            if (logDEBUG) {
                                Logger.debug(this, "Added " + item4.buf.length + " to remote buffer. Total is now " + this.sendBufferUsed + " for " + this.pn.shortToString());
                            }
                            queue.put(messageID, wrapper);
                        }
                        if (!wrapper.allSent()) continue;
                        if (haveAddedStatsBulk == null && wrapper.getItem().sendLoadBulk) {
                            addStatsBulk = true;
                            break;
                        }
                        if (haveAddedStatsRT != null || !wrapper.getItem().sendLoadRT) continue;
                        addStatsRT = true;
                        break;
                    }
                    if (!addStatsBulk && !addStatsRT) continue block19;
                    if (addStatsBulk && (item3 = this.pn.makeLoadStats(false, false, true)) != null) {
                        buf = item3.getData();
                        haveAddedStatsBulk = item3.buf;
                        packet.addLossyMessage(buf, maxPacketSize);
                    }
                    if (!addStatsRT || (item3 = this.pn.makeLoadStats(true, false, true)) == null) continue;
                    buf = item3.getData();
                    haveAddedStatsRT = item3.buf;
                    packet.addLossyMessage(buf, maxPacketSize);
                } while (!cantSend);
            }
        }
        if (packet.getLength() == 5) {
            return null;
        }
        int seqNum = keyContext.allocateSequenceNumber(this.pn);
        if (seqNum == -1) {
            return null;
        }
        packet.setSequenceNumber(seqNum);
        if (logDEBUG && ackOnly) {
            Logger.debug(this, "Sending ack-only packet length " + packet.getLength() + " for " + this);
        } else if (logDEBUG && !ackOnly) {
            Logger.debug(this, "Sending packet length " + packet.getLength() + " for " + this);
        }
        if (packet.getFragments().size() > 0) {
            keyContext.sent(sentPacket, seqNum, packet.getLength());
        }
        return packet;
    }

    private int maxSendBufferSize() {
        return 262144;
    }

    @Override
    public long timeCheckForLostPackets() {
        long timeCheck = Long.MAX_VALUE;
        double averageRTT = this.averageRTT();
        SessionKey key = this.pn.getCurrentKeyTracker();
        if (key != null) {
            timeCheck = Math.min(timeCheck, key.packetContext.timeCheckForLostPackets(averageRTT));
        }
        if ((key = this.pn.getPreviousKeyTracker()) != null) {
            timeCheck = Math.min(timeCheck, key.packetContext.timeCheckForLostPackets(averageRTT));
        }
        if ((key = this.pn.getUnverifiedKeyTracker()) != null) {
            timeCheck = Math.min(timeCheck, key.packetContext.timeCheckForLostPackets(averageRTT));
        }
        return timeCheck;
    }

    private long timeCheckForAcks() {
        long timeCheck = Long.MAX_VALUE;
        SessionKey key = this.pn.getCurrentKeyTracker();
        if (key != null) {
            timeCheck = Math.min(timeCheck, key.packetContext.timeCheckForAcks());
        }
        if ((key = this.pn.getPreviousKeyTracker()) != null) {
            timeCheck = Math.min(timeCheck, key.packetContext.timeCheckForAcks());
        }
        if ((key = this.pn.getUnverifiedKeyTracker()) != null) {
            timeCheck = Math.min(timeCheck, key.packetContext.timeCheckForAcks());
        }
        return timeCheck;
    }

    @Override
    public void checkForLostPackets() {
        if (this.pn == null) {
            return;
        }
        double averageRTT = this.averageRTT();
        long curTime = System.currentTimeMillis();
        SessionKey key = this.pn.getCurrentKeyTracker();
        if (key != null) {
            key.packetContext.checkForLostPackets(averageRTT, curTime, this.pn);
        }
        if ((key = this.pn.getPreviousKeyTracker()) != null) {
            key.packetContext.checkForLostPackets(averageRTT, curTime, this.pn);
        }
        if ((key = this.pn.getUnverifiedKeyTracker()) != null) {
            key.packetContext.checkForLostPackets(averageRTT, curTime, this.pn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageItem> onDisconnect() {
        int messageSize = 0;
        ArrayList<MessageItem> items = new ArrayList<MessageItem>();
        Object object = this.sendBufferLock;
        synchronized (object) {
            for (Map<Integer, MessageWrapper> queue : this.startedByPrio) {
                for (MessageWrapper wrapper : queue.values()) {
                    items.add(wrapper.getItem());
                    messageSize += wrapper.getLength();
                }
                queue.clear();
            }
            this.sendBufferUsed -= messageSize;
            if (this.sendBufferUsed != 0) {
                Logger.warning(this, "Possible leak in transport code: Buffer size not empty after disconnecting on " + this + " for " + this.pn + " after removing " + messageSize + " total was " + this.sendBufferUsed);
                this.sendBufferUsed = 0;
            }
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long timeNextUrgent(boolean canSend, long now) {
        Object object;
        long ret = Long.MAX_VALUE;
        if (canSend) {
            object = this.sendBufferLock;
            synchronized (object) {
                for (Map<Integer, MessageWrapper> started : this.startedByPrio) {
                    for (MessageWrapper wrapper : started.values()) {
                        if (wrapper.allSent()) continue;
                        long d = wrapper.getItem().getDeadline();
                        if (d > 0L) {
                            ret = Math.min(ret, d);
                            continue;
                        }
                        Logger.error(this, "Started sending message " + wrapper.getItem() + " but deadline is " + d);
                    }
                }
            }
        }
        if ((ret = Math.min(ret, this.timeCheckForAcks())) > now) {
            ret = Math.min(ret, now + Math.min(100L, (long)this.averageRTT() / 2L));
            if (canSend && DO_KEEPALIVES) {
                object = this;
                synchronized (object) {
                    ret = Math.min(ret, this.timeLastSentPayload + Node.KEEPALIVE_INTERVAL);
                }
            }
        }
        return ret;
    }

    @Override
    public long timeSendAcks() {
        return this.timeCheckForAcks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canSend(SessionKey tracker) {
        PacketThrottle throttle;
        boolean canAllocateID;
        NewPacketFormat newPacketFormat = this;
        synchronized (newPacketFormat) {
            canAllocateID = !this.seqNumGreaterThan(this.nextMessageID, (this.messageWindowPtrAcked + 65536) % 0x10000000, 28);
        }
        if (canAllocateID) {
            if (tracker == null) {
                return false;
            }
            NewPacketFormatKeyContext keyContext = tracker.packetContext;
            if (!keyContext.canAllocateSeqNum()) {
                this.pn.startRekeying();
                Logger.error(this, "Can't send because we would block on " + this);
                return false;
            }
        }
        if (canAllocateID) {
            int bufferUsage;
            Object object = this.sendBufferLock;
            synchronized (object) {
                bufferUsage = this.sendBufferUsed;
            }
            int maxSendBufferSize = this.maxSendBufferSize();
            if (bufferUsage + 4096 > maxSendBufferSize) {
                if (logDEBUG) {
                    Logger.debug(this, "Cannot send: Would exceed remote buffer size. Remote at " + bufferUsage + " max is " + maxSendBufferSize + " on " + this);
                }
                return false;
            }
        }
        if (tracker != null && this.pn != null && (throttle = this.pn.getThrottle()) != null) {
            NewPacketFormatKeyContext packets;
            int maxPackets = (int)Math.min(2.147483647E9, this.pn.getThrottle().getWindowSize());
            if (maxPackets < 1) {
                maxPackets = 1;
            }
            if (maxPackets <= (packets = tracker.packetContext).countSentPackets()) {
                if (logDEBUG) {
                    Logger.debug(this, "Cannot send because " + packets.countSentPackets() + " in flight of limit " + maxPackets + " on " + this);
                }
                return false;
            }
        }
        if (!canAllocateID) {
            Object object = this.sendBufferLock;
            synchronized (object) {
                for (Map<Integer, MessageWrapper> started : this.startedByPrio) {
                    for (MessageWrapper wrapper : started.values()) {
                        if (wrapper.allSent()) continue;
                        return true;
                    }
                }
            }
        }
        if (logDEBUG && !canAllocateID) {
            Logger.debug(this, "Cannot send because cannot allocate ID on " + this);
        }
        return canAllocateID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMessageID() throws BlockedTooLongException {
        int messageID;
        NewPacketFormat newPacketFormat = this;
        synchronized (newPacketFormat) {
            if (this.seqNumGreaterThan(this.nextMessageID, (this.messageWindowPtrAcked + 65536) % 0x10000000, 28)) {
                if (this.blockedSince == -1L) {
                    this.blockedSince = System.currentTimeMillis();
                } else if (System.currentTimeMillis() - this.blockedSince > MAX_MSGID_BLOCK_TIME) {
                    throw new BlockedTooLongException(System.currentTimeMillis() - this.blockedSince);
                }
                return -1;
            }
            this.blockedSince = -1L;
            messageID = this.nextMessageID++;
            if (this.nextMessageID == 0x10000000) {
                this.nextMessageID = 0;
            }
        }
        return messageID;
    }

    private double averageRTT() {
        if (this.pn != null) {
            return this.pn.averagePingTimeCorrected();
        }
        return PeerNode.MIN_RTO;
    }

    public String toString() {
        if (this.pn != null) {
            return super.toString() + " for " + this.pn.shortToString();
        }
        return super.toString();
    }

    @Override
    public boolean fullPacketQueued(int maxPacketSize) {
        return this.pn.getMessageQueue().mustSendSize(10, maxPacketSize);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
    }

    private static class PartiallyReceivedBuffer {
        private int messageLength = -1;
        private byte[] buffer = new byte[0];
        private final NewPacketFormat npf;

        private PartiallyReceivedBuffer(NewPacketFormat npf) {
            this.npf = npf;
        }

        private boolean add(byte[] data, int dataOffset) {
            if (this.buffer.length < dataOffset + data.length && !this.resize(dataOffset + data.length)) {
                return false;
            }
            System.arraycopy(data, 0, this.buffer, dataOffset, data.length);
            return true;
        }

        private boolean setMessageLength(int messageLength) {
            if (this.messageLength != -1 && this.messageLength != messageLength) {
                Logger.warning(this, "Message length has already been set to a different length");
            }
            this.messageLength = messageLength;
            if (this.buffer.length > messageLength) {
                Logger.warning(this, "Buffer is larger than set message length! (" + this.buffer.length + ">" + messageLength + ")");
            }
            return this.resize(messageLength);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean resize(int length) {
            if (logDEBUG) {
                Logger.debug(this, "Resizing from " + this.buffer.length + " to " + length);
            }
            Object object = this.npf.receiveBufferSizeLock;
            synchronized (object) {
                if (this.npf.receiveBufferUsed + (length - this.buffer.length) > 262144) {
                    if (logMINOR) {
                        Logger.minor(this, "Could not resize buffer, would excede max size");
                    }
                    return false;
                }
                NewPacketFormat newPacketFormat = this.npf;
                newPacketFormat.receiveBufferUsed = newPacketFormat.receiveBufferUsed + (length - this.buffer.length);
                if (logDEBUG) {
                    Logger.debug(this, "Added " + (length - this.buffer.length) + " to buffer. Total is now " + this.npf.receiveBufferUsed);
                }
            }
            this.buffer = Arrays.copyOf(this.buffer, length);
            return true;
        }
    }

    static class SentPacket {
        final NewPacketFormat npf;
        final List<MessageWrapper> messages = new ArrayList<MessageWrapper>();
        final List<int[]> ranges = new ArrayList<int[]>();
        long sentTime;

        SentPacket(NewPacketFormat npf, SessionKey key) {
            this.npf = npf;
        }

        void addFragment(MessageFragment frag) {
            this.messages.add(frag.wrapper);
            this.ranges.add(new int[]{frag.fragmentOffset, frag.fragmentOffset + frag.fragmentLength - 1});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long acked(SessionKey key) {
            Iterator<MessageWrapper> msgIt = this.messages.iterator();
            Iterator<int[]> rangeIt = this.ranges.iterator();
            while (msgIt.hasNext()) {
                NewPacketFormat newPacketFormat;
                MessageWrapper wrapper = msgIt.next();
                int[] range = rangeIt.next();
                if (logDEBUG) {
                    Logger.debug(this, "Acknowledging " + range[0] + " to " + range[1] + " on " + wrapper.getMessageID());
                }
                if (!wrapper.ack(range[0], range[1], this.npf.pn)) continue;
                Map started = (Map)this.npf.startedByPrio.get(wrapper.getPriority());
                MessageWrapper removed = null;
                Object object = this.npf.sendBufferLock;
                synchronized (object) {
                    removed = (MessageWrapper)started.remove(wrapper.getMessageID());
                    if (removed != null) {
                        int size = wrapper.getLength();
                        newPacketFormat = this.npf;
                        newPacketFormat.sendBufferUsed = newPacketFormat.sendBufferUsed - size;
                        if (logDEBUG) {
                            Logger.debug(this, "Removed " + size + " from remote buffer. Total is now " + this.npf.sendBufferUsed);
                        }
                    }
                }
                if (removed == null && logMINOR) {
                    Logger.minor(this, "Completed message " + wrapper.getMessageID() + " but it is not in the map from " + wrapper);
                }
                if (removed == null) continue;
                if (logDEBUG) {
                    Logger.debug(this, "Completed message " + wrapper.getMessageID() + " from " + wrapper);
                }
                boolean couldSend = this.npf.canSend(key);
                int id = wrapper.getMessageID();
                newPacketFormat = this.npf;
                synchronized (newPacketFormat) {
                    this.npf.ackedMessages.add(id, id);
                    int oldWindow = this.npf.messageWindowPtrAcked;
                    while (this.npf.ackedMessages.contains(this.npf.messageWindowPtrAcked, this.npf.messageWindowPtrAcked)) {
                        this.npf.messageWindowPtrAcked++;
                        if (this.npf.messageWindowPtrAcked != 0x10000000) continue;
                        this.npf.messageWindowPtrAcked = 0;
                    }
                    if (this.npf.messageWindowPtrAcked < oldWindow) {
                        this.npf.ackedMessages.remove(oldWindow, 0xFFFFFFF);
                        this.npf.ackedMessages.remove(0, this.npf.messageWindowPtrAcked);
                    } else {
                        this.npf.ackedMessages.remove(oldWindow, this.npf.messageWindowPtrAcked);
                    }
                }
                if (couldSend || !this.npf.canSend(key)) continue;
                this.npf.pn.wakeUpSender();
            }
            return System.currentTimeMillis() - this.sentTime;
        }

        public void lost() {
            Iterator<MessageWrapper> msgIt = this.messages.iterator();
            Iterator<int[]> rangeIt = this.ranges.iterator();
            while (msgIt.hasNext()) {
                MessageWrapper wrapper = msgIt.next();
                int[] range = rangeIt.next();
                wrapper.lost(range[0], range[1]);
            }
        }

        public void sent(int length) {
            this.sentTime = System.currentTimeMillis();
        }

        long getSentTime() {
            return this.sentTime;
        }
    }
}

