/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.DTrace;
import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.Db4oIOException;
import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.Arrays4;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.DefragmentContext;
import com.db4o.internal.FieldIndexException;
import com.db4o.internal.HardObjectReference;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.SystemData;
import com.db4o.internal.Transaction;
import com.db4o.internal.VirtualAttributes;
import com.db4o.internal.VirtualFieldMetadata;
import com.db4o.internal.activation.FixedActivationDepth;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.BTreeRange;
import com.db4o.internal.btree.FieldIndexKey;
import com.db4o.internal.delete.DeleteContextImpl;
import com.db4o.internal.handlers.HandlerVersion;
import com.db4o.internal.handlers.LongHandler;
import com.db4o.internal.marshall.ObjectIdContextImpl;
import com.db4o.internal.marshall.ObjectReferenceContext;
import com.db4o.internal.slots.Slot;
import com.db4o.marshall.WriteBuffer;

public class UUIDFieldMetadata
extends VirtualFieldMetadata {
    UUIDFieldMetadata() {
        super(2, new LongHandler());
        this.setName("v4ouuid");
    }

    @Override
    public void addFieldIndex(ObjectIdContextImpl context, Slot oldSlot) throws FieldIndexException {
        boolean isnew = oldSlot == null;
        int offset = context.offset();
        int db4oDatabaseIdentityID = context.readInt();
        long uuid = context.readLong();
        context.seek(offset);
        LocalObjectContainer yf = (LocalObjectContainer)context.transaction().container();
        if (!(uuid != 0L && db4oDatabaseIdentityID != 0 || context.id() <= 0 || isnew)) {
            DatabaseIdentityIDAndUUID identityAndUUID = this.readDatabaseIdentityIDAndUUID(yf, context.classMetadata(), oldSlot, false);
            db4oDatabaseIdentityID = identityAndUUID.databaseIdentityID;
            uuid = identityAndUUID.uuid;
        }
        if (db4oDatabaseIdentityID == 0) {
            db4oDatabaseIdentityID = yf.identity().getID(context.transaction());
        }
        if (uuid == 0L) {
            uuid = yf.generateTimeStampId();
        }
        StatefulBuffer writer = (StatefulBuffer)context.buffer();
        writer.writeInt(db4oDatabaseIdentityID);
        writer.writeLong(uuid);
        if (isnew) {
            this.addIndexEntry(writer, new Long(uuid));
        }
    }

    private DatabaseIdentityIDAndUUID readDatabaseIdentityIDAndUUID(ObjectContainerBase container, ClassMetadata classMetadata, Slot oldSlot, boolean checkClass) throws Db4oIOException {
        ClassMetadata realClass;
        if (DTrace.enabled) {
            DTrace.REREAD_OLD_UUID.logLength(oldSlot.address(), oldSlot.length());
        }
        ByteArrayBuffer reader = container.bufferByAddress(oldSlot.address(), oldSlot.length());
        if (checkClass && (realClass = ClassMetadata.readClass(container, reader)) != classMetadata) {
            return null;
        }
        if (classMetadata.seekToField(container.transaction(), reader, this) == HandlerVersion.INVALID) {
            return null;
        }
        return new DatabaseIdentityIDAndUUID(reader.readInt(), reader.readLong());
    }

    @Override
    public void delete(DeleteContextImpl context, boolean isUpdate) {
        if (isUpdate) {
            context.seek(context.offset() + this.linkLength());
            return;
        }
        context.seek(context.offset() + 4);
        long longPart = context.readLong();
        if (longPart > 0L && context.container().maintainsIndices()) {
            this.removeIndexEntry(context.transaction(), context.id(), new Long(longPart));
        }
    }

    @Override
    public boolean hasIndex() {
        return true;
    }

    @Override
    public BTree getIndex(Transaction transaction) {
        this.ensureIndex(transaction);
        return super.getIndex(transaction);
    }

    @Override
    protected void rebuildIndexForObject(LocalObjectContainer stream, ClassMetadata yapClass, int objectId) throws FieldIndexException {
        DatabaseIdentityIDAndUUID data = this.readDatabaseIdentityIDAndUUID(stream, yapClass, ((LocalTransaction)stream.systemTransaction()).getCurrentSlotOfID(objectId), true);
        if (null == data) {
            return;
        }
        this.addIndexEntry(stream.getLocalSystemTransaction(), objectId, new Long(data.uuid));
    }

    private void ensureIndex(Transaction transaction) {
        if (null == transaction) {
            throw new ArgumentNullException();
        }
        if (null != super.getIndex(transaction)) {
            return;
        }
        LocalObjectContainer file = (LocalObjectContainer)transaction.container();
        SystemData sd = file.systemData();
        if (sd == null) {
            return;
        }
        this.initIndex(transaction, sd.uuidIndexId());
        if (sd.uuidIndexId() == 0) {
            sd.uuidIndexId(super.getIndex(transaction).getID());
            file.getFileHeader().writeVariablePart(file, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void instantiate1(ObjectReferenceContext context) {
        int dbID = context.readInt();
        Transaction trans = context.transaction();
        ObjectContainerBase container = trans.container();
        container.showInternalClasses(true);
        try {
            Db4oDatabase db = (Db4oDatabase)container.getByID2(trans, dbID);
            if (db != null && db.i_signature == null) {
                container.activate(trans, db, new FixedActivationDepth(2));
            }
            VirtualAttributes va = context.objectReference().virtualAttributes();
            va.i_database = db;
            va.i_uuid = context.readLong();
        }
        finally {
            container.showInternalClasses(false);
        }
    }

    @Override
    public int linkLength() {
        return 12;
    }

    @Override
    void marshall(Transaction trans, ObjectReference ref, WriteBuffer buffer, boolean isMigrating, boolean isNew) {
        boolean linkToDatabase;
        VirtualAttributes attr = ref.virtualAttributes();
        ObjectContainerBase container = trans.container();
        boolean doAddIndexEntry = isNew && container.maintainsIndices();
        int dbID = 0;
        boolean bl = attr != null && attr.i_database == null ? true : (linkToDatabase = !isMigrating);
        if (linkToDatabase) {
            Db4oDatabase db = container.identity();
            if (db == null) {
                attr = null;
            } else {
                if (attr.i_database == null) {
                    attr.i_database = db;
                    if (container instanceof LocalObjectContainer) {
                        attr.i_uuid = container.generateTimeStampId();
                        doAddIndexEntry = true;
                    }
                }
                if ((db = attr.i_database) != null) {
                    dbID = db.getID(trans);
                }
            }
        } else if (attr != null) {
            dbID = attr.i_database.getID(trans);
        }
        buffer.writeInt(dbID);
        if (attr == null) {
            buffer.writeLong(0L);
            return;
        }
        buffer.writeLong(attr.i_uuid);
        if (doAddIndexEntry) {
            this.addIndexEntry(trans, ref.getID(), new Long(attr.i_uuid));
        }
    }

    @Override
    void marshallIgnore(WriteBuffer buffer) {
        buffer.writeInt(0);
        buffer.writeLong(0L);
    }

    public final HardObjectReference getHardObjectReferenceBySignature(Transaction transaction, long longPart, byte[] signature) {
        BTreeRange range = this.search(transaction, new Long(longPart));
        Iterator4 keys = range.keys();
        while (keys.moveNext()) {
            FieldIndexKey current = (FieldIndexKey)keys.current();
            HardObjectReference hardRef = this.getHardObjectReferenceById(transaction, current.parentID(), signature);
            if (null == hardRef) continue;
            return hardRef;
        }
        return HardObjectReference.INVALID;
    }

    protected final HardObjectReference getHardObjectReferenceById(Transaction transaction, int parentId, byte[] signature) {
        HardObjectReference hardRef = transaction.container().getHardObjectReferenceById(transaction, parentId);
        if (hardRef._reference == null) {
            return null;
        }
        VirtualAttributes vad = hardRef._reference.virtualAttributes(transaction, false);
        if (!Arrays4.areEqual(signature, vad.i_database.i_signature)) {
            return null;
        }
        return hardRef;
    }

    @Override
    public void defragAspect(DefragmentContext context) {
        context.copyID();
        context.incrementOffset(8);
    }

    static class DatabaseIdentityIDAndUUID {
        public int databaseIdentityID;
        public long uuid;

        public DatabaseIdentityIDAndUUID(int databaseIdentityID_, long uuid_) {
            this.databaseIdentityID = databaseIdentityID_;
            this.uuid = uuid_;
        }
    }
}

