/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.clients.fcp.ProbeBandwidth;
import freenet.clients.fcp.ProbeBuild;
import freenet.clients.fcp.ProbeError;
import freenet.clients.fcp.ProbeIdentifier;
import freenet.clients.fcp.ProbeLinkLengths;
import freenet.clients.fcp.ProbeLocation;
import freenet.clients.fcp.ProbeOverallBulkOutputCapacityUsage;
import freenet.clients.fcp.ProbeRefused;
import freenet.clients.fcp.ProbeRejectStats;
import freenet.clients.fcp.ProbeStoreSize;
import freenet.clients.fcp.ProbeUptime;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.node.probe.Error;
import freenet.node.probe.Listener;
import freenet.node.probe.Type;
import freenet.support.SimpleFieldSet;

public class ProbeRequest
extends FCPMessage {
    public static final String NAME = "ProbeRequest";
    private final String identifier;
    private final Type type;
    private final byte htl;

    public ProbeRequest(SimpleFieldSet fs) throws MessageInvalidException {
        this.identifier = fs.get("Identifier");
        try {
            this.type = Type.valueOf(fs.get("Type"));
            this.htl = (byte)(fs.get("HopsToLive") == null ? 70 : (int)fs.getByte("HopsToLive"));
            if (this.htl < 0) {
                throw new MessageInvalidException(7, "hopsToLive cannot be negative.", null, false);
            }
        }
        catch (IllegalArgumentException e) {
            throw new MessageInvalidException(7, "Unrecognized parse probe type \"" + fs.get("Type") + "\": " + e, null, false);
        }
        catch (FSParseException e) {
            throw new MessageInvalidException(7, "Unable to parse hopsToLive \"" + fs.get("HopsToLive") + "\": " + e, null, false);
        }
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        return new SimpleFieldSet(true);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(final FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        if (!handler.hasFullAccess()) {
            throw new MessageInvalidException(24, "Probe requires full access.", this.identifier, false);
        }
        Listener listener = new Listener(){

            @Override
            public void onError(Error error, Byte code, boolean local) {
                handler.send(new ProbeError(ProbeRequest.this.identifier, error, code, local));
            }

            @Override
            public void onRefused() {
                handler.send(new ProbeRefused(ProbeRequest.this.identifier));
            }

            @Override
            public void onOutputBandwidth(float outputBandwidth) {
                handler.send(new ProbeBandwidth(ProbeRequest.this.identifier, outputBandwidth));
            }

            @Override
            public void onBuild(int build) {
                handler.send(new ProbeBuild(ProbeRequest.this.identifier, build));
            }

            @Override
            public void onIdentifier(long probeIdentifier, byte percentageUptime) {
                handler.send(new ProbeIdentifier(ProbeRequest.this.identifier, probeIdentifier, percentageUptime));
            }

            @Override
            public void onLinkLengths(float[] linkLengths) {
                handler.send(new ProbeLinkLengths(ProbeRequest.this.identifier, linkLengths));
            }

            @Override
            public void onLocation(float location) {
                handler.send(new ProbeLocation(ProbeRequest.this.identifier, location));
            }

            @Override
            public void onStoreSize(float storeSize) {
                handler.send(new ProbeStoreSize(ProbeRequest.this.identifier, storeSize));
            }

            @Override
            public void onUptime(float uptimePercent) {
                handler.send(new ProbeUptime(ProbeRequest.this.identifier, uptimePercent));
            }

            @Override
            public void onRejectStats(byte[] stats) {
                handler.send(new ProbeRejectStats(ProbeRequest.this.identifier, stats));
            }

            @Override
            public void onOverallBulkOutputCapacity(byte bandwidthClassForCapacityUsage, float capacityUsage) {
                handler.send(new ProbeOverallBulkOutputCapacityUsage(ProbeRequest.this.identifier, bandwidthClassForCapacityUsage, capacityUsage));
            }
        };
        node.startProbe(this.htl, node.random.nextLong(), this.type, listener);
    }
}

