/*
 * Decompiled with CFR 0.152.
 */
package freenet.io.comm;

import freenet.support.LightweightException;

public class RetrievalException
extends LightweightException {
    private static final long serialVersionUID = 3257565105301500723L;
    public static final int UNKNOWN = 0;
    public static final int PREMATURE_EOF = 2;
    public static final int IO_ERROR = 3;
    public static final int SENDER_DIED = 5;
    public static final int TIMED_OUT = 4;
    public static final int ALREADY_CACHED = 6;
    public static final int SENDER_DISCONNECTED = 7;
    public static final int NO_DATAINSERT = 8;
    public static final int CANCELLED_BY_RECEIVER = 9;
    public static final int RECEIVER_DIED = 11;
    public static final int UNABLE_TO_SEND_BLOCK_WITHIN_TIMEOUT = 12;
    public static final int GONE_TO_TURTLE_MODE = 13;
    public static final int TURTLE_KILLED = 14;
    int _reason;
    String _cause;

    public RetrievalException(int reason) {
        this._reason = reason;
        this._cause = RetrievalException.getErrString(reason);
    }

    public RetrievalException(int reason, String cause) {
        this._reason = reason;
        this._cause = cause;
        if (cause == null || cause.length() == 0 || cause.equals("null")) {
            this._cause = RetrievalException.getErrString(reason);
        }
    }

    public int getReason() {
        return this._reason;
    }

    @Override
    public String toString() {
        return RetrievalException.getErrString(this._reason) + ":" + this._cause;
    }

    public String getErrString() {
        return RetrievalException.getErrString(this._reason);
    }

    public static String getErrString(int reason) {
        switch (reason) {
            case 2: {
                return "PREMATURE_EOF";
            }
            case 3: {
                return "IO_ERROR";
            }
            case 5: {
                return "SENDER_DIED";
            }
            case 4: {
                return "TIMED_OUT";
            }
            case 6: {
                return "ALREADY_CACHED";
            }
            case 7: {
                return "SENDER_DISCONNECTED";
            }
            case 8: {
                return "NO_DATAINSERT";
            }
            case 9: {
                return "CANCELLED_BY_RECEIVER";
            }
            case 0: {
                return "UNKNOWN";
            }
            case 12: {
                return "UNABLE_TO_SEND_BLOCK_WITHIN_TIMEOUT";
            }
            case 13: {
                return "GONE_TO_TURTLE_MODE";
            }
            case 14: {
                return "TURTLE_KILLED";
            }
        }
        return "UNKNOWN (" + reason + ")";
    }

    @Override
    public String getMessage() {
        return this.toString();
    }
}

