/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.useralerts;

import freenet.clients.http.wizardsteps.BandwidthLimit;
import freenet.l10n.NodeL10n;
import freenet.node.Node;
import freenet.node.useralerts.AbstractUserAlert;
import freenet.support.HTMLNode;
import freenet.support.SizeUtil;

public class UpgradeConnectionSpeedUserAlert
extends AbstractUserAlert {
    private final Node node;
    private BandwidthLimit bandwidthLimit;
    private boolean upgraded;
    private String error;

    private UpgradeConnectionSpeedUserAlert(Node node, BandwidthLimit bandwidthLimit) {
        this.node = node;
        this.bandwidthLimit = bandwidthLimit;
    }

    public static void createAlert(Node node, BandwidthLimit bandwidthLimit) {
        node.clientCore.alerts.register(new UpgradeConnectionSpeedUserAlert(node, bandwidthLimit));
    }

    @Override
    public String getTitle() {
        return this.l10n("title");
    }

    @Override
    public HTMLNode getHTMLText() {
        HTMLNode content = new HTMLNode("div");
        if (this.upgraded) {
            content.addChild("p", this.l10n("upgraded"));
            return content;
        }
        content.addChild("p", this.l10n("text", new String[]{"input", "output"}, new String[]{SizeUtil.formatSize(this.node.config.get("node").getInt("inputBandwidthLimit")), SizeUtil.formatSize(this.node.config.get("node").getInt("outputBandwidthLimit"))}));
        if (this.error != null) {
            content.addChild("p", this.error);
            this.error = null;
        }
        HTMLNode form = content.addChild("form", new String[]{"action", "method"}, new String[]{"/", "post"});
        HTMLNode bandwidthInput = form.addChild("div", new String[]{"style"}, new String[]{"display: inline-block; text-align: right;"});
        bandwidthInput.addChild("span", "style", "margin-right: .5em;", this.l10n("downloadLimit"));
        bandwidthInput.addChild("input", new String[]{"type", "name", "value"}, new String[]{"text", "inputBandwidthLimit", SizeUtil.formatSize(this.bandwidthLimit.downBytes)});
        bandwidthInput.addChild("br");
        bandwidthInput.addChild("span", "style", "margin-right: .5em;", this.l10n("uploadLimit"));
        bandwidthInput.addChild("input", new String[]{"type", "name", "value"}, new String[]{"text", "outputBandwidthLimit", SizeUtil.formatSize(this.bandwidthLimit.upBytes)});
        form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "upgradeConnectionSpeed", "upgradeConnectionSpeed"});
        form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "formPassword", this.node.clientCore.formPassword});
        form.addChild("input", new String[]{"type", "value"}, new String[]{"submit", "Upgrade"});
        return content;
    }

    @Override
    public String dismissButtonText() {
        return this.upgraded ? NodeL10n.getBase().getString("Toadlet.ok") : NodeL10n.getBase().getString("Toadlet.no");
    }

    @Override
    public boolean userCanDismiss() {
        return true;
    }

    @Override
    public boolean shouldUnregisterOnDismiss() {
        return true;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void setUpgraded(boolean upgraded) {
        this.upgraded = upgraded;
    }

    private String l10n(String key) {
        return NodeL10n.getBase().getString("UpgradeConnectionSpeedUserAlert." + key);
    }

    private String l10n(String key, String[] patterns, String[] values) {
        return NodeL10n.getBase().getString("UpgradeConnectionSpeedUserAlert." + key, patterns, values);
    }
}

