/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.client.InsertContext;
import freenet.clients.fcp.ClientPutBase;
import freenet.clients.fcp.ClientRequest;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.keys.FreenetURI;
import freenet.node.Node;
import freenet.support.HexUtil;
import freenet.support.SimpleFieldSet;
import java.io.File;

public class PersistentPut
extends FCPMessage {
    static final String name = "PersistentPut";
    final String identifier;
    final FreenetURI uri;
    final FreenetURI privateURI;
    final int verbosity;
    final short priorityClass;
    final ClientPutBase.UploadFrom uploadFrom;
    final ClientRequest.Persistence persistence;
    final File origFilename;
    final String mimeType;
    final boolean global;
    final FreenetURI targetURI;
    final long size;
    final String token;
    final boolean started;
    final int maxRetries;
    final String targetFilename;
    final boolean binaryBlob;
    final InsertContext.CompatibilityMode compatMode;
    final boolean dontCompress;
    final boolean realTime;
    final byte[] splitfileCryptoKey;
    final String compressorDescriptor;

    public PersistentPut(String identifier, FreenetURI publicURI, FreenetURI privateURI, int verbosity, short priorityClass, ClientPutBase.UploadFrom uploadFrom, FreenetURI targetURI, ClientRequest.Persistence persistence, File origFilename, String mimeType, boolean global, long size, String clientToken, boolean started, int maxRetries, String targetFilename, boolean binaryBlob, InsertContext.CompatibilityMode compatMode, boolean dontCompress, String compressorDescriptor, boolean realTime, byte[] splitfileCryptoKey) {
        this.identifier = identifier;
        this.uri = publicURI;
        this.privateURI = privateURI;
        this.verbosity = verbosity;
        this.priorityClass = priorityClass;
        this.uploadFrom = uploadFrom;
        this.targetURI = targetURI;
        this.persistence = persistence;
        this.origFilename = origFilename;
        this.mimeType = mimeType;
        this.global = global;
        this.size = size;
        this.token = clientToken;
        this.started = started;
        this.maxRetries = maxRetries;
        this.targetFilename = targetFilename;
        this.binaryBlob = binaryBlob;
        this.compatMode = compatMode;
        this.dontCompress = dontCompress;
        this.compressorDescriptor = compressorDescriptor;
        this.realTime = realTime;
        this.splitfileCryptoKey = splitfileCryptoKey;
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.putSingle("Identifier", this.identifier);
        fs.putSingle("URI", this.uri.toString(false, false));
        if (this.privateURI != null) {
            fs.putSingle("PrivateURI", this.privateURI.toString(false, false));
        }
        fs.put("Verbosity", this.verbosity);
        fs.put("PriorityClass", this.priorityClass);
        fs.putSingle("UploadFrom", this.uploadFrom.toString().toLowerCase());
        fs.putSingle("Persistence", this.persistence.toString().toLowerCase());
        if (this.origFilename != null) {
            fs.putSingle("Filename", this.origFilename.getAbsolutePath());
        }
        if (this.targetURI != null) {
            fs.putSingle("TargetURI", this.targetURI.toString());
        }
        if (this.mimeType != null) {
            fs.putSingle("Metadata.ContentType", this.mimeType);
        }
        fs.put("Global", this.global);
        if (this.size != -1L) {
            fs.put("DataLength", this.size);
        }
        if (this.token != null) {
            fs.putSingle("ClientToken", this.token);
        }
        fs.put("Started", this.started);
        fs.put("MaxRetries", this.maxRetries);
        if (this.targetFilename != null) {
            fs.putSingle("TargetFilename", this.targetFilename);
        }
        if (this.binaryBlob) {
            fs.put("BinaryBlob", this.binaryBlob);
        }
        fs.putOverwrite("CompatibilityMode", this.compatMode.name());
        fs.put("DontCompress", this.dontCompress);
        if (this.compressorDescriptor != null) {
            fs.putSingle("Codecs", this.compressorDescriptor);
        }
        fs.put("RealTime", this.realTime);
        if (this.splitfileCryptoKey != null) {
            fs.putSingle("SplitfileCryptoKey", HexUtil.bytesToHex(this.splitfileCryptoKey));
        }
        return fs;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "PersistentPut goes from server to client not the other way around", this.identifier, this.global);
    }
}

