/*
 * Decompiled with CFR 0.152.
 */
package freenet.io.comm;

import freenet.io.WritableToDataOutputStream;
import freenet.io.comm.FreenetInetAddress;
import freenet.io.comm.PeerParseException;
import freenet.support.transport.ip.HostnameSyntaxException;
import freenet.support.transport.ip.IPUtil;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Peer
implements WritableToDataOutputStream {
    public static final String VERSION = "$Id: Peer.java,v 1.4 2005/08/25 17:28:19 amphibian Exp $";
    private final FreenetInetAddress addr;
    private final int _port;

    public Peer(DataInput dis) throws IOException {
        this.addr = new FreenetInetAddress(dis);
        this._port = dis.readInt();
        if (this._port > 65535 || this._port < 0) {
            throw new IOException("bogus port");
        }
    }

    public Peer(DataInput dis, boolean checkHostnameOrIPSyntax) throws HostnameSyntaxException, IOException {
        this.addr = new FreenetInetAddress(dis, checkHostnameOrIPSyntax);
        this._port = dis.readInt();
        if (this._port > 65535 || this._port < 0) {
            throw new IOException("bogus port");
        }
    }

    public Peer(InetAddress address, int port) {
        this.addr = new FreenetInetAddress(address);
        this._port = port;
        if (this._port > 65535 || this._port < 0) {
            throw new IllegalArgumentException("bogus port");
        }
    }

    public Peer(String physical, boolean allowUnknown) throws PeerParseException, UnknownHostException {
        int offset = physical.lastIndexOf(58);
        if (offset < 0) {
            throw new PeerParseException();
        }
        String host = physical.substring(0, offset);
        this.addr = new FreenetInetAddress(host, allowUnknown);
        String strport = physical.substring(offset + 1);
        try {
            this._port = Integer.parseInt(strport);
            if (this._port < 0 || this._port > 65535) {
                throw new PeerParseException("Invalid port " + this._port);
            }
        }
        catch (NumberFormatException e) {
            throw new PeerParseException(e);
        }
    }

    public Peer(String physical, boolean allowUnknown, boolean checkHostnameOrIPSyntax) throws HostnameSyntaxException, PeerParseException, UnknownHostException {
        int offset = physical.lastIndexOf(58);
        if (offset < 0) {
            throw new PeerParseException("No port number: \"" + physical + "\"");
        }
        String host = physical.substring(0, offset);
        this.addr = new FreenetInetAddress(host, allowUnknown, checkHostnameOrIPSyntax);
        String strport = physical.substring(offset + 1);
        try {
            this._port = Integer.parseInt(strport);
            if (this._port < 0 || this._port > 65535) {
                throw new PeerParseException("Invalid port " + this._port);
            }
        }
        catch (NumberFormatException e) {
            throw new PeerParseException(e);
        }
    }

    public Peer(FreenetInetAddress addr, int port) {
        this.addr = addr;
        if (addr == null) {
            throw new NullPointerException();
        }
        this._port = port;
        if (this._port > 65535 || this._port < 0) {
            throw new IllegalArgumentException("bogus port");
        }
    }

    public boolean isNull() {
        return this._port == 0;
    }

    public boolean laxEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Peer)) {
            return false;
        }
        Peer peer = (Peer)o;
        if (this._port != peer._port) {
            return false;
        }
        return this.addr.laxEquals(peer.addr);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Peer)) {
            return false;
        }
        Peer peer = (Peer)o;
        if (this._port != peer._port) {
            return false;
        }
        return this.addr.equals(peer.addr);
    }

    public boolean strictEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Peer)) {
            return false;
        }
        Peer peer = (Peer)o;
        if (this._port != peer._port) {
            return false;
        }
        return this.addr.strictEquals(peer.addr);
    }

    public InetAddress getAddress() {
        return this.getAddress(true);
    }

    public InetAddress getAddress(boolean doDNSRequest) {
        return this.addr.getAddress(doDNSRequest);
    }

    public InetAddress getAddress(boolean doDNSRequest, boolean allowLocal) throws LocalAddressException {
        InetAddress a = this.addr.getAddress(doDNSRequest);
        if (a == null) {
            return null;
        }
        if (allowLocal || IPUtil.isValidAddress(a, false)) {
            return a;
        }
        throw new LocalAddressException();
    }

    public InetAddress getHandshakeAddress() {
        return this.addr.getHandshakeAddress();
    }

    public int hashCode() {
        return this.addr.hashCode() + this._port;
    }

    public int getPort() {
        return this._port;
    }

    public String toString() {
        return this.addr.toString() + ':' + this._port;
    }

    @Override
    public void writeToDataOutputStream(DataOutputStream dos) throws IOException {
        this.addr.writeToDataOutputStream(dos);
        dos.writeInt(this._port);
    }

    public FreenetInetAddress getFreenetAddress() {
        return this.addr;
    }

    public boolean isRealInternetAddress(boolean lookup, boolean defaultVal, boolean allowLocalAddresses) {
        return this.addr.isRealInternetAddress(lookup, defaultVal, allowLocalAddresses);
    }

    public String toStringPrefNumeric() {
        return this.addr.toStringPrefNumeric() + ':' + this._port;
    }

    public Peer dropHostName() {
        FreenetInetAddress newAddr = this.addr.dropHostname();
        if (newAddr == null) {
            return null;
        }
        if (this.addr != newAddr) {
            return new Peer(newAddr, this._port);
        }
        return this;
    }

    public boolean isIPv6(boolean defaultValue) {
        if (this.addr == null) {
            return defaultValue;
        }
        return this.addr.isIPv6(defaultValue);
    }

    public static class LocalAddressException
    extends Exception {
        private static final long serialVersionUID = -1L;
    }
}

