/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.node.SemiOrderedShutdownHook;
import freenet.node.Version;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.LoggerHook;
import freenet.support.OutputStreamLogger;
import freenet.support.io.FileUtil;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Deque;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;

public class FileLoggerHook
extends LoggerHook
implements Closeable {
    public static final int DATE = 1;
    public static final int CLASS = 2;
    public static final int HASHCODE = 3;
    public static final int THREAD = 4;
    public static final int PRIORITY = 5;
    public static final int MESSAGE = 6;
    public static final int UNAME = 7;
    private volatile boolean closed = false;
    private boolean closedFinished = false;
    protected int INTERVAL = 12;
    protected int INTERVAL_MULTIPLIER = 5;
    private static final String ENCODING = "UTF-8";
    private static volatile boolean logMINOR;
    private static String uname;
    private DateFormat df;
    private int[] fmt;
    private String[] str;
    protected OutputStream logStream;
    protected OutputStream altLogStream;
    protected final boolean logOverwrite;
    protected String baseFilename = null;
    protected File latestFile;
    protected File previousFile;
    protected boolean redirectStdOut = false;
    protected boolean redirectStdErr = false;
    protected final int MAX_LIST_SIZE;
    protected long MAX_LIST_BYTES = 0xA00000L;
    protected long LIST_WRITE_THRESHOLD;
    protected final ArrayBlockingQueue<byte[]> list;
    protected long listBytes = 0L;
    long maxOldLogfilesDiskUsage;
    protected final Deque<OldLogFile> logFiles = new ArrayDeque<OldLogFile>();
    private long oldLogFilesDiskSpaceUsage = 0L;
    private long flushTime = 1000L;
    private static final byte[] BOM;
    protected int runningCompressors = 0;
    protected Object runningCompressorsSync = new Object();
    private Date myDate = new Date();
    private final Object trimOldLogFilesLock = new Object();
    private static final int LINE_OVERHEAD = 60;
    private boolean switchedBaseFilename;

    static synchronized void getUName() {
        if (!uname.equals("unknown")) {
            return;
        }
        System.out.println("Getting uname for logging");
        try {
            InetAddress addr = InetAddress.getLocalHost();
            if (addr != null) {
                uname = new StringTokenizer(addr.getHostName(), ".").nextToken();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxListBytes(long len) {
        ArrayBlockingQueue<byte[]> arrayBlockingQueue = this.list;
        synchronized (arrayBlockingQueue) {
            this.MAX_LIST_BYTES = len;
            this.LIST_WRITE_THRESHOLD = this.MAX_LIST_BYTES / 4L;
        }
    }

    public void setInterval(String intervalName) throws IntervalParseException {
        char c;
        StringBuilder sb = new StringBuilder(intervalName.length());
        for (int i = 0; i < intervalName.length() && Character.isDigit(c = intervalName.charAt(i)); ++i) {
            sb.append(c);
        }
        if (sb.length() > 0) {
            String prefix = sb.toString();
            intervalName = intervalName.substring(prefix.length());
            this.INTERVAL_MULTIPLIER = Integer.parseInt(prefix);
        } else {
            this.INTERVAL_MULTIPLIER = 1;
        }
        if (intervalName.endsWith("S")) {
            intervalName = intervalName.substring(0, intervalName.length() - 1);
        }
        if (intervalName.equalsIgnoreCase("MINUTE")) {
            this.INTERVAL = 12;
        } else if (intervalName.equalsIgnoreCase("HOUR")) {
            this.INTERVAL = 10;
        } else if (intervalName.equalsIgnoreCase("DAY")) {
            this.INTERVAL = 5;
        } else if (intervalName.equalsIgnoreCase("WEEK")) {
            this.INTERVAL = 3;
        } else if (intervalName.equalsIgnoreCase("MONTH")) {
            this.INTERVAL = 2;
        } else if (intervalName.equalsIgnoreCase("YEAR")) {
            this.INTERVAL = 1;
        } else {
            throw new IntervalParseException("invalid interval " + intervalName);
        }
        System.out.println("Set interval to " + this.INTERVAL + " and multiplier to " + this.INTERVAL_MULTIPLIER);
    }

    protected String getHourLogName(Calendar c, int digit, boolean compressed) {
        StringBuilder buf = new StringBuilder(50);
        buf.append(this.baseFilename).append('-');
        buf.append(Version.buildNumber());
        buf.append('-');
        buf.append(c.get(1)).append('-');
        this.pad2digits(buf, c.get(2) + 1);
        buf.append('-');
        this.pad2digits(buf, c.get(5));
        buf.append('-');
        this.pad2digits(buf, c.get(11));
        if (this.INTERVAL == 12) {
            buf.append('-');
            this.pad2digits(buf, c.get(12));
        }
        if (digit > 0) {
            buf.append("-");
            buf.append(digit);
        }
        buf.append(".log");
        if (compressed) {
            buf.append(".gz");
        }
        return buf.toString();
    }

    private StringBuilder pad2digits(StringBuilder buf, int x) {
        String s = Integer.toString(x);
        if (s.length() == 1) {
            buf.append('0');
        }
        buf.append(s);
        return buf;
    }

    public FileLoggerHook(String filename, String fmt, String dfmt, String logRotateInterval, Logger.LogLevel threshold, boolean assumeWorking, boolean logOverwrite, long maxOldLogfilesDiskUsage, int maxListSize) throws IOException, IntervalParseException {
        this(false, filename, fmt, dfmt, logRotateInterval, threshold, assumeWorking, logOverwrite, maxOldLogfilesDiskUsage, maxListSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimOldLogFiles() {
        Object object = this.trimOldLogFilesLock;
        synchronized (object) {
            while (this.oldLogFilesDiskSpaceUsage > this.maxOldLogfilesDiskUsage) {
                OldLogFile olf;
                Deque<OldLogFile> deque = this.logFiles;
                synchronized (deque) {
                    if (this.logFiles.isEmpty()) {
                        System.err.println("ERROR: INCONSISTENT LOGGER TOTALS: Log file list is empty but still used " + this.oldLogFilesDiskSpaceUsage + " bytes!");
                    }
                    olf = this.logFiles.removeFirst();
                }
                olf.filename.delete();
                this.oldLogFilesDiskSpaceUsage -= olf.size;
                if (!logMINOR) continue;
                Logger.minor(this, "Deleting " + olf.filename + " - saving " + olf.size + " bytes, disk usage now: " + this.oldLogFilesDiskSpaceUsage + " of " + this.maxOldLogfilesDiskUsage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findOldLogFiles(GregorianCalendar gc) {
        String prefix;
        File dir;
        gc = (GregorianCalendar)gc.clone();
        File currentFilename = new File(this.getHourLogName(gc, -1, true));
        System.out.println("Finding old log files. New log file is " + currentFilename);
        int slashIndex = this.baseFilename.lastIndexOf(File.separatorChar);
        if (slashIndex == -1) {
            dir = new File(System.getProperty("user.dir"));
            prefix = this.baseFilename.toLowerCase();
        } else {
            dir = new File(this.baseFilename.substring(0, slashIndex));
            prefix = this.baseFilename.substring(slashIndex + 1).toLowerCase();
        }
        Object[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        Arrays.sort(files);
        long lastStartTime = -1L;
        Object oldFile = null;
        if (this.latestFile.exists()) {
            FileUtil.renameTo(this.latestFile, this.previousFile);
        }
        for (Object f : files) {
            String name = ((File)f).getName();
            if (name.toLowerCase().startsWith(prefix)) {
                if (name.equals(this.previousFile.getName()) || name.equals(this.latestFile.getName())) continue;
                if (!name.endsWith(".log.gz")) {
                    if (logMINOR) {
                        Logger.minor(this, "Does not end in .log.gz: " + name);
                    }
                    ((File)f).delete();
                    continue;
                }
                name = name.substring(0, name.length() - ".log.gz".length());
                if ((name = name.substring(prefix.length())).length() == 0 || name.charAt(0) != '-') {
                    if (logMINOR) {
                        Logger.minor(this, "Deleting unrecognized: " + name + " (" + ((File)f).getPath() + ')');
                    }
                    ((File)f).delete();
                    continue;
                }
                name = name.substring(1);
                String[] tokens = name.split("-");
                int[] nums = new int[tokens.length];
                for (int j = 0; j < tokens.length; ++j) {
                    try {
                        nums[j] = Integer.parseInt(tokens[j]);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        Logger.normal(this, "Could not parse: " + tokens[j] + " into number from " + name);
                        ((File)f).delete();
                    }
                }
                if (nums.length > 1) {
                    gc.set(1, nums[1]);
                }
                if (nums.length > 2) {
                    gc.set(2, nums[2] - 1);
                }
                if (nums.length > 3) {
                    gc.set(5, nums[3]);
                }
                if (nums.length > 4) {
                    gc.set(11, nums[4]);
                }
                if (nums.length > 5) {
                    gc.set(12, nums[5]);
                }
                gc.set(13, 0);
                gc.set(14, 0);
                long startTime = gc.getTimeInMillis();
                if (oldFile != null) {
                    long l = ((File)oldFile).length();
                    OldLogFile olf = new OldLogFile((File)oldFile, lastStartTime, startTime, l);
                    Object object = this.logFiles;
                    synchronized (object) {
                        this.logFiles.addLast(olf);
                    }
                    object = this.trimOldLogFilesLock;
                    synchronized (object) {
                        this.oldLogFilesDiskSpaceUsage += l;
                    }
                }
                lastStartTime = startTime;
                oldFile = f;
                continue;
            }
            Logger.normal(this, "Unknown file: " + name + " in the log directory");
        }
        if (currentFilename != null && currentFilename.exists()) {
            System.out.println("Old log file exists for this time period: " + currentFilename);
            int a = 1;
            while (true) {
                File numericSameDateFilename;
                if ((numericSameDateFilename = new File(this.getHourLogName(gc, a, true))) == null || !numericSameDateFilename.exists()) {
                    if (numericSameDateFilename == null) break;
                    System.out.println("Renaming to: " + numericSameDateFilename);
                    FileUtil.renameTo(currentFilename, numericSameDateFilename);
                    break;
                }
                ++a;
            }
        }
        if (oldFile != null) {
            long l = ((File)oldFile).length();
            OldLogFile olf = new OldLogFile((File)oldFile, lastStartTime, System.currentTimeMillis(), l);
            Object object = this.logFiles;
            synchronized (object) {
                this.logFiles.addLast(olf);
            }
            object = this.trimOldLogFilesLock;
            synchronized (object) {
                this.oldLogFilesDiskSpaceUsage += l;
            }
        }
        this.trimOldLogFiles();
    }

    public FileLoggerHook(String filename, String fmt, String dfmt, String threshold, String logRotateInterval, boolean assumeWorking, boolean logOverwrite, long maxOldLogFilesDiskUsage, int maxListSize) throws IOException, LoggerHook.InvalidThresholdException, IntervalParseException {
        this(filename, fmt, dfmt, logRotateInterval, Logger.LogLevel.valueOf(threshold.toUpperCase()), assumeWorking, logOverwrite, maxOldLogFilesDiskUsage, maxListSize);
    }

    private void checkStdStreams() {
        System.out.print(" \b");
        if (System.out.checkError()) {
            this.redirectStdOut = true;
        }
        System.err.print(" \b");
        if (System.err.checkError()) {
            this.redirectStdErr = true;
        }
    }

    public FileLoggerHook(OutputStream os, String fmt, String dfmt, Logger.LogLevel threshold) throws IntervalParseException {
        this(os, fmt, dfmt, threshold, true);
        this.logStream = os;
    }

    public FileLoggerHook(OutputStream os, String fmt, String dfmt, String threshold) throws LoggerHook.InvalidThresholdException, IntervalParseException {
        this(os, fmt, dfmt, Logger.LogLevel.valueOf(threshold.toUpperCase()), true);
        this.logStream = os;
    }

    public FileLoggerHook(OutputStream stream, String fmt, String dfmt, Logger.LogLevel threshold, boolean overwrite) throws IntervalParseException {
        this(fmt, dfmt, threshold, "HOUR", overwrite, -1L, 10000);
        this.logStream = stream;
    }

    public void start() {
        if (this.redirectStdOut) {
            try {
                System.setOut(new PrintStream((OutputStream)new OutputStreamLogger(Logger.LogLevel.NORMAL, "Stdout: ", ENCODING), false, ENCODING));
                if (this.redirectStdErr) {
                    System.setErr(new PrintStream((OutputStream)new OutputStreamLogger(Logger.LogLevel.ERROR, "Stderr: ", ENCODING), false, ENCODING));
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e);
            }
        }
        WriterThread wt = new WriterThread();
        wt.setDaemon(true);
        CloserThread ct = new CloserThread();
        SemiOrderedShutdownHook.get().addLateJob(ct);
        wt.start();
    }

    public FileLoggerHook(boolean rotate, String baseFilename, String fmt, String dfmt, String logRotateInterval, Logger.LogLevel threshold, boolean assumeWorking, boolean logOverwrite, long maxOldLogfilesDiskUsage, int maxListSize) throws IOException, IntervalParseException {
        this(fmt, dfmt, threshold, logRotateInterval, logOverwrite, maxOldLogfilesDiskUsage, maxListSize);
        if (!assumeWorking) {
            this.checkStdStreams();
        }
        if (rotate) {
            this.baseFilename = baseFilename;
        } else {
            this.logStream = new BufferedOutputStream(new FileOutputStream(baseFilename, !logOverwrite), 65536);
        }
    }

    public FileLoggerHook(boolean rotate, String baseFilename, String fmt, String dfmt, String threshold, String logRotateInterval, boolean assumeWorking, boolean logOverwrite, long maxOldLogFilesDiskUsage, int maxListSize) throws IOException, LoggerHook.InvalidThresholdException, IntervalParseException {
        this(rotate, baseFilename, fmt, dfmt, logRotateInterval, Logger.LogLevel.valueOf(threshold.toUpperCase()), assumeWorking, logOverwrite, maxOldLogFilesDiskUsage, maxListSize);
    }

    private FileLoggerHook(String fmt, String dfmt, Logger.LogLevel threshold, String logRotateInterval, boolean overwrite, long maxOldLogfilesDiskUsage, int maxListSize) throws IntervalParseException {
        super(threshold);
        this.maxOldLogfilesDiskUsage = maxOldLogfilesDiskUsage;
        this.logOverwrite = overwrite;
        this.setInterval(logRotateInterval);
        this.MAX_LIST_SIZE = maxListSize;
        this.list = new ArrayBlockingQueue(this.MAX_LIST_SIZE);
        this.setDateFormat(dfmt);
        this.setLogFormat(fmt);
    }

    private void setLogFormat(String fmt) {
        if (fmt == null || fmt.length() == 0) {
            fmt = "d:c:h:t:p:m";
        }
        char[] f = fmt.toCharArray();
        ArrayList<Integer> fmtVec = new ArrayList<Integer>();
        ArrayList<String> strVec = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean comment = false;
        for (char fi : f) {
            int type = FileLoggerHook.numberOf(fi);
            if (type == 7) {
                FileLoggerHook.getUName();
            }
            if (!comment && type != 0) {
                if (sb.length() > 0) {
                    strVec.add(sb.toString());
                    fmtVec.add(0);
                    sb = new StringBuilder();
                }
                fmtVec.add(type);
                continue;
            }
            if (fi == '\\') {
                comment = true;
                continue;
            }
            comment = false;
            sb.append(fi);
        }
        if (sb.length() > 0) {
            strVec.add(sb.toString());
            fmtVec.add(0);
        }
        this.fmt = new int[fmtVec.size()];
        int size = fmtVec.size();
        for (int i = 0; i < size; ++i) {
            this.fmt[i] = (Integer)fmtVec.get(i);
        }
        this.str = new String[strVec.size()];
        this.str = strVec.toArray(this.str);
    }

    private void setDateFormat(String dfmt) {
        if (dfmt != null && dfmt.length() != 0) {
            try {
                this.df = new SimpleDateFormat(dfmt);
            }
            catch (RuntimeException e) {
                this.df = DateFormat.getDateTimeInstance();
            }
        } else {
            this.df = DateFormat.getDateTimeInstance();
        }
        this.df.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Object o, Class<?> c, String msg, Throwable e, Logger.LogLevel priority) {
        if (!this.instanceShouldLog(priority, c)) {
            return;
        }
        if (this.closed) {
            return;
        }
        StringBuilder sb = new StringBuilder(e == null ? 512 : 1024);
        int sctr = 0;
        block15: for (int f : this.fmt) {
            switch (f) {
                case 0: {
                    sb.append(this.str[sctr++]);
                    continue block15;
                }
                case 1: {
                    long now = System.currentTimeMillis();
                    FileLoggerHook fileLoggerHook = this;
                    synchronized (fileLoggerHook) {
                        this.myDate.setTime(now);
                        sb.append(this.df.format(this.myDate));
                        continue block15;
                    }
                }
                case 2: {
                    sb.append(c == null ? "<none>" : c.getName());
                    continue block15;
                }
                case 3: {
                    sb.append(o == null ? "<none>" : Integer.toHexString(o.hashCode()));
                    continue block15;
                }
                case 4: {
                    sb.append(Thread.currentThread().getName());
                    continue block15;
                }
                case 5: {
                    sb.append(priority.name());
                    continue block15;
                }
                case 6: {
                    sb.append(msg);
                    continue block15;
                }
                case 7: {
                    sb.append(uname);
                }
            }
        }
        sb.append('\n');
        for (int j = 0; j < 20 && e != null; ++j) {
            sb.append(e.toString());
            StackTraceElement[] trace = e.getStackTrace();
            if (trace == null) {
                sb.append("(null)\n");
            } else if (trace.length == 0) {
                sb.append("(no stack trace)\n");
            } else {
                sb.append('\n');
                for (StackTraceElement elt : trace) {
                    sb.append("\tat ");
                    sb.append(elt.toString());
                    sb.append('\n');
                }
            }
            Throwable cause = e.getCause();
            if (cause == e) break;
            e = cause;
        }
        try {
            this.logString(sb.toString().getBytes(ENCODING));
        }
        catch (UnsupportedEncodingException e1) {
            throw new Error(e1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logString(byte[] b) throws UnsupportedEncodingException {
        ArrayBlockingQueue<byte[]> arrayBlockingQueue = this.list;
        synchronized (arrayBlockingQueue) {
            String err;
            byte[] buf;
            int sz = this.list.size();
            if (!this.list.offer(b)) {
                byte[] ss = this.list.poll();
                if (ss != null) {
                    this.listBytes -= (long)(ss.length + 60);
                }
                if ((ss = this.list.poll()) != null) {
                    this.listBytes -= (long)(ss.length + 60);
                }
                if (this.list.offer(buf = (err = "GRRR: ERROR: Logging too fast, chopped 2 entries, " + this.listBytes + " bytes in memory\n").getBytes(ENCODING))) {
                    this.listBytes += (long)(buf.length + 60);
                }
                if (this.list.offer(b)) {
                    this.listBytes += (long)(b.length + 60);
                }
            } else {
                this.listBytes += (long)(b.length + 60);
            }
            int x = 0;
            if (this.listBytes > this.MAX_LIST_BYTES) {
                while ((float)this.list.size() > (float)this.MAX_LIST_SIZE * 0.9f || (float)this.listBytes > (float)this.MAX_LIST_BYTES * 0.9f) {
                    byte[] ss = this.list.poll();
                    this.listBytes -= (long)(ss.length + 60);
                    ++x;
                }
                err = "GRRR: ERROR: Logging too fast, chopped " + x + " entries, " + this.listBytes + " bytes in memory\n";
                buf = err.getBytes(ENCODING);
                if (!this.list.offer(buf)) {
                    byte[] ss = this.list.poll();
                    if (ss != null) {
                        this.listBytes -= (long)(ss.length + 60);
                    }
                    if (this.list.offer(buf)) {
                        this.listBytes += (long)(buf.length + 60);
                    }
                } else {
                    this.listBytes += (long)(buf.length + 60);
                }
            }
            if (sz == 0) {
                this.list.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long listBytes() {
        ArrayBlockingQueue<byte[]> arrayBlockingQueue = this.list;
        synchronized (arrayBlockingQueue) {
            return this.listBytes;
        }
    }

    public static int numberOf(char c) {
        switch (c) {
            case 'd': {
                return 1;
            }
            case 'c': {
                return 2;
            }
            case 'h': {
                return 3;
            }
            case 't': {
                return 4;
            }
            case 'p': {
                return 5;
            }
            case 'm': {
                return 6;
            }
            case 'u': {
                return 7;
            }
        }
        return 0;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listAvailableLogs(OutputStreamWriter writer) throws IOException {
        OldLogFile[] oldLogFiles;
        Deque<OldLogFile> deque = this.logFiles;
        synchronized (deque) {
            oldLogFiles = this.logFiles.toArray(new OldLogFile[this.logFiles.size()]);
        }
        DateFormat tempDF = DateFormat.getDateTimeInstance(3, 3, Locale.ENGLISH);
        tempDF.setTimeZone(TimeZone.getTimeZone("GMT"));
        for (OldLogFile olf : oldLogFiles) {
            writer.write(olf.filename.getName() + " : " + tempDF.format(new Date(olf.start)) + " to " + tempDF.format(new Date(olf.end)) + " - " + olf.size + " bytes\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendLogByContainedDate(long time, OutputStream os) throws IOException {
        int toRead;
        OldLogFile toReturn = null;
        Deque<OldLogFile> deque = this.logFiles;
        synchronized (deque) {
            for (OldLogFile olf : this.logFiles) {
                if (logMINOR) {
                    Logger.minor(this, "Checking " + time + " against " + olf.filename + " : start=" + olf.start + ", end=" + olf.end);
                }
                if (time < olf.start || time >= olf.end) continue;
                toReturn = olf;
                if (!logMINOR) break;
                Logger.minor(this, "Found " + olf);
                break;
            }
            if (toReturn == null) {
                return;
            }
        }
        FileInputStream fis = new FileInputStream(toReturn.filename);
        DataInputStream dis = new DataInputStream(fis);
        long size = toReturn.size;
        byte[] buf = new byte[4096];
        for (long written = 0L; written < size; written += (long)toRead) {
            toRead = (int)Math.min((long)buf.length, size - written);
            try {
                dis.readFully(buf, 0, toRead);
            }
            catch (IOException e) {
                Logger.error(this, "Could not read bytes " + written + " to " + (written + (long)toRead) + " from file " + toReturn.filename + " which is supposed to be " + size + " bytes (" + toReturn.filename.length() + ')');
                return;
            }
            os.write(buf, 0, toRead);
        }
        dis.close();
        fis.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxOldLogsSize(long val) {
        Object object = this.trimOldLogFilesLock;
        synchronized (object) {
            this.maxOldLogfilesDiskUsage = val;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                FileLoggerHook.this.trimOldLogFiles();
            }
        };
        Thread t = new Thread(r, "Shrink logs");
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchBaseFilename(String filename) {
        FileLoggerHook fileLoggerHook = this;
        synchronized (fileLoggerHook) {
            this.baseFilename = filename;
            this.switchedBaseFilename = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForSwitch() {
        long now = System.currentTimeMillis();
        FileLoggerHook fileLoggerHook = this;
        synchronized (fileLoggerHook) {
            if (!this.switchedBaseFilename) {
                return;
            }
            long startTime = now;
            long endTime = startTime + 10000L;
            while ((now = System.currentTimeMillis()) < endTime && !this.switchedBaseFilename) {
                try {
                    this.wait(Math.max(1L, endTime - now));
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllOldLogFiles() {
        Object object = this.trimOldLogFilesLock;
        synchronized (object) {
            while (true) {
                OldLogFile olf;
                Deque<OldLogFile> deque = this.logFiles;
                synchronized (deque) {
                    if (this.logFiles.isEmpty()) {
                        return;
                    }
                    olf = this.logFiles.removeFirst();
                }
                olf.filename.delete();
                this.oldLogFilesDiskSpaceUsage -= olf.size;
                if (!logMINOR) continue;
                Logger.minor(this, "Deleting " + olf.filename + " - saving " + olf.size + " bytes, disk usage now: " + this.oldLogFilesDiskSpaceUsage + " of " + this.maxOldLogfilesDiskUsage);
            }
        }
    }

    public boolean hasRedirectedStdOutErrNoLock() {
        return this.redirectStdOut || this.redirectStdErr;
    }

    public synchronized void setMaxBacklogNotBusy(long val) {
        this.flushTime = val;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        uname = "unknown";
        try {
            BOM = "\ufeff".getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    class CloserThread
    extends Thread {
        CloserThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayBlockingQueue<byte[]> arrayBlockingQueue = FileLoggerHook.this.list;
            synchronized (arrayBlockingQueue) {
                FileLoggerHook.this.closed = true;
                long deadline = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10L);
                while (!FileLoggerHook.this.closedFinished) {
                    int wait = (int)(deadline - System.currentTimeMillis());
                    if (wait <= 0) {
                        return;
                    }
                    try {
                        FileLoggerHook.this.list.wait(wait);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                System.out.println("Completed writing logs to disk.");
            }
        }
    }

    class WriterThread
    extends Thread {
        static final int maxSleepTime = 60000;

        WriterThread() {
            super("Log File Writer Thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            File currentFilename = null;
            byte[] o = null;
            long lastTime = -1L;
            long nextHour = -1L;
            GregorianCalendar gc = null;
            if (FileLoggerHook.this.baseFilename != null) {
                FileLoggerHook.this.latestFile = new File(FileLoggerHook.this.baseFilename + "-latest.log");
                FileLoggerHook.this.previousFile = new File(FileLoggerHook.this.baseFilename + "-previous.log");
                gc = new GregorianCalendar();
                switch (FileLoggerHook.this.INTERVAL) {
                    case 1: {
                        gc.set(2, 0);
                    }
                    case 2: {
                        gc.set(5, 0);
                    }
                    case 3: {
                        if (FileLoggerHook.this.INTERVAL == 3) {
                            gc.set(7, 0);
                        }
                    }
                    case 5: {
                        gc.set(10, 0);
                    }
                    case 10: {
                        gc.set(12, 0);
                    }
                    case 12: {
                        gc.set(13, 0);
                        gc.set(14, 0);
                        break;
                    }
                }
                if (FileLoggerHook.this.INTERVAL_MULTIPLIER > 1) {
                    int x = gc.get(FileLoggerHook.this.INTERVAL);
                    gc.set(FileLoggerHook.this.INTERVAL, x / FileLoggerHook.this.INTERVAL_MULTIPLIER * FileLoggerHook.this.INTERVAL_MULTIPLIER);
                }
                FileLoggerHook.this.findOldLogFiles((GregorianCalendar)gc.clone());
                currentFilename = new File(FileLoggerHook.this.getHourLogName(gc, -1, true));
                Deque<OldLogFile> x = FileLoggerHook.this.logFiles;
                // MONITORENTER : x
                if (!FileLoggerHook.this.logFiles.isEmpty() && FileLoggerHook.this.logFiles.getLast().filename.equals(currentFilename)) {
                    FileLoggerHook.this.logFiles.removeLast();
                }
                // MONITOREXIT : x
                FileLoggerHook.this.logStream = this.openNewLogFile(currentFilename, true);
                if (FileLoggerHook.this.latestFile != null) {
                    FileLoggerHook.this.altLogStream = this.openNewLogFile(FileLoggerHook.this.latestFile, false);
                }
                System.err.println("Created log files");
                long startTime = gc.getTimeInMillis();
                if (logMINOR) {
                    Logger.minor(this, "Start time: " + gc + " -> " + startTime);
                }
                lastTime = startTime;
                gc.add(FileLoggerHook.this.INTERVAL, FileLoggerHook.this.INTERVAL_MULTIPLIER);
                nextHour = gc.getTimeInMillis();
            }
            long timeWaitingForSync = -1L;
            WriterThread writerThread = this;
            // MONITORENTER : writerThread
            long flush = FileLoggerHook.this.flushTime;
            // MONITOREXIT : writerThread
            while (true) {
                try {
                    while (true) {
                        long thisTime = System.currentTimeMillis();
                        if (FileLoggerHook.this.baseFilename != null && (thisTime > nextHour || FileLoggerHook.this.switchedBaseFilename)) {
                            currentFilename = this.rotateLog(currentFilename, lastTime, nextHour, gc);
                            gc.add(FileLoggerHook.this.INTERVAL, FileLoggerHook.this.INTERVAL_MULTIPLIER);
                            lastTime = nextHour;
                            nextHour = gc.getTimeInMillis();
                            if (FileLoggerHook.this.switchedBaseFilename) {
                                Class<FileLoggerHook> clazz = FileLoggerHook.class;
                                // MONITORENTER : freenet.support.FileLoggerHook.class
                                FileLoggerHook.this.switchedBaseFilename = false;
                                // MONITOREXIT : clazz
                            }
                        }
                        boolean died = false;
                        boolean timeoutFlush = false;
                        ArrayBlockingQueue<byte[]> arrayBlockingQueue = FileLoggerHook.this.list;
                        // MONITORENTER : arrayBlockingQueue
                        flush = FileLoggerHook.this.flushTime;
                        long maxWait = timeWaitingForSync == -1L ? Long.MAX_VALUE : timeWaitingForSync + flush;
                        o = FileLoggerHook.this.list.poll();
                        while (o == null) {
                            block51: {
                                if (FileLoggerHook.this.closed) {
                                    died = true;
                                    break;
                                }
                                try {
                                    if (thisTime >= maxWait) break block51;
                                    FileLoggerHook.this.list.wait(Math.min(500L, maxWait - thisTime));
                                    thisTime = System.currentTimeMillis();
                                    if (FileLoggerHook.this.listBytes < FileLoggerHook.this.LIST_WRITE_THRESHOLD) {
                                        assert (FileLoggerHook.this.listBytes == 0L == (FileLoggerHook.this.list.peek() == null));
                                        if (FileLoggerHook.this.listBytes != 0L && maxWait == Long.MAX_VALUE) {
                                            maxWait = thisTime + flush;
                                        }
                                        if (FileLoggerHook.this.closed) {
                                            o = FileLoggerHook.this.list.poll();
                                            break block51;
                                        } else if (maxWait != Long.MAX_VALUE) {
                                            continue;
                                        }
                                        break block51;
                                    }
                                    o = FileLoggerHook.this.list.poll();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            if (o != null) break;
                            if (timeWaitingForSync == -1L) {
                                timeWaitingForSync = thisTime;
                                maxWait = thisTime + flush;
                            }
                            if (thisTime < maxWait) continue;
                            timeoutFlush = true;
                            timeWaitingForSync = -1L;
                            break;
                        }
                        if (o != null) {
                            FileLoggerHook.this.listBytes -= (long)(o.length + 60);
                        }
                        // MONITOREXIT : arrayBlockingQueue
                        if (timeoutFlush || died) {
                            this.myWrite(FileLoggerHook.this.logStream, null);
                            if (FileLoggerHook.this.altLogStream != null) {
                                this.myWrite(FileLoggerHook.this.altLogStream, null);
                            }
                        }
                        if (died) {
                            try {
                                FileLoggerHook.this.logStream.close();
                            }
                            catch (IOException e) {
                                System.err.println("Failed to close log stream: " + e);
                            }
                            if (FileLoggerHook.this.altLogStream != null) {
                                try {
                                    FileLoggerHook.this.altLogStream.close();
                                }
                                catch (IOException e) {
                                    System.err.println("Failed to close compressed log stream: " + e);
                                }
                            }
                            arrayBlockingQueue = FileLoggerHook.this.list;
                            // MONITORENTER : arrayBlockingQueue
                            FileLoggerHook.this.closedFinished = true;
                            FileLoggerHook.this.list.notifyAll();
                            // MONITOREXIT : arrayBlockingQueue
                            return;
                        }
                        if (o == null) continue;
                        this.myWrite(FileLoggerHook.this.logStream, o);
                        if (FileLoggerHook.this.altLogStream == null) continue;
                        this.myWrite(FileLoggerHook.this.altLogStream, o);
                    }
                }
                catch (OutOfMemoryError e) {
                    System.err.println(e.getClass());
                    System.err.println(e.getMessage());
                    e.printStackTrace();
                    continue;
                }
                catch (Throwable t) {
                    System.err.println("FileLoggerHook log writer caught " + t);
                    t.printStackTrace(System.err);
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File rotateLog(File currentFilename, long lastTime, long nextHour, GregorianCalendar gc) {
            try {
                FileLoggerHook.this.logStream.flush();
                if (FileLoggerHook.this.altLogStream != null) {
                    FileLoggerHook.this.altLogStream.flush();
                }
            }
            catch (IOException e) {
                System.err.println("Flushing on change caught " + e);
            }
            try {
                FileLoggerHook.this.logStream.close();
            }
            catch (IOException e) {
                System.err.println("Closing on change caught " + e);
            }
            long length = currentFilename.length();
            OldLogFile olf = new OldLogFile(currentFilename, lastTime, nextHour, length);
            Deque<OldLogFile> deque = FileLoggerHook.this.logFiles;
            synchronized (deque) {
                FileLoggerHook.this.logFiles.addLast(olf);
            }
            FileLoggerHook.this.oldLogFilesDiskSpaceUsage = FileLoggerHook.this.oldLogFilesDiskSpaceUsage + length;
            FileLoggerHook.this.trimOldLogFiles();
            currentFilename = new File(FileLoggerHook.this.getHourLogName(gc, -1, true));
            FileLoggerHook.this.logStream = this.openNewLogFile(currentFilename, true);
            if (FileLoggerHook.this.latestFile != null) {
                try {
                    FileLoggerHook.this.altLogStream.close();
                }
                catch (IOException e) {
                    System.err.println("Closing alt on change caught " + e);
                }
                if (FileLoggerHook.this.previousFile != null && FileLoggerHook.this.latestFile.exists()) {
                    FileUtil.renameTo(FileLoggerHook.this.latestFile, FileLoggerHook.this.previousFile);
                }
                FileLoggerHook.this.latestFile.delete();
                FileLoggerHook.this.altLogStream = this.openNewLogFile(FileLoggerHook.this.latestFile, false);
            }
            return currentFilename;
        }

        protected void myWrite(OutputStream os, byte[] b) {
            long sleepTime = 1000L;
            while (true) {
                boolean thrown = false;
                try {
                    if (b != null) {
                        os.write(b);
                    } else {
                        os.flush();
                    }
                }
                catch (IOException e) {
                    System.err.println("Exception writing to log: " + e + ", sleeping " + sleepTime);
                    thrown = true;
                }
                if (!thrown) break;
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if ((sleepTime += sleepTime) <= 60000L) continue;
                sleepTime = 60000L;
            }
        }

        protected OutputStream openNewLogFile(File filename, boolean compress) {
            while (true) {
                long sleepTime = 1000L;
                try {
                    OutputStream o = new FileOutputStream(filename, !FileLoggerHook.this.logOverwrite);
                    if (compress) {
                        o = new BufferedOutputStream(o, 524288);
                        o = new GZIPOutputStream(o);
                        o = new BufferedOutputStream(o, 65536);
                    } else {
                        o = new BufferedOutputStream(o, 524288);
                    }
                    o.write(BOM);
                    return o;
                }
                catch (IOException e) {
                    System.err.println("Could not create FOS " + filename + ": " + e);
                    System.err.println("Sleeping " + sleepTime / 1000L + " seconds");
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    long l = sleepTime + sleepTime;
                    continue;
                }
                break;
            }
        }
    }

    public static class IntervalParseException
    extends Exception {
        private static final long serialVersionUID = 69847854744673572L;

        public IntervalParseException(String string) {
            super(string);
        }
    }

    private static class OldLogFile {
        final File filename;
        final long start;
        final long end;
        final long size;

        public OldLogFile(File currentFilename, long startTime, long endTime, long length) {
            this.filename = currentFilename;
            this.start = startTime;
            this.end = endTime;
            this.size = length;
        }
    }
}

