/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.ClientRequest;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.PersistentRequestClient;
import freenet.clients.fcp.RequestIdentifier;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class PersistentRequestRoot {
    private static final long serialVersionUID = 1L;
    final PersistentRequestClient globalForeverClient = new PersistentRequestClient("Global Queue", null, true, null, ClientRequest.Persistence.FOREVER, this);
    private final Map<String, PersistentRequestClient> clients = new TreeMap<String, PersistentRequestClient>();
    private static volatile boolean logMINOR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentRequestClient registerForeverClient(String name, FCPConnectionHandler handler) {
        PersistentRequestClient client;
        if (logMINOR) {
            Logger.minor(this, "Registering forever-client for " + name);
        }
        PersistentRequestRoot persistentRequestRoot = this;
        synchronized (persistentRequestRoot) {
            client = this.clients.get(name);
            if (client == null) {
                client = new PersistentRequestClient(name, handler, false, null, ClientRequest.Persistence.FOREVER, this);
            }
            this.clients.put(name, client);
        }
        if (handler != null) {
            client.setConnection(handler);
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentRequestClient getForeverClient(String name, FCPConnectionHandler handler) {
        PersistentRequestClient client;
        PersistentRequestRoot persistentRequestRoot = this;
        synchronized (persistentRequestRoot) {
            client = this.clients.get(name);
            if (client == null) {
                return null;
            }
        }
        if (handler != null) {
            client.setConnection(handler);
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeUnregisterClient(PersistentRequestClient client) {
        if (!client.isGlobalQueue && !client.hasPersistentRequests()) {
            PersistentRequestRoot persistentRequestRoot = this;
            synchronized (persistentRequestRoot) {
                this.clients.remove(client.name);
            }
        }
    }

    public ClientRequest[] getPersistentRequests() {
        ArrayList<ClientRequest> requests = new ArrayList<ClientRequest>();
        this.globalForeverClient.addPersistentRequests(requests, true);
        for (PersistentRequestClient client : this.clients.values()) {
            client.addPersistentRequests(requests, true);
        }
        return requests.toArray(new ClientRequest[requests.size()]);
    }

    PersistentRequestClient resume(ClientRequest clientRequest, boolean global, String clientName) {
        PersistentRequestClient client = this.makeClient(global, clientName);
        client.resume(clientRequest);
        return client;
    }

    PersistentRequestClient makeClient(boolean global, String clientName) {
        if (global) {
            return this.globalForeverClient;
        }
        return this.registerForeverClient(clientName, null);
    }

    public synchronized boolean hasRequest(RequestIdentifier req) {
        PersistentRequestClient client = req.globalQueue ? this.globalForeverClient : this.getForeverClient(req.clientName, null);
        if (client == null) {
            return false;
        }
        return client.getRequest(req.identifier) != null;
    }

    public PersistentRequestClient getGlobalForeverClient() {
        return this.globalForeverClient;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

