/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.useralerts;

import freenet.clients.fcp.FCPConnectionHandler;
import freenet.l10n.NodeL10n;
import freenet.node.NodeClientCore;
import freenet.node.useralerts.UserAlert;
import freenet.node.useralerts.UserEvent;
import freenet.support.Base64;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class UserAlertManager
implements Comparator<UserAlert> {
    private final Set<UserAlert> alerts;
    private final NodeClientCore core;
    private final Set<FCPConnectionHandler> subscribers;
    private final Map<UserEvent.Type, UserEvent> events;
    private final Set<UserEvent.Type> unregisteredEventTypes;
    private long lastUpdated;
    static final HTMLNode ALERTS_LINK = new HTMLNode("a", "href", "/alerts/").setReadOnly();

    public UserAlertManager(NodeClientCore core) {
        this.core = core;
        this.alerts = new HashSet<UserAlert>();
        this.subscribers = new CopyOnWriteArraySet<FCPConnectionHandler>();
        this.events = new HashMap<UserEvent.Type, UserEvent>();
        this.unregisteredEventTypes = new HashSet<UserEvent.Type>();
        this.lastUpdated = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(UserAlert alert) {
        if (alert instanceof UserEvent) {
            this.register((UserEvent)alert);
        }
        Set<UserAlert> set = this.alerts;
        synchronized (set) {
            if (!this.alerts.contains(alert)) {
                this.alerts.add(alert);
                this.lastUpdated = System.currentTimeMillis();
                this.notifySubscribers(alert);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(UserEvent event) {
        Object object = this.unregisteredEventTypes;
        synchronized (object) {
            if (this.unregisteredEventTypes.contains((Object)event.getEventType())) {
                return;
            }
        }
        object = this.events;
        synchronized (object) {
            UserEvent lastEvent = this.events.get((Object)event.getEventType());
            Set<UserAlert> set = this.alerts;
            synchronized (set) {
                if (lastEvent != null) {
                    this.alerts.remove(lastEvent);
                }
                this.alerts.add(event);
            }
            this.events.put(event.getEventType(), event);
            this.lastUpdated = System.currentTimeMillis();
            this.notifySubscribers(event);
        }
    }

    private void notifySubscribers(final UserAlert alert) {
        this.core.clientContext.mainExecutor.execute(new Runnable(){

            @Override
            public void run() {
                for (FCPConnectionHandler subscriber : UserAlertManager.this.subscribers) {
                    subscriber.send(alert.getFCPMessage());
                }
            }
        }, "UserAlertManager callback executor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(UserAlert alert) {
        if (alert == null) {
            return;
        }
        if (alert instanceof UserEvent) {
            this.unregister(((UserEvent)alert).getEventType());
        }
        Set<UserAlert> set = this.alerts;
        synchronized (set) {
            this.alerts.remove(alert);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(UserEvent.Type eventType) {
        Object object;
        if (eventType.unregisterIndefinitely()) {
            object = this.unregisteredEventTypes;
            synchronized (object) {
                this.unregisteredEventTypes.add(eventType);
            }
        }
        object = this.events;
        synchronized (object) {
            UserEvent latestEvent = this.events.remove((Object)eventType);
            if (latestEvent != null) {
                Set<UserAlert> set = this.alerts;
                synchronized (set) {
                    this.alerts.remove(latestEvent);
                }
            }
        }
    }

    public void dismissAlert(int alertHashCode) {
        UserAlert[] userAlerts;
        for (UserAlert userAlert : userAlerts = this.getAlerts()) {
            if (userAlert.hashCode() != alertHashCode || !userAlert.userCanDismiss()) continue;
            if (userAlert.shouldUnregisterOnDismiss()) {
                userAlert.onDismiss();
                this.unregister(userAlert);
                continue;
            }
            userAlert.isValid(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserAlert[] getAlerts() {
        UserAlert[] a;
        Set<UserAlert> set = this.alerts;
        synchronized (set) {
            a = this.alerts.toArray(new UserAlert[this.alerts.size()]);
        }
        Arrays.sort(a, this);
        return a;
    }

    @Override
    public int compare(UserAlert a0, UserAlert a1) {
        short prio1;
        if (a0 == a1) {
            return 0;
        }
        short prio0 = a0.getPriorityClass();
        if (prio0 - (prio1 = a1.getPriorityClass()) == 0) {
            int hash1;
            int classHash1;
            boolean isEvent0 = a0.isEventNotification();
            boolean isEvent1 = a1.isEventNotification();
            if (isEvent0 && !isEvent1) {
                return 1;
            }
            if (!isEvent0 && isEvent1) {
                return -1;
            }
            int classHash0 = a0.getClass().hashCode();
            if (classHash0 > (classHash1 = a1.getClass().hashCode())) {
                return 1;
            }
            if (classHash0 < classHash1) {
                return -1;
            }
            if (a0.getUpdatedTime() < a1.getUpdatedTime()) {
                return 1;
            }
            if (a0.getUpdatedTime() > a1.getUpdatedTime()) {
                return -1;
            }
            int hash0 = a0.hashCode();
            if (hash0 > (hash1 = a1.hashCode())) {
                return 1;
            }
            if (hash1 > hash0) {
                return -1;
            }
            return 0;
        }
        if (prio0 > prio1) {
            return 1;
        }
        return -1;
    }

    public HTMLNode createAlerts() {
        return this.createAlerts(true);
    }

    public HTMLNode createAlerts(boolean showOnlyErrors) {
        HTMLNode alertsNode = new HTMLNode("div");
        int totalNumber = 0;
        for (UserAlert alert : this.getAlerts()) {
            if (showOnlyErrors && alert.getPriorityClass() > 1 || !alert.isValid()) continue;
            ++totalNumber;
            alertsNode.addChild("a", "name", alert.anchor());
            if (showOnlyErrors) {
                try {
                    alertsNode.addChild(this.renderAlert(alert));
                }
                catch (Throwable t) {
                    Logger.error(this, "FAILED TO RENDER ALERT: " + alert + " : " + t, t);
                }
                continue;
            }
            alertsNode.addChild(this.renderAlert(alert));
        }
        if (totalNumber == 0) {
            return new HTMLNode("#", "");
        }
        return alertsNode;
    }

    public HTMLNode renderAlert(UserAlert userAlert) {
        HTMLNode userAlertNode = null;
        short level = userAlert.getPriorityClass();
        userAlertNode = new HTMLNode("div", "class", "infobox infobox-" + this.getAlertLevelName(level));
        userAlertNode.addChild("div", "class", "infobox-header", userAlert.getTitle());
        HTMLNode alertContentNode = userAlertNode.addChild("div", "class", "infobox-content");
        alertContentNode.addChild(userAlert.getHTMLText());
        alertContentNode.addChild(this.renderDismissButton(userAlert, null));
        return userAlertNode;
    }

    public HTMLNode renderDismissButton(UserAlert userAlert, String redirectToAfterDisable) {
        HTMLNode result = new HTMLNode("div");
        if (userAlert.userCanDismiss()) {
            HTMLNode dismissFormNode = result.addChild("form", new String[]{"action", "method"}, new String[]{"/alerts/", "post"}).addChild("div");
            dismissFormNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "disable", String.valueOf(userAlert.hashCode())});
            dismissFormNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "formPassword", this.core.formPassword});
            dismissFormNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "dismiss-user-alert", userAlert.dismissButtonText()});
            if (redirectToAfterDisable != null) {
                dismissFormNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "redirectToAfterDisable", redirectToAfterDisable});
            }
        }
        return result;
    }

    private String getAlertLevelName(short level) {
        if (level <= 0) {
            return "error";
        }
        if (level <= 1) {
            return "alert";
        }
        if (level <= 2) {
            return "warning";
        }
        if (level <= 3) {
            return "minor";
        }
        Logger.error(this, "Unknown alert level: " + level, (Throwable)new Exception("debug"));
        return "error";
    }

    public HTMLNode createSummary() {
        return this.createAlerts(true);
    }

    public HTMLNode createSummary(boolean oneLine) {
        String classes;
        short highestLevel = 99;
        int numberOfCriticalError = 0;
        int numberOfError = 0;
        int numberOfWarning = 0;
        int numberOfMinor = 0;
        int totalNumber = 0;
        for (UserAlert alert : this.getAlerts()) {
            if (!alert.isValid()) continue;
            short level = alert.getPriorityClass();
            if (level < highestLevel) {
                highestLevel = level;
            }
            if (level <= 0) {
                ++numberOfCriticalError;
            } else if (level <= 1) {
                ++numberOfError;
            } else if (level <= 2) {
                ++numberOfWarning;
            } else if (level <= 3) {
                ++numberOfMinor;
            }
            ++totalNumber;
        }
        if (numberOfMinor == 0 && numberOfWarning == 0 && oneLine) {
            return null;
        }
        if (totalNumber == 0) {
            return new HTMLNode("#", "");
        }
        boolean separatorNeeded = false;
        String separator = oneLine ? ", " : " | ";
        int messageTypes = 0;
        StringBuilder alertSummaryString = new StringBuilder(1024);
        if (numberOfCriticalError != 0 && !oneLine) {
            alertSummaryString.append(this.l10n("criticalErrorCountLabel")).append(' ').append(numberOfCriticalError);
            separatorNeeded = true;
            ++messageTypes;
        }
        if (numberOfError != 0 && !oneLine) {
            if (separatorNeeded) {
                alertSummaryString.append(separator);
            }
            alertSummaryString.append(this.l10n("errorCountLabel")).append(' ').append(numberOfError);
            separatorNeeded = true;
            ++messageTypes;
        }
        if (numberOfWarning != 0) {
            if (separatorNeeded) {
                alertSummaryString.append(separator);
            }
            if (oneLine) {
                alertSummaryString.append(numberOfWarning).append(' ').append(this.l10n("warningCountLabel").replace(":", ""));
            } else {
                alertSummaryString.append(this.l10n("warningCountLabel")).append(' ').append(numberOfWarning);
            }
            separatorNeeded = true;
            ++messageTypes;
        }
        if (numberOfMinor != 0) {
            if (separatorNeeded) {
                alertSummaryString.append(separator);
            }
            if (oneLine) {
                alertSummaryString.append(numberOfMinor).append(' ').append(this.l10n("minorCountLabel").replace(":", ""));
            } else {
                alertSummaryString.append(this.l10n("minorCountLabel")).append(' ').append(numberOfMinor);
            }
            separatorNeeded = true;
            ++messageTypes;
        }
        if (messageTypes != 1 && !oneLine) {
            if (separatorNeeded) {
                alertSummaryString.append(separator);
            }
            alertSummaryString.append(this.l10n("totalLabel")).append(' ').append(totalNumber);
        }
        HTMLNode summaryBox = null;
        String string = classes = oneLine ? "alerts-line contains-" : "infobox infobox-";
        if (highestLevel <= 0 && !oneLine) {
            summaryBox = new HTMLNode("div", "class", classes + "error");
        } else if (highestLevel <= 1 && !oneLine) {
            summaryBox = new HTMLNode("div", "class", classes + "alert");
        } else if (highestLevel <= 2) {
            summaryBox = new HTMLNode("div", "class", classes + "warning");
        } else if (highestLevel <= 3) {
            summaryBox = new HTMLNode("div", "class", classes + "information");
        }
        summaryBox.addChild("div", "class", "infobox-header", this.l10n("alertsTitle"));
        HTMLNode summaryContent = summaryBox.addChild("div", "class", "infobox-content");
        if (!oneLine) {
            summaryContent.addChild("#", alertSummaryString.toString() + separator + " ");
            NodeL10n.getBase().addL10nSubstitution(summaryContent, "UserAlertManager.alertsOnAlertsPage", new String[]{"link"}, new HTMLNode[]{ALERTS_LINK});
        } else {
            summaryContent.addChild("a", "href", "/alerts/", NodeL10n.getBase().getString("StatusBar.alerts") + " " + alertSummaryString.toString());
        }
        summaryBox.addAttribute("id", "messages-summary-box");
        return summaryBox;
    }

    private String l10n(String key) {
        return NodeL10n.getBase().getString("UserAlertManager." + key);
    }

    public void dumpEvents(HashSet<String> toDump) {
        for (UserAlert alert : this.getAlerts()) {
            if (!alert.isEventNotification() || !toDump.contains(alert.anchor())) continue;
            this.unregister(alert);
            alert.onDismiss();
        }
    }

    public void watch(final FCPConnectionHandler subscriber) {
        this.subscribers.add(subscriber);
        this.core.clientContext.mainExecutor.execute(new Runnable(){

            @Override
            public void run() {
                for (UserAlert alert : UserAlertManager.this.getAlerts()) {
                    if (!alert.isValid()) continue;
                    subscriber.send(alert.getFCPMessage());
                }
            }
        }, "UserAlertManager callback executor");
        this.subscribers.add(subscriber);
    }

    public void unwatch(FCPConnectionHandler subscriber) {
        this.subscribers.remove(subscriber);
    }

    private String formatTime(long time) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        String date = format.format((Object)new Date(time));
        return date.substring(0, 22) + ":" + date.substring(22);
    }

    public String getAtom(String startURI) {
        String messagesURI = startURI + "/alerts/";
        String feedURI = startURI + "/feed/";
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        sb.append("<feed xmlns=\"http://www.w3.org/2005/Atom\">\n");
        sb.append("\n");
        sb.append("  <title>").append(this.l10n("feedTitle")).append("</title>\n");
        sb.append("  <link href=\"").append(feedURI).append("\" rel=\"self\"/>\n");
        sb.append("  <link href=\"").append(startURI).append("\"/>\n");
        sb.append("  <updated>").append(this.formatTime(this.lastUpdated)).append("</updated>\n");
        sb.append("  <id>urn:node:").append(Base64.encode(this.core.node.getDarknetPubKeyHash())).append("</id>\n");
        sb.append("  <logo>").append("/favicon.ico").append("</logo>\n");
        UserAlert[] alerts = this.getAlerts();
        for (int i = alerts.length - 1; i >= 0; --i) {
            UserAlert alert = alerts[i];
            if (!alert.isValid()) continue;
            sb.append("\n");
            sb.append("  <entry>\n");
            sb.append("    <title>").append(alert.getTitle()).append("</title>\n");
            sb.append("    <link href=\"").append(messagesURI).append("#").append(alert.anchor()).append("\"/>\n");
            sb.append("    <summary>").append(alert.getShortText()).append("</summary>\n");
            sb.append("    <content type=\"text\">").append(alert.getText()).append("</content>\n");
            sb.append("    <id>urn:feed:").append(alert.anchor()).append("</id>\n");
            sb.append("    <updated>").append(this.formatTime(alert.getUpdatedTime())).append("</updated>\n");
            sb.append("  </entry>\n");
        }
        sb.append("\n</feed>\n");
        return sb.toString();
    }
}

