/*
 * Decompiled with CFR 0.152.
 */
package freenet.keys;

import freenet.crypt.CryptFormatException;
import freenet.crypt.DSAPublicKey;
import freenet.crypt.SHA256;
import freenet.crypt.Util;
import freenet.io.WritableToDataOutputStream;
import freenet.keys.CHKBlock;
import freenet.keys.CHKDecodeException;
import freenet.keys.CHKEncodeException;
import freenet.keys.ClientCHK;
import freenet.keys.ClientCHKBlock;
import freenet.keys.ClientKey;
import freenet.keys.ClientKeyBlock;
import freenet.keys.ClientSSK;
import freenet.keys.ClientSSKBlock;
import freenet.keys.KeyBlock;
import freenet.keys.KeyEncodeException;
import freenet.keys.KeyVerifyException;
import freenet.keys.NodeCHK;
import freenet.keys.NodeSSK;
import freenet.keys.SSKBlock;
import freenet.keys.TooBigException;
import freenet.support.Fields;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleReadOnlyArrayBucket;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.api.RandomAccessBucket;
import freenet.support.compress.CompressionOutputSizeException;
import freenet.support.compress.Compressor;
import freenet.support.compress.InvalidCompressionCodecException;
import freenet.support.io.ArrayBucket;
import freenet.support.io.ArrayBucketFactory;
import freenet.support.io.BucketTools;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Arrays;

public abstract class Key
implements WritableToDataOutputStream,
Comparable<Key> {
    final int hash;
    double cachedNormalizedDouble;
    final byte[] routingKey;
    public static final byte ALGO_AES_PCFB_256_SHA256 = 2;
    public static final byte ALGO_AES_CTR_256_SHA256 = 3;
    private static volatile boolean logMINOR;

    protected Key(byte[] routingKey) {
        this.routingKey = routingKey;
        this.hash = Fields.hashCode(routingKey);
        this.cachedNormalizedDouble = -1.0;
    }

    protected Key(Key key) {
        this.hash = key.hash;
        this.cachedNormalizedDouble = key.cachedNormalizedDouble;
        this.routingKey = new byte[key.routingKey.length];
        System.arraycopy(key.routingKey, 0, this.routingKey, 0, this.routingKey.length);
    }

    public abstract Key cloneKey();

    public abstract void write(DataOutput var1) throws IOException;

    public static Key read(DataInput raf) throws IOException {
        byte type = raf.readByte();
        byte subtype = raf.readByte();
        if (type == 1) {
            return NodeCHK.readCHK(raf, subtype);
        }
        if (type == 2) {
            return NodeSSK.readSSK(raf, subtype);
        }
        throw new IOException("Unrecognized format: " + type);
    }

    public static KeyBlock createBlock(short keyType, byte[] keyBytes, byte[] headersBytes, byte[] dataBytes, byte[] pubkeyBytes) throws KeyVerifyException {
        byte type = (byte)(keyType >> 8);
        byte subtype = (byte)(keyType & 0xFF);
        if (type == 1) {
            return CHKBlock.construct(dataBytes, headersBytes, subtype);
        }
        if (type == 2) {
            DSAPublicKey pubKey;
            try {
                pubKey = new DSAPublicKey(pubkeyBytes);
            }
            catch (IOException e) {
                throw new KeyVerifyException("Failed to construct pubkey: " + e, e);
            }
            catch (CryptFormatException e) {
                throw new KeyVerifyException("Failed to construct pubkey: " + e, e);
            }
            NodeSSK key = new NodeSSK(pubKey.asBytesHash(), keyBytes, pubKey, subtype);
            return new SSKBlock(dataBytes, headersBytes, key, false);
        }
        throw new KeyVerifyException("No such key type " + Integer.toHexString(type));
    }

    public synchronized double toNormalizedDouble() {
        if (this.cachedNormalizedDouble > 0.0) {
            return this.cachedNormalizedDouble;
        }
        MessageDigest md = SHA256.getMessageDigest();
        if (this.routingKey == null) {
            throw new NullPointerException();
        }
        md.update(this.routingKey);
        short TYPE = this.getType();
        md.update((byte)(TYPE >> 8));
        md.update((byte)TYPE);
        byte[] digest = md.digest();
        SHA256.returnMessageDigest(md);
        md = null;
        this.cachedNormalizedDouble = Util.keyDigestAsNormalizedDouble(digest);
        return this.cachedNormalizedDouble;
    }

    public abstract short getType();

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Key)) {
            return false;
        }
        return Arrays.equals(this.routingKey, ((Key)o).routingKey);
    }

    static Bucket decompress(boolean isCompressed, byte[] input, int inputLength, BucketFactory bf, long maxLength, short compressionAlgorithm, boolean shortLength) throws CHKDecodeException, IOException {
        if (maxLength < 0L) {
            throw new IllegalArgumentException("maxlength=" + maxLength);
        }
        if (input.length < inputLength) {
            throw new IndexOutOfBoundsException("" + input.length + "<" + inputLength);
        }
        if (isCompressed) {
            int inputOffset;
            if (logMINOR) {
                Logger.minor(Key.class, "Decompressing " + inputLength + " bytes in decode with codec " + compressionAlgorithm);
            }
            int n = inputOffset = shortLength ? 2 : 4;
            if (inputLength < inputOffset + 1) {
                throw new CHKDecodeException("No bytes to decompress");
            }
            int len = shortLength ? ((input[0] & 0xFF) << 8) + (input[1] & 0xFF) : ((((input[0] & 0xFF) << 8) + (input[1] & 0xFF) << 8) + (input[2] & 0xFF) << 8) + (input[3] & 0xFF);
            if ((long)len > maxLength) {
                throw new TooBigException("Invalid precompressed size: " + len + " maxlength=" + maxLength);
            }
            Compressor.COMPRESSOR_TYPE decompressor = Compressor.COMPRESSOR_TYPE.getCompressorByMetadataID(compressionAlgorithm);
            if (decompressor == null) {
                throw new CHKDecodeException("Unknown compression algorithm: " + compressionAlgorithm);
            }
            InputStream inputStream = null;
            OutputStream outputStream = null;
            SimpleReadOnlyArrayBucket inputBucket = new SimpleReadOnlyArrayBucket(input, inputOffset, inputLength - inputOffset);
            RandomAccessBucket outputBucket = bf.makeBucket(maxLength);
            outputStream = outputBucket.getOutputStream();
            inputStream = inputBucket.getInputStream();
            try {
                decompressor.decompress(inputStream, outputStream, maxLength, -1L);
            }
            catch (CompressionOutputSizeException e) {
                throw new TooBigException("Too big");
            }
            finally {
                inputStream.close();
                outputStream.close();
                inputBucket.free();
            }
            return outputBucket;
        }
        return BucketTools.makeImmutableBucket(bf, input, inputLength);
    }

    public static Compressed compress(Bucket sourceData, boolean dontCompress, short alreadyCompressedCodec, long sourceLength, long MAX_LENGTH_BEFORE_COMPRESSION, int MAX_COMPRESSED_DATA_LENGTH, boolean shortLength, String compressordescriptor) throws KeyEncodeException, IOException, InvalidCompressionCodecException {
        byte[] finalData = null;
        short compressionAlgorithm = -1;
        int maxCompressedDataLength = MAX_COMPRESSED_DATA_LENGTH;
        maxCompressedDataLength = shortLength ? (maxCompressedDataLength -= 2) : (maxCompressedDataLength -= 4);
        if (sourceData.size() > MAX_LENGTH_BEFORE_COMPRESSION) {
            throw new KeyEncodeException("Too big");
        }
        if (!dontCompress || alreadyCompressedCodec >= 0) {
            byte[] cbuf = null;
            if (alreadyCompressedCodec >= 0) {
                if (sourceData.size() > (long)maxCompressedDataLength) {
                    throw new TooBigException("Too big (precompressed)");
                }
                compressionAlgorithm = alreadyCompressedCodec;
                cbuf = BucketTools.toByteArray(sourceData);
                if (sourceLength > MAX_LENGTH_BEFORE_COMPRESSION) {
                    throw new TooBigException("Too big");
                }
            } else if (sourceData.size() > (long)maxCompressedDataLength) {
                Compressor.COMPRESSOR_TYPE[] comps;
                for (Compressor.COMPRESSOR_TYPE comp : comps = Compressor.COMPRESSOR_TYPE.getCompressorsArray(compressordescriptor)) {
                    ArrayBucket compressedData;
                    try {
                        compressedData = (ArrayBucket)comp.compress(sourceData, new ArrayBucketFactory(), Long.MAX_VALUE, (long)maxCompressedDataLength);
                    }
                    catch (CompressionOutputSizeException e) {
                        continue;
                    }
                    if (compressedData.size() > (long)maxCompressedDataLength) continue;
                    compressionAlgorithm = comp.metadataID;
                    sourceLength = sourceData.size();
                    try {
                        cbuf = BucketTools.toByteArray(compressedData);
                        break;
                    }
                    catch (IOException e) {
                        throw new Error(e);
                    }
                }
            }
            if (cbuf != null) {
                int compressedLength = cbuf.length;
                finalData = new byte[compressedLength + (shortLength ? 2 : 4)];
                System.arraycopy(cbuf, 0, finalData, shortLength ? 2 : 4, compressedLength);
                if (!shortLength) {
                    finalData[0] = (byte)(sourceLength >> 24 & 0xFFL);
                    finalData[1] = (byte)(sourceLength >> 16 & 0xFFL);
                    finalData[2] = (byte)(sourceLength >> 8 & 0xFFL);
                    finalData[3] = (byte)(sourceLength & 0xFFL);
                } else {
                    finalData[0] = (byte)(sourceLength >> 8 & 0xFFL);
                    finalData[1] = (byte)(sourceLength & 0xFFL);
                }
            }
        }
        if (finalData == null) {
            if (sourceData.size() > (long)MAX_COMPRESSED_DATA_LENGTH) {
                throw new CHKEncodeException("Too big: " + sourceData.size() + " should be " + MAX_COMPRESSED_DATA_LENGTH);
            }
            finalData = BucketTools.toByteArray(sourceData);
        }
        return new Compressed(finalData, compressionAlgorithm);
    }

    public byte[] getRoutingKey() {
        return this.routingKey;
    }

    public byte[] getKeyBytes() {
        return this.routingKey;
    }

    public static ClientKeyBlock createKeyBlock(ClientKey key, KeyBlock block) throws KeyVerifyException {
        if (key instanceof ClientSSK) {
            return ClientSSKBlock.construct((SSKBlock)block, (ClientSSK)key);
        }
        return new ClientCHKBlock((CHKBlock)block, (ClientCHK)key);
    }

    public abstract byte[] getFullKey();

    public abstract Key archivalCopy();

    public static boolean isValidCryptoAlgorithm(byte cryptoAlgorithm) {
        return cryptoAlgorithm == 2 || cryptoAlgorithm == 3;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    static class Compressed {
        byte[] compressedData;
        short compressionAlgorithm;

        public Compressed(byte[] finalData, short compressionAlgorithm2) {
            this.compressedData = finalData;
            this.compressionAlgorithm = compressionAlgorithm2;
        }
    }
}

