/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.xfer.PacketThrottle;
import freenet.node.BasePeerNode;
import freenet.node.NPFPacket;
import freenet.node.NewPacketFormat;
import freenet.node.SessionKey;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SentTimeCache;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class NewPacketFormatKeyContext {
    public int firstSeqNumUsed = -1;
    public int nextSeqNum;
    public int highestReceivedSeqNum;
    public byte[][] seqNumWatchList = null;
    public int watchListPointer = 0;
    public int watchListOffset = 0;
    private final TreeMap<Integer, Long> acks = new TreeMap();
    private final HashMap<Integer, NewPacketFormat.SentPacket> sentPackets = new HashMap();
    private static final int MAX_LOST_SENT_TIMES = 128;
    private final SentTimeCache lostSentTimes = new SentTimeCache(128);
    private final Object sequenceNumberLock = new Object();
    private static final int REKEY_THRESHOLD = 100;
    static final int MAX_ACK_DELAY = 200;
    private static final int MIN_RTT_FOR_RETRANSMIT = 250;
    private int maxSeenInFlight;
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;

    NewPacketFormatKeyContext(int ourFirstSeqNum, int theirFirstSeqNum) {
        this.nextSeqNum = ourFirstSeqNum &= Integer.MAX_VALUE;
        this.watchListOffset = theirFirstSeqNum &= Integer.MAX_VALUE;
        this.highestReceivedSeqNum = theirFirstSeqNum - 1;
        if (this.highestReceivedSeqNum == -1) {
            this.highestReceivedSeqNum = Integer.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canAllocateSeqNum() {
        Object object = this.sequenceNumberLock;
        synchronized (object) {
            return this.nextSeqNum != this.firstSeqNumUsed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int allocateSequenceNumber(BasePeerNode pn) {
        Object object = this.sequenceNumberLock;
        synchronized (object) {
            if (this.firstSeqNumUsed == -1) {
                this.firstSeqNumUsed = this.nextSeqNum;
                if (logMINOR) {
                    Logger.minor(this, "First seqnum used for " + this + " is " + this.firstSeqNumUsed);
                }
            } else {
                if (this.nextSeqNum == this.firstSeqNumUsed) {
                    Logger.error(this, "Blocked because we haven't rekeyed yet");
                    pn.startRekeying();
                    return -1;
                }
                if (this.firstSeqNumUsed > this.nextSeqNum) {
                    if (this.firstSeqNumUsed - this.nextSeqNum < 100) {
                        pn.startRekeying();
                    }
                } else if (0x80000000L - (long)this.nextSeqNum + (long)this.firstSeqNumUsed < 100L) {
                    pn.startRekeying();
                }
            }
            int seqNum = this.nextSeqNum++;
            if (this.nextSeqNum < 0) {
                this.nextSeqNum = 0;
            }
            return seqNum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ack(int ack, BasePeerNode pn, SessionKey key) {
        PacketThrottle throttle;
        long rtt;
        int maxSize;
        NewPacketFormat.SentPacket sent;
        boolean validAck = false;
        long ackReceived = System.currentTimeMillis();
        if (logDEBUG) {
            Logger.debug(this, "Acknowledging packet " + ack + " from " + pn);
        }
        HashMap<Integer, NewPacketFormat.SentPacket> hashMap = this.sentPackets;
        synchronized (hashMap) {
            sent = this.sentPackets.remove(ack);
            maxSize = this.maxSeenInFlight * 2 + 10;
        }
        if (sent != null) {
            rtt = sent.acked(key);
            validAck = true;
        } else {
            long packetSent;
            if (logDEBUG) {
                Logger.debug(this, "Already acked or lost " + ack);
            }
            if ((packetSent = this.lostSentTimes.queryAndRemove(ack)) < 0L) {
                if (logDEBUG) {
                    Logger.debug(this, "No time for " + ack + " - maybe acked twice?");
                }
                return;
            }
            rtt = ackReceived - packetSent;
        }
        if (pn == null) {
            return;
        }
        int rt = (int)Math.min(rtt, Integer.MAX_VALUE);
        pn.reportPing(rt);
        if (validAck) {
            pn.receivedAck(ackReceived);
        }
        if ((throttle = pn.getThrottle()) == null) {
            return;
        }
        throttle.setRoundTripTime(rt);
        if (validAck) {
            throttle.notifyOfPacketAcknowledged(maxSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queueAck(int seqno) {
        TreeMap<Integer, Long> treeMap = this.acks;
        synchronized (treeMap) {
            if (!this.acks.containsKey(seqno)) {
                this.acks.put(seqno, System.currentTimeMillis());
                return this.acks.size();
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sent(int sequenceNumber, int length) {
        HashMap<Integer, NewPacketFormat.SentPacket> hashMap = this.sentPackets;
        synchronized (hashMap) {
            NewPacketFormat.SentPacket sentPacket = this.sentPackets.get(sequenceNumber);
            if (sentPacket != null) {
                sentPacket.sent(length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddedAcks addAcks(NPFPacket packet, int maxPacketSize, long now) {
        boolean mustSend = false;
        HashMap<Integer, Long> moved = null;
        int numAcks = 0;
        TreeMap<Integer, Long> treeMap = this.acks;
        synchronized (treeMap) {
            Iterator<Map.Entry<Integer, Long>> it = this.acks.entrySet().iterator();
            while (it.hasNext() && packet.getLength() < maxPacketSize) {
                Map.Entry<Integer, Long> entry = it.next();
                int ack = entry.getKey();
                if (logDEBUG) {
                    Logger.debug(this, "Trying to ack " + ack);
                }
                if (!packet.addAck(ack, maxPacketSize)) {
                    if (!logDEBUG) break;
                    Logger.debug(this, "Can't add ack " + ack);
                    break;
                }
                if (entry.getValue() + 200L < now) {
                    mustSend = true;
                }
                if (moved == null) {
                    moved = new HashMap<Integer, Long>();
                }
                moved.put(ack, entry.getValue());
                ++numAcks;
                it.remove();
            }
        }
        if (numAcks == 0) {
            return null;
        }
        return new AddedAcks(mustSend, moved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countSentPackets() {
        HashMap<Integer, NewPacketFormat.SentPacket> hashMap = this.sentPackets;
        synchronized (hashMap) {
            return this.sentPackets.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sent(NewPacketFormat.SentPacket sentPacket, int seqNum, int length) {
        sentPacket.sent(length);
        HashMap<Integer, NewPacketFormat.SentPacket> hashMap = this.sentPackets;
        synchronized (hashMap) {
            this.sentPackets.put(seqNum, sentPacket);
            int inFlight = this.sentPackets.size();
            if (inFlight > this.maxSeenInFlight) {
                this.maxSeenInFlight = inFlight;
                if (logDEBUG) {
                    Logger.debug(this, "Max seen in flight new record: " + this.maxSeenInFlight + " for " + this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long timeCheckForLostPackets(double averageRTT) {
        long timeCheck = Long.MAX_VALUE;
        double avgRtt = Math.max(250.0, averageRTT);
        long maxDelay = (long)(avgRtt + 220.00000000000003);
        HashMap<Integer, NewPacketFormat.SentPacket> hashMap = this.sentPackets;
        synchronized (hashMap) {
            for (NewPacketFormat.SentPacket s : this.sentPackets.values()) {
                long t = s.getSentTime() + maxDelay;
                if (t >= timeCheck) continue;
                timeCheck = t;
            }
        }
        return timeCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForLostPackets(double averageRTT, long curTime, BasePeerNode pn) {
        int bigLostCount = 0;
        int count = 0;
        double avgRtt = Math.max(250.0, averageRTT);
        long maxDelay = (long)(avgRtt + 220.00000000000003);
        long threshold = curTime - maxDelay;
        HashMap<Integer, NewPacketFormat.SentPacket> hashMap = this.sentPackets;
        synchronized (hashMap) {
            Iterator<Map.Entry<Integer, NewPacketFormat.SentPacket>> it = this.sentPackets.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, NewPacketFormat.SentPacket> e = it.next();
                NewPacketFormat.SentPacket s = e.getValue();
                if (s.getSentTime() < threshold) {
                    if (logMINOR) {
                        Logger.minor(this, "Assuming packet " + e.getKey() + " has been lost. Delay " + (curTime - s.getSentTime()) + "ms, threshold " + threshold + "ms");
                    }
                    if (!s.messages.isEmpty()) {
                        this.lostSentTimes.report(e.getKey(), s.getSentTime());
                    }
                    s.lost();
                    it.remove();
                    ++bigLostCount;
                    continue;
                }
                ++count;
            }
        }
        if (count > 0 && logMINOR) {
            Logger.minor(this, "" + count + " packets in flight with threshold " + maxDelay + "ms");
        }
        if (bigLostCount != 0 && pn != null) {
            PacketThrottle throttle = pn.getThrottle();
            if (throttle != null) {
                throttle.notifyOfPacketsLost(bigLostCount);
            }
            pn.backoffOnResend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long timeCheckForAcks() {
        long ret = Long.MAX_VALUE;
        TreeMap<Integer, Long> treeMap = this.acks;
        synchronized (treeMap) {
            for (Long l : this.acks.values()) {
                long timeout = l + 200L;
                if (ret <= timeout) continue;
                ret = timeout;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnected() {
        HashMap<Integer, NewPacketFormat.SentPacket> hashMap = this.sentPackets;
        synchronized (hashMap) {
            for (NewPacketFormat.SentPacket s : this.sentPackets.values()) {
                s.lost();
            }
            this.sentPackets.clear();
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
    }

    class AddedAcks {
        final boolean anyUrgentAcks;
        private final HashMap<Integer, Long> moved;

        public AddedAcks(boolean mustSend, HashMap<Integer, Long> moved) {
            this.anyUrgentAcks = mustSend;
            this.moved = moved;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abort() {
            TreeMap treeMap = NewPacketFormatKeyContext.this.acks;
            synchronized (treeMap) {
                NewPacketFormatKeyContext.this.acks.putAll(this.moved);
            }
        }
    }
}

