/*
 * Decompiled with CFR 0.152.
 */
package freenet.io;

import freenet.io.InetAddressAddressTrackerItem;
import freenet.io.PeerAddressTrackerItem;
import freenet.io.comm.Peer;
import freenet.l10n.NodeL10n;
import freenet.node.FSParseException;
import freenet.node.ProgramDirectory;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.io.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public class AddressTracker {
    private final HashMap<Peer, PeerAddressTrackerItem> peerTrackers;
    private final HashMap<InetAddress, InetAddressAddressTrackerItem> ipTrackers;
    private int MAX_ITEMS = 1000;
    static final int DEFAULT_MAX_ITEMS = 1000;
    static final int SEED_MAX_ITEMS = 10000;
    private long timeDefinitelyNoPacketsReceivedIP;
    private long timeDefinitelyNoPacketsSentIP;
    private long timeDefinitelyNoPacketsReceivedPeer;
    private long timeDefinitelyNoPacketsSentPeer;
    private long brokenTime;
    public static final long MAYBE_TUNNEL_LENGTH = TimeUnit.MINUTES.toMillis(5L) + TimeUnit.SECONDS.toMillis(1L);
    public static final long DEFINITELY_TUNNEL_LENGTH = TimeUnit.HOURS.toMillis(12L) + TimeUnit.MINUTES.toMillis(1L);
    public static final long HORIZON = TimeUnit.HOURS.toMillis(24L);
    private long timePresumeGuilty = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AddressTracker create(long lastBootID, ProgramDirectory runDir, int port) {
        File data = runDir.file("packets-" + port + ".dat");
        File dataBak = runDir.file("packets-" + port + ".bak");
        dataBak.delete();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(data);
            BufferedInputStream bis = new BufferedInputStream(fis);
            InputStreamReader ir = new InputStreamReader((InputStream)bis, "UTF-8");
            BufferedReader br = new BufferedReader(ir);
            SimpleFieldSet fs = new SimpleFieldSet(br, false, true);
            AddressTracker addressTracker = new AddressTracker(fs, lastBootID);
            return addressTracker;
        }
        catch (IOException bis) {
        }
        catch (FSParseException e) {
            Logger.warning(AddressTracker.class, "Failed to load from disk for port " + port + ": " + e, (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new AddressTracker();
    }

    private AddressTracker() {
        this.timeDefinitelyNoPacketsReceivedIP = System.currentTimeMillis();
        this.timeDefinitelyNoPacketsSentIP = System.currentTimeMillis();
        this.timeDefinitelyNoPacketsReceivedPeer = System.currentTimeMillis();
        this.timeDefinitelyNoPacketsSentPeer = System.currentTimeMillis();
        this.peerTrackers = new HashMap();
        this.ipTrackers = new HashMap();
    }

    private AddressTracker(SimpleFieldSet fs, long lastBootID) throws FSParseException {
        Iterator<String> i;
        Iterator<String> i2;
        int version = fs.getInt("Version");
        if (version != 2) {
            throw new FSParseException("Unknown Version " + version);
        }
        long savedBootID = fs.getLong("BootID");
        if (savedBootID != lastBootID) {
            throw new FSParseException("Unable to load address tracker table, assuming an unclean shutdown: Last ID was " + lastBootID + " but stored " + savedBootID);
        }
        this.timeDefinitelyNoPacketsReceivedPeer = System.currentTimeMillis();
        this.timeDefinitelyNoPacketsReceivedIP = System.currentTimeMillis();
        this.timeDefinitelyNoPacketsSentPeer = fs.getLong("TimeDefinitelyNoPacketsSentPeer");
        this.timeDefinitelyNoPacketsSentIP = fs.getLong("TimeDefinitelyNoPacketsSentIP");
        this.peerTrackers = new HashMap();
        SimpleFieldSet peers = fs.subset("Peers");
        if (peers != null && (i2 = peers.directSubsetNameIterator()) != null) {
            while (i2.hasNext()) {
                SimpleFieldSet peer = peers.subset(i2.next());
                PeerAddressTrackerItem item = new PeerAddressTrackerItem(peer);
                this.peerTrackers.put(item.peer, item);
            }
        }
        this.ipTrackers = new HashMap();
        SimpleFieldSet ips = fs.subset("IPs");
        if (ips != null && (i = ips.directSubsetNameIterator()) != null) {
            while (i.hasNext()) {
                SimpleFieldSet peer = ips.subset(i.next());
                InetAddressAddressTrackerItem item = new InetAddressAddressTrackerItem(peer);
                this.ipTrackers.put(item.addr, item);
            }
        }
    }

    public void sentPacketTo(Peer peer) {
        this.packetTo(peer, true);
    }

    public void receivedPacketFrom(Peer peer) {
        this.packetTo(peer, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packetTo(Peer peer, boolean sent) {
        Peer peer2 = peer.dropHostName();
        if (peer2 == null) {
            Logger.error(this, "Impossible: No host name in AddressTracker.packetTo for " + peer);
            return;
        }
        peer = peer2;
        InetAddress ip = peer.getAddress();
        long now = System.currentTimeMillis();
        AddressTracker addressTracker = this;
        synchronized (addressTracker) {
            PeerAddressTrackerItem peerItem = this.peerTrackers.get(peer);
            if (peerItem == null) {
                peerItem = new PeerAddressTrackerItem(this.timeDefinitelyNoPacketsReceivedPeer, this.timeDefinitelyNoPacketsSentPeer, peer);
                if (this.peerTrackers.size() > this.MAX_ITEMS) {
                    Logger.error(this, "Clearing peer trackers on " + this);
                    this.peerTrackers.clear();
                    this.ipTrackers.clear();
                    this.timeDefinitelyNoPacketsReceivedPeer = now;
                    this.timeDefinitelyNoPacketsSentPeer = now;
                }
                this.peerTrackers.put(peer, peerItem);
            }
            if (sent) {
                peerItem.sentPacket(now);
            } else {
                peerItem.receivedPacket(now);
            }
            InetAddressAddressTrackerItem ipItem = this.ipTrackers.get(ip);
            if (ipItem == null) {
                ipItem = new InetAddressAddressTrackerItem(this.timeDefinitelyNoPacketsReceivedIP, this.timeDefinitelyNoPacketsSentIP, ip);
                if (this.ipTrackers.size() > this.MAX_ITEMS) {
                    Logger.error(this, "Clearing IP trackers on " + this);
                    this.peerTrackers.clear();
                    this.ipTrackers.clear();
                    this.timeDefinitelyNoPacketsReceivedIP = now;
                    this.timeDefinitelyNoPacketsSentIP = now;
                }
                this.ipTrackers.put(ip, ipItem);
            }
            if (sent) {
                ipItem.sentPacket(now);
            } else {
                ipItem.receivedPacket(now);
            }
        }
    }

    public synchronized void startReceive(long now) {
        this.timeDefinitelyNoPacketsReceivedIP = now;
        this.timeDefinitelyNoPacketsReceivedPeer = now;
    }

    public synchronized void startSend(long now) {
        this.timeDefinitelyNoPacketsSentIP = now;
        this.timeDefinitelyNoPacketsSentPeer = now;
    }

    public synchronized PeerAddressTrackerItem[] getPeerAddressTrackerItems() {
        PeerAddressTrackerItem[] items = new PeerAddressTrackerItem[this.peerTrackers.size()];
        return this.peerTrackers.values().toArray(items);
    }

    public synchronized InetAddressAddressTrackerItem[] getInetAddressTrackerItems() {
        InetAddressAddressTrackerItem[] items = new InetAddressAddressTrackerItem[this.ipTrackers.size()];
        return this.ipTrackers.values().toArray(items);
    }

    public long getLongestSendReceiveGap() {
        return this.getLongestSendReceiveGap(HORIZON);
    }

    public long getLongestSendReceiveGap(long horizon) {
        PeerAddressTrackerItem[] items;
        long longestGap = -1L;
        long now = System.currentTimeMillis();
        for (PeerAddressTrackerItem item : items = this.getPeerAddressTrackerItems()) {
            if (item.packetsReceived() <= 0L || !item.peer.isRealInternetAddress(false, false, false)) continue;
            longestGap = Math.max(longestGap, item.longestGap(horizon, now));
        }
        return longestGap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status getPortForwardStatus() {
        long minGap = this.getLongestSendReceiveGap(HORIZON);
        if (minGap > DEFINITELY_TUNNEL_LENGTH) {
            return Status.DEFINITELY_PORT_FORWARDED;
        }
        if (minGap > MAYBE_TUNNEL_LENGTH) {
            return Status.MAYBE_PORT_FORWARDED;
        }
        AddressTracker addressTracker = this;
        synchronized (addressTracker) {
            if (this.isBroken()) {
                return Status.DEFINITELY_NATED;
            }
            if (minGap == 0L && this.timePresumeGuilty > 0L && System.currentTimeMillis() > this.timePresumeGuilty) {
                return Status.MAYBE_NATED;
            }
        }
        return Status.DONT_KNOW;
    }

    private boolean isBroken() {
        return System.currentTimeMillis() - this.brokenTime < HORIZON;
    }

    public static String statusString(Status status) {
        return NodeL10n.getBase().getString("ConnectivityToadlet.status." + (Object)((Object)status));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeData(long bootID, ProgramDirectory runDir, int port) {
        if (this.isBroken()) {
            return;
        }
        File data = runDir.file("packets-" + port + ".dat");
        File dataBak = runDir.file("packets-" + port + ".bak");
        dataBak.delete();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(dataBak);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)bos, "UTF-8");
            BufferedWriter bw = new BufferedWriter(osw);
            SimpleFieldSet fs = this.getFieldset(bootID);
            fs.writeTo(bw);
            bw.flush();
            bw.close();
            fos = null;
            FileUtil.renameTo(dataBak, data);
        }
        catch (IOException e) {
            Logger.error(this, "Cannot store packet tracker to disk");
            return;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private synchronized SimpleFieldSet getFieldset(long bootID) {
        SimpleFieldSet sfs = new SimpleFieldSet(true);
        sfs.put("Version", 2);
        sfs.put("BootID", bootID);
        sfs.put("TimeDefinitelyNoPacketsReceivedPeer", this.timeDefinitelyNoPacketsReceivedPeer);
        sfs.put("TimeDefinitelyNoPacketsReceivedIP", this.timeDefinitelyNoPacketsReceivedIP);
        sfs.put("TimeDefinitelyNoPacketsSentPeer", this.timeDefinitelyNoPacketsSentPeer);
        sfs.put("TimeDefinitelyNoPacketsSentIP", this.timeDefinitelyNoPacketsSentIP);
        PeerAddressTrackerItem[] peerItems = this.getPeerAddressTrackerItems();
        SimpleFieldSet items = new SimpleFieldSet(true);
        if (peerItems.length > 0) {
            for (int i = 0; i < peerItems.length; ++i) {
                items.put(Integer.toString(i), peerItems[i].toFieldSet());
            }
            sfs.put("Peers", items);
        }
        InetAddressAddressTrackerItem[] inetItems = this.getInetAddressTrackerItems();
        items = new SimpleFieldSet(true);
        if (inetItems.length > 0) {
            for (int i = 0; i < inetItems.length; ++i) {
                items.put(Integer.toString(i), inetItems[i].toFieldSet());
            }
            sfs.put("IPs", items);
        }
        return sfs;
    }

    public void rescan() {
    }

    public synchronized void setBroken() {
        this.brokenTime = System.currentTimeMillis();
    }

    public synchronized void setPresumedGuiltyAt(long l) {
        if (this.timePresumeGuilty <= 0L) {
            this.timePresumeGuilty = l;
        }
    }

    public synchronized void setPresumedInnocent() {
        this.timePresumeGuilty = -1L;
    }

    public synchronized void setHugeTracker() {
        this.MAX_ITEMS = 10000;
    }

    public static enum Status {
        DEFINITELY_NATED,
        MAYBE_NATED,
        DONT_KNOW,
        MAYBE_PORT_FORWARDED,
        DEFINITELY_PORT_FORWARDED;

    }
}

