/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.client.ArchiveManager;
import freenet.client.FetchContext;
import freenet.client.HighLevelSimpleClient;
import freenet.client.HighLevelSimpleClientImpl;
import freenet.client.InsertContext;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientLayerPersister;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.DatastoreChecker;
import freenet.client.async.HealingQueue;
import freenet.client.async.PersistentStatsPutter;
import freenet.client.async.SimpleHealingQueue;
import freenet.client.async.USKManager;
import freenet.client.events.SimpleEventProducer;
import freenet.client.filter.FilterCallback;
import freenet.client.filter.FoundURICallback;
import freenet.client.filter.GenericReadFilterCallback;
import freenet.client.filter.LinkFilterExceptionProvider;
import freenet.clients.fcp.ClientRequest;
import freenet.clients.fcp.FCPServer;
import freenet.clients.fcp.PersistentRequestRoot;
import freenet.clients.http.FProxyToadlet;
import freenet.clients.http.SimpleToadletServer;
import freenet.clients.http.bookmark.BookmarkManager;
import freenet.config.Config;
import freenet.config.InvalidConfigValueException;
import freenet.config.NodeNeedRestartException;
import freenet.config.SubConfig;
import freenet.crypt.MasterSecret;
import freenet.crypt.RandomSource;
import freenet.io.xfer.AbortedException;
import freenet.io.xfer.PartiallyReceivedBlock;
import freenet.keys.CHKBlock;
import freenet.keys.CHKVerifyException;
import freenet.keys.ClientCHK;
import freenet.keys.ClientCHKBlock;
import freenet.keys.ClientKey;
import freenet.keys.ClientKeyBlock;
import freenet.keys.ClientSSK;
import freenet.keys.ClientSSKBlock;
import freenet.keys.FreenetURI;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.NodeSSK;
import freenet.keys.SSKBlock;
import freenet.keys.SSKVerifyException;
import freenet.l10n.NodeL10n;
import freenet.node.CHKInsertSender;
import freenet.node.ConfigurablePersister;
import freenet.node.DatabaseKey;
import freenet.node.InsertTag;
import freenet.node.LowLevelGetException;
import freenet.node.LowLevelPutException;
import freenet.node.MasterKeysWrongPasswordException;
import freenet.node.Node;
import freenet.node.NodeInitException;
import freenet.node.NodeStarter;
import freenet.node.NodeStats;
import freenet.node.PeerNode;
import freenet.node.Persistable;
import freenet.node.Persister;
import freenet.node.PrioRunnable;
import freenet.node.ProgramDirectory;
import freenet.node.RecentlyFailedReturn;
import freenet.node.RequestCompletionListener;
import freenet.node.RequestSender;
import freenet.node.RequestSenderListener;
import freenet.node.RequestStarterGroup;
import freenet.node.RequestTag;
import freenet.node.RequestTracker;
import freenet.node.SSKInsertSender;
import freenet.node.SecurityLevelListener;
import freenet.node.SecurityLevels;
import freenet.node.SemiOrderedShutdownHook;
import freenet.node.SimpleSendableInsert;
import freenet.node.TextModeClientInterface;
import freenet.node.TextModeClientInterfaceServer;
import freenet.node.useralerts.DatastoreTooSmallAlert;
import freenet.node.useralerts.DiskSpaceUserAlert;
import freenet.node.useralerts.SimpleUserAlert;
import freenet.node.useralerts.UserAlert;
import freenet.node.useralerts.UserAlertManager;
import freenet.pluginmanager.PluginStores;
import freenet.store.KeyCollisionException;
import freenet.support.Base64;
import freenet.support.Executor;
import freenet.support.Logger;
import freenet.support.MemoryLimitedJobRunner;
import freenet.support.SimpleFieldSet;
import freenet.support.SizeUtil;
import freenet.support.Ticker;
import freenet.support.api.BooleanCallback;
import freenet.support.api.IntCallback;
import freenet.support.api.LongCallback;
import freenet.support.api.StringArrCallback;
import freenet.support.compress.Compressor;
import freenet.support.compress.RealCompressor;
import freenet.support.io.DiskSpaceCheckingRandomAccessBufferFactory;
import freenet.support.io.FileUtil;
import freenet.support.io.FilenameGenerator;
import freenet.support.io.MaybeEncryptedRandomAccessBufferFactory;
import freenet.support.io.NativeThread;
import freenet.support.io.PersistentTempBucketFactory;
import freenet.support.io.PooledFileRandomAccessBufferFactory;
import freenet.support.io.TempBucketFactory;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;

public class NodeClientCore
implements Persistable {
    private static volatile boolean logMINOR;
    public final PersistentStatsPutter bandwidthStatsPutter;
    public final USKManager uskManager;
    public final ArchiveManager archiveManager;
    public final RequestStarterGroup requestStarters;
    private final HealingQueue healingQueue;
    public final MemoryLimitedJobRunner memoryLimitedJobRunner;
    public final String formPassword;
    final ProgramDirectory downloadsDir;
    private File[] downloadAllowedDirs;
    private boolean includeDownloadDir;
    private boolean downloadAllowedEverywhere;
    private boolean downloadDisabled;
    private File[] uploadAllowedDirs;
    private boolean uploadAllowedEverywhere;
    public final FilenameGenerator tempFilenameGenerator;
    public final FilenameGenerator persistentFilenameGenerator;
    public final TempBucketFactory tempBucketFactory;
    public final PersistentTempBucketFactory persistentTempBucketFactory;
    private final DiskSpaceCheckingRandomAccessBufferFactory persistentDiskChecker;
    public final MaybeEncryptedRandomAccessBufferFactory persistentRAFFactory;
    public final ClientLayerPersister clientLayerPersister;
    public final Node node;
    public final RequestTracker tracker;
    final NodeStats nodeStats;
    public final RandomSource random;
    final ProgramDirectory tempDir;
    final ProgramDirectory persistentTempDir;
    public final UserAlertManager alerts;
    final TextModeClientInterfaceServer tmci;
    TextModeClientInterface directTMCI;
    private final PersistentRequestRoot fcpPersistentRoot;
    final FCPServer fcpServer;
    FProxyToadlet fproxyServlet;
    final SimpleToadletServer toadletContainer;
    public final RealCompressor compressor;
    protected final Persister persister;
    public final DatastoreChecker storeChecker;
    private long minDiskFreeLongTerm;
    private long minDiskFreeShortTerm;
    private final MasterSecret cryptoSecretTransient;
    public final transient ClientContext clientContext;
    private static int maxBackgroundUSKFetchers;
    static final int MAX_ARCHIVE_HANDLERS = 200;
    static final long MAX_CACHED_ARCHIVE_DATA = 0x2000000L;
    static final long MAX_ARCHIVED_FILE_SIZE = 0x100000L;
    static final int MAX_CACHED_ELEMENTS = 262144;
    private UserAlert startingUpAlert;
    private boolean alwaysCommit;
    private final PluginStores pluginStores;
    private boolean lazyStartDatastoreChecker;
    private boolean finishedInitStorage;
    private boolean finishingInitStorage;

    NodeClientCore(Node node, Config config, SubConfig nodeConfig, SubConfig installConfig, int portNumber, int sortOrder, SimpleFieldSet oldConfig, SubConfig fproxyConfig, SimpleToadletServer toadlets, DatabaseKey databaseKey, MasterSecret persistentSecret) throws NodeInitException {
        int defaultRamBucketPoolSize;
        long maxMemory;
        this.node = node;
        this.tracker = node.tracker;
        this.nodeStats = node.nodeStats;
        this.random = node.random;
        this.pluginStores = new PluginStores(node, installConfig);
        nodeConfig.register("lazyStartDatastoreChecker", false, sortOrder++, true, false, "NodeClientCore.lazyStartDatastoreChecker", "NodeClientCore.lazyStartDatastoreCheckerLong", new BooleanCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean get() {
                NodeClientCore nodeClientCore = NodeClientCore.this;
                synchronized (nodeClientCore) {
                    return NodeClientCore.this.lazyStartDatastoreChecker;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                NodeClientCore nodeClientCore = NodeClientCore.this;
                synchronized (nodeClientCore) {
                    if (val != NodeClientCore.this.lazyStartDatastoreChecker) {
                        NodeClientCore.this.lazyStartDatastoreChecker = val;
                        throw new NodeNeedRestartException(NodeClientCore.l10n("lazyStartDatastoreCheckerMustRestartNode"));
                    }
                }
            }
        });
        this.lazyStartDatastoreChecker = nodeConfig.getBoolean("lazyStartDatastoreChecker");
        this.storeChecker = new DatastoreChecker(node, this.lazyStartDatastoreChecker, node.executor, "Datastore checker");
        byte[] pwdBuf = new byte[16];
        this.random.nextBytes(pwdBuf);
        this.compressor = new RealCompressor();
        this.formPassword = Base64.encode(pwdBuf);
        this.alerts = new UserAlertManager(this);
        this.persister = new ConfigurablePersister(this, nodeConfig, "clientThrottleFile", "client-throttle.dat", sortOrder++, true, false, "NodeClientCore.fileForClientStats", "NodeClientCore.fileForClientStatsLong", node.ticker, node.getRunDir());
        SimpleFieldSet throttleFS = this.persister.read();
        if (logMINOR) {
            Logger.minor(this, "Read throttleFS:\n" + throttleFS);
        }
        if (logMINOR) {
            Logger.minor(this, "Serializing RequestStarterGroup from:\n" + throttleFS);
        }
        this.tempDir = node.setupProgramDir(installConfig, "tempDir", node.runDir().file("temp").toString(), "NodeClientCore.tempDir", "NodeClientCore.tempDirLong", nodeConfig);
        File oldTemp = node.runDir().file("temp-" + node.getDarknetPortNumber());
        if (oldTemp.exists() && oldTemp.isDirectory() && !FileUtil.equals(this.tempDir.dir, oldTemp)) {
            System.err.println("Deleting old temporary dir: " + oldTemp);
            try {
                FileUtil.secureDeleteAll(oldTemp);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        FileUtil.setOwnerRWX(this.getTempDir());
        try {
            this.tempFilenameGenerator = new FilenameGenerator(this.random, true, this.getTempDir(), "temp-");
        }
        catch (IOException e) {
            String msg = "Could not find or create temporary directory (filename generator)";
            throw new NodeInitException(15, msg);
        }
        this.uskManager = new USKManager(this);
        nodeConfig.register("encryptPersistentTempBuckets", true, sortOrder++, true, false, "NodeClientCore.encryptPersistentTempBuckets", "NodeClientCore.encryptPersistentTempBucketsLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return NodeClientCore.this.persistentTempBucketFactory == null ? true : NodeClientCore.this.persistentTempBucketFactory.isEncrypting();
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException {
                if (this.get().equals(val) || NodeClientCore.this.persistentTempBucketFactory == null) {
                    return;
                }
                NodeClientCore.this.persistentTempBucketFactory.setEncryption(val);
                NodeClientCore.this.persistentRAFFactory.setEncryption(val);
            }
        });
        this.persistentTempDir = node.setupProgramDir(installConfig, "persistentTempDir", node.userDir().file("persistent-temp").toString(), "NodeClientCore.persistentTempDir", "NodeClientCore.persistentTempDirLong", nodeConfig);
        this.fcpPersistentRoot = new PersistentRequestRoot();
        try {
            this.persistentTempBucketFactory = new PersistentTempBucketFactory(this.persistentTempDir.dir(), "freenet-temp-", node.random, node.fastWeakRandom, nodeConfig.getBoolean("encryptPersistentTempBuckets"));
            this.persistentFilenameGenerator = this.persistentTempBucketFactory.fg;
        }
        catch (IOException e) {
            String msg = "Could not find or create persistent temporary directory: " + e;
            e.printStackTrace();
            throw new NodeInitException(15, msg);
        }
        File oldBlobFile = new File(this.persistentTempDir.dir(), "persistent-blob.tmp");
        if (oldBlobFile.exists()) {
            System.err.println("Deleting " + oldBlobFile);
            if (this.persistentTempBucketFactory.isEncrypting()) {
                try {
                    FileUtil.secureDelete(oldBlobFile);
                }
                catch (IOException e) {
                    System.err.println("Unable to delete old blob file " + oldBlobFile + " : error: " + e);
                    System.err.println("Please delete " + oldBlobFile + " yourself.");
                }
            } else {
                oldBlobFile.delete();
            }
        }
        if ((maxMemory = NodeStarter.getMemoryLimitMB()) < 0L) {
            defaultRamBucketPoolSize = 10;
        } else {
            defaultRamBucketPoolSize = (int)Math.min(Integer.MAX_VALUE, (maxMemory - 64L) / 10L);
            if (defaultRamBucketPoolSize <= 0) {
                defaultRamBucketPoolSize = 1;
            }
        }
        long maxBucketSize = Math.max(32768, defaultRamBucketPoolSize * 1024 * 1024 / 20);
        nodeConfig.register("maxRAMBucketSize", SizeUtil.formatSizeWithoutSpace(maxBucketSize), sortOrder++, true, false, "NodeClientCore.maxRAMBucketSize", "NodeClientCore.maxRAMBucketSizeLong", new LongCallback(){

            @Override
            public Long get() {
                return NodeClientCore.this.tempBucketFactory == null ? 0L : NodeClientCore.this.tempBucketFactory.getMaxRAMBucketSize();
            }

            @Override
            public void set(Long val) throws InvalidConfigValueException {
                if (this.get().equals(val) || NodeClientCore.this.tempBucketFactory == null) {
                    return;
                }
                NodeClientCore.this.tempBucketFactory.setMaxRAMBucketSize(val);
            }
        }, true);
        nodeConfig.register("RAMBucketPoolSize", defaultRamBucketPoolSize + "MiB", sortOrder++, true, false, "NodeClientCore.ramBucketPoolSize", "NodeClientCore.ramBucketPoolSizeLong", new LongCallback(){

            @Override
            public Long get() {
                return NodeClientCore.this.tempBucketFactory == null ? 0L : NodeClientCore.this.tempBucketFactory.getMaxRamUsed();
            }

            @Override
            public void set(Long val) throws InvalidConfigValueException {
                if (this.get().equals(val) || NodeClientCore.this.tempBucketFactory == null) {
                    return;
                }
                NodeClientCore.this.tempBucketFactory.setMaxRamUsed(val);
                NodeClientCore.this.updatePersistentRAFSpaceLimit();
            }
        }, true);
        nodeConfig.register("encryptTempBuckets", true, sortOrder++, true, false, "NodeClientCore.encryptTempBuckets", "NodeClientCore.encryptTempBucketsLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return NodeClientCore.this.tempBucketFactory == null ? true : NodeClientCore.this.tempBucketFactory.isEncrypting();
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException {
                if (this.get().equals(val) || NodeClientCore.this.tempBucketFactory == null) {
                    return;
                }
                NodeClientCore.this.tempBucketFactory.setEncryption(val);
            }
        });
        this.initDiskSpaceLimits(nodeConfig, sortOrder);
        this.cryptoSecretTransient = new MasterSecret();
        this.tempBucketFactory = new TempBucketFactory(node.executor, this.tempFilenameGenerator, nodeConfig.getLong("maxRAMBucketSize"), nodeConfig.getLong("RAMBucketPoolSize"), node.fastWeakRandom, nodeConfig.getBoolean("encryptTempBuckets"), this.minDiskFreeShortTerm, this.cryptoSecretTransient);
        this.bandwidthStatsPutter = new PersistentStatsPutter();
        this.clientLayerPersister = new ClientLayerPersister(node.executor, node.ticker, node, this, this.persistentTempBucketFactory, this.tempBucketFactory, this.bandwidthStatsPutter);
        SemiOrderedShutdownHook shutdownHook = SemiOrderedShutdownHook.get();
        shutdownHook.addEarlyJob(new NativeThread("Shutdown RealCompressor", NativeThread.HIGH_PRIORITY, true){

            @Override
            public void realRun() {
                NodeClientCore.this.compressor.shutdown();
            }
        });
        shutdownHook.addEarlyJob(new NativeThread("Shutdown database", NativeThread.HIGH_PRIORITY, true){

            @Override
            public void realRun() {
                System.err.println("Stopping database jobs...");
                NodeClientCore.this.clientLayerPersister.shutdown();
            }
        });
        shutdownHook.addLateJob(new NativeThread("Close database", NativeThread.HIGH_PRIORITY, true){

            @Override
            public void realRun() {
                if (NodeClientCore.this.node.hasPanicked()) {
                    return;
                }
                System.out.println("Waiting for jobs to finish");
                NodeClientCore.this.clientLayerPersister.waitForIdleAndCheckpoint();
                System.out.println("Saved persistent requests to disk");
            }
        });
        this.archiveManager = new ArchiveManager(200, 0x2000000L, 0x100000L, 262144, this.tempBucketFactory);
        this.healingQueue = new SimpleHealingQueue(new InsertContext(0, 2, 0, 0, new SimpleEventProducer(), false, true, false, Compressor.DEFAULT_COMPRESSORDESCRIPTOR, 0, 0, InsertContext.CompatibilityMode.COMPAT_DEFAULT), 5, 512);
        PooledFileRandomAccessBufferFactory raff = new PooledFileRandomAccessBufferFactory(this.persistentFilenameGenerator, node.fastWeakRandom);
        this.persistentDiskChecker = new DiskSpaceCheckingRandomAccessBufferFactory(raff, this.persistentTempDir.dir(), this.minDiskFreeLongTerm + this.tempBucketFactory.getMaxRamUsed());
        this.persistentRAFFactory = new MaybeEncryptedRandomAccessBufferFactory(this.persistentDiskChecker, nodeConfig.getBoolean("encryptPersistentTempBuckets"));
        this.persistentTempBucketFactory.setDiskSpaceChecker(this.persistentDiskChecker);
        HighLevelSimpleClient client = this.makeClient((short)0, false, false);
        FetchContext defaultFetchContext = client.getFetchContext();
        InsertContext defaultInsertContext = client.getInsertContext(false);
        int maxMemoryLimitedJobThreads = Runtime.getRuntime().availableProcessors() / 2;
        maxMemoryLimitedJobThreads = Math.min(maxMemoryLimitedJobThreads, node.nodeStats.getThreadLimit() / 20);
        maxMemoryLimitedJobThreads = Math.max(1, maxMemoryLimitedJobThreads);
        nodeConfig.register("memoryLimitedJobThreadLimit", maxMemoryLimitedJobThreads, sortOrder++, true, false, "NodeClientCore.memoryLimitedJobThreadLimit", "NodeClientCore.memoryLimitedJobThreadLimitLong", new IntCallback(){

            @Override
            public Integer get() {
                return NodeClientCore.this.memoryLimitedJobRunner.getMaxThreads();
            }

            @Override
            public void set(Integer val) throws InvalidConfigValueException, NodeNeedRestartException {
                if (val < 1) {
                    throw new InvalidConfigValueException(NodeClientCore.l10n("memoryLimitedJobThreadLimitMustBe1Plus"));
                }
                NodeClientCore.this.memoryLimitedJobRunner.setMaxThreads(val);
            }
        }, false);
        long defaultMemoryLimitedJobMemoryLimit = 0x840000L;
        long overallMemoryLimit = NodeStarter.getMemoryLimitBytes();
        if (overallMemoryLimit > 0x20000000L) {
            defaultMemoryLimitedJobMemoryLimit += (overallMemoryLimit - 0x20000000L) / 20L;
        }
        nodeConfig.register("memoryLimitedJobMemoryLimit", defaultMemoryLimitedJobMemoryLimit, sortOrder++, true, false, "NodeClientCore.memoryLimitedJobMemoryLimit", "NodeClientCore.memoryLimitedJobMemoryLimitLong", new LongCallback(){

            @Override
            public Long get() {
                return NodeClientCore.this.memoryLimitedJobRunner.getCapacity();
            }

            @Override
            public void set(Long val) throws InvalidConfigValueException, NodeNeedRestartException {
                if (val < 0x840000L) {
                    throw new InvalidConfigValueException(NodeClientCore.l10n("memoryLimitedJobMemoryLimitMustBeAtLeast", "min", SizeUtil.formatSize(0x840000L)));
                }
                NodeClientCore.this.memoryLimitedJobRunner.setCapacity(val);
            }
        }, true);
        this.memoryLimitedJobRunner = new MemoryLimitedJobRunner(nodeConfig.getLong("memoryLimitedJobMemoryLimit"), nodeConfig.getInt("memoryLimitedJobThreadLimit"), node.executor, 7);
        shutdownHook.addEarlyJob(new NativeThread("Shutdown FEC", NativeThread.HIGH_PRIORITY, true){

            @Override
            public void realRun() {
                System.out.println("Stopping FEC decode threads...");
                NodeClientCore.this.memoryLimitedJobRunner.shutdown();
            }
        });
        shutdownHook.addLateJob(new NativeThread("Shutdown FEC", NativeThread.HIGH_PRIORITY, true){

            @Override
            public void realRun() {
                NodeClientCore.this.memoryLimitedJobRunner.waitForShutdown();
                System.out.println("FEC decoding threads finished.");
            }
        });
        this.clientContext = new ClientContext(node.bootID, this.clientLayerPersister, node.executor, this.archiveManager, this.persistentTempBucketFactory, this.tempBucketFactory, this.persistentTempBucketFactory, this.healingQueue, this.uskManager, this.random, node.fastWeakRandom, node.getTicker(), this.memoryLimitedJobRunner, this.tempFilenameGenerator, this.persistentFilenameGenerator, this.tempBucketFactory, this.persistentRAFFactory, this.tempBucketFactory.getUnderlyingRAFFactory(), this.persistentDiskChecker, this.compressor, this.storeChecker, this.fcpPersistentRoot, this.cryptoSecretTransient, toadlets, defaultFetchContext, defaultInsertContext, config);
        this.compressor.setClientContext(this.clientContext);
        this.storeChecker.setContext(this.clientContext);
        this.clientLayerPersister.start(this.clientContext);
        try {
            this.requestStarters = new RequestStarterGroup(node, this, portNumber, this.random, config, throttleFS, this.clientContext);
        }
        catch (InvalidConfigValueException e1) {
            throw new NodeInitException(30, e1.toString());
        }
        this.clientContext.init(this.requestStarters, this.alerts);
        if (persistentSecret != null) {
            this.setupMasterSecret(persistentSecret);
        }
        try {
            this.initStorage(databaseKey);
        }
        catch (MasterKeysWrongPasswordException e) {
            System.err.println("Cannot load persistent requests, awaiting password ...");
            node.setDatabaseAwaitingPassword();
        }
        node.securityLevels.addPhysicalThreatLevelListener(new SecurityLevelListener<SecurityLevels.PHYSICAL_THREAT_LEVEL>(){

            @Override
            public void onChange(SecurityLevels.PHYSICAL_THREAT_LEVEL oldLevel, SecurityLevels.PHYSICAL_THREAT_LEVEL newLevel) {
                if (newLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.LOW) {
                    if (NodeClientCore.this.tempBucketFactory.isEncrypting()) {
                        NodeClientCore.this.tempBucketFactory.setEncryption(false);
                    }
                    if (NodeClientCore.this.persistentTempBucketFactory != null && NodeClientCore.this.persistentTempBucketFactory.isEncrypting()) {
                        NodeClientCore.this.persistentTempBucketFactory.setEncryption(false);
                    }
                    NodeClientCore.this.persistentRAFFactory.setEncryption(false);
                } else {
                    if (!NodeClientCore.this.tempBucketFactory.isEncrypting()) {
                        NodeClientCore.this.tempBucketFactory.setEncryption(true);
                    }
                    if (NodeClientCore.this.persistentTempBucketFactory != null && !NodeClientCore.this.persistentTempBucketFactory.isEncrypting()) {
                        NodeClientCore.this.persistentTempBucketFactory.setEncryption(true);
                    }
                    NodeClientCore.this.persistentRAFFactory.setEncryption(true);
                }
                if (NodeClientCore.this.clientLayerPersister.hasLoaded()) {
                    try {
                        NodeClientCore.this.initStorage(NodeClientCore.this.node.getDatabaseKey());
                    }
                    catch (MasterKeysWrongPasswordException e) {
                        NodeClientCore.this.node.setDatabaseAwaitingPassword();
                    }
                }
            }
        });
        this.downloadsDir = node.setupProgramDir(nodeConfig, "downloadsDir", node.userDir().file("downloads").getPath(), "NodeClientCore.downloadsDir", "NodeClientCore.downloadsDirLong", NodeClientCore.l10n("couldNotFindOrCreateDir"), null);
        nodeConfig.register("downloadAllowedDirs", new String[]{"all"}, sortOrder++, true, true, "NodeClientCore.downloadAllowedDirs", "NodeClientCore.downloadAllowedDirsLong", new StringArrCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] get() {
                NodeClientCore nodeClientCore = NodeClientCore.this;
                synchronized (nodeClientCore) {
                    if (NodeClientCore.this.downloadAllowedEverywhere) {
                        return new String[]{"all"};
                    }
                    String[] dirs = new String[NodeClientCore.this.downloadAllowedDirs.length + (NodeClientCore.this.includeDownloadDir ? 1 : 0)];
                    for (int i = 0; i < NodeClientCore.this.downloadAllowedDirs.length; ++i) {
                        dirs[i] = NodeClientCore.this.downloadAllowedDirs[i].getPath();
                    }
                    if (NodeClientCore.this.includeDownloadDir) {
                        dirs[((NodeClientCore)NodeClientCore.this).downloadAllowedDirs.length] = "downloads";
                    }
                    return dirs;
                }
            }

            @Override
            public void set(String[] val) throws InvalidConfigValueException {
                NodeClientCore.this.setDownloadAllowedDirs(val);
            }
        });
        this.setDownloadAllowedDirs(nodeConfig.getStringArr("downloadAllowedDirs"));
        nodeConfig.register("uploadAllowedDirs", new String[]{"all"}, sortOrder++, true, true, "NodeClientCore.uploadAllowedDirs", "NodeClientCore.uploadAllowedDirsLong", new StringArrCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] get() {
                NodeClientCore nodeClientCore = NodeClientCore.this;
                synchronized (nodeClientCore) {
                    if (NodeClientCore.this.uploadAllowedEverywhere) {
                        return new String[]{"all"};
                    }
                    String[] dirs = new String[NodeClientCore.this.uploadAllowedDirs.length];
                    for (int i = 0; i < NodeClientCore.this.uploadAllowedDirs.length; ++i) {
                        dirs[i] = NodeClientCore.this.uploadAllowedDirs[i].getPath();
                    }
                    return dirs;
                }
            }

            @Override
            public void set(String[] val) throws InvalidConfigValueException {
                NodeClientCore.this.setUploadAllowedDirs(val);
            }
        });
        this.setUploadAllowedDirs(nodeConfig.getStringArr("uploadAllowedDirs"));
        Logger.normal(this, "Initializing USK Manager");
        System.out.println("Initializing USK Manager");
        this.uskManager.init(this.clientContext);
        nodeConfig.register("maxBackgroundUSKFetchers", "64", sortOrder++, true, false, "NodeClientCore.maxUSKFetchers", "NodeClientCore.maxUSKFetchersLong", new IntCallback(){

            @Override
            public Integer get() {
                return maxBackgroundUSKFetchers;
            }

            @Override
            public void set(Integer uskFetch) throws InvalidConfigValueException {
                if (uskFetch <= 0) {
                    throw new InvalidConfigValueException(NodeClientCore.l10n("maxUSKFetchersMustBeGreaterThanZero"));
                }
                maxBackgroundUSKFetchers = uskFetch;
            }
        }, false);
        maxBackgroundUSKFetchers = nodeConfig.getInt("maxBackgroundUSKFetchers");
        try {
            this.tmci = TextModeClientInterfaceServer.maybeCreate(node, this, config);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new NodeInitException(19, "Could not start TMCI: " + e);
        }
        try {
            this.fcpServer = FCPServer.maybeCreate(node, this, node.config, this.fcpPersistentRoot);
            this.clientContext.setDownloadCache(this.fcpServer);
            if (!this.killedDatabase()) {
                this.fcpServer.load();
            }
        }
        catch (IOException e) {
            throw new NodeInitException(17, "Could not start FCP: " + e);
        }
        catch (InvalidConfigValueException e) {
            throw new NodeInitException(17, "Could not start FCP: " + e);
        }
        this.startingUpAlert = new SimpleUserAlert(true, NodeClientCore.l10n("startingUpTitle"), NodeClientCore.l10n("startingUp"), NodeClientCore.l10n("startingUpShort"), 1);
        this.alerts.register(this.startingUpAlert);
        this.alerts.register(new SimpleUserAlert(true, NodeL10n.getBase().getString("QueueToadlet.persistenceBrokenTitle"), NodeL10n.getBase().getString("QueueToadlet.persistenceBroken", new String[]{"TEMPDIR", "DBFILE"}, new String[]{new File(FileUtil.getCanonicalFile(this.getPersistentTempDir()), File.separator).toString(), new File(FileUtil.getCanonicalFile(node.getUserDir()), "client.dat").toString()}), NodeL10n.getBase().getString("QueueToadlet.persistenceBrokenShortAlert"), 0){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isValid() {
                NodeClientCore nodeClientCore = NodeClientCore.this;
                synchronized (nodeClientCore) {
                    if (!NodeClientCore.this.killedDatabase()) {
                        return false;
                    }
                }
                if (NodeClientCore.this.node.awaitingPassword()) {
                    return false;
                }
                return !NodeClientCore.this.node.isStopping();
            }

            @Override
            public boolean userCanDismiss() {
                return false;
            }
        });
        this.toadletContainer = toadlets;
        this.toadletContainer.setBucketFactory(this.tempBucketFactory);
        nodeConfig.register("alwaysCommit", false, sortOrder++, true, false, "NodeClientCore.alwaysCommit", "NodeClientCore.alwaysCommitLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return NodeClientCore.this.alwaysCommit;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                NodeClientCore.this.alwaysCommit = val;
            }
        });
        this.alwaysCommit = nodeConfig.getBoolean("alwaysCommit");
        this.alerts.register(new DiskSpaceUserAlert(this));
        this.alerts.register(new DatastoreTooSmallAlert(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePersistentRAFSpaceLimit() {
        if (this.persistentRAFFactory != null) {
            NodeClientCore nodeClientCore = this;
            synchronized (nodeClientCore) {
                long size = this.minDiskFreeLongTerm;
            }
            this.persistentDiskChecker.setMinDiskSpace(size += this.tempBucketFactory.getMaxRamUsed());
        }
    }

    private void initDiskSpaceLimits(SubConfig nodeConfig, int sortOrder) {
        nodeConfig.register("minDiskFreeLongTerm", "1G", sortOrder++, true, true, "NodeClientCore.minDiskFreeLongTerm", "NodeClientCore.minDiskFreeLongTermLong", new LongCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long get() {
                NodeClientCore nodeClientCore = NodeClientCore.this;
                synchronized (nodeClientCore) {
                    return NodeClientCore.this.minDiskFreeLongTerm;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(Long val) throws InvalidConfigValueException, NodeNeedRestartException {
                NodeClientCore nodeClientCore = NodeClientCore.this;
                synchronized (nodeClientCore) {
                    if (val < 0L) {
                        throw new InvalidConfigValueException(NodeClientCore.l10n("minDiskFreeMustBePositive"));
                    }
                    NodeClientCore.this.minDiskFreeLongTerm = val;
                }
                NodeClientCore.this.updatePersistentRAFSpaceLimit();
            }
        }, true);
        this.minDiskFreeLongTerm = nodeConfig.getLong("minDiskFreeLongTerm");
        nodeConfig.register("minDiskFreeShortTerm", "512M", sortOrder++, true, true, "NodeClientCore.minDiskFreeShortTerm", "NodeClientCore.minDiskFreeShortTermLong", new LongCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long get() {
                NodeClientCore nodeClientCore = NodeClientCore.this;
                synchronized (nodeClientCore) {
                    return NodeClientCore.this.minDiskFreeShortTerm;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(Long val) throws InvalidConfigValueException, NodeNeedRestartException {
                NodeClientCore nodeClientCore = NodeClientCore.this;
                synchronized (nodeClientCore) {
                    if (val < 0L) {
                        throw new InvalidConfigValueException(NodeClientCore.l10n("minDiskFreeMustBePositive"));
                    }
                    NodeClientCore.this.minDiskFreeShortTerm = val;
                }
                NodeClientCore.this.tempBucketFactory.setMinDiskSpace(val);
            }
        }, true);
        this.minDiskFreeShortTerm = nodeConfig.getLong("minDiskFreeShortTerm");
    }

    boolean lateInitDatabase(DatabaseKey databaseKey) throws NodeInitException {
        System.out.println("Late database initialisation: starting middle phase");
        try {
            this.initStorage(databaseKey);
        }
        catch (MasterKeysWrongPasswordException e) {
            Logger.error(this, "Impossible: can't load even though have key? " + (databaseKey != null));
            return true;
        }
        this.fcpServer.load();
        System.out.println("Late database initialisation completed.");
        return true;
    }

    private void initStorage(DatabaseKey databaseKey) throws MasterKeysWrongPasswordException {
        this.clientLayerPersister.setFilesAndLoad(this.node.nodeDir.dir(), "client.dat", this.node.wantEncryptedDatabase(), this.node.wantNoPersistentDatabase(), databaseKey, this.clientContext, this.requestStarters, this.random);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishInitStorage() {
        boolean success = false;
        NodeClientCore nodeClientCore = this;
        synchronized (nodeClientCore) {
            if (this.finishedInitStorage || this.finishingInitStorage) {
                return;
            }
            this.finishingInitStorage = true;
        }
        try {
            this.persistentTempBucketFactory.completedInit();
            success = true;
        }
        finally {
            nodeClientCore = this;
            synchronized (nodeClientCore) {
                this.finishingInitStorage = false;
                if (success) {
                    this.finishedInitStorage = true;
                }
            }
        }
    }

    private static String l10n(String key) {
        return NodeL10n.getBase().getString("NodeClientCore." + key);
    }

    private static String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("NodeClientCore." + key, pattern, value);
    }

    public boolean isDownloadDisabled() {
        return this.downloadDisabled;
    }

    protected synchronized void setDownloadAllowedDirs(String[] val) {
        int x = 0;
        this.downloadAllowedEverywhere = false;
        this.includeDownloadDir = false;
        this.downloadDisabled = false;
        int i = 0;
        this.downloadAllowedDirs = new File[val.length];
        for (i = 0; i < this.downloadAllowedDirs.length; ++i) {
            String s = val[i];
            if (s.equals("downloads")) {
                this.includeDownloadDir = true;
                continue;
            }
            if (s.equals("all")) {
                this.downloadAllowedEverywhere = true;
                continue;
            }
            this.downloadAllowedDirs[x++] = new File(val[i]);
        }
        if (x != i) {
            this.downloadAllowedDirs = Arrays.copyOf(this.downloadAllowedDirs, x);
        }
        if (i == 0) {
            this.downloadDisabled = true;
        }
    }

    protected synchronized void setUploadAllowedDirs(String[] val) {
        int x = 0;
        int i = 0;
        this.uploadAllowedEverywhere = false;
        this.uploadAllowedDirs = new File[val.length];
        for (i = 0; i < this.uploadAllowedDirs.length; ++i) {
            String s = val[i];
            if (s.equals("all")) {
                this.uploadAllowedEverywhere = true;
                continue;
            }
            this.uploadAllowedDirs[x++] = new File(val[i]);
        }
        if (x != i) {
            this.uploadAllowedDirs = Arrays.copyOf(this.uploadAllowedDirs, x);
        }
    }

    public void start(Config config) throws NodeInitException {
        this.persister.start();
        this.requestStarters.start();
        this.storeChecker.start();
        if (this.fcpServer != null) {
            this.fcpServer.maybeStart();
        }
        this.node.pluginManager.start();
        this.node.ipDetector.ipDetectorManager.start();
        if (this.tmci != null) {
            this.tmci.start();
        }
        this.node.executor.execute(new PrioRunnable(){

            @Override
            public void run() {
                Logger.normal(this, "Resuming persistent requests");
                if (NodeClientCore.this.node.getDatabaseKey() != null) {
                    try {
                        NodeClientCore.this.finishInitStorage();
                    }
                    catch (Throwable t) {
                        Logger.error(this, "Failed to migrate and/or cleanup persistent temp buckets: " + t, t);
                        System.err.println("Failed to migrate and/or cleanup persistent temp buckets: " + t);
                        t.printStackTrace();
                    }
                }
                Logger.normal(this, "Completed startup: All persistent requests resumed or restarted");
                NodeClientCore.this.alerts.unregister(NodeClientCore.this.startingUpAlert);
            }

            @Override
            public int getPriority() {
                return NativeThread.LOW_PRIORITY;
            }
        }, "Startup completion thread");
    }

    long makeUID() {
        long uid;
        while ((uid = this.random.nextLong()) == -1L) {
        }
        return uid;
    }

    public void asyncGet(final Key key, boolean offersOnly, final RequestCompletionListener listener, boolean canReadClientCache, boolean canWriteClientCache, final boolean realTimeFlag, boolean localOnly, boolean ignoreStore) {
        RequestTag tag;
        boolean isSSK;
        long uid = this.makeUID();
        if (!this.tracker.lockUID(uid, isSSK = key instanceof NodeSSK, false, false, true, realTimeFlag, tag = new RequestTag(isSSK, RequestTag.START.ASYNC_GET, null, realTimeFlag, uid, this.node))) {
            Logger.error(this, "Could not lock UID just randomly generated: " + uid + " - probably indicates broken PRNG");
            listener.onFailed(new LowLevelGetException(3, "Could not lock random UID - serious PRNG problem???"));
            return;
        }
        tag.setAccepted();
        short htl = this.node.maxHTL();
        if (offersOnly) {
            htl = this.node.failureTable.minOfferedHTL(key, htl);
            if (logMINOR) {
                Logger.minor(this, "Using old HTL for GetOfferedKey: " + htl);
            }
        }
        final long startTime = System.currentTimeMillis();
        this.asyncGet(key, offersOnly, uid, new RequestSenderListener(){
            private boolean rejectedOverload;

            @Override
            public void onCHKTransferBegins() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceivedRejectOverload() {
                22 var1_1 = this;
                synchronized (var1_1) {
                    if (this.rejectedOverload) {
                        return;
                    }
                    this.rejectedOverload = true;
                }
                NodeClientCore.this.requestStarters.rejectedOverload(isSSK, false, realTimeFlag);
            }

            @Override
            public void onDataFoundLocally() {
                tag.unlockHandler();
                listener.onSucceeded();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestSenderFinished(int status, boolean fromOfferedKey, RequestSender rs) {
                boolean rejectedOverload;
                tag.unlockHandler();
                if (status == -1) {
                    Logger.error(this, "Bogus status in onRequestSenderFinished for " + rs, (Throwable)new Exception("error"));
                    listener.onFailed(new LowLevelGetException(3));
                    return;
                }
                22 var5_4 = this;
                synchronized (var5_4) {
                    rejectedOverload = this.rejectedOverload;
                }
                if (status != 6 && status != 7 && status != 8) {
                    if (logMINOR) {
                        Logger.minor(this, (isSSK ? "SSK" : "CHK") + " fetch cost " + rs.getTotalSentBytes() + '/' + rs.getTotalReceivedBytes() + " bytes (" + status + ')');
                    }
                    (isSSK ? NodeClientCore.this.nodeStats.localSskFetchBytesSentAverage : NodeClientCore.this.nodeStats.localChkFetchBytesSentAverage).report(rs.getTotalSentBytes());
                    (isSSK ? NodeClientCore.this.nodeStats.localSskFetchBytesReceivedAverage : NodeClientCore.this.nodeStats.localChkFetchBytesReceivedAverage).report(rs.getTotalReceivedBytes());
                    if (status == 0) {
                        (isSSK ? NodeClientCore.this.nodeStats.successfulSskFetchBytesReceivedAverage : NodeClientCore.this.nodeStats.successfulChkFetchBytesReceivedAverage).report(rs.getTotalReceivedBytes());
                    }
                }
                if (status == 6 || status == 7) {
                    if (!rejectedOverload) {
                        NodeClientCore.this.requestStarters.rejectedOverload(isSSK, false, realTimeFlag);
                        rejectedOverload = true;
                        long rtt = System.currentTimeMillis() - startTime;
                        double targetLocation = key.toNormalizedDouble();
                        if (isSSK) {
                            NodeClientCore.this.node.nodeStats.reportSSKOutcome(rtt, false, realTimeFlag);
                        } else {
                            NodeClientCore.this.node.nodeStats.reportCHKOutcome(rtt, false, targetLocation, realTimeFlag);
                        }
                    }
                } else if (rs.hasForwarded() && (status == 3 || status == 9 || status == 0 || status == 1 || status == 5 || status == 10)) {
                    long rtt = System.currentTimeMillis() - startTime;
                    double targetLocation = key.toNormalizedDouble();
                    if (!rejectedOverload) {
                        NodeClientCore.this.requestStarters.requestCompleted(isSSK, false, key, realTimeFlag);
                    }
                    NodeClientCore.this.requestStarters.getThrottle(isSSK, false, realTimeFlag).successfulCompletion(rtt);
                    if (isSSK) {
                        NodeClientCore.this.node.nodeStats.reportSSKOutcome(rtt, status == 0, realTimeFlag);
                    } else {
                        NodeClientCore.this.node.nodeStats.reportCHKOutcome(rtt, status == 0, targetLocation, realTimeFlag);
                    }
                    if (status == 0) {
                        Logger.minor(this, "Successful " + (isSSK ? "SSK" : "CHK") + " fetch took " + rtt);
                    }
                }
                if (status != 0) {
                    switch (status) {
                        case -1: {
                            Logger.error(this, "RS still running in get" + (isSSK ? "SSK" : "CHK") + "!: " + rs);
                            listener.onFailed(new LowLevelGetException(3));
                            return;
                        }
                        case 3: {
                            listener.onFailed(new LowLevelGetException(4));
                            return;
                        }
                        case 9: {
                            listener.onFailed(new LowLevelGetException(10));
                            return;
                        }
                        case 1: {
                            listener.onFailed(new LowLevelGetException(5));
                            return;
                        }
                        case 4: 
                        case 11: {
                            listener.onFailed(new LowLevelGetException(7));
                            return;
                        }
                        case 5: 
                        case 10: {
                            listener.onFailed(new LowLevelGetException(8));
                            return;
                        }
                        case 6: 
                        case 7: {
                            listener.onFailed(new LowLevelGetException(6));
                            return;
                        }
                        case 8: {
                            listener.onFailed(new LowLevelGetException(3));
                            return;
                        }
                    }
                    Logger.error(this, "Unknown RequestSender code in get" + (isSSK ? "SSK" : "CHK") + ": " + status + " on " + rs);
                    listener.onFailed(new LowLevelGetException(3));
                    return;
                }
                listener.onSucceeded();
            }

            @Override
            public void onNotStarted(boolean internalError) {
                if (internalError) {
                    listener.onFailed(new LowLevelGetException(3));
                } else {
                    listener.onFailed(new LowLevelGetException(2));
                }
            }
        }, tag, canReadClientCache, canWriteClientCache, htl, realTimeFlag, localOnly, ignoreStore);
    }

    void asyncGet(Key key, boolean offersOnly, long uid, RequestSenderListener listener, RequestTag tag, boolean canReadClientCache, boolean canWriteClientCache, short htl, boolean realTimeFlag, boolean localOnly, boolean ignoreStore) {
        try {
            Object o = this.node.makeRequestSender(key, htl, uid, tag, null, localOnly, ignoreStore, offersOnly, canReadClientCache, canWriteClientCache, realTimeFlag);
            if (o instanceof KeyBlock) {
                tag.setServedFromDatastore();
                listener.onDataFoundLocally();
                return;
            }
            if (o == null) {
                listener.onNotStarted(false);
                tag.unlockHandler();
                return;
            }
            RequestSender rs = (RequestSender)o;
            rs.addListener(listener);
            if (rs.uid != uid) {
                tag.unlockHandler();
            }
            if (logMINOR) {
                Logger.minor(this, "Started " + o + " for " + uid + " for " + key);
            }
        }
        catch (RuntimeException e) {
            Logger.error(this, "Caught error trying to start request: " + e, (Throwable)e);
            listener.onNotStarted(true);
        }
        catch (Error e) {
            Logger.error(this, "Caught error trying to start request: " + e, (Throwable)e);
            listener.onNotStarted(true);
        }
    }

    public ClientKeyBlock realGetKey(ClientKey key, boolean localOnly, boolean ignoreStore, boolean canWriteClientCache, boolean realTimeFlag) throws LowLevelGetException {
        if (key instanceof ClientCHK) {
            return this.realGetCHK((ClientCHK)key, localOnly, ignoreStore, canWriteClientCache, realTimeFlag);
        }
        if (key instanceof ClientSSK) {
            return this.realGetSSK((ClientSSK)key, localOnly, ignoreStore, canWriteClientCache, realTimeFlag);
        }
        throw new IllegalArgumentException("Not a CHK or SSK: " + key);
    }

    ClientCHKBlock realGetCHK(ClientCHK key, boolean localOnly, boolean ignoreStore, boolean canWriteClientCache, boolean realTimeFlag) throws LowLevelGetException {
        long rtt2;
        int status;
        Object o;
        RequestSender rs;
        RequestTag tag;
        long startTime;
        block33: {
            startTime = System.currentTimeMillis();
            long uid = this.makeUID();
            if (!this.tracker.lockUID(uid, false, false, false, true, realTimeFlag, tag = new RequestTag(false, RequestTag.START.LOCAL, null, realTimeFlag, uid, this.node))) {
                Logger.error(this, "Could not lock UID just randomly generated: " + uid + " - probably indicates broken PRNG");
                throw new LowLevelGetException(3);
            }
            tag.setAccepted();
            rs = null;
            o = this.node.makeRequestSender(key.getNodeCHK(), this.node.maxHTL(), uid, tag, null, localOnly, ignoreStore, false, true, canWriteClientCache, realTimeFlag);
            if (o instanceof CHKBlock) {
                try {
                    tag.setServedFromDatastore();
                    ClientCHKBlock clientCHKBlock = new ClientCHKBlock((CHKBlock)o, key);
                    return clientCHKBlock;
                }
                catch (CHKVerifyException e) {
                    Logger.error(this, "Does not verify: " + e, (Throwable)e);
                    throw new LowLevelGetException(1);
                }
            }
            if (o != null) break block33;
            throw new LowLevelGetException(2);
        }
        rs = (RequestSender)o;
        boolean rejectedOverload = false;
        short waitStatus = 0;
        do {
            waitStatus = rs.waitUntilStatusChange(waitStatus);
            if (rejectedOverload || (waitStatus & 1) == 0) continue;
            this.requestStarters.rejectedOverload(false, false, realTimeFlag);
            rejectedOverload = true;
        } while ((status = rs.getStatus()) == -1);
        if (status != 6 && status != 7 && status != 8) {
            if (logMINOR) {
                Logger.minor(this, "CHK fetch cost " + rs.getTotalSentBytes() + '/' + rs.getTotalReceivedBytes() + " bytes (" + status + ')');
            }
            this.nodeStats.localChkFetchBytesSentAverage.report(rs.getTotalSentBytes());
            this.nodeStats.localChkFetchBytesReceivedAverage.report(rs.getTotalReceivedBytes());
            if (status == 0) {
                this.nodeStats.successfulChkFetchBytesReceivedAverage.report(rs.getTotalReceivedBytes());
            }
        }
        if (status == 6 || status == 7) {
            if (!rejectedOverload) {
                this.requestStarters.rejectedOverload(false, false, realTimeFlag);
                rejectedOverload = true;
                rtt2 = System.currentTimeMillis() - startTime;
                double targetLocation = key.getNodeCHK().toNormalizedDouble();
                this.node.nodeStats.reportCHKOutcome(rtt2, false, targetLocation, realTimeFlag);
            }
        } else if (rs.hasForwarded() && (status == 3 || status == 9 || status == 0 || status == 1 || status == 5 || status == 10)) {
            rtt2 = System.currentTimeMillis() - startTime;
            double targetLocation = key.getNodeCHK().toNormalizedDouble();
            if (!rejectedOverload) {
                this.requestStarters.requestCompleted(false, false, key.getNodeKey(true), realTimeFlag);
            }
            this.requestStarters.getThrottle(false, false, realTimeFlag).successfulCompletion(rtt2);
            this.node.nodeStats.reportCHKOutcome(rtt2, status == 0, targetLocation, realTimeFlag);
            if (status == 0) {
                Logger.minor(this, "Successful CHK fetch took " + rtt2);
            }
        }
        if (status == 0) {
            try {
                ClientCHKBlock rtt2 = new ClientCHKBlock(rs.getPRB().getBlock(), rs.getHeaders(), key, true);
                return rtt2;
            }
            catch (CHKVerifyException e) {
                Logger.error(this, "Does not verify: " + e, (Throwable)e);
                throw new LowLevelGetException(1);
            }
            catch (AbortedException e) {
                Logger.error(this, "Impossible: " + e, (Throwable)e);
                throw new LowLevelGetException(3);
            }
        }
        switch (status) {
            case -1: {
                Logger.error(this, "RS still running in getCHK!: " + rs);
                throw new LowLevelGetException(3);
            }
            case 3: {
                throw new LowLevelGetException(4);
            }
            case 9: {
                throw new LowLevelGetException(10);
            }
            case 1: {
                throw new LowLevelGetException(5);
            }
            case 4: 
            case 11: {
                throw new LowLevelGetException(7);
            }
            case 5: 
            case 10: {
                throw new LowLevelGetException(8);
            }
            case 6: 
            case 7: {
                throw new LowLevelGetException(6);
            }
            case 8: {
                throw new LowLevelGetException(3);
            }
        }
        Logger.error(this, "Unknown RequestSender code in getCHK: " + status + " on " + rs);
        throw new LowLevelGetException(3);
        finally {
            tag.unlockHandler();
        }
    }

    ClientSSKBlock realGetSSK(ClientSSK key, boolean localOnly, boolean ignoreStore, boolean canWriteClientCache, boolean realTimeFlag) throws LowLevelGetException {
        int status;
        Object o;
        RequestSender rs;
        RequestTag tag;
        long uid;
        long startTime;
        block30: {
            startTime = System.currentTimeMillis();
            uid = this.makeUID();
            if (!this.tracker.lockUID(uid, true, false, false, true, realTimeFlag, tag = new RequestTag(true, RequestTag.START.LOCAL, null, realTimeFlag, uid, this.node))) {
                Logger.error(this, "Could not lock UID just randomly generated: " + uid + " - probably indicates broken PRNG");
                throw new LowLevelGetException(3);
            }
            tag.setAccepted();
            rs = null;
            o = this.node.makeRequestSender(key.getNodeKey(true), this.node.maxHTL(), uid, tag, null, localOnly, ignoreStore, false, true, canWriteClientCache, realTimeFlag);
            if (o instanceof SSKBlock) {
                try {
                    tag.setServedFromDatastore();
                    SSKBlock block = (SSKBlock)o;
                    key.setPublicKey(block.getPubKey());
                    ClientSSKBlock clientSSKBlock = ClientSSKBlock.construct(block, key);
                    return clientSSKBlock;
                }
                catch (SSKVerifyException e) {
                    Logger.error(this, "Does not verify: " + e, (Throwable)e);
                    throw new LowLevelGetException(1);
                }
            }
            if (o != null) break block30;
            throw new LowLevelGetException(2);
        }
        rs = (RequestSender)o;
        boolean rejectedOverload = false;
        short waitStatus = 0;
        do {
            waitStatus = rs.waitUntilStatusChange(waitStatus);
            if (rejectedOverload || (waitStatus & 1) == 0) continue;
            this.requestStarters.rejectedOverload(true, false, realTimeFlag);
            rejectedOverload = true;
        } while ((status = rs.getStatus()) == -1);
        if (status != 6 && status != 7 && status != 8) {
            if (logMINOR) {
                Logger.minor(this, "SSK fetch cost " + rs.getTotalSentBytes() + '/' + rs.getTotalReceivedBytes() + " bytes (" + status + ')');
            }
            this.nodeStats.localSskFetchBytesSentAverage.report(rs.getTotalSentBytes());
            this.nodeStats.localSskFetchBytesReceivedAverage.report(rs.getTotalReceivedBytes());
            if (status == 0) {
                this.nodeStats.successfulSskFetchBytesReceivedAverage.report(rs.getTotalReceivedBytes());
            }
        }
        long rtt = System.currentTimeMillis() - startTime;
        if (status == 6 || status == 7) {
            if (!rejectedOverload) {
                this.requestStarters.rejectedOverload(true, false, realTimeFlag);
                rejectedOverload = true;
            }
            this.node.nodeStats.reportSSKOutcome(rtt, false, realTimeFlag);
        } else if (rs.hasForwarded() && (status == 3 || status == 9 || status == 0 || status == 1 || status == 5 || status == 10)) {
            if (!rejectedOverload) {
                this.requestStarters.requestCompleted(true, false, key.getNodeKey(true), realTimeFlag);
            }
            this.requestStarters.getThrottle(true, false, realTimeFlag).successfulCompletion(rtt);
            this.node.nodeStats.reportSSKOutcome(rtt, status == 0, realTimeFlag);
        }
        if (rs.getStatus() == 0) {
            try {
                SSKBlock block = rs.getSSKBlock();
                key.setPublicKey(block.getPubKey());
                ClientSSKBlock clientSSKBlock = ClientSSKBlock.construct(block, key);
                return clientSSKBlock;
            }
            catch (SSKVerifyException e) {
                Logger.error(this, "Does not verify: " + e, (Throwable)e);
                throw new LowLevelGetException(1);
            }
        }
        switch (rs.getStatus()) {
            case -1: {
                Logger.error(this, "RS still running in getCHK!: " + rs);
                throw new LowLevelGetException(3);
            }
            case 3: {
                throw new LowLevelGetException(4);
            }
            case 9: {
                throw new LowLevelGetException(10);
            }
            case 1: {
                throw new LowLevelGetException(5);
            }
            case 4: 
            case 11: {
                Logger.error(this, "WTF? Transfer failed on an SSK? on " + uid);
                throw new LowLevelGetException(7);
            }
            case 5: 
            case 10: {
                throw new LowLevelGetException(8);
            }
            case 6: 
            case 7: {
                throw new LowLevelGetException(6);
            }
        }
        Logger.error(this, "Unknown RequestSender code in getCHK: " + rs.getStatus() + " on " + rs);
        throw new LowLevelGetException(3);
        finally {
            tag.unlockHandler();
        }
    }

    public void realPut(KeyBlock block, boolean canWriteClientCache, boolean forkOnCacheable, boolean preferInsert, boolean ignoreLowBackoff, boolean realTimeFlag) throws LowLevelPutException {
        if (block instanceof CHKBlock) {
            this.realPutCHK((CHKBlock)block, canWriteClientCache, forkOnCacheable, preferInsert, ignoreLowBackoff, realTimeFlag);
        } else if (block instanceof SSKBlock) {
            this.realPutSSK((SSKBlock)block, canWriteClientCache, forkOnCacheable, preferInsert, ignoreLowBackoff, realTimeFlag);
        } else {
            throw new IllegalArgumentException("Unknown put type " + block.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void realPutCHK(CHKBlock block, boolean canWriteClientCache, boolean forkOnCacheable, boolean preferInsert, boolean ignoreLowBackoff, boolean realTimeFlag) throws LowLevelPutException {
        InsertTag tag;
        byte[] data = block.getData();
        byte[] headers = block.getHeaders();
        PartiallyReceivedBlock prb = new PartiallyReceivedBlock(32, 1024, data);
        long uid = this.makeUID();
        if (!this.tracker.lockUID(uid, false, true, false, true, realTimeFlag, tag = new InsertTag(false, InsertTag.START.LOCAL, null, realTimeFlag, uid, this.node))) {
            Logger.error(this, "Could not lock UID just randomly generated: " + uid + " - probably indicates broken PRNG");
            throw new LowLevelPutException(1);
        }
        tag.setAccepted();
        try {
            int status;
            CHKInsertSender cHKInsertSender;
            long startTime = System.currentTimeMillis();
            CHKInsertSender is = this.node.makeInsertSender(block.getKey(), this.node.maxHTL(), uid, tag, null, headers, prb, false, canWriteClientCache, forkOnCacheable, preferInsert, ignoreLowBackoff, realTimeFlag);
            boolean hasReceivedRejectedOverload = false;
            while (true) {
                cHKInsertSender = is;
                synchronized (cHKInsertSender) {
                    if (is.getStatus() == -1) {
                        try {
                            is.wait(TimeUnit.SECONDS.toMillis(5L));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (is.getStatus() != -1) {
                        break;
                    }
                }
                if (hasReceivedRejectedOverload || !is.receivedRejectedOverload()) continue;
                hasReceivedRejectedOverload = true;
                this.requestStarters.rejectedOverload(false, true, realTimeFlag);
            }
            while (true) {
                cHKInsertSender = is;
                synchronized (cHKInsertSender) {
                    if (is.completed()) {
                        break;
                    }
                    try {
                        is.wait(TimeUnit.SECONDS.toMillis(10L));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!is.anyTransfersFailed() || hasReceivedRejectedOverload) continue;
                hasReceivedRejectedOverload = true;
                this.requestStarters.rejectedOverload(false, true, realTimeFlag);
            }
            if (logMINOR) {
                Logger.minor(this, "Completed " + uid + " overload=" + hasReceivedRejectedOverload + ' ' + is.getStatusString());
            }
            if (!hasReceivedRejectedOverload && is.sentRequest() && is.uid == uid && (is.getStatus() == 1 || is.getStatus() == 0)) {
                long endTime = System.currentTimeMillis();
                long len = endTime - startTime;
                this.requestStarters.getThrottle(false, true, realTimeFlag).successfulCompletion(len);
                this.requestStarters.requestCompleted(false, true, block.getKey(), realTimeFlag);
            }
            if ((status = is.getStatus()) != 4 && status != 5 && status != 3 && status != 6) {
                int sent = is.getTotalSentBytes();
                int received = is.getTotalReceivedBytes();
                if (logMINOR) {
                    Logger.minor(this, "Local CHK insert cost " + sent + '/' + received + " bytes (" + status + ')');
                }
                this.nodeStats.localChkInsertBytesSentAverage.report(sent);
                this.nodeStats.localChkInsertBytesReceivedAverage.report(received);
                if (status == 0) {
                    this.nodeStats.successfulChkInsertBytesSentAverage.report(sent);
                }
            }
            boolean deep = this.node.shouldStoreDeep(block.getKey(), null, is == null ? new PeerNode[]{} : is.getRoutedTo());
            try {
                this.node.store((KeyBlock)block, deep, canWriteClientCache, false, false);
            }
            catch (KeyCollisionException received) {
                // empty catch block
            }
            if (status == 0) {
                Logger.normal(this, "Succeeded inserting " + block);
                return;
            }
            String msg = "Failed inserting " + block + " : " + is.getStatusString();
            if (status == 1) {
                msg = msg + " - this is normal on small networks; the data will still be propagated, but it can't find the 20+ nodes needed for full success";
            }
            if (is.getStatus() != 1) {
                Logger.error(this, msg);
            } else {
                Logger.normal(this, msg);
            }
            switch (is.getStatus()) {
                case -1: {
                    Logger.error(this, "IS still running in putCHK!: " + is);
                    throw new LowLevelPutException(1);
                }
                case 4: 
                case 5: {
                    throw new LowLevelPutException(3);
                }
                case 1: {
                    throw new LowLevelPutException(2);
                }
                case 6: {
                    throw new LowLevelPutException(4);
                }
                case 3: {
                    throw new LowLevelPutException(1);
                }
            }
            Logger.error(this, "Unknown CHKInsertSender code in putCHK: " + is.getStatus() + " on " + is);
            throw new LowLevelPutException(1);
        }
        finally {
            tag.unlockHandler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void realPutSSK(SSKBlock block, boolean canWriteClientCache, boolean forkOnCacheable, boolean preferInsert, boolean ignoreLowBackoff, boolean realTimeFlag) throws LowLevelPutException {
        InsertTag tag;
        long uid = this.makeUID();
        if (!this.tracker.lockUID(uid, true, true, false, true, realTimeFlag, tag = new InsertTag(true, InsertTag.START.LOCAL, null, realTimeFlag, uid, this.node))) {
            Logger.error(this, "Could not lock UID just randomly generated: " + uid + " - probably indicates broken PRNG");
            throw new LowLevelPutException(1);
        }
        tag.setAccepted();
        try {
            int status;
            SSKInsertSender sSKInsertSender;
            long startTime = System.currentTimeMillis();
            SSKBlock altBlock = this.node.fetch(block.getKey(), false, true, canWriteClientCache, false, false, null);
            if (altBlock != null && !altBlock.equals(block)) {
                throw new LowLevelPutException(altBlock);
            }
            SSKInsertSender is = this.node.makeInsertSender(block, this.node.maxHTL(), uid, tag, null, false, canWriteClientCache, false, forkOnCacheable, preferInsert, ignoreLowBackoff, realTimeFlag);
            boolean hasReceivedRejectedOverload = false;
            while (true) {
                sSKInsertSender = is;
                synchronized (sSKInsertSender) {
                    if (is.getStatus() == -1) {
                        try {
                            is.wait(TimeUnit.SECONDS.toMillis(5L));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (is.getStatus() != -1) {
                        break;
                    }
                }
                if (hasReceivedRejectedOverload || !is.receivedRejectedOverload()) continue;
                hasReceivedRejectedOverload = true;
                this.requestStarters.rejectedOverload(true, true, realTimeFlag);
            }
            while (true) {
                sSKInsertSender = is;
                synchronized (sSKInsertSender) {
                    if (is.getStatus() != -1) {
                        break;
                    }
                    try {
                        is.wait(TimeUnit.SECONDS.toMillis(10L));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (logMINOR) {
                Logger.minor(this, "Completed " + uid + " overload=" + hasReceivedRejectedOverload + ' ' + is.getStatusString());
            }
            if (!hasReceivedRejectedOverload && is.sentRequest() && is.uid == uid && (is.getStatus() == 1 || is.getStatus() == 0)) {
                long endTime = System.currentTimeMillis();
                long rtt = endTime - startTime;
                this.requestStarters.requestCompleted(true, true, block.getKey(), realTimeFlag);
                this.requestStarters.getThrottle(true, true, realTimeFlag).successfulCompletion(rtt);
            }
            if ((status = is.getStatus()) != 4 && status != 5 && status != 3 && status != 6) {
                int sent = is.getTotalSentBytes();
                int received = is.getTotalReceivedBytes();
                if (logMINOR) {
                    Logger.minor(this, "Local SSK insert cost " + sent + '/' + received + " bytes (" + status + ')');
                }
                this.nodeStats.localSskInsertBytesSentAverage.report(sent);
                this.nodeStats.localSskInsertBytesReceivedAverage.report(received);
                if (status == 0) {
                    this.nodeStats.successfulSskInsertBytesSentAverage.report(sent);
                }
            }
            boolean deep = this.node.shouldStoreDeep(block.getKey(), null, is == null ? new PeerNode[]{} : is.getRoutedTo());
            if (is.hasCollided()) {
                SSKBlock collided = is.getBlock();
                try {
                    this.node.storeInsert(collided, deep, true, canWriteClientCache, false);
                }
                catch (KeyCollisionException e) {
                    Logger.normal(this, "collision race? is=" + is, (Throwable)e);
                }
                throw new LowLevelPutException(collided);
            }
            try {
                this.node.storeInsert(block, deep, false, canWriteClientCache, false);
            }
            catch (KeyCollisionException e) {
                LowLevelPutException failed = new LowLevelPutException(5);
                NodeSSK key = block.getKey();
                KeyBlock collided = this.node.fetch(key, true, canWriteClientCache, false, false, null);
                if (collided == null) {
                    Logger.error(this, "Collided but no key?!");
                    try {
                        this.node.store(block, false, canWriteClientCache, false, false);
                    }
                    catch (KeyCollisionException e2) {
                        Logger.error(this, "Collided but no key and still collided!");
                        throw new LowLevelPutException(1, "Collided, can't find block, but still collides!", e);
                    }
                }
                failed.setCollidedBlock(collided);
                throw failed;
            }
            if (status == 0) {
                Logger.normal(this, "Succeeded inserting " + block);
                return;
            }
            String msg = "Failed inserting " + block + " : " + is.getStatusString();
            if (status == 1) {
                msg = msg + " - this is normal on small networks; the data will still be propagated, but it can't find the 20+ nodes needed for full success";
            }
            if (is.getStatus() != 1) {
                Logger.error(this, msg);
            } else {
                Logger.normal(this, msg);
            }
            switch (is.getStatus()) {
                case -1: {
                    Logger.error(this, "IS still running in putCHK!: " + is);
                    throw new LowLevelPutException(1);
                }
                case 4: 
                case 5: {
                    throw new LowLevelPutException(3);
                }
                case 1: {
                    throw new LowLevelPutException(2);
                }
                case 6: {
                    throw new LowLevelPutException(4);
                }
                case 3: {
                    throw new LowLevelPutException(1);
                }
            }
            Logger.error(this, "Unknown CHKInsertSender code in putSSK: " + is.getStatus() + " on " + is);
            throw new LowLevelPutException(1);
        }
        finally {
            tag.unlockHandler();
        }
    }

    @Deprecated
    public HighLevelSimpleClient makeClient(short prioClass) {
        return this.makeClient(prioClass, false, false);
    }

    @Deprecated
    public HighLevelSimpleClient makeClient(short prioClass, boolean forceDontIgnoreTooManyPathComponents) {
        return this.makeClient(prioClass, forceDontIgnoreTooManyPathComponents, false);
    }

    public HighLevelSimpleClient makeClient(short prioClass, boolean forceDontIgnoreTooManyPathComponents, boolean realTimeFlag) {
        return new HighLevelSimpleClientImpl(this, this.tempBucketFactory, this.random, prioClass, forceDontIgnoreTooManyPathComponents, realTimeFlag);
    }

    public FCPServer getFCPServer() {
        return this.fcpServer;
    }

    public FProxyToadlet getFProxy() {
        return this.fproxyServlet;
    }

    public SimpleToadletServer getToadletContainer() {
        return this.toadletContainer;
    }

    public LinkFilterExceptionProvider getLinkFilterExceptionProvider() {
        return this.toadletContainer;
    }

    public TextModeClientInterfaceServer getTextModeClientInterface() {
        return this.tmci;
    }

    public void setFProxy(FProxyToadlet fproxy) {
        this.fproxyServlet = fproxy;
    }

    public TextModeClientInterface getDirectTMCI() {
        return this.directTMCI;
    }

    public void setDirectTMCI(TextModeClientInterface i) {
        this.directTMCI = i;
    }

    public File getDownloadsDir() {
        return this.downloadsDir.dir();
    }

    public ProgramDirectory downloadsDir() {
        return this.downloadsDir;
    }

    public HealingQueue getHealingQueue() {
        return this.healingQueue;
    }

    public void queueRandomReinsert(KeyBlock block) {
        SimpleSendableInsert ssi = new SimpleSendableInsert(this, block, 0);
        if (logMINOR) {
            Logger.minor(this, "Queueing random reinsert for " + block + " : " + ssi);
        }
        ssi.schedule();
    }

    public void storeConfig() {
        Logger.normal(this, "Trying to write config to disk", (Throwable)new Exception("debug"));
        this.node.config.store();
    }

    public boolean isTestnetEnabled() {
        return Node.isTestnetEnabled();
    }

    public boolean isAdvancedModeEnabled() {
        return this.getToadletContainer() != null && this.getToadletContainer().isAdvancedModeEnabled();
    }

    public boolean isFProxyJavascriptEnabled() {
        return this.getToadletContainer() != null && this.getToadletContainer().isFProxyJavascriptEnabled();
    }

    public String getMyName() {
        return this.node.getMyName();
    }

    public FilterCallback createFilterCallback(URI uri, FoundURICallback cb) {
        if (logMINOR) {
            Logger.minor(this, "Creating filter callback: " + uri + ", " + cb);
        }
        return new GenericReadFilterCallback(uri, cb, null, (LinkFilterExceptionProvider)this.toadletContainer);
    }

    public int maxBackgroundUSKFetchers() {
        return maxBackgroundUSKFetchers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allowDownloadTo(File filename) {
        SecurityLevels.PHYSICAL_THREAT_LEVEL physicalThreatLevel = this.node.securityLevels.getPhysicalThreatLevel();
        if (physicalThreatLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.MAXIMUM) {
            return false;
        }
        NodeClientCore nodeClientCore = this;
        synchronized (nodeClientCore) {
            if (this.downloadAllowedEverywhere) {
                return true;
            }
            if (this.includeDownloadDir && FileUtil.isParent(this.getDownloadsDir(), filename)) {
                return true;
            }
            for (File dir : this.downloadAllowedDirs) {
                if (dir == null) {
                    Logger.error(this, "Null in upload allowed dirs???");
                    continue;
                }
                if (!FileUtil.isParent(dir, filename)) continue;
                return true;
            }
            return false;
        }
    }

    public synchronized boolean allowUploadFrom(File filename) {
        if (this.uploadAllowedEverywhere) {
            return true;
        }
        for (File dir : this.uploadAllowedDirs) {
            if (dir == null) {
                Logger.error(this, "Null in upload allowed dirs???");
                continue;
            }
            if (!FileUtil.isParent(dir, filename)) continue;
            return true;
        }
        return false;
    }

    public synchronized File[] getAllowedDownloadDirs() {
        return this.downloadAllowedDirs;
    }

    public synchronized File[] getAllowedUploadDirs() {
        return this.uploadAllowedDirs;
    }

    @Override
    public SimpleFieldSet persistThrottlesToFieldSet() {
        return this.requestStarters.persistToFieldSet();
    }

    public Ticker getTicker() {
        return this.node.getTicker();
    }

    public Executor getExecutor() {
        return this.node.executor;
    }

    public File getPersistentTempDir() {
        return this.persistentTempDir.dir();
    }

    public File getTempDir() {
        return this.tempDir.dir();
    }

    public void queueOfferedKey(Key key, boolean realTime) {
        ClientRequestScheduler sched = this.requestStarters.getScheduler(key instanceof NodeSSK, false, realTime);
        sched.queueOfferedKey(key, realTime);
    }

    public void dequeueOfferedKey(Key key) {
        ClientRequestScheduler sched = this.requestStarters.getScheduler(key instanceof NodeSSK, false, false);
        sched.dequeueOfferedKey(key);
        sched = this.requestStarters.getScheduler(key instanceof NodeSSK, false, true);
        sched.dequeueOfferedKey(key);
    }

    public BookmarkManager getBookmarkManager() {
        return this.toadletContainer.getBookmarks();
    }

    public FreenetURI[] getBookmarkURIs() {
        return this.toadletContainer.getBookmarkURIs();
    }

    public long countQueuedRequests() {
        return this.requestStarters.countQueuedRequests();
    }

    public static int getMaxBackgroundUSKFetchers() {
        return maxBackgroundUSKFetchers;
    }

    public boolean wantKey(Key key) {
        boolean isSSK = key instanceof NodeSSK;
        if (this.clientContext.getFetchScheduler(isSSK, true).wantKey(key)) {
            return true;
        }
        return this.clientContext.getFetchScheduler(isSSK, false).wantKey(key);
    }

    public long checkRecentlyFailed(Key key, boolean realTime) {
        RecentlyFailedReturn r = new RecentlyFailedReturn();
        short origHTL = this.node.decrementHTL(null, this.node.maxHTL());
        this.node.peers.closerPeer(null, new HashSet<PeerNode>(), key.toNormalizedDouble(), true, false, -1, null, 2.0, key, origHTL, 0L, true, realTime, r, false, System.currentTimeMillis(), this.node.enableNewLoadManagement(realTime));
        return r.recentlyFailed();
    }

    public PluginStores getPluginStores() {
        return this.pluginStores;
    }

    public synchronized long getMinDiskFreeLongTerm() {
        return this.minDiskFreeLongTerm;
    }

    public synchronized long getMinDiskFreeShortTerm() {
        return this.minDiskFreeShortTerm;
    }

    public boolean killedDatabase() {
        return this.clientLayerPersister.isKilledOrNotLoaded();
    }

    public ClientRequest[] getPersistentRequests() {
        return this.fcpPersistentRoot.getPersistentRequests();
    }

    public void setupMasterSecret(MasterSecret persistentSecret) {
        if (this.clientContext.getPersistentMasterSecret() == null) {
            this.clientContext.setPersistentMasterSecret(persistentSecret);
        }
        this.persistentTempBucketFactory.setMasterSecret(persistentSecret);
        this.persistentRAFFactory.setMasterSecret(persistentSecret);
    }

    public boolean loadedDatabase() {
        return this.clientLayerPersister.hasLoaded();
    }

    static {
        Logger.registerClass(NodeClientCore.class);
    }

    public static interface SimpleRequestSenderCompletionListener {
        public void completed(boolean var1);
    }
}

