/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.HasKeyListener;
import freenet.client.async.KeyListener;
import freenet.client.async.KeySalter;
import freenet.crypt.RandomSource;
import freenet.crypt.SHA256;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.NodeSSK;
import freenet.node.SendableGet;
import freenet.support.ByteArrayWrapper;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class KeyListenerTracker
implements KeySalter {
    private static volatile boolean logMINOR;
    private static final int MIN_RETRY_COUNT = 3;
    final boolean isInsertScheduler;
    final boolean isSSKScheduler;
    final boolean isRTScheduler;
    protected final ClientRequestScheduler sched;
    protected final ArrayList<KeyListener> keyListeners;
    protected final Map<ByteArrayWrapper, Object> singleKeyListeners;
    final boolean persistent;
    public byte[] globalSalt;

    public boolean persistent() {
        return this.persistent;
    }

    protected KeyListenerTracker(boolean forInserts, boolean forSSKs, boolean forRT, RandomSource random, ClientRequestScheduler sched, byte[] globalSalt, boolean persistent) {
        this.isInsertScheduler = forInserts;
        this.isSSKScheduler = forSSKs;
        this.isRTScheduler = forRT;
        this.sched = sched;
        this.keyListeners = new ArrayList();
        Map<ByteArrayWrapper, Object> map = this.singleKeyListeners = this.isSSKScheduler ? new TreeMap(ByteArrayWrapper.FAST_COMPARATOR) : new HashMap();
        if (globalSalt == null) {
            globalSalt = new byte[32];
            random.nextBytes(globalSalt);
        }
        this.globalSalt = globalSalt;
        this.persistent = persistent;
    }

    protected static int fixRetryCount(int retryCount) {
        return Math.max(0, retryCount - 3);
    }

    private boolean contains(KeyListener[] listeners, KeyListener listener) {
        for (KeyListener l : listeners) {
            if (l != listener) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPendingKeys(KeyListener listener) {
        ByteArrayWrapper wrapper;
        if (listener == null) {
            throw new NullPointerException();
        }
        byte[] wantedKey = listener.getWantedKey();
        ByteArrayWrapper byteArrayWrapper = wrapper = wantedKey != null ? new ByteArrayWrapper(this.saltKey(wantedKey)) : null;
        assert (Arrays.equals(wantedKey, listener.getHasKeyListener().getWantedKey()));
        KeyListenerTracker keyListenerTracker = this;
        synchronized (keyListenerTracker) {
            if (wantedKey != null) {
                Object o = this.singleKeyListeners.get(wrapper);
                if (o == null) {
                    this.singleKeyListeners.put(wrapper, listener);
                } else if (o instanceof KeyListener) {
                    if (listener == (KeyListener)o) {
                        return;
                    }
                    this.singleKeyListeners.put(wrapper, new KeyListener[]{(KeyListener)o, listener});
                } else {
                    KeyListener[] listeners = (KeyListener[])o;
                    if (this.contains(listeners, listener)) {
                        return;
                    }
                    KeyListener[] newListeners = Arrays.copyOf(listeners, listeners.length + 1);
                    newListeners[listeners.length] = listener;
                    this.singleKeyListeners.put(wrapper, newListeners);
                }
            } else {
                if (this.keyListeners.contains(listener)) {
                    return;
                }
                this.keyListeners.add(listener);
            }
        }
        if (logMINOR) {
            Logger.minor(this, "Added pending keys to " + this + " : size now " + this.keyListeners.size() + "/" + this.singleKeyListeners.size() + " : " + listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePendingKeys(KeyListener listener) {
        boolean ret = false;
        byte[] wantedKey = listener.getWantedKey();
        ByteArrayWrapper wrapper = wantedKey != null ? new ByteArrayWrapper(this.saltKey(wantedKey)) : null;
        KeyListenerTracker keyListenerTracker = this;
        synchronized (keyListenerTracker) {
            if (wantedKey != null) {
                Object o = this.singleKeyListeners.get(wrapper);
                if (o != null) {
                    if (o instanceof KeyListener) {
                        ret = listener == (KeyListener)o;
                        if (ret) {
                            this.singleKeyListeners.remove(wrapper);
                        }
                    } else {
                        KeyListener[] listeners = (KeyListener[])o;
                        KeyListener[] newListeners = new KeyListener[listeners.length - 1];
                        int x = 0;
                        for (KeyListener l : listeners) {
                            if (listener == l) {
                                assert (!ret);
                                ret = true;
                                continue;
                            }
                            if (x == newListeners.length) {
                                assert (!ret);
                                break;
                            }
                            newListeners[x++] = l;
                        }
                        if (ret) {
                            assert (x == newListeners.length);
                            if (newListeners.length == 0) {
                                this.singleKeyListeners.remove(wrapper);
                            } else if (newListeners.length == 1) {
                                this.singleKeyListeners.put(wrapper, newListeners[0]);
                            } else {
                                this.singleKeyListeners.put(wrapper, newListeners);
                            }
                        }
                    }
                }
            } else {
                ret = this.keyListeners.remove(listener);
            }
            listener.onRemove();
        }
        listener.onRemove();
        if (logMINOR) {
            Logger.minor(this, "Removed pending keys from " + this + " : size now " + this.keyListeners.size() + "/" + this.singleKeyListeners.size() + " : " + listener, (Throwable)new Exception("debug"));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePendingKeys(HasKeyListener hasListener) {
        boolean ret = false;
        byte[] wantedKey = hasListener.getWantedKey();
        ByteArrayWrapper wrapper = wantedKey != null ? new ByteArrayWrapper(this.saltKey(wantedKey)) : null;
        KeyListenerTracker keyListenerTracker = this;
        synchronized (keyListenerTracker) {
            if (wantedKey != null) {
                Object o = this.singleKeyListeners.get(wrapper);
                if (o != null) {
                    if (o instanceof KeyListener) {
                        ret = ((KeyListener)o).getHasKeyListener() == hasListener;
                        if (ret) {
                            this.singleKeyListeners.remove(wrapper);
                            ((KeyListener)o).onRemove();
                        }
                    } else {
                        KeyListener[] listeners = (KeyListener[])o;
                        KeyListener[] newListeners = new KeyListener[listeners.length - 1];
                        int x = 0;
                        String msg = logMINOR ? "" : null;
                        for (KeyListener l : listeners) {
                            if (l.getHasKeyListener() == hasListener) {
                                ret = true;
                                l.onRemove();
                                if (!logMINOR) continue;
                                msg = msg + " : " + l;
                                continue;
                            }
                            if (x == newListeners.length) {
                                assert (!ret);
                                break;
                            }
                            newListeners[x++] = l;
                        }
                        if (ret) {
                            if (x < newListeners.length) {
                                newListeners = Arrays.copyOf(newListeners, x);
                            }
                            if (newListeners.length == 0) {
                                this.singleKeyListeners.remove(wrapper);
                            } else if (newListeners.length == 1) {
                                this.singleKeyListeners.put(wrapper, newListeners[0]);
                            } else {
                                this.singleKeyListeners.put(wrapper, newListeners);
                            }
                            if (logMINOR) {
                                Logger.minor(this, "Removed pending keys from " + this + " : size now " + this.keyListeners.size() + "/" + this.singleKeyListeners.size() + msg);
                            }
                        }
                    }
                }
                return ret;
            }
            Iterator<KeyListener> i = this.keyListeners.iterator();
            while (i.hasNext()) {
                KeyListener listener = i.next();
                if (listener.getHasKeyListener() != hasListener) continue;
                ret = true;
                i.remove();
                listener.onRemove();
                if (!logMINOR) continue;
                Logger.minor(this, "Removed pending keys from " + this + " : size now " + this.keyListeners.size() + "/" + this.singleKeyListeners.size() + " : " + listener);
            }
        }
        return ret;
    }

    private synchronized ArrayList<KeyListener> probablyMatches(Key key, byte[] saltedKey) {
        ArrayList<KeyListener> matches = null;
        ByteArrayWrapper wrapper = new ByteArrayWrapper(saltedKey);
        Object o = this.singleKeyListeners.get(wrapper);
        if (o != null) {
            if (o instanceof KeyListener) {
                KeyListener listener = (KeyListener)o;
                if (listener.probablyWantKey(key, saltedKey)) {
                    if (matches == null) {
                        matches = new ArrayList<KeyListener>();
                    }
                    matches.add(listener);
                }
            } else {
                KeyListener[] listeners;
                for (KeyListener listener : listeners = (KeyListener[])o) {
                    if (!listener.probablyWantKey(key, saltedKey)) continue;
                    if (matches == null) {
                        matches = new ArrayList();
                    }
                    matches.add(listener);
                }
            }
        }
        for (KeyListener listener : this.keyListeners) {
            if (!listener.probablyWantKey(key, saltedKey)) continue;
            if (matches == null) {
                matches = new ArrayList();
            }
            matches.add(listener);
        }
        return matches;
    }

    public short getKeyPrio(Key key, short priority, ClientContext context) {
        assert (key instanceof NodeSSK == this.isSSKScheduler);
        byte[] saltedKey = this.saltKey(key);
        ArrayList<KeyListener> matches = this.probablyMatches(key, saltedKey);
        if (matches == null) {
            return priority;
        }
        for (KeyListener listener : matches) {
            short prio;
            try {
                prio = listener.definitelyWantKey(key, saltedKey, this.sched.clientContext);
            }
            catch (Throwable t) {
                Logger.error(this, String.format("Error in definitelyWantKey callback for %s", listener), t);
                continue;
            }
            if (prio == -1 || prio >= priority) continue;
            priority = prio;
        }
        return priority;
    }

    public synchronized long countWaitingKeys() {
        long count = 0L;
        for (Object o : this.singleKeyListeners.values()) {
            KeyListener[] listeners;
            if (o == null) continue;
            if (o instanceof KeyListener) {
                count += ((KeyListener)o).countKeys();
                continue;
            }
            for (KeyListener listener : listeners = (KeyListener[])o) {
                count += listener.countKeys();
            }
        }
        for (KeyListener listener : this.keyListeners) {
            try {
                count += listener.countKeys();
            }
            catch (Throwable t) {
                Logger.error(this, String.format("Error in countKeys callback for %s", listener), t);
            }
        }
        return count;
    }

    public boolean anyWantKey(Key key, ClientContext context) {
        assert (key instanceof NodeSSK == this.isSSKScheduler);
        byte[] saltedKey = this.saltKey(key);
        List<KeyListener> matches = this.probablyWantKey(key, saltedKey);
        if (!matches.isEmpty()) {
            for (KeyListener listener : matches) {
                try {
                    if (listener.definitelyWantKey(key, saltedKey, this.sched.clientContext) < 0) continue;
                    return true;
                }
                catch (Throwable t) {
                    Logger.error(this, String.format("Error in definitelyWantKey callback for %s", listener), t);
                }
            }
        }
        return false;
    }

    public synchronized boolean anyProbablyWantKey(Key key, ClientContext context) {
        assert (key instanceof NodeSSK == this.isSSKScheduler);
        byte[] saltedKey = this.saltKey(key);
        ByteArrayWrapper wrapper = new ByteArrayWrapper(saltedKey);
        Object o = this.singleKeyListeners.get(wrapper);
        if (o != null) {
            if (o instanceof KeyListener) {
                KeyListener listener = (KeyListener)o;
                if (listener.probablyWantKey(key, saltedKey)) {
                    return true;
                }
            } else {
                KeyListener[] listeners;
                for (KeyListener listener : listeners = (KeyListener[])o) {
                    if (!listener.probablyWantKey(key, saltedKey)) continue;
                    return true;
                }
            }
        }
        for (KeyListener listener : this.keyListeners) {
            try {
                if (!listener.probablyWantKey(key, saltedKey)) continue;
                return true;
            }
            catch (Throwable t) {
                Logger.error(this, String.format("Error in probablyWantKey callback for %s", listener), t);
            }
        }
        return false;
    }

    public boolean tripPendingKey(Key key, KeyBlock block, ClientContext context) {
        if (key instanceof NodeSSK != this.isSSKScheduler) {
            Logger.error(this, "Key " + key + " on scheduler ssk=" + this.isSSKScheduler, (Throwable)new Exception("debug"));
            return false;
        }
        assert (key instanceof NodeSSK == this.isSSKScheduler);
        byte[] saltedKey = this.saltKey(key);
        ArrayList<KeyListener> matches = this.probablyMatches(key, saltedKey);
        boolean ret = false;
        if (matches != null) {
            for (KeyListener listener : matches) {
                try {
                    if (listener.handleBlock(key, saltedKey, block, context)) {
                        ret = true;
                    }
                }
                catch (Throwable t) {
                    Logger.error(this, String.format("Error in handleBlock callback for %s", listener), t);
                }
                if (!listener.isEmpty()) continue;
                try {
                    this.removePendingKeys(listener);
                }
                catch (Throwable t) {
                    Logger.error(this, String.format("Error while removing %s", listener), t);
                }
            }
        }
        return ret;
    }

    public SendableGet[] requestsForKey(Key key, ClientContext context) {
        ArrayList<SendableGet> list = new ArrayList<SendableGet>();
        assert (key instanceof NodeSSK == this.isSSKScheduler);
        byte[] saltedKey = this.saltKey(key);
        List<KeyListener> matches = this.probablyWantKey(key, saltedKey);
        if (matches == null) {
            return null;
        }
        for (KeyListener listener : matches) {
            SendableGet[] reqs;
            try {
                reqs = listener.getRequestsForKey(key, saltedKey, context);
            }
            catch (Throwable t) {
                Logger.error(this, String.format("Error in getRequestsForKey callback for %s", listener), t);
                continue;
            }
            if (reqs == null) continue;
            for (SendableGet req : reqs) {
                list.add(req);
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new SendableGet[list.size()]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append(':');
        if (this.isInsertScheduler) {
            sb.append("insert:");
        }
        if (this.isSSKScheduler) {
            sb.append("SSK");
        } else {
            sb.append("CHK");
        }
        return sb.toString();
    }

    @Override
    public byte[] saltKey(Key key) {
        return this.saltKey(key instanceof NodeSSK ? ((NodeSSK)key).getPubKeyHash() : key.getRoutingKey());
    }

    private byte[] saltKey(byte[] key) {
        if (this.isSSKScheduler) {
            return key;
        }
        MessageDigest md = SHA256.getMessageDigest();
        md.update(key);
        md.update(this.globalSalt);
        byte[] ret = md.digest();
        SHA256.returnMessageDigest(md);
        return ret;
    }

    protected void hintGlobalSalt(byte[] globalSalt2) {
        if (this.globalSalt == null) {
            this.globalSalt = globalSalt2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<KeyListener> probablyWantKey(Key key, byte[] saltedKey) {
        ArrayList<KeyListener> matches = new ArrayList<KeyListener>();
        KeyListenerTracker keyListenerTracker = this;
        synchronized (keyListenerTracker) {
            for (KeyListener listener : this.keyListeners) {
                block7: {
                    try {
                        if (!listener.probablyWantKey(key, saltedKey)) {
                        }
                        break block7;
                    }
                    catch (Throwable t) {
                        Logger.error(this, String.format("Error in probablyWantKey callback for %s", listener), t);
                    }
                    continue;
                }
                matches.add(listener);
            }
        }
        return matches;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

