/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.async.BaseSingleFileFetcher;
import freenet.client.async.ClientContext;
import freenet.client.async.HasKeyListener;
import freenet.client.async.KeyListener;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.NodeSSK;
import freenet.node.LowLevelGetException;
import freenet.node.SendableGet;
import freenet.support.Logger;

public class SingleKeyListener
implements KeyListener {
    private final Key key;
    private final BaseSingleFileFetcher fetcher;
    private boolean done;
    private short prio;
    private final boolean persistent;

    public SingleKeyListener(Key key, BaseSingleFileFetcher fetcher, short prio, boolean persistent) {
        this.key = key;
        this.fetcher = fetcher;
        this.prio = prio;
        this.persistent = persistent;
    }

    @Override
    public long countKeys() {
        if (this.done) {
            return 0L;
        }
        return 1L;
    }

    @Override
    public short definitelyWantKey(Key key, byte[] saltedKey, ClientContext context) {
        if (!key.equals(this.key)) {
            return -1;
        }
        return this.prio;
    }

    @Override
    public HasKeyListener getHasKeyListener() {
        return this.fetcher;
    }

    @Override
    public short getPriorityClass() {
        return this.prio;
    }

    @Override
    public SendableGet[] getRequestsForKey(Key key, byte[] saltedKey, ClientContext context) {
        if (!key.equals(this.key)) {
            return null;
        }
        return new SendableGet[]{this.fetcher};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleBlock(Key key, byte[] saltedKey, KeyBlock found, ClientContext context) {
        if (!key.equals(this.key)) {
            return false;
        }
        try {
            this.fetcher.onGotKey(key, found, context);
        }
        catch (Throwable t) {
            Logger.error(this, "Failed: " + t, t);
            this.fetcher.onFailure(new LowLevelGetException(3), null, context);
        }
        SingleKeyListener singleKeyListener = this;
        synchronized (singleKeyListener) {
            this.done = true;
        }
        return true;
    }

    @Override
    public boolean persistent() {
        return this.persistent;
    }

    @Override
    public boolean probablyWantKey(Key key, byte[] saltedKey) {
        if (this.done) {
            return false;
        }
        return key.equals(this.key);
    }

    @Override
    public synchronized void onRemove() {
        this.done = true;
    }

    @Override
    public boolean isEmpty() {
        return this.done;
    }

    @Override
    public boolean isSSK() {
        return this.key instanceof NodeSSK;
    }

    @Override
    public byte[] getWantedKey() {
        return this.key instanceof NodeSSK ? ((NodeSSK)this.key).getPubKeyHash() : this.key.getRoutingKey();
    }
}

