/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.FetchException;
import freenet.client.async.ClientContext;
import freenet.client.async.HasKeyListener;
import freenet.client.async.KeyListener;
import freenet.client.async.KeySalter;
import freenet.client.async.SplitFileFetcherStorage;
import freenet.client.async.SplitFileFetcherStorageCallback;
import freenet.crypt.ChecksumFailedException;
import freenet.crypt.SHA256;
import freenet.keys.CHKBlock;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.NodeCHK;
import freenet.node.SendableGet;
import freenet.support.BinaryBloomFilter;
import freenet.support.BloomFilter;
import freenet.support.CountingBloomFilter;
import freenet.support.Logger;
import freenet.support.io.StorageFormatException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;

public class SplitFileFetcherKeyListener
implements KeyListener {
    private static volatile boolean logMINOR;
    final SplitFileFetcherStorage storage;
    final SplitFileFetcherStorageCallback fetcher;
    private final byte[] localSalt;
    private final int mainBloomFilterSizeBytes;
    static final int DEFAULT_MAIN_BLOOM_ELEMENTS_PER_KEY = 19;
    private final int mainBloomK;
    static final double ACCEPTABLE_BLOOM_FALSE_POSITIVES_ALL_SEGMENTS = 0.01;
    private final int perSegmentBloomFilterSizeBytes;
    private final int perSegmentK;
    private final CountingBloomFilter filter;
    private final BinaryBloomFilter[] segmentFilters;
    private boolean finishedSetup;
    private final boolean persistent;
    private boolean dirty;
    private transient boolean mustRegenerateMainFilter;
    private transient boolean mustRegenerateSegmentFilters;

    public SplitFileFetcherKeyListener(SplitFileFetcherStorageCallback fetcher, SplitFileFetcherStorage storage, boolean persistent, byte[] localSalt, int origSize, int segBlocks, int segments) throws FetchException {
        if (origSize <= 0) {
            throw new FetchException(FetchException.FetchExceptionMode.INTERNAL_ERROR, "Cannot listen for non-positive number of blocks: " + origSize);
        }
        if (segBlocks <= 0) {
            throw new FetchException(FetchException.FetchExceptionMode.INTERNAL_ERROR, "Cannot listen for non-positive number of blocks per segment: " + segBlocks);
        }
        if (segments <= 0) {
            throw new FetchException(FetchException.FetchExceptionMode.INTERNAL_ERROR, "Cannot listen for non-positive number of segments: " + segments);
        }
        this.fetcher = fetcher;
        this.storage = storage;
        this.localSalt = localSalt;
        this.persistent = persistent;
        int mainElementsPerKey = 19;
        this.mainBloomK = (int)((double)mainElementsPerKey * 0.7);
        long elementsLong = origSize * mainElementsPerKey;
        if (elementsLong > Integer.MAX_VALUE) {
            throw new FetchException(FetchException.FetchExceptionMode.TOO_BIG, "Cannot fetch splitfiles with more than " + Integer.MAX_VALUE / mainElementsPerKey + " keys! (approx 3.3TB)");
        }
        int mainSizeBits = (int)elementsLong;
        mainSizeBits = mainSizeBits + 7 & 0xFFFFFFF8;
        this.mainBloomFilterSizeBytes = mainSizeBits / 8 * 2;
        double acceptableFalsePositives = 0.01 / (double)segments;
        int perSegmentBitsPerKey = (int)Math.ceil(Math.log(acceptableFalsePositives) / Math.log(0.6185));
        if (segBlocks > origSize) {
            segBlocks = origSize;
        }
        int perSegmentSize = perSegmentBitsPerKey * segBlocks;
        perSegmentSize = perSegmentSize + 7 & 0xFFFFFFF8;
        this.perSegmentBloomFilterSizeBytes = perSegmentSize / 8;
        this.perSegmentK = BloomFilter.optimialK(perSegmentSize, segBlocks);
        this.segmentFilters = new BinaryBloomFilter[segments];
        byte[] segmentsFilterBuffer = new byte[this.perSegmentBloomFilterSizeBytes * segments];
        ByteBuffer baseBuffer = ByteBuffer.wrap(segmentsFilterBuffer);
        int start = 0;
        int end = this.perSegmentBloomFilterSizeBytes;
        for (int i = 0; i < segments; ++i) {
            baseBuffer.position(start);
            baseBuffer.limit(end);
            ByteBuffer slice = baseBuffer.slice();
            this.segmentFilters[i] = new BinaryBloomFilter(slice, this.perSegmentBloomFilterSizeBytes * 8, this.perSegmentK);
            start += this.perSegmentBloomFilterSizeBytes;
            end += this.perSegmentBloomFilterSizeBytes;
        }
        byte[] filterBuffer = new byte[this.mainBloomFilterSizeBytes];
        this.filter = new CountingBloomFilter(this.mainBloomFilterSizeBytes * 8 / 2, this.mainBloomK, filterBuffer);
        this.filter.setWarnOnRemoveFromEmpty();
    }

    public SplitFileFetcherKeyListener(SplitFileFetcherStorage storage, SplitFileFetcherStorageCallback callback, DataInputStream dis, boolean persistent, boolean newSalt) throws IOException, StorageFormatException {
        this.storage = storage;
        this.fetcher = callback;
        this.persistent = persistent;
        this.localSalt = new byte[32];
        dis.readFully(this.localSalt);
        this.mainBloomFilterSizeBytes = dis.readInt();
        if (this.mainBloomFilterSizeBytes < 0) {
            throw new StorageFormatException("Bad main bloom filter size");
        }
        this.mainBloomK = dis.readInt();
        if (this.mainBloomK < 1) {
            throw new StorageFormatException("Bad main bloom filter K");
        }
        this.perSegmentBloomFilterSizeBytes = dis.readInt();
        if (this.perSegmentBloomFilterSizeBytes < 0) {
            throw new StorageFormatException("Bad per segment bloom filter size");
        }
        this.perSegmentK = dis.readInt();
        if (this.perSegmentK < 0) {
            throw new StorageFormatException("Bad per segment bloom filter K");
        }
        int segments = storage.segments.length;
        this.segmentFilters = new BinaryBloomFilter[segments];
        byte[] segmentsFilterBuffer = new byte[this.perSegmentBloomFilterSizeBytes * segments];
        try {
            storage.preadChecksummed(storage.offsetSegmentBloomFilters, segmentsFilterBuffer, 0, segmentsFilterBuffer.length);
        }
        catch (ChecksumFailedException e) {
            Logger.error(this, "Checksummed read for segment filters at " + storage.offsetSegmentBloomFilters + " failed for " + this + ": " + e);
            this.mustRegenerateSegmentFilters = true;
        }
        ByteBuffer baseBuffer = ByteBuffer.wrap(segmentsFilterBuffer);
        int start = 0;
        int end = this.perSegmentBloomFilterSizeBytes;
        for (int i = 0; i < segments; ++i) {
            baseBuffer.position(start);
            baseBuffer.limit(end);
            ByteBuffer slice = baseBuffer.slice();
            this.segmentFilters[i] = new BinaryBloomFilter(slice, this.perSegmentBloomFilterSizeBytes * 8, this.perSegmentK);
            start += this.perSegmentBloomFilterSizeBytes;
            end += this.perSegmentBloomFilterSizeBytes;
        }
        byte[] filterBuffer = new byte[this.mainBloomFilterSizeBytes];
        if (!newSalt) {
            try {
                storage.preadChecksummed(storage.offsetMainBloomFilter, filterBuffer, 0, this.mainBloomFilterSizeBytes);
            }
            catch (ChecksumFailedException e) {
                Logger.error(this, "Checksummed read for main filters at " + storage.offsetMainBloomFilter + " failed for " + this + ": " + e);
                this.mustRegenerateMainFilter = true;
            }
        } else {
            this.mustRegenerateMainFilter = true;
        }
        this.filter = new CountingBloomFilter(this.mainBloomFilterSizeBytes * 8 / 2, this.mainBloomK, filterBuffer);
        this.filter.setWarnOnRemoveFromEmpty();
    }

    synchronized void addKey(Key key, int segNo, KeySalter salter) {
        if (this.finishedSetup && !this.mustRegenerateMainFilter && !this.mustRegenerateSegmentFilters) {
            throw new IllegalStateException();
        }
        if (this.mustRegenerateMainFilter || !this.finishedSetup) {
            byte[] saltedKey = salter.saltKey(key);
            this.filter.addKey(saltedKey);
        }
        if (this.mustRegenerateSegmentFilters || !this.finishedSetup) {
            byte[] localSalted = this.localSaltKey(key);
            this.segmentFilters[segNo].addKey(localSalted);
        }
    }

    synchronized void finishedSetup() {
        this.finishedSetup = true;
    }

    private byte[] localSaltKey(Key key) {
        MessageDigest md = SHA256.getMessageDigest();
        md.update(key.getRoutingKey());
        md.update(this.localSalt);
        byte[] ret = md.digest();
        SHA256.returnMessageDigest(md);
        return ret;
    }

    void initialWriteSegmentBloomFilters(long fileOffset) throws IOException {
        OutputStream cos = this.storage.writeChecksummedTo(fileOffset, this.totalSegmentBloomFiltersSize());
        for (BinaryBloomFilter segFilter : this.segmentFilters) {
            segFilter.writeTo(cos);
        }
        cos.close();
    }

    int totalSegmentBloomFiltersSize() {
        return this.perSegmentBloomFilterSizeBytes * this.segmentFilters.length + this.storage.checksumLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void maybeWriteMainBloomFilter(long fileOffset) throws IOException {
        SplitFileFetcherKeyListener splitFileFetcherKeyListener = this;
        synchronized (splitFileFetcherKeyListener) {
            if (!this.dirty) {
                return;
            }
            this.dirty = false;
        }
        this.innerWriteMainBloomFilter(fileOffset);
    }

    void innerWriteMainBloomFilter(long fileOffset) throws IOException {
        OutputStream cos = this.storage.writeChecksummedTo(fileOffset, this.paddedMainBloomFilterSize());
        this.filter.writeTo(cos);
        cos.close();
    }

    public int paddedMainBloomFilterSize() {
        assert (this.mainBloomFilterSizeBytes == this.filter.getSizeBytes());
        return this.mainBloomFilterSizeBytes + this.storage.checksumLength;
    }

    @Override
    public boolean probablyWantKey(Key key, byte[] saltedKey) {
        if (this.filter.checkFilter(saltedKey)) {
            byte[] salted = this.localSaltKey(key);
            for (int i = 0; i < this.segmentFilters.length; ++i) {
                if (!this.segmentFilters[i].checkFilter(salted)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public short definitelyWantKey(Key key, byte[] saltedKey, ClientContext context) {
        byte[] salted = this.localSaltKey(key);
        for (int i = 0; i < this.segmentFilters.length; ++i) {
            if (!this.segmentFilters[i].checkFilter(salted) || !this.storage.segments[i].definitelyWantKey((NodeCHK)key)) continue;
            return this.fetcher.getPriorityClass();
        }
        return -1;
    }

    @Override
    public SendableGet[] getRequestsForKey(Key key, byte[] saltedKey, ClientContext context) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleBlock(Key key, byte[] saltedKey, KeyBlock block, ClientContext context) {
        boolean found = false;
        byte[] salted = this.localSaltKey(key);
        if (logMINOR) {
            Logger.minor(this, "handleBlock(" + key + ") on " + this + " for " + this.fetcher, (Throwable)new Exception("debug"));
        }
        for (int i = 0; i < this.segmentFilters.length; ++i) {
            boolean match;
            SplitFileFetcherKeyListener splitFileFetcherKeyListener = this;
            synchronized (splitFileFetcherKeyListener) {
                match = this.segmentFilters[i].checkFilter(salted);
            }
            if (!match) continue;
            try {
                found = this.storage.segments[i].onGotKey((NodeCHK)key, (CHKBlock)block);
                continue;
            }
            catch (IOException e) {
                this.fetcher.failOnDiskError(e);
                return false;
            }
        }
        if (found) {
            SplitFileFetcherKeyListener splitFileFetcherKeyListener = this;
            synchronized (splitFileFetcherKeyListener) {
                this.dirty = true;
            }
            this.filter.removeKey(saltedKey);
            if (this.persistent) {
                this.storage.lazyWriteMetadata();
            }
        }
        return found;
    }

    @Override
    public boolean persistent() {
        return this.persistent;
    }

    @Override
    public short getPriorityClass() {
        return this.fetcher.getPriorityClass();
    }

    @Override
    public long countKeys() {
        throw new UnsupportedOperationException();
    }

    @Override
    public HasKeyListener getHasKeyListener() {
        return this.fetcher.getHasKeyListener();
    }

    @Override
    public void onRemove() {
    }

    @Override
    public boolean isEmpty() {
        return this.storage.hasFinished();
    }

    @Override
    public boolean isSSK() {
        return false;
    }

    @Override
    public byte[] getWantedKey() {
        return null;
    }

    public void writeStaticSettings(DataOutputStream dos) throws IOException {
        dos.write(this.localSalt);
        dos.writeInt(this.mainBloomFilterSizeBytes);
        dos.writeInt(this.mainBloomK);
        dos.writeInt(this.perSegmentBloomFilterSizeBytes);
        dos.writeInt(this.perSegmentK);
    }

    public boolean needsKeys() {
        return this.mustRegenerateMainFilter || this.mustRegenerateSegmentFilters;
    }

    public void addedAllKeys() {
        this.mustRegenerateMainFilter = false;
        this.mustRegenerateSegmentFilters = false;
        this.finishedSetup = true;
    }

    static {
        Logger.registerClass(SplitFileFetcherKeyListener.class);
    }
}

