/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.BloomFilter;
import freenet.support.Logger;
import freenet.support.io.Closer;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class CountingBloomFilter
extends BloomFilter {
    private boolean warnOnRemoveFromEmpty;

    public void setWarnOnRemoveFromEmpty() {
        this.warnOnRemoveFromEmpty = true;
    }

    public CountingBloomFilter(int length, int k) {
        super(length, k);
        this.filter = ByteBuffer.allocate(this.length / 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CountingBloomFilter(File file, int length, int k) throws IOException {
        super(length, k);
        int fileLength = length / 4;
        if (!file.exists() || file.length() != (long)fileLength) {
            this.needRebuild = true;
        }
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        FileChannel channel = null;
        try {
            raf.setLength(fileLength);
            channel = raf.getChannel();
            this.filter = channel.map(FileChannel.MapMode.READ_WRITE, 0L, fileLength).load();
        }
        catch (Throwable throwable) {
            Closer.close(raf);
            Closer.close(channel);
            throw throwable;
        }
        Closer.close(raf);
        Closer.close(channel);
    }

    public CountingBloomFilter(int length, int k, byte[] buffer) {
        super(length, k);
        assert (buffer.length == length / 4);
        this.filter = ByteBuffer.wrap(buffer);
    }

    @Override
    public boolean getBit(int offset) {
        byte b = this.filter.get(offset / 4);
        byte v = (byte)(b >>> offset % 4 * 2 & 3);
        return v != 0;
    }

    @Override
    public void setBit(int offset) {
        byte b = this.filter.get(offset / 4);
        byte v = (byte)(b >>> offset % 4 * 2 & 3);
        if (v == 3) {
            return;
        }
        b = (byte)(b & ~(3 << offset % 4 * 2));
        b = (byte)(b | v + 1 << offset % 4 * 2);
        this.filter.put(offset / 4, b);
    }

    @Override
    public void unsetBit(int offset) {
        byte b = this.filter.get(offset / 4);
        byte v = (byte)(b >>> offset % 4 * 2 & 3);
        if (v == 0 && this.warnOnRemoveFromEmpty) {
            Logger.error(this, "Unsetting bit but already unset - probable double remove, can cause false negatives, is very bad!", (Throwable)new Exception("error"));
        }
        if (v == 0 || v == 3) {
            return;
        }
        b = (byte)(b & ~(3 << offset % 4 * 2));
        b = (byte)(b | v - 1 << offset % 4 * 2);
        this.filter.put(offset / 4, b);
    }

    @Override
    public void fork(int k) {
        this.lock.writeLock().lock();
        try {
            File tempFile = File.createTempFile("bloom-", ".tmp");
            tempFile.deleteOnExit();
            this.forkedFilter = new CountingBloomFilter(tempFile, this.length, k);
        }
        catch (IOException e) {
            this.forkedFilter = new CountingBloomFilter(this.length, k);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

