/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

public class RssSniffer {
    public static boolean isSniffedAsFeed(byte[] prefix) {
        int tlt = RssSniffer.indexOfTopLevelTag(prefix);
        if (tlt == -1) {
            return false;
        }
        return RssSniffer.startsWithString(prefix, "<rss", tlt) || RssSniffer.startsWithString(prefix, "<feed", tlt) || RssSniffer.startsWithString(prefix, "<rdf:RDF", tlt);
    }

    private static int indexOfTopLevelTag(byte[] data) {
        int i = 0;
        while ((i = RssSniffer.indexOf(data, (byte)60, i)) != -1) {
            if (++i >= data.length) {
                return -1;
            }
            if (data[i] != 63 && data[i] != 33) {
                return i - 1;
            }
            if ((i = RssSniffer.indexOf(data, (byte)62, i)) != -1) continue;
            return -1;
        }
        return -1;
    }

    private static boolean startsWithString(byte[] data, String key, int fromIndex) {
        if (data.length - fromIndex < key.length()) {
            return false;
        }
        for (int i = 0; i < key.length(); ++i) {
            if (data[i + fromIndex] == key.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static int indexOf(byte[] data, byte key, int fromIndex) {
        for (int i = fromIndex; i < data.length; ++i) {
            if (data[i] != key) continue;
            return i;
        }
        return -1;
    }
}

