/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.simulator;

import freenet.crypt.DummyRandomSource;
import freenet.crypt.RandomSource;
import freenet.node.LocationManager;
import freenet.node.Node;
import freenet.node.NodeStarter;
import freenet.node.PeerNode;
import freenet.node.simulator.RealNodeTest;
import freenet.support.Logger;
import freenet.support.PooledExecutor;
import freenet.support.io.FileUtil;
import freenet.support.math.BootstrappingDecayingRunningAverage;
import freenet.support.math.SimpleRunningAverage;
import java.io.File;
import java.time.Clock;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class RealNodePitchBlackMitigationTest
extends RealNodeTest {
    static final int NUMBER_OF_NODES = 300;
    static final int DEGREE = 4;
    static final short MAX_HTL = 10;
    static final boolean START_WITH_IDEAL_LOCATIONS = true;
    static final boolean FORCE_NEIGHBOUR_CONNECTIONS = true;
    static final int MIN_PINGS = 420;
    static final int MAX_PINGS = 840;
    static final boolean ENABLE_SWAPPING = true;
    static final boolean ENABLE_SWAP_QUEUEING = true;
    static final boolean ENABLE_FOAF = true;
    static final boolean ACTIVE_PITCH_BLACK_ATTACK = false;
    static final boolean INITIAL_PITCH_BLACK_ATTACK = true;
    public static final long PITCH_BLACK_MITIGATION_STARTUP_DELAY = TimeUnit.MINUTES.toMillis(1L);
    public static final long PITCH_BLACK_MITIGATION_FREQUENCY_ONE_DAY = TimeUnit.MINUTES.toMillis(30L);
    public static final int PINGS_PER_ITERATION = 10;
    public static int DARKNET_PORT_BASE = 10100;
    public static final int DARKNET_PORT_END = DARKNET_PORT_BASE + 300;
    public static final double PITCH_BLACK_ATTACK_JITTER = 0.001;
    public static final double PITCH_BLACK_ATTACK_MEAN_LOCATION = 0.5;
    public static final int BETWEEN_PING_SLEEP_TIME = 500000;

    public static void main(String[] args) throws Exception {
        int i;
        System.out.println("Routing test using real nodes:");
        System.out.println();
        String dir = "realNodeRequestInsertTest";
        File wd = new File(dir);
        if (!FileUtil.removeAll(wd)) {
            System.err.println("Mass delete failed, test may not be accurate.");
            System.exit(1027);
        }
        wd.mkdir();
        NodeStarter.globalTestInit(dir, false, Logger.LogLevel.ERROR, "", true);
        DummyRandomSource random = new DummyRandomSource(3142L);
        final Node[] nodes = new Node[300];
        Logger.normal(RealNodePitchBlackMitigationTest.class, "Creating nodes...");
        PooledExecutor executor = new PooledExecutor();
        for (i = 0; i < 300; ++i) {
            System.err.println("Creating node " + i);
            nodes[i] = NodeStarter.createTestNode(DARKNET_PORT_BASE + i, 0, dir, true, (short)10, 0, random, executor, 150000, 4000000L, true, true, false, false, false, true, true, 0, true, false, true, false, null);
            Logger.normal(RealNodePitchBlackMitigationTest.class, "Created node " + i);
        }
        Logger.normal(RealNodePitchBlackMitigationTest.class, "Created 300 nodes");
        RealNodePitchBlackMitigationTest.makeKleinbergNetwork(nodes, true, 4, true, random);
        Logger.normal(RealNodePitchBlackMitigationTest.class, "Added random links");
        for (i = 0; i < 300; ++i) {
            Node nodeToAttack = nodes[i];
            RealNodePitchBlackMitigationTest.attackSpecificNode(0.5, 0.001, nodeToAttack, i);
        }
        Logger.globalSetThreshold(Logger.LogLevel.WARNING);
        LocationManager cfr_ignored_0 = nodes[0].lm;
        LocationManager.setClockForTesting(Clock.offset(Clock.systemDefaultZone(), Duration.ofDays(-1L)));
        Runnable dayIncrementingJob = new Runnable(){

            @Override
            public void run() {
                nodes[0].ticker.queueTimedJob(this, PITCH_BLACK_MITIGATION_FREQUENCY_ONE_DAY);
                LocationManager cfr_ignored_0 = nodes[0].lm;
                Node node = nodes[0];
                LocationManager.setClockForTesting(Clock.offset(node.lm.getClockForTesting(), Duration.ofDays(1L)));
            }
        };
        nodes[0].ticker.queueTimedJob(dayIncrementingJob, PITCH_BLACK_MITIGATION_FREQUENCY_ONE_DAY);
        LocationManager cfr_ignored_1 = nodes[0].lm;
        LocationManager.PITCH_BLACK_MITIGATION_FREQUENCY_ONE_DAY = PITCH_BLACK_MITIGATION_FREQUENCY_ONE_DAY;
        LocationManager cfr_ignored_2 = nodes[0].lm;
        LocationManager.PITCH_BLACK_MITIGATION_STARTUP_DELAY = PITCH_BLACK_MITIGATION_STARTUP_DELAY;
        for (int i2 = 0; i2 < 300; ++i2) {
            System.err.println("Starting node " + i2);
            nodes[i2].start(false);
        }
        RealNodePitchBlackMitigationTest.waitForAllConnected(nodes);
        RealNodePitchBlackMitigationTest.waitForPingAverage(0.98, nodes, new DummyRandomSource(3143L), 840, 500000);
        System.exit(0);
    }

    public static void attackSpecificNode(double pitchBlackAttackMeanLocation, double pitchBlackAttackJitter, Node nodeToAttack, int indexOfNode) {
        double pitchBlackFakeLocation = pitchBlackAttackMeanLocation + nodeToAttack.fastWeakRandom.nextDouble() * pitchBlackAttackJitter;
        System.err.println("Pitch-Black-Attack on node " + indexOfNode + " using mean " + pitchBlackAttackMeanLocation + " with jitter " + pitchBlackAttackJitter + ": " + pitchBlackFakeLocation);
        nodeToAttack.setLocation(pitchBlackFakeLocation);
        System.err.println("New location of node " + indexOfNode + ": " + nodeToAttack.getLocation());
    }

    static void waitForPingAverage(double accuracy, Node[] nodes, RandomSource random, int maxTests, int sleepTime) throws InterruptedException {
        int totalHopsTaken = 0;
        int cycleNumber = 0;
        int lastSwaps = 0;
        int lastNoSwaps = 0;
        int failures = 0;
        int successes = 0;
        SimpleRunningAverage avg = new SimpleRunningAverage(100, 0.0);
        BootstrappingDecayingRunningAverage avg2 = new BootstrappingDecayingRunningAverage(0.0, 0.0, 1.0, 100, null);
        int pings = 0;
        for (int total = 0; total < maxTests; ++total) {
            int i;
            ++cycleNumber;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            for (int i2 = 0; i2 < nodes.length; ++i2) {
                System.err.println("Cycle " + cycleNumber + " node " + i2 + ": " + nodes[i2].getLocation() + " degree: " + nodes[i2].getPeerNodes().length + " locs: " + Arrays.stream(nodes[i2].getPeerNodes()).map(PeerNode::getLocation).collect(Collectors.summarizingDouble(d -> d)));
            }
            int newSwaps = LocationManager.swaps;
            int totalStarted = LocationManager.startedSwaps;
            int noSwaps = LocationManager.noSwaps;
            System.err.println("Swaps: " + (newSwaps - lastSwaps));
            System.err.println("\nTotal swaps: Started*2: " + totalStarted * 2 + ", succeeded: " + newSwaps + ", last minute failures: " + noSwaps + ", ratio " + (double)noSwaps / (double)newSwaps + ", early failures: " + (totalStarted * 2 - (noSwaps + newSwaps)));
            System.err.println("This cycle ratio: " + (double)(noSwaps - lastNoSwaps) / (double)(newSwaps - lastSwaps));
            lastNoSwaps = noSwaps;
            System.err.println("Swaps rejected (already locked): " + LocationManager.swapsRejectedAlreadyLocked);
            System.err.println("Swaps rejected (nowhere to go): " + LocationManager.swapsRejectedNowhereToGo);
            System.err.println("Swaps rejected (rate limit): " + LocationManager.swapsRejectedRateLimit);
            System.err.println("Swaps rejected (recognized ID):" + LocationManager.swapsRejectedRecognizedID);
            System.err.println("Swaps failed:" + LocationManager.noSwaps);
            System.err.println("Swaps succeeded:" + LocationManager.swaps);
            double totalSwapInterval = 0.0;
            double totalSwapTime = 0.0;
            for (i = 0; i < nodes.length; ++i) {
                totalSwapInterval += (double)nodes[i].lm.getSendSwapInterval();
                totalSwapTime += (double)nodes[i].lm.getAverageSwapTime();
            }
            System.err.println("Average swap time: " + totalSwapTime / (double)nodes.length);
            System.err.println("Average swap sender interval: " + totalSwapInterval / (double)nodes.length);
            RealNodePitchBlackMitigationTest.waitForAllConnected(nodes);
            lastSwaps = newSwaps;
            for (i = 0; i < 10; ++i) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    double ratio;
                    Node randomNode;
                    Node randomNode2 = randomNode = nodes[random.nextInt(nodes.length)];
                    while (randomNode2 == randomNode) {
                        randomNode2 = nodes[random.nextInt(nodes.length)];
                    }
                    double loc2 = randomNode2.getLocation();
                    Logger.normal(RealNodePitchBlackMitigationTest.class, "Pinging " + randomNode2.getDarknetPortNumber() + " @ " + loc2 + " from " + randomNode.getDarknetPortNumber() + " @ " + randomNode.getLocation());
                    int hopsTaken = randomNode.routedPing(loc2, randomNode2.getDarknetPubKeyHash());
                    ++pings;
                    if (hopsTaken < 0) {
                        avg.report(0.0);
                        avg2.report(0.0);
                        ratio = (double)successes / (double)(++failures + successes);
                        System.err.println("Routed ping " + pings + " FAILED from " + randomNode.getDarknetPortNumber() + " to " + randomNode2.getDarknetPortNumber() + " (long:" + ratio + ", short:" + avg.currentValue() + ", vague:" + avg2.currentValue() + ')');
                        continue;
                    }
                    totalHopsTaken += hopsTaken;
                    avg.report(1.0);
                    avg2.report(1.0);
                    ratio = (double)(++successes) / (double)(failures + successes);
                    System.err.println("Routed ping " + pings + " success: " + hopsTaken + ' ' + randomNode.getDarknetPortNumber() + " to " + randomNode2.getDarknetPortNumber() + " (long:" + ratio + ", short:" + avg.currentValue() + ", vague:" + avg2.currentValue() + ')');
                    continue;
                }
                catch (Throwable t) {
                    Logger.error(RealNodePitchBlackMitigationTest.class, "Caught " + t, t);
                }
            }
            System.err.println("Average path length for successful requests: " + (double)totalHopsTaken / (double)successes);
            if (pings <= 840 && (pings <= 420 || !(avg.currentValue() > accuracy) || !((double)successes / (double)(failures + successes) > accuracy))) continue;
            System.err.println();
            System.err.println("Reached " + accuracy * 100.0 + "% accuracy.");
            System.err.println();
            System.err.println("Network size: " + nodes.length);
            System.err.println("Maximum HTL: 10");
            System.err.println("Average path length for successful requests: " + totalHopsTaken / successes);
            System.err.println("Total started swaps: " + LocationManager.startedSwaps);
            System.err.println("Total rejected swaps (already locked): " + LocationManager.swapsRejectedAlreadyLocked);
            System.err.println("Total swaps rejected (nowhere to go): " + LocationManager.swapsRejectedNowhereToGo);
            System.err.println("Total swaps rejected (rate limit): " + LocationManager.swapsRejectedRateLimit);
            System.err.println("Total swaps rejected (recognized ID):" + LocationManager.swapsRejectedRecognizedID);
            System.err.println("Total swaps failed:" + LocationManager.noSwaps);
            System.err.println("Total swaps succeeded:" + LocationManager.swaps);
            return;
        }
        System.exit(1028);
    }
}

