/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.node.expression;

import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.node.RenderableNode;
import com.mitchellbosecke.pebble.node.expression.UnaryExpression;
import com.mitchellbosecke.pebble.template.EvaluationContextImpl;
import com.mitchellbosecke.pebble.template.PebbleTemplateImpl;
import com.mitchellbosecke.pebble.utils.LimitedSizeWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class RenderableNodeExpression
extends UnaryExpression {
    private final RenderableNode node;
    private final int lineNumber;

    public RenderableNodeExpression(RenderableNode node, int lineNumber) {
        this.node = node;
        this.lineNumber = lineNumber;
    }

    @Override
    public Object evaluate(PebbleTemplateImpl self, EvaluationContextImpl context) {
        Writer writer = LimitedSizeWriter.from(new StringWriter(), context);
        try {
            this.node.render(self, writer, context);
        }
        catch (IOException e) {
            throw new PebbleException(e, "Error occurred while rendering node", this.getLineNumber(), self.getName());
        }
        return writer.toString();
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }
}

