/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.client.async.ClientContext;
import freenet.client.async.PersistenceDisabledException;
import freenet.client.async.PersistentJob;
import freenet.clients.fcp.ClientRequest;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.clients.fcp.ProtocolErrorMessage;
import freenet.node.Node;
import freenet.support.SimpleFieldSet;
import freenet.support.io.NativeThread;

public class GetRequestStatusMessage
extends FCPMessage {
    final String identifier;
    final boolean global;
    final boolean onlyData;
    static final String NAME = "GetRequestStatus";

    public GetRequestStatusMessage(SimpleFieldSet fs) {
        this.identifier = fs.get("Identifier");
        this.global = fs.getBoolean("Global", false);
        this.onlyData = fs.getBoolean("OnlyData", false);
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.putSingle("Identifier", this.identifier);
        return fs;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(final FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        ClientRequest req = handler.getRebootRequest(this.global, handler, this.identifier);
        if (req == null) {
            if (node.clientCore.killedDatabase()) {
                return;
            }
            try {
                node.clientCore.clientContext.jobRunner.queue(new PersistentJob(){

                    @Override
                    public boolean run(ClientContext context) {
                        ClientRequest req = handler.getForeverRequest(GetRequestStatusMessage.this.global, handler, GetRequestStatusMessage.this.identifier);
                        if (req == null) {
                            ProtocolErrorMessage msg = new ProtocolErrorMessage(15, false, null, GetRequestStatusMessage.this.identifier, GetRequestStatusMessage.this.global);
                            handler.send(msg);
                        } else {
                            req.sendPendingMessages(handler.outputHandler, GetRequestStatusMessage.this.identifier, true, GetRequestStatusMessage.this.onlyData);
                        }
                        return false;
                    }
                }, NativeThread.NORM_PRIORITY);
            }
            catch (PersistenceDisabledException e) {
                ProtocolErrorMessage msg = new ProtocolErrorMessage(15, false, null, this.identifier, this.global);
                handler.send(msg);
            }
        } else {
            req.sendPendingMessages(handler.outputHandler, this.identifier, true, this.onlyData);
        }
    }
}

