/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SkipShieldingInputStream
extends FilterInputStream {
    private static final int SKIP_BUFFER_SIZE = 8192;
    private static final byte[] SKIP_BUFFER = new byte[8192];

    public SkipShieldingInputStream(InputStream in) {
        super(in);
    }

    @Override
    public long skip(long n) throws IOException {
        int retval;
        if (n < 0L) {
            retval = 0;
        } else {
            retval = this.read(SKIP_BUFFER, 0, (int)Math.min(n, 8192L));
            if (retval < 0) {
                retval = 0;
            }
        }
        return retval;
    }
}

