/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.config.InvalidConfigValueException;
import freenet.l10n.NodeL10n;
import freenet.support.api.StringCallback;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;

public class ProgramDirectory {
    protected File dir = null;
    protected final HashSet<String> files = new HashSet();
    private final StringCallback callback;
    private final String moveErrMsg;
    private static int sortOrder = 0;

    protected static synchronized int nextOrder() {
        return sortOrder++;
    }

    public ProgramDirectory() {
        this(null);
    }

    public ProgramDirectory(String moveErrMsg) {
        this.moveErrMsg = moveErrMsg;
        this.callback = moveErrMsg != null ? new RWDirectoryCallback() : new DirectoryCallback();
    }

    public void move(String file) throws IOException {
        File dir = new File(file);
        if (this.dir != null && !dir.equals(this.dir)) {
            throw new IOException("move not implemented");
        }
        if (!(dir.exists() && dir.isDirectory() || dir.mkdir())) {
            throw new IOException("Could not find or make a directory called: " + ProgramDirectory.l10n(file));
        }
        this.dir = dir;
    }

    public StringCallback getStringCallback() {
        return this.callback;
    }

    public File file(String base) {
        this.files.add(base);
        return new File(this.dir, base);
    }

    public File dir() {
        return this.dir;
    }

    private static String l10n(String key) {
        return NodeL10n.getBase().getString(key);
    }

    public class RWDirectoryCallback
    extends DirectoryCallback {
        @Override
        public void set(String val) throws InvalidConfigValueException {
            if (ProgramDirectory.this.dir == null) {
                ProgramDirectory.this.dir = new File(val);
                return;
            }
            if (ProgramDirectory.this.dir.equals(new File(val))) {
                return;
            }
            File f = new File(val);
            if (!(f.exists() && f.isDirectory() || f.mkdir())) {
                throw new InvalidConfigValueException(ProgramDirectory.l10n(ProgramDirectory.this.moveErrMsg));
            }
            ProgramDirectory.this.dir = new File(val);
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }
    }

    public class DirectoryCallback
    extends StringCallback {
        @Override
        public String get() {
            return ProgramDirectory.this.dir.getPath();
        }

        @Override
        public void set(String val) throws InvalidConfigValueException {
            if (ProgramDirectory.this.dir == null) {
                ProgramDirectory.this.dir = new File(val);
                return;
            }
            if (ProgramDirectory.this.dir.equals(new File(val))) {
                return;
            }
            throw new InvalidConfigValueException("Moving program directory on the fly not supported at present");
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }
    }
}

