/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.client.async.ClientContext;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.LockableRandomAccessBuffer;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.FileDoesNotExistException;
import freenet.support.io.FileExistsException;
import freenet.support.io.FileUtil;
import freenet.support.io.NullInputStream;
import freenet.support.io.PooledFileRandomAccessBuffer;
import freenet.support.io.ReadOnlyFileSliceBucket;
import freenet.support.io.ResumeFailedException;
import freenet.support.io.StorageFormatException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Vector;
import org.tanukisoftware.wrapper.WrapperManager;

public abstract class BaseFileBucket
implements RandomAccessBucket {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    protected long fileRestartCounter;
    private boolean freed;
    private transient Vector<Closeable> streams;
    protected static String tempDir;
    public static final int MAGIC = -994618563;
    static final int VERSION = 1;

    public BaseFileBucket(File file, boolean deleteOnExit) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.maybeSetDeleteOnExit(deleteOnExit, file);
        assert (!this.createFileOnly() || !this.tempFileAlreadyExists());
    }

    protected BaseFileBucket() {
    }

    private void maybeSetDeleteOnExit(boolean deleteOnExit, File file) {
        if (deleteOnExit) {
            this.setDeleteOnExit(file);
        }
    }

    protected void setDeleteOnExit(File file) {
        try {
            file.deleteOnExit();
        }
        catch (NullPointerException e) {
            if (WrapperManager.hasShutdownHookBeenTriggered()) {
                Logger.normal(this, "NullPointerException setting deleteOnExit while shutting down - buggy JVM code: " + e, (Throwable)e);
            }
            Logger.error(this, "Caught " + e + " doing deleteOnExit() for " + file + " - JVM bug ????");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStreamUnbuffered() throws IOException {
        BaseFileBucket baseFileBucket = this;
        synchronized (baseFileBucket) {
            File file = this.getFile();
            if (this.freed) {
                throw new IOException("File already freed: " + this);
            }
            if (this.isReadOnly()) {
                throw new IOException("Bucket is read-only: " + this);
            }
            if (this.createFileOnly() && this.fileRestartCounter == 0L && !file.createNewFile()) {
                throw new FileExistsException(file);
            }
            if (!(!this.tempFileAlreadyExists() || file.exists() && file.canRead() && file.canWrite())) {
                throw new FileDoesNotExistException(file);
            }
            if (this.streams != null && !this.streams.isEmpty()) {
                Logger.error(this, "Streams open on " + this + " while opening an output stream!: " + this.streams, (Throwable)new Exception("debug"));
            }
            boolean rename = !this.tempFileAlreadyExists();
            File tempfile = rename ? this.getTempfile() : file;
            long streamNumber = ++this.fileRestartCounter;
            FileBucketOutputStream os = new FileBucketOutputStream(tempfile, streamNumber);
            if (logDEBUG) {
                Logger.debug(this, "Creating " + os, (Throwable)new Exception("debug"));
            }
            this.addStream(os);
            return os;
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new BufferedOutputStream(this.getOutputStreamUnbuffered());
    }

    private synchronized void addStream(Closeable stream) {
        if (this.streams == null) {
            this.streams = new Vector(1, 1);
        }
        this.streams.add(stream);
    }

    private synchronized void removeStream(Closeable stream) {
        if (this.streams == null) {
            return;
        }
        this.streams.remove(stream);
        if (this.streams.isEmpty()) {
            this.streams = null;
        }
    }

    protected abstract boolean tempFileAlreadyExists();

    protected abstract boolean createFileOnly();

    protected abstract boolean deleteOnExit();

    protected abstract boolean deleteOnFree();

    protected File getTempfile() throws IOException {
        File file = this.getFile();
        File f = FileUtil.createTempFile(file.getName(), ".freenet-tmp", file.getParentFile());
        if (this.deleteOnExit()) {
            f.deleteOnExit();
        }
        return f;
    }

    @Override
    public synchronized InputStream getInputStreamUnbuffered() throws IOException {
        if (this.freed) {
            throw new IOException("File already freed: " + this);
        }
        File file = this.getFile();
        if (!file.exists()) {
            Logger.normal(this, "File does not exist: " + file + " for " + this);
            return new NullInputStream();
        }
        FileBucketInputStream is = new FileBucketInputStream(file);
        this.addStream(is);
        if (logDEBUG) {
            Logger.debug(this, "Creating " + is, (Throwable)new Exception("debug"));
        }
        return is;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new BufferedInputStream(this.getInputStreamUnbuffered());
    }

    @Override
    public synchronized String getName() {
        return this.getFile().getName();
    }

    @Override
    public synchronized long size() {
        return this.getFile().length();
    }

    protected synchronized void deleteFile() {
        if (logMINOR) {
            Logger.minor(this, "Deleting " + this.getFile() + " for " + this, (Throwable)new Exception("debug"));
        }
        this.getFile().delete();
    }

    public static synchronized String getTempDir() {
        return tempDir;
    }

    public static synchronized void setTempDir(String dirName) {
        File dir = new File(dirName);
        if (!(dir.exists() && dir.isDirectory() && dir.canWrite())) {
            throw new IllegalArgumentException("Bad Temp Directory: " + dir.getAbsolutePath());
        }
        tempDir = dirName;
    }

    public synchronized Bucket[] split(int splitSize) {
        long length = this.size();
        if (length > Integer.MAX_VALUE * (long)splitSize) {
            throw new IllegalArgumentException("Way too big!: " + length + " for " + splitSize);
        }
        int bucketCount = (int)(length / (long)splitSize);
        if (length % (long)splitSize > 0L) {
            ++bucketCount;
        }
        Bucket[] buckets = new Bucket[bucketCount];
        File file = this.getFile();
        for (int i = 0; i < buckets.length; ++i) {
            long startAt = 1L * (long)i * (long)splitSize;
            long endAt = Math.min(startAt + (long)splitSize * 1L, length);
            long len = endAt - startAt;
            buckets[i] = new ReadOnlyFileSliceBucket(file, startAt, len);
        }
        return buckets;
    }

    @Override
    public void free() {
        this.free(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(boolean forceFree) {
        if (logMINOR) {
            Logger.minor(this, "Freeing " + this, (Throwable)new Exception("debug"));
        }
        Object[] objectArray = this;
        synchronized (this) {
            if (this.freed) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            this.freed = true;
            Object[] toClose = this.streams == null ? null : this.streams.toArray(new Closeable[this.streams.size()]);
            this.streams = null;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (toClose != null) {
                Logger.error(this, "Streams open free()ing " + this + " : " + Arrays.toString(toClose), (Throwable)new Exception("debug"));
                for (Object strm : toClose) {
                    try {
                        strm.close();
                    }
                    catch (IOException e) {
                        Logger.error(this, "Caught closing stream in free(): " + e, (Throwable)e);
                    }
                    catch (Throwable t) {
                        Logger.error(this, "Caught closing stream in free(): " + t, t);
                    }
                }
            }
            File file = this.getFile();
            if ((this.deleteOnFree() || forceFree) && file.exists()) {
                Logger.debug(this, "Deleting bucket " + file, (Throwable)new Exception("debug"));
                this.deleteFile();
                if (file.exists()) {
                    Logger.error(this, "Delete failed on bucket " + file, (Throwable)new Exception("debug"));
                }
            }
            return;
        }
    }

    public synchronized String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append(':');
        File f = this.getFile();
        if (f != null) {
            sb.append(f.getPath());
        } else {
            sb.append("???");
        }
        sb.append(":streams=");
        sb.append(this.streams == null ? 0 : this.streams.size());
        return sb.toString();
    }

    public abstract File getFile();

    @Override
    public void onResume(ClientContext context) throws ResumeFailedException {
    }

    @Override
    public void storeTo(DataOutputStream dos) throws IOException {
        dos.writeInt(-994618563);
        dos.writeInt(1);
        dos.writeBoolean(this.freed);
    }

    protected BaseFileBucket(DataInputStream dis) throws IOException, StorageFormatException {
        int magic = dis.readInt();
        if (magic != -994618563) {
            throw new StorageFormatException("Bad magic");
        }
        int version = dis.readInt();
        if (version != 1) {
            throw new StorageFormatException("Bad version");
        }
        this.freed = dis.readBoolean();
    }

    @Override
    public LockableRandomAccessBuffer toRandomAccessBuffer() throws IOException {
        if (this.freed) {
            throw new IOException("Already freed");
        }
        this.setReadOnly();
        long size = this.size();
        if (size == 0L) {
            throw new IOException("Must not be empty");
        }
        return new PooledFileRandomAccessBuffer(this.getFile(), true, size, null, this.getPersistentTempID(), this.deleteOnFree());
    }

    protected long getPersistentTempID() {
        return -1L;
    }

    static {
        String os;
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
        tempDir = null;
        tempDir = System.getProperty("java.io.tmpdir");
        if (tempDir == null && (os = System.getProperty("os.name")) != null) {
            String[] candidates = null;
            if (os.equalsIgnoreCase("Linux") || os.equalsIgnoreCase("FreeBSD")) {
                String[] linuxCandidates;
                candidates = linuxCandidates = new String[]{"/tmp", "/var/tmp"};
            } else if (os.equalsIgnoreCase("Windows")) {
                String[] windowsCandidates = new String[]{"C:\\TEMP", "C:\\WINDOWS\\TEMP"};
                candidates = windowsCandidates;
            }
            if (candidates != null) {
                for (String candidate : candidates) {
                    File path = new File(candidate);
                    if (!path.exists() || !path.isDirectory() || !path.canWrite()) continue;
                    tempDir = candidate;
                    break;
                }
            }
        }
        if (tempDir == null) {
            tempDir = System.getProperty("user.dir");
        }
    }

    class FileBucketInputStream
    extends FileInputStream {
        boolean closed;

        public FileBucketInputStream(File f) throws IOException {
            super(f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            FileBucketInputStream fileBucketInputStream = this;
            synchronized (fileBucketInputStream) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            BaseFileBucket.this.removeStream(this);
            super.close();
        }

        public String toString() {
            return super.toString() + ":" + BaseFileBucket.this.toString();
        }
    }

    class FileBucketOutputStream
    extends FileOutputStream {
        private long restartCount;
        private File tempfile;
        private boolean closed;

        protected FileBucketOutputStream(File tempfile, long restartCount) throws FileNotFoundException {
            super(tempfile, false);
            if (logMINOR) {
                Logger.minor(FileBucketOutputStream.class, "Writing to " + tempfile + " for " + BaseFileBucket.this.getFile() + " : " + this);
            }
            this.tempfile = tempfile;
            this.restartCount = restartCount;
            this.closed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void confirmWriteSynchronized() throws IOException {
            BaseFileBucket baseFileBucket = BaseFileBucket.this;
            synchronized (baseFileBucket) {
                if (BaseFileBucket.this.fileRestartCounter > this.restartCount) {
                    throw new IllegalStateException("writing to file after restart");
                }
                if (BaseFileBucket.this.freed) {
                    throw new IOException("writing to file after it has been freed");
                }
            }
            if (BaseFileBucket.this.isReadOnly()) {
                throw new IOException("File is read-only");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b) throws IOException {
            BaseFileBucket baseFileBucket = BaseFileBucket.this;
            synchronized (baseFileBucket) {
                this.confirmWriteSynchronized();
                super.write(b);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            BaseFileBucket baseFileBucket = BaseFileBucket.this;
            synchronized (baseFileBucket) {
                this.confirmWriteSynchronized();
                super.write(b, off, len);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            BaseFileBucket baseFileBucket = BaseFileBucket.this;
            synchronized (baseFileBucket) {
                this.confirmWriteSynchronized();
                super.write(b);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            File file;
            FileBucketOutputStream fileBucketOutputStream = this;
            synchronized (fileBucketOutputStream) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                file = BaseFileBucket.this.getFile();
            }
            boolean renaming = !BaseFileBucket.this.tempFileAlreadyExists();
            BaseFileBucket.this.removeStream(this);
            if (logMINOR) {
                Logger.minor(this, "Closing " + BaseFileBucket.this);
            }
            try {
                super.close();
            }
            catch (IOException e) {
                if (logMINOR) {
                    Logger.minor(this, "Failed closing " + BaseFileBucket.this + " : " + e, (Throwable)e);
                }
                if (renaming) {
                    this.tempfile.delete();
                }
                throw e;
            }
            if (renaming && !FileUtil.renameTo(this.tempfile, file)) {
                this.tempfile.delete();
                if (logMINOR) {
                    Logger.minor(this, "Deleted, cannot rename file for " + this);
                }
                throw new IOException("Cannot rename file");
            }
        }

        public String toString() {
            return super.toString() + ":" + BaseFileBucket.this.toString();
        }
    }
}

