/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.ConnectionsToadlet;
import freenet.clients.http.DarknetConnectionsToadlet;
import freenet.clients.http.PageMaker;
import freenet.clients.http.PageNode;
import freenet.clients.http.RedirectException;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.l10n.NodeL10n;
import freenet.node.Node;
import freenet.node.NodeFile;
import freenet.support.HTMLNode;
import freenet.support.SimpleFieldSet;
import freenet.support.api.HTTPRequest;
import freenet.support.io.FileBucket;
import java.io.File;
import java.io.IOException;
import java.net.URI;

public class DarknetAddRefToadlet
extends Toadlet {
    private final Node node;
    private final DarknetConnectionsToadlet friendsToadlet;
    static final String PATH = "/addfriend/";

    protected DarknetAddRefToadlet(Node n, HighLevelSimpleClient client, DarknetConnectionsToadlet friendsToadlet) {
        super(client);
        this.node = n;
        this.friendsToadlet = friendsToadlet;
    }

    @Override
    public void handleMethodGET(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        File installer;
        if (!ctx.checkFullAccess(this)) {
            return;
        }
        String path = uri.getPath();
        if (path.endsWith(NodeFile.InstallerWindows.getFilename()) && (installer = this.node.nodeUpdater.getInstallerWindows()) != null) {
            FileBucket bucket = new FileBucket(installer, true, false, false, false);
            this.writeReply(ctx, 200, "application/x-msdownload", "OK", bucket);
            return;
        }
        if (path.endsWith(NodeFile.InstallerNonWindows.getFilename()) && (installer = this.node.nodeUpdater.getInstallerNonWindows()) != null) {
            FileBucket bucket = new FileBucket(installer, true, false, false, false);
            this.writeReply(ctx, 200, "application/x-java-archive", "OK", bucket);
            return;
        }
        PageMaker pageMaker = ctx.getPageMaker();
        PageNode page = pageMaker.getPageNode(DarknetAddRefToadlet.l10n("title"), ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        contentNode.addChild(ctx.getAlertManager().createSummary());
        HTMLNode boxContent = pageMaker.getInfobox("infobox-information", DarknetAddRefToadlet.l10n("explainBoxTitle"), contentNode, "darknet-explanations", true);
        boxContent.addChild("p", DarknetAddRefToadlet.l10n("explainBox1"));
        boxContent.addChild("p", DarknetAddRefToadlet.l10n("explainBox2"));
        File installer2 = this.node.nodeUpdater.getInstallerWindows();
        String shortFilename = NodeFile.InstallerWindows.getFilename();
        HTMLNode p = boxContent.addChild("p");
        if (installer2 != null) {
            NodeL10n.getBase().addL10nSubstitution(p, "DarknetAddRefToadlet.explainInstallerWindows", new String[]{"filename", "get-windows"}, new HTMLNode[]{HTMLNode.text(installer2.getCanonicalPath()), HTMLNode.link(this.path() + shortFilename)});
        } else {
            NodeL10n.getBase().addL10nSubstitution(p, "DarknetAddRefToadlet.explainInstallerWindowsNotYet", new String[]{"link"}, new HTMLNode[]{HTMLNode.link("/" + this.node.nodeUpdater.getInstallerWindowsURI().toString())});
        }
        installer2 = this.node.nodeUpdater.getInstallerNonWindows();
        shortFilename = NodeFile.InstallerNonWindows.getFilename();
        boxContent.addChild("#", " ");
        p = boxContent.addChild("p");
        if (installer2 != null) {
            NodeL10n.getBase().addL10nSubstitution(p, "DarknetAddRefToadlet.explainInstallerNonWindows", new String[]{"filename", "get-nonwindows", "shortfilename"}, new HTMLNode[]{HTMLNode.text(installer2.getCanonicalPath()), HTMLNode.link(this.path() + shortFilename), HTMLNode.text(shortFilename)});
        } else {
            NodeL10n.getBase().addL10nSubstitution(p, "DarknetAddRefToadlet.explainInstallerNonWindowsNotYet", new String[]{"link", "shortfilename"}, new HTMLNode[]{HTMLNode.link("/" + this.node.nodeUpdater.getInstallerNonWindowsURI().toString()), HTMLNode.text(shortFilename)});
        }
        ConnectionsToadlet.drawAddPeerBox(contentNode, ctx, false, this.friendsToadlet.path());
        this.friendsToadlet.drawNoderefBox(contentNode, this.getNoderef());
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    protected SimpleFieldSet getNoderef() {
        return this.node.exportDarknetPublicFieldSet();
    }

    private static String l10n(String string) {
        return NodeL10n.getBase().getString("DarknetAddRefToadlet." + string);
    }

    @Override
    public String path() {
        return PATH;
    }
}

