/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.client.InsertContext;
import freenet.client.filter.FilterOperation;
import freenet.clients.http.ContentFilterToadlet;
import freenet.clients.http.InfoboxNode;
import freenet.clients.http.LinkEnabledCallback;
import freenet.clients.http.PageMaker;
import freenet.clients.http.PageNode;
import freenet.clients.http.RedirectException;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.l10n.NodeL10n;
import freenet.node.NodeClientCore;
import freenet.node.SecurityLevels;
import freenet.support.HTMLNode;
import freenet.support.api.HTTPRequest;
import java.io.IOException;
import java.net.URI;

public class FileInsertWizardToadlet
extends Toadlet
implements LinkEnabledCallback {
    final NodeClientCore core;
    private boolean rememberedLastTime;
    private boolean wasCanonicalLastTime;
    static final String PATH = "/insertfile/";

    protected FileInsertWizardToadlet(HighLevelSimpleClient client, NodeClientCore clientCore) {
        super(client);
        this.core = clientCore;
    }

    @Override
    public String path() {
        return PATH;
    }

    public void reportCanonicalInsert() {
        this.rememberedLastTime = true;
        this.wasCanonicalLastTime = true;
    }

    public void reportRandomInsert() {
        this.rememberedLastTime = true;
        this.wasCanonicalLastTime = false;
    }

    @Override
    public void handleMethodGET(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        if (this.container.publicGatewayMode() && !ctx.isAllowedFullAccess()) {
            this.sendUnauthorizedPage(ctx);
            return;
        }
        PageMaker pageMaker = ctx.getPageMaker();
        PageNode page = pageMaker.getPageNode(this.l10n("pageTitle"), ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        if (ctx.isAllowedFullAccess()) {
            contentNode.addChild(ctx.getAlertManager().createSummary());
        }
        contentNode.addChild(this.createInsertBox(pageMaker, ctx, ctx.isAdvancedModeEnabled()));
        if (ctx.isAdvancedModeEnabled()) {
            contentNode.addChild(this.createFilterBox(pageMaker, ctx));
        }
        this.writeHTMLReply(ctx, 200, "OK", null, pageNode.generate());
    }

    private HTMLNode createInsertBox(PageMaker pageMaker, ToadletContext ctx, boolean isAdvancedModeEnabled) {
        InfoboxNode infobox = pageMaker.getInfobox(NodeL10n.getBase().getString("QueueToadlet.insertFile"), "insert-queue", true);
        HTMLNode insertBox = infobox.outer;
        HTMLNode insertContent = infobox.content;
        insertContent.addChild("p", this.l10n("insertIntro"));
        SecurityLevels.NETWORK_THREAT_LEVEL seclevel = this.core.node.securityLevels.getNetworkThreatLevel();
        HTMLNode insertForm = ctx.addFormChild(insertContent, "/uploads/", "queueInsertForm");
        boolean preselectSsk = !this.rememberedLastTime && seclevel != SecurityLevels.NETWORK_THREAT_LEVEL.LOW || this.rememberedLastTime && !this.wasCanonicalLastTime || seclevel == SecurityLevels.NETWORK_THREAT_LEVEL.MAXIMUM;
        HTMLNode input = insertForm.addChild("input", new String[]{"type", "name", "value", "id"}, new String[]{"radio", "keytype", "CHK", "keytypeChk"});
        if (!preselectSsk) {
            input.addAttribute("checked", "checked");
        }
        insertForm.addChild("label", new String[]{"for"}, new String[]{"keytypeChk"}).addChild("b", this.l10n("insertCanonicalTitle"));
        insertForm.addChild("#", ": " + this.l10n("insertCanonical"));
        if (isAdvancedModeEnabled) {
            insertForm.addChild("#", " " + this.l10n("insertCanonicalAdvanced"));
        }
        insertForm.addChild("br");
        input = insertForm.addChild("input", new String[]{"type", "name", "value", "id"}, new String[]{"radio", "keytype", "SSK", "keytypeSsk"});
        if (preselectSsk) {
            input.addAttribute("checked", "checked");
        }
        insertForm.addChild("label", new String[]{"for"}, new String[]{"keytypeSsk"}).addChild("b", this.l10n("insertRandomTitle"));
        insertForm.addChild("#", ": " + this.l10n("insertRandom"));
        if (isAdvancedModeEnabled) {
            insertForm.addChild("#", " " + this.l10n("insertRandomAdvanced"));
        }
        if (isAdvancedModeEnabled) {
            insertForm.addChild("br");
            insertForm.addChild("input", new String[]{"type", "name", "value", "id"}, new String[]{"radio", "keytype", "specify", "keytypeSpecify"});
            insertForm.addChild("label", new String[]{"for"}, new String[]{"keytypeSpecify"}).addChild("b", this.l10n("insertSpecificKeyTitle"));
            insertForm.addChild("#", ": " + this.l10n("insertSpecificKey") + " ");
            insertForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"text", "key", "KSK@"});
        }
        if (isAdvancedModeEnabled) {
            insertForm.addChild("br");
            insertForm.addChild("br");
            insertForm.addChild("input", new String[]{"type", "name", "checked", "id"}, new String[]{"checkbox", "compress", "checked", "checkboxCompress"});
            insertForm.addChild("label", new String[]{"for"}, new String[]{"checkboxCompress"}, ' ' + NodeL10n.getBase().getString("QueueToadlet.insertFileCompressLabel"));
        } else {
            insertForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "compress", "true"});
        }
        if (isAdvancedModeEnabled) {
            insertForm.addChild("br");
            insertForm.addChild("#", NodeL10n.getBase().getString("QueueToadlet.compatModeLabel") + ": ");
            HTMLNode select = insertForm.addChild("select", "name", "compatibilityMode");
            for (InsertContext.CompatibilityMode mode : InsertContext.CompatibilityMode.values()) {
                if (mode == InsertContext.CompatibilityMode.COMPAT_UNKNOWN) continue;
                HTMLNode option = select.addChild("option", "value", mode.name(), NodeL10n.getBase().getString("InsertContext.CompatibilityMode." + mode.name()));
                if (mode != InsertContext.CompatibilityMode.COMPAT_DEFAULT) continue;
                option.addAttribute("selected", "");
            }
            insertForm.addChild("br");
            insertForm.addChild("#", this.l10n("splitfileCryptoKeyLabel") + ": ");
            insertForm.addChild("input", new String[]{"type", "name", "maxlength"}, new String[]{"text", "overrideSplitfileKey", "64"});
        }
        insertForm.addChild("br");
        insertForm.addChild("br");
        if (ctx.isAllowedFullAccess()) {
            insertForm.addChild("#", NodeL10n.getBase().getString("QueueToadlet.insertFileBrowseLabel") + ": ");
            insertForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "insert-local", NodeL10n.getBase().getString("QueueToadlet.insertFileBrowseButton") + "..."});
            insertForm.addChild("br");
        }
        insertForm.addChild("#", NodeL10n.getBase().getString("QueueToadlet.insertFileLabel") + ": ");
        insertForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"file", "filename", ""});
        insertForm.addChild("#", " \u00a0 ");
        insertForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "insert", NodeL10n.getBase().getString("QueueToadlet.insertFileInsertFileLabel")});
        insertForm.addChild("#", " \u00a0 ");
        return insertBox;
    }

    private HTMLNode createFilterBox(PageMaker pageMaker, ToadletContext ctx) {
        InfoboxNode infobox = pageMaker.getInfobox(this.l10n("previewFilterFile"), "insert-queue", true);
        HTMLNode insertBox = infobox.outer;
        HTMLNode insertContent = infobox.content;
        HTMLNode insertForm = ctx.addFormChild(insertContent, "/filterfile/", "filterPreviewForm");
        insertForm.addChild("#", this.l10n("filterFileLabel"));
        insertForm.addChild("br");
        insertForm.addChild("br");
        insertForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "filter-operation", FilterOperation.BOTH.toString()});
        insertForm.addChild("input", new String[]{"type", "name", "value", "id"}, new String[]{"radio", "result-handling", ContentFilterToadlet.ResultHandling.DISPLAY.toString(), "resHandlingDisplay"});
        insertForm.addChild("label", new String[]{"for"}, new String[]{"resHandlingDisplay"}, ContentFilterToadlet.l10n("displayResultLabel"));
        insertForm.addChild("br");
        insertForm.addChild("input", new String[]{"type", "name", "value", "id"}, new String[]{"radio", "result-handling", ContentFilterToadlet.ResultHandling.SAVE.toString(), "resHandlingSave"});
        insertForm.addChild("label", new String[]{"for"}, new String[]{"resHandlingSave"}, ContentFilterToadlet.l10n("saveResultLabel"));
        insertForm.addChild("br");
        insertForm.addChild("br");
        insertForm.addChild("#", ContentFilterToadlet.l10n("mimeTypeLabel") + ": ");
        insertForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"text", "mime-type", ""});
        insertForm.addChild("br");
        insertForm.addChild("#", ContentFilterToadlet.l10n("mimeTypeText"));
        insertForm.addChild("br");
        insertForm.addChild("br");
        if (ctx.isAllowedFullAccess()) {
            insertForm.addChild("#", NodeL10n.getBase().getString("QueueToadlet.insertFileBrowseLabel") + ": ");
            insertForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "filter-local", NodeL10n.getBase().getString("QueueToadlet.insertFileBrowseButton") + "..."});
            insertForm.addChild("br");
        }
        insertForm.addChild("#", NodeL10n.getBase().getString("QueueToadlet.insertFileLabel") + ": ");
        insertForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"file", "filename", ""});
        insertForm.addChild("#", " \u00a0 ");
        insertForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "filter-upload", ContentFilterToadlet.l10n("filterFileFilterLabel")});
        return insertBox;
    }

    String l10n(String key) {
        return NodeL10n.getBase().getString("FileInsertWizardToadlet." + key);
    }

    String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("FileInsertWizardToadlet." + key, pattern, value);
    }

    @Override
    public boolean isEnabled(ToadletContext ctx) {
        return !this.container.publicGatewayMode() || ctx != null && ctx.isAllowedFullAccess();
    }
}

