/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.HashResult;
import freenet.crypt.HashType;
import freenet.support.HexUtil;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import net.i2p.util.NativeBigInteger;

public final class Hash {
    private final HashType type;
    private MessageDigest digest;

    public Hash(HashType type) {
        this.type = type;
        this.digest = type.get();
    }

    public final byte[] genHash() {
        byte[] result = this.digest.digest();
        if (this.type == HashType.ED2K) {
            this.digest.reset();
        } else if (this.type == HashType.TTH) {
            this.digest = this.type.get();
        }
        return result;
    }

    public final byte[] genHash(byte[] ... input) {
        this.digest.reset();
        this.addBytes(input);
        return this.genHash();
    }

    public final HashResult genHashResult() {
        return new HashResult(this.type, this.genHash());
    }

    public final HashResult genHashResult(byte[] ... input) {
        this.digest.reset();
        this.addBytes(input);
        return this.genHashResult();
    }

    public final String genHexHash() {
        return HexUtil.bytesToHex(this.genHash());
    }

    public final NativeBigInteger genNativeBigIntegerHash() {
        return new NativeBigInteger(1, this.genHash());
    }

    public final NativeBigInteger genNativeBigIntegerHash(byte[] ... data) {
        this.digest.reset();
        this.addBytes(data);
        return this.genNativeBigIntegerHash();
    }

    public final void addByte(byte input) {
        this.digest.update(input);
    }

    public final void addBytes(byte[] ... input) {
        for (byte[] b : input) {
            this.digest.update(b);
        }
    }

    public final void addBytes(ByteBuffer input) {
        this.digest.update(input);
    }

    public final void addBytes(byte[] input, int offset, int len) {
        this.digest.update(input, offset, len);
    }

    public final boolean verify(byte[] hash, byte[] ... data) {
        return MessageDigest.isEqual(hash, this.genHash(data));
    }

    public static final boolean verify(HashResult hash1, HashResult hash2) {
        return hash1.equals(hash2);
    }

    public static final boolean verify(HashResult hash, byte[] ... input) {
        HashType type = hash.type;
        Hash h = new Hash(type);
        return Hash.verify(hash, new HashResult(type, h.genHash(input)));
    }
}

