/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.keys.NodeCHK;
import freenet.node.InsertTag;
import freenet.node.OfferReplyTag;
import freenet.node.PeerManager;
import freenet.node.PeerNode;
import freenet.node.RequestSender;
import freenet.node.RequestTag;
import freenet.node.UIDTag;
import freenet.support.Logger;
import freenet.support.Ticker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class RequestTracker {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private final HashMap<Long, RequestTag> runningCHKGetUIDsBulk;
    private final HashMap<Long, RequestTag> runningLocalCHKGetUIDsBulk;
    private final HashMap<Long, RequestTag> runningSSKGetUIDsBulk;
    private final HashMap<Long, RequestTag> runningLocalSSKGetUIDsBulk;
    private final HashMap<Long, InsertTag> runningCHKPutUIDsBulk;
    private final HashMap<Long, InsertTag> runningLocalCHKPutUIDsBulk;
    private final HashMap<Long, InsertTag> runningSSKPutUIDsBulk;
    private final HashMap<Long, InsertTag> runningLocalSSKPutUIDsBulk;
    private final HashMap<Long, OfferReplyTag> runningCHKOfferReplyUIDsBulk;
    private final HashMap<Long, OfferReplyTag> runningSSKOfferReplyUIDsBulk;
    private final HashMap<Long, RequestTag> runningCHKGetUIDsRT;
    private final HashMap<Long, RequestTag> runningLocalCHKGetUIDsRT;
    private final HashMap<Long, RequestTag> runningSSKGetUIDsRT;
    private final HashMap<Long, RequestTag> runningLocalSSKGetUIDsRT;
    private final HashMap<Long, InsertTag> runningCHKPutUIDsRT;
    private final HashMap<Long, InsertTag> runningLocalCHKPutUIDsRT;
    private final HashMap<Long, InsertTag> runningSSKPutUIDsRT;
    private final HashMap<Long, InsertTag> runningLocalSSKPutUIDsRT;
    private final HashMap<Long, OfferReplyTag> runningCHKOfferReplyUIDsRT;
    private final HashMap<Long, OfferReplyTag> runningSSKOfferReplyUIDsRT;
    private final PeerManager peers;
    private final Ticker ticker;
    private final HashMap<NodeCHK, RequestSender> transferringRequestSendersRT;
    private final HashMap<NodeCHK, RequestSender> transferringRequestSendersBulk;
    private final HashSet<Long> transferringRequestHandlers;
    static final long TIMEOUT;
    private Runnable deadUIDChecker = new Runnable(){

        @Override
        public void run() {
            try {
                this.checkUIDs(RequestTracker.this.runningSSKGetUIDsRT);
                this.checkUIDs(RequestTracker.this.runningCHKGetUIDsRT);
                this.checkUIDs(RequestTracker.this.runningSSKPutUIDsRT);
                this.checkUIDs(RequestTracker.this.runningCHKPutUIDsRT);
                this.checkUIDs(RequestTracker.this.runningSSKOfferReplyUIDsRT);
                this.checkUIDs(RequestTracker.this.runningCHKOfferReplyUIDsRT);
                this.checkUIDs(RequestTracker.this.runningSSKGetUIDsBulk);
                this.checkUIDs(RequestTracker.this.runningCHKGetUIDsBulk);
                this.checkUIDs(RequestTracker.this.runningSSKPutUIDsBulk);
                this.checkUIDs(RequestTracker.this.runningCHKPutUIDsBulk);
                this.checkUIDs(RequestTracker.this.runningSSKOfferReplyUIDsBulk);
                this.checkUIDs(RequestTracker.this.runningCHKOfferReplyUIDsBulk);
            }
            finally {
                RequestTracker.this.ticker.queueTimedJob(this, TimeUnit.SECONDS.toMillis(60L));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkUIDs(HashMap<Long, ? extends UIDTag> map) {
            UIDTag[] tags;
            Long[] uids;
            HashMap<Long, ? extends UIDTag> hashMap = map;
            synchronized (hashMap) {
                uids = map.keySet().toArray(new Long[map.size()]);
                tags = map.values().toArray(new UIDTag[map.size()]);
            }
            long now = System.currentTimeMillis();
            for (int i = 0; i < uids.length; ++i) {
                tags[i].maybeLogStillPresent(now, uids[i]);
            }
        }
    };
    private ArrayList<Long> completedBuffer = new ArrayList();
    static final int COMPLETED_THRESHOLD = 128;

    RequestTracker(PeerManager peers, Ticker ticker) {
        this.peers = peers;
        this.ticker = ticker;
        this.runningCHKGetUIDsRT = new HashMap();
        this.runningLocalCHKGetUIDsRT = new HashMap();
        this.runningSSKGetUIDsRT = new HashMap();
        this.runningLocalSSKGetUIDsRT = new HashMap();
        this.runningCHKPutUIDsRT = new HashMap();
        this.runningLocalCHKPutUIDsRT = new HashMap();
        this.runningSSKPutUIDsRT = new HashMap();
        this.runningLocalSSKPutUIDsRT = new HashMap();
        this.runningCHKOfferReplyUIDsRT = new HashMap();
        this.runningSSKOfferReplyUIDsRT = new HashMap();
        this.runningCHKGetUIDsBulk = new HashMap();
        this.runningLocalCHKGetUIDsBulk = new HashMap();
        this.runningSSKGetUIDsBulk = new HashMap();
        this.runningLocalSSKGetUIDsBulk = new HashMap();
        this.runningCHKPutUIDsBulk = new HashMap();
        this.runningLocalCHKPutUIDsBulk = new HashMap();
        this.runningSSKPutUIDsBulk = new HashMap();
        this.runningLocalSSKPutUIDsBulk = new HashMap();
        this.runningCHKOfferReplyUIDsBulk = new HashMap();
        this.runningSSKOfferReplyUIDsBulk = new HashMap();
        this.transferringRequestSendersRT = new HashMap();
        this.transferringRequestSendersBulk = new HashMap();
        this.transferringRequestHandlers = new HashSet();
    }

    public boolean lockUID(UIDTag tag) {
        return this.lockUID(tag.uid, tag.isSSK(), tag.isInsert(), tag.isOfferReply(), tag.wasLocal(), tag.realTimeFlag, tag);
    }

    public boolean lockUID(long uid, boolean ssk, boolean insert, boolean offerReply, boolean local, boolean realTimeFlag, UIDTag tag) {
        if (offerReply) {
            HashMap<Long, OfferReplyTag> map = this.getOfferTracker(ssk, realTimeFlag);
            return this.innerLock(map, null, (OfferReplyTag)tag, uid, ssk, insert, offerReply, false);
        }
        if (insert) {
            HashMap<Long, InsertTag> overallMap = this.getInsertTracker(ssk, false, realTimeFlag);
            HashMap<Long, InsertTag> localMap = local ? this.getInsertTracker(ssk, local, realTimeFlag) : null;
            return this.innerLock(overallMap, localMap, (InsertTag)tag, uid, ssk, insert, offerReply, local);
        }
        HashMap<Long, RequestTag> overallMap = this.getRequestTracker(ssk, false, realTimeFlag);
        HashMap<Long, RequestTag> localMap = local ? this.getRequestTracker(ssk, local, realTimeFlag) : null;
        return this.innerLock(overallMap, localMap, (RequestTag)tag, uid, ssk, insert, offerReply, local);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends UIDTag> boolean innerLock(HashMap<Long, T> overallMap, HashMap<Long, T> localMap, T tag, Long uid, boolean ssk, boolean insert, boolean offerReply, boolean local) {
        HashMap<Long, T> hashMap = overallMap;
        synchronized (hashMap) {
            UIDTag oldTag;
            if (logMINOR) {
                Logger.minor(this, "Locking " + uid + " ssk=" + ssk + " insert=" + insert + " offerReply=" + offerReply + " local=" + local + " size=" + overallMap.size(), (Throwable)new Exception("debug"));
            }
            if ((oldTag = (UIDTag)overallMap.get(uid)) != null) {
                if (oldTag == tag) {
                    Logger.error(this, "Tag already registered: " + tag, (Throwable)new Exception("debug"));
                } else {
                    return false;
                }
            }
            overallMap.put(uid, tag);
            if (logMINOR) {
                Logger.minor(this, "Locked " + uid + " ssk=" + ssk + " insert=" + insert + " offerReply=" + offerReply + " local=" + local + " size=" + overallMap.size());
            }
            if (local) {
                if (logMINOR) {
                    Logger.minor(this, "Locking (local) " + uid + " ssk=" + ssk + " insert=" + insert + " offerReply=" + offerReply + " local=" + local + " size=" + localMap.size(), (Throwable)new Exception("debug"));
                }
                if ((oldTag = (UIDTag)localMap.get(uid)) != null) {
                    if (oldTag == tag) {
                        Logger.error(this, "Tag already registered (local): " + tag, (Throwable)new Exception("debug"));
                    } else {
                        Logger.error(this, "Different tag already registered (local) EVEN THOUGH NOT ON MAIN MAP: " + tag, (Throwable)new Exception("debug"));
                        overallMap.remove(uid);
                        return false;
                    }
                }
                localMap.put(uid, tag);
                if (logMINOR) {
                    Logger.minor(this, "Locked (local) " + uid + " ssk=" + ssk + " insert=" + insert + " offerReply=" + offerReply + " local=" + local + " size=" + localMap.size());
                }
            }
        }
        return true;
    }

    void unlockUID(UIDTag tag, boolean canFail, boolean noRecord) {
        this.unlockUID(tag.uid, tag.isSSK(), tag.isInsert(), canFail, tag.isOfferReply(), tag.wasLocal(), tag.realTimeFlag, tag, noRecord);
    }

    protected void unlockUID(long uid, boolean ssk, boolean insert, boolean canFail, boolean offerReply, boolean local, boolean realTimeFlag, UIDTag tag, boolean noRecord) {
        if (!noRecord) {
            this.completed(uid);
        }
        if (offerReply) {
            HashMap<Long, OfferReplyTag> map = this.getOfferTracker(ssk, realTimeFlag);
            this.innerUnlock(map, null, (OfferReplyTag)tag, uid, ssk, insert, offerReply, false, canFail);
        } else if (insert) {
            HashMap<Long, InsertTag> overallMap = this.getInsertTracker(ssk, false, realTimeFlag);
            HashMap<Long, InsertTag> localMap = local ? this.getInsertTracker(ssk, local, realTimeFlag) : null;
            this.innerUnlock(overallMap, localMap, (InsertTag)tag, uid, ssk, insert, offerReply, local, canFail);
        } else {
            HashMap<Long, RequestTag> overallMap = this.getRequestTracker(ssk, false, realTimeFlag);
            HashMap<Long, RequestTag> localMap = local ? this.getRequestTracker(ssk, local, realTimeFlag) : null;
            this.innerUnlock(overallMap, localMap, (RequestTag)tag, uid, ssk, insert, offerReply, local, canFail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends UIDTag> void innerUnlock(HashMap<Long, T> overallMap, HashMap<Long, T> localMap, T tag, Long uid, boolean ssk, boolean insert, boolean offerReply, boolean local, boolean canFail) {
        HashMap<Long, T> hashMap = overallMap;
        synchronized (hashMap) {
            if (logMINOR) {
                Logger.minor(this, "Unlocking " + uid + " ssk=" + ssk + " insert=" + insert + " offerReply=" + offerReply + " local=" + local + " size=" + overallMap.size(), (Throwable)new Exception("debug"));
            }
            if (overallMap.get(uid) != tag) {
                if (canFail) {
                    if (logMINOR) {
                        Logger.minor(this, "Can fail and did fail: removing " + tag + " got " + overallMap.get(uid) + " for " + uid);
                    }
                } else {
                    Logger.error(this, "Removing " + tag + " for " + uid + " returned " + overallMap.get(uid));
                }
            } else {
                overallMap.remove(uid);
            }
            if (logMINOR) {
                Logger.minor(this, "Unlocked " + uid + " ssk=" + ssk + " insert=" + insert + " offerReply=" + offerReply + " local=" + local + " size=" + overallMap.size());
            }
            if (local) {
                if (localMap.get(uid) != tag) {
                    if (canFail) {
                        if (logMINOR) {
                            Logger.minor(this, "Can fail and did fail (local): removing " + tag + " got " + localMap.get(uid) + " for " + uid);
                        }
                    } else {
                        Logger.error(this, "Removing " + tag + " for " + uid + " returned (local) " + localMap.get(uid));
                    }
                } else {
                    localMap.remove(uid);
                }
                if (logMINOR) {
                    Logger.minor(this, "Unlocked (local) " + uid + " ssk=" + ssk + " insert=" + insert + " offerReply=" + offerReply + " local=" + local + " size=" + localMap.size());
                }
            } else assert (localMap == null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void countRequests(boolean local, boolean ssk, boolean insert, boolean offer, boolean realTimeFlag, int transfersPerInsert, boolean ignoreLocalVsRemote, CountedRequests counter, CountedRequests counterSourceRestarted) {
        HashMap<Long, ? extends UIDTag> map;
        HashMap<Long, ? extends UIDTag> mapLock = map = this.getTracker(local, ssk, insert, offer, realTimeFlag);
        if (local) {
            mapLock = this.getTracker(false, ssk, insert, offer, realTimeFlag);
        }
        HashMap<Long, ? extends UIDTag> hashMap = mapLock;
        synchronized (hashMap) {
            int count = 0;
            int transfersOut = 0;
            int transfersIn = 0;
            int countSR = 0;
            int transfersOutSR = 0;
            int transfersInSR = 0;
            for (Map.Entry<Long, ? extends UIDTag> entry : map.entrySet()) {
                UIDTag tag = entry.getValue();
                if (!local && tag.wasLocal) continue;
                int out = tag.expectedTransfersOut(ignoreLocalVsRemote, transfersPerInsert, true);
                int in = tag.expectedTransfersIn(ignoreLocalVsRemote, transfersPerInsert, true);
                ++count;
                transfersOut += out;
                transfersIn += in;
                if (counterSourceRestarted != null && tag.countAsSourceRestarted()) {
                    ++countSR;
                    transfersOutSR += out;
                    transfersInSR += in;
                }
                if (!logDEBUG) continue;
                Logger.debug(this, "UID " + entry.getKey() + " : out " + transfersOut + " in " + transfersIn);
            }
            Object object = counter;
            ((CountedRequests)object).total = ((CountedRequests)object).total + count;
            object = counter;
            ((CountedRequests)object).expectedTransfersIn = ((CountedRequests)object).expectedTransfersIn + transfersIn;
            object = counter;
            ((CountedRequests)object).expectedTransfersOut = ((CountedRequests)object).expectedTransfersOut + transfersOut;
            if (counterSourceRestarted != null) {
                object = counterSourceRestarted;
                ((CountedRequests)object).total = ((CountedRequests)object).total + countSR;
                object = counterSourceRestarted;
                ((CountedRequests)object).expectedTransfersIn = ((CountedRequests)object).expectedTransfersIn + transfersInSR;
                object = counterSourceRestarted;
                ((CountedRequests)object).expectedTransfersOut = ((CountedRequests)object).expectedTransfersOut + transfersOutSR;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void countRequests(PeerNode source, boolean requestsToNode, boolean local, boolean ssk, boolean insert, boolean offer, boolean realTimeFlag, int transfersPerInsert, boolean ignoreLocalVsRemote, CountedRequests counter, CountedRequests counterSR) {
        HashMap<Long, ? extends UIDTag> map;
        HashMap<Long, ? extends UIDTag> mapLock = map = this.getTracker(local, ssk, insert, offer, realTimeFlag);
        if (local) {
            mapLock = this.getTracker(false, ssk, insert, offer, realTimeFlag);
        }
        HashMap<Long, ? extends UIDTag> hashMap = mapLock;
        synchronized (hashMap) {
            int count = 0;
            int transfersOut = 0;
            int transfersIn = 0;
            int countSR = 0;
            int transfersOutSR = 0;
            int transfersInSR = 0;
            if (!requestsToNode) {
                if (source != null && local) {
                    return;
                }
                for (Map.Entry<Long, ? extends UIDTag> entry : map.entrySet()) {
                    UIDTag tag = entry.getValue();
                    if (!local && tag.wasLocal) continue;
                    if (tag.getSource() == source) {
                        int out = tag.expectedTransfersOut(ignoreLocalVsRemote, transfersPerInsert, true);
                        int in = tag.expectedTransfersIn(ignoreLocalVsRemote, transfersPerInsert, true);
                        ++count;
                        transfersOut += out;
                        transfersIn += in;
                        if (counterSR != null && tag.countAsSourceRestarted()) {
                            ++countSR;
                            transfersOutSR += out;
                            transfersInSR += in;
                        }
                        if (!logMINOR) continue;
                        Logger.minor(this, "Counting " + tag + " from " + entry.getKey() + " from " + source + " count now " + count + " out now " + transfersOut + " in now " + transfersIn);
                        continue;
                    }
                    if (!logDEBUG) continue;
                    Logger.debug(this, "Not counting " + entry.getKey());
                }
                if (logMINOR) {
                    Logger.minor(this, "Returning count: " + count + " in: " + transfersIn + " out: " + transfersOut);
                }
                Object object = counter;
                ((CountedRequests)object).total = ((CountedRequests)object).total + count;
                object = counter;
                ((CountedRequests)object).expectedTransfersIn = ((CountedRequests)object).expectedTransfersIn + transfersIn;
                object = counter;
                ((CountedRequests)object).expectedTransfersOut = ((CountedRequests)object).expectedTransfersOut + transfersOut;
                if (counterSR != null) {
                    object = counterSR;
                    ((CountedRequests)object).total = ((CountedRequests)object).total + countSR;
                    object = counterSR;
                    ((CountedRequests)object).expectedTransfersIn = ((CountedRequests)object).expectedTransfersIn + transfersInSR;
                    object = counterSR;
                    ((CountedRequests)object).expectedTransfersOut = ((CountedRequests)object).expectedTransfersOut + transfersOutSR;
                }
            } else {
                for (Map.Entry<Long, ? extends UIDTag> entry : map.entrySet()) {
                    UIDTag tag = entry.getValue();
                    if (!local && tag.wasLocal) continue;
                    if (tag.currentlyFetchingOfferedKeyFrom(source)) {
                        if (logMINOR) {
                            Logger.minor(this, "Counting " + tag + " to " + entry.getKey());
                        }
                        transfersOut += tag.expectedTransfersOut(ignoreLocalVsRemote, transfersPerInsert, false);
                        transfersIn += tag.expectedTransfersIn(ignoreLocalVsRemote, transfersPerInsert, false);
                        ++count;
                        continue;
                    }
                    if (tag.currentlyRoutingTo(source)) {
                        if (logMINOR) {
                            Logger.minor(this, "Counting " + tag + " to " + entry.getKey());
                        }
                        transfersOut += tag.expectedTransfersOut(ignoreLocalVsRemote, transfersPerInsert, false);
                        transfersIn += tag.expectedTransfersIn(ignoreLocalVsRemote, transfersPerInsert, false);
                        ++count;
                        continue;
                    }
                    if (!logDEBUG) continue;
                    Logger.debug(this, "Not counting " + entry.getKey());
                }
                if (logMINOR) {
                    Logger.minor(this, "Counted for " + (local ? "local" : "remote") + " " + (ssk ? "ssk" : "chk") + " " + (insert ? "insert" : "request") + " " + (offer ? "offer" : "") + " : " + count + " of " + map.size() + " for " + source);
                }
                Object object = counter;
                ((CountedRequests)object).total = ((CountedRequests)object).total + count;
                object = counter;
                ((CountedRequests)object).expectedTransfersIn = ((CountedRequests)object).expectedTransfersIn + transfersIn;
                object = counter;
                ((CountedRequests)object).expectedTransfersOut = ((CountedRequests)object).expectedTransfersOut + transfersOut;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void countAllRequestsByIncomingPeer(boolean requestsToNode, boolean local, boolean ssk, boolean insert, boolean offer, boolean realTimeFlag, int transfersPerInsert, boolean ignoreLocalVsRemote, Map<PeerNode, CountedRequests> counterMap) {
        HashMap<Long, ? extends UIDTag> map;
        HashMap<Long, ? extends UIDTag> mapLock = map = this.getTracker(local, ssk, insert, offer, realTimeFlag);
        if (local) {
            mapLock = this.getTracker(false, ssk, insert, offer, realTimeFlag);
        }
        HashMap<Long, ? extends UIDTag> hashMap = mapLock;
        synchronized (hashMap) {
            if (!requestsToNode) {
                for (Map.Entry<Long, ? extends UIDTag> entry : map.entrySet()) {
                    UIDTag tag = entry.getValue();
                    if (!local && tag.wasLocal) continue;
                    PeerNode source = tag.getSource();
                    CountedRequests counter = counterMap.get(source);
                    if (counter == null) {
                        counter = new CountedRequests();
                        counterMap.put(source, counter);
                    }
                    int out = tag.expectedTransfersOut(ignoreLocalVsRemote, transfersPerInsert, true);
                    int in = tag.expectedTransfersIn(ignoreLocalVsRemote, transfersPerInsert, true);
                    counter.total++;
                    CountedRequests countedRequests = counter;
                    countedRequests.expectedTransfersIn = countedRequests.expectedTransfersIn + in;
                    countedRequests = counter;
                    countedRequests.expectedTransfersOut = countedRequests.expectedTransfersOut + out;
                }
            }
        }
    }

    public WaitingForSlots countRequestsWaitingForSlots() {
        WaitingForSlots slots = new WaitingForSlots();
        this.countRequestsWaitingForSlots(this.runningSSKGetUIDsRT, slots);
        this.countRequestsWaitingForSlots(this.runningCHKGetUIDsRT, slots);
        this.countRequestsWaitingForSlots(this.runningSSKPutUIDsRT, slots);
        this.countRequestsWaitingForSlots(this.runningCHKPutUIDsRT, slots);
        this.countRequestsWaitingForSlots(this.runningSSKOfferReplyUIDsRT, slots);
        this.countRequestsWaitingForSlots(this.runningCHKOfferReplyUIDsRT, slots);
        this.countRequestsWaitingForSlots(this.runningSSKGetUIDsBulk, slots);
        this.countRequestsWaitingForSlots(this.runningCHKGetUIDsBulk, slots);
        this.countRequestsWaitingForSlots(this.runningSSKPutUIDsBulk, slots);
        this.countRequestsWaitingForSlots(this.runningCHKPutUIDsBulk, slots);
        return slots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void countRequestsWaitingForSlots(HashMap<Long, ? extends UIDTag> runningUIDs, WaitingForSlots slots) {
        HashMap<Long, ? extends UIDTag> hashMap = runningUIDs;
        synchronized (hashMap) {
            for (UIDTag uIDTag : runningUIDs.values()) {
                if (!uIDTag.isWaitingForSlot()) continue;
                if (uIDTag.isLocal()) {
                    ++slots.local;
                    continue;
                }
                ++slots.remote;
            }
        }
    }

    void reassignTagToSelf(UIDTag tag) {
        tag.reassignToSelf();
    }

    private HashMap<Long, ? extends UIDTag> getTracker(boolean local, boolean ssk, boolean insert, boolean offer, boolean realTimeFlag) {
        if (offer) {
            return this.getOfferTracker(ssk, realTimeFlag);
        }
        if (insert) {
            return this.getInsertTracker(ssk, local, realTimeFlag);
        }
        return this.getRequestTracker(ssk, local, realTimeFlag);
    }

    private HashMap<Long, RequestTag> getRequestTracker(boolean ssk, boolean local, boolean realTimeFlag) {
        if (realTimeFlag) {
            if (ssk) {
                return local ? this.runningLocalSSKGetUIDsRT : this.runningSSKGetUIDsRT;
            }
            return local ? this.runningLocalCHKGetUIDsRT : this.runningCHKGetUIDsRT;
        }
        if (ssk) {
            return local ? this.runningLocalSSKGetUIDsBulk : this.runningSSKGetUIDsBulk;
        }
        return local ? this.runningLocalCHKGetUIDsBulk : this.runningCHKGetUIDsBulk;
    }

    private HashMap<Long, InsertTag> getInsertTracker(boolean ssk, boolean local, boolean realTimeFlag) {
        if (realTimeFlag) {
            if (ssk) {
                return local ? this.runningLocalSSKPutUIDsRT : this.runningSSKPutUIDsRT;
            }
            return local ? this.runningLocalCHKPutUIDsRT : this.runningCHKPutUIDsRT;
        }
        if (ssk) {
            return local ? this.runningLocalSSKPutUIDsBulk : this.runningSSKPutUIDsBulk;
        }
        return local ? this.runningLocalCHKPutUIDsBulk : this.runningCHKPutUIDsBulk;
    }

    private HashMap<Long, OfferReplyTag> getOfferTracker(boolean ssk, boolean realTimeFlag) {
        if (realTimeFlag) {
            return ssk ? this.runningSSKOfferReplyUIDsRT : this.runningCHKOfferReplyUIDsRT;
        }
        return ssk ? this.runningSSKOfferReplyUIDsBulk : this.runningCHKOfferReplyUIDsBulk;
    }

    void startDeadUIDChecker() {
        this.ticker.queueTimedJob(this.deadUIDChecker, TIMEOUT);
    }

    public void onRestartOrDisconnect(PeerNode pn) {
        this.onRestartOrDisconnect(pn, this.runningSSKGetUIDsRT);
        this.onRestartOrDisconnect(pn, this.runningCHKGetUIDsRT);
        this.onRestartOrDisconnect(pn, this.runningSSKPutUIDsRT);
        this.onRestartOrDisconnect(pn, this.runningCHKPutUIDsRT);
        this.onRestartOrDisconnect(pn, this.runningSSKOfferReplyUIDsRT);
        this.onRestartOrDisconnect(pn, this.runningCHKOfferReplyUIDsRT);
        this.onRestartOrDisconnect(pn, this.runningSSKGetUIDsBulk);
        this.onRestartOrDisconnect(pn, this.runningCHKGetUIDsBulk);
        this.onRestartOrDisconnect(pn, this.runningSSKPutUIDsBulk);
        this.onRestartOrDisconnect(pn, this.runningCHKPutUIDsBulk);
        this.onRestartOrDisconnect(pn, this.runningSSKOfferReplyUIDsBulk);
        this.onRestartOrDisconnect(pn, this.runningCHKOfferReplyUIDsBulk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRestartOrDisconnect(PeerNode pn, HashMap<Long, ? extends UIDTag> uids) {
        HashMap<Long, ? extends UIDTag> hashMap = uids;
        synchronized (hashMap) {
            for (UIDTag uIDTag : uids.values()) {
                if (!uIDTag.isSource(pn)) continue;
                uIDTag.onRestartOrDisconnectSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumSSKRequests() {
        int total = 0;
        HashMap<Long, RequestTag> hashMap = this.runningSSKGetUIDsBulk;
        synchronized (hashMap) {
            total += this.runningSSKGetUIDsBulk.size();
        }
        hashMap = this.runningSSKGetUIDsRT;
        synchronized (hashMap) {
        }
        return total += this.runningSSKGetUIDsRT.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumCHKRequests() {
        int total = 0;
        HashMap<Long, RequestTag> hashMap = this.runningCHKGetUIDsBulk;
        synchronized (hashMap) {
            total += this.runningCHKGetUIDsBulk.size();
        }
        hashMap = this.runningCHKGetUIDsRT;
        synchronized (hashMap) {
        }
        return total += this.runningCHKGetUIDsRT.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumSSKInserts() {
        int total = 0;
        HashMap<Long, InsertTag> hashMap = this.runningSSKPutUIDsBulk;
        synchronized (hashMap) {
            total += this.runningSSKPutUIDsBulk.size();
        }
        hashMap = this.runningSSKPutUIDsRT;
        synchronized (hashMap) {
        }
        return total += this.runningSSKPutUIDsRT.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumCHKInserts() {
        int total = 0;
        HashMap<Long, InsertTag> hashMap = this.runningCHKPutUIDsBulk;
        synchronized (hashMap) {
            total += this.runningCHKPutUIDsBulk.size();
        }
        hashMap = this.runningCHKPutUIDsRT;
        synchronized (hashMap) {
        }
        return total += this.runningCHKPutUIDsRT.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumLocalSSKRequests() {
        int total = 0;
        HashMap<Long, RequestTag> hashMap = this.runningSSKGetUIDsBulk;
        synchronized (hashMap) {
            total += this.runningLocalSSKGetUIDsBulk.size();
        }
        hashMap = this.runningSSKGetUIDsRT;
        synchronized (hashMap) {
        }
        return total += this.runningLocalSSKGetUIDsRT.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumLocalCHKRequests() {
        int total = 0;
        HashMap<Long, RequestTag> hashMap = this.runningCHKGetUIDsBulk;
        synchronized (hashMap) {
            total += this.runningLocalCHKGetUIDsBulk.size();
        }
        hashMap = this.runningCHKGetUIDsRT;
        synchronized (hashMap) {
        }
        return total += this.runningLocalCHKGetUIDsRT.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumRemoteCHKRequests() {
        int total = 0;
        HashMap<Long, RequestTag> hashMap = this.runningCHKGetUIDsBulk;
        synchronized (hashMap) {
            total += this.runningCHKGetUIDsBulk.size();
            total -= this.runningLocalCHKGetUIDsBulk.size();
        }
        hashMap = this.runningCHKGetUIDsRT;
        synchronized (hashMap) {
            total += this.runningCHKGetUIDsRT.size();
        }
        return total -= this.runningLocalCHKGetUIDsRT.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumRemoteSSKRequests() {
        int total = 0;
        HashMap<Long, RequestTag> hashMap = this.runningSSKGetUIDsBulk;
        synchronized (hashMap) {
            total += this.runningSSKGetUIDsBulk.size();
            total -= this.runningLocalSSKGetUIDsBulk.size();
        }
        hashMap = this.runningSSKGetUIDsRT;
        synchronized (hashMap) {
            total += this.runningSSKGetUIDsRT.size();
        }
        return total -= this.runningLocalSSKGetUIDsRT.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumLocalCHKInserts() {
        int total = 0;
        HashMap<Long, InsertTag> hashMap = this.runningCHKPutUIDsBulk;
        synchronized (hashMap) {
            total += this.runningLocalCHKPutUIDsBulk.size();
        }
        hashMap = this.runningCHKPutUIDsRT;
        synchronized (hashMap) {
        }
        return total += this.runningLocalCHKPutUIDsRT.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumLocalSSKInserts() {
        int total = 0;
        HashMap<Long, InsertTag> hashMap = this.runningSSKPutUIDsBulk;
        synchronized (hashMap) {
            total += this.runningLocalSSKPutUIDsBulk.size();
        }
        hashMap = this.runningSSKPutUIDsRT;
        synchronized (hashMap) {
        }
        return total += this.runningLocalSSKPutUIDsRT.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumRemoteCHKInserts() {
        int total = 0;
        HashMap<Long, InsertTag> hashMap = this.runningCHKPutUIDsBulk;
        synchronized (hashMap) {
            total += this.runningCHKPutUIDsBulk.size() - this.runningLocalCHKPutUIDsBulk.size();
        }
        hashMap = this.runningCHKPutUIDsRT;
        synchronized (hashMap) {
        }
        return total += this.runningCHKPutUIDsRT.size() - this.runningLocalCHKPutUIDsRT.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumRemoteSSKInserts() {
        int total = 0;
        HashMap<Long, InsertTag> hashMap = this.runningSSKPutUIDsRT;
        synchronized (hashMap) {
            total += this.runningSSKPutUIDsRT.size() - this.runningLocalSSKPutUIDsRT.size();
        }
        hashMap = this.runningSSKPutUIDsBulk;
        synchronized (hashMap) {
        }
        return total += this.runningSSKPutUIDsBulk.size() - this.runningLocalSSKPutUIDsBulk.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumSSKOfferReplies() {
        int total = 0;
        HashMap<Long, OfferReplyTag> hashMap = this.runningSSKOfferReplyUIDsRT;
        synchronized (hashMap) {
            total += this.runningSSKOfferReplyUIDsRT.size();
        }
        hashMap = this.runningSSKOfferReplyUIDsBulk;
        synchronized (hashMap) {
        }
        return total += this.runningSSKOfferReplyUIDsBulk.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumCHKOfferReplies() {
        int total = 0;
        HashMap<Long, OfferReplyTag> hashMap = this.runningCHKOfferReplyUIDsRT;
        synchronized (hashMap) {
            total += this.runningCHKOfferReplyUIDsRT.size();
        }
        hashMap = this.runningCHKOfferReplyUIDsBulk;
        synchronized (hashMap) {
        }
        return total += this.runningCHKOfferReplyUIDsBulk.size();
    }

    public int getNumSSKOfferReplies(boolean realTimeFlag) {
        return realTimeFlag ? this.runningSSKOfferReplyUIDsRT.size() : this.runningSSKOfferReplyUIDsBulk.size();
    }

    public int getNumCHKOfferReplies(boolean realTimeFlag) {
        return realTimeFlag ? this.runningCHKOfferReplyUIDsRT.size() : this.runningCHKOfferReplyUIDsBulk.size();
    }

    public void addRunningUIDs(List<Long> list) {
        this.addRunningUIDs(this.runningSSKGetUIDsRT, list);
        this.addRunningUIDs(this.runningCHKGetUIDsRT, list);
        this.addRunningUIDs(this.runningSSKPutUIDsRT, list);
        this.addRunningUIDs(this.runningCHKPutUIDsRT, list);
        this.addRunningUIDs(this.runningSSKOfferReplyUIDsRT, list);
        this.addRunningUIDs(this.runningCHKOfferReplyUIDsRT, list);
        this.addRunningUIDs(this.runningSSKGetUIDsBulk, list);
        this.addRunningUIDs(this.runningCHKGetUIDsBulk, list);
        this.addRunningUIDs(this.runningSSKPutUIDsBulk, list);
        this.addRunningUIDs(this.runningCHKPutUIDsBulk, list);
        this.addRunningUIDs(this.runningSSKOfferReplyUIDsBulk, list);
        this.addRunningUIDs(this.runningCHKOfferReplyUIDsBulk, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRunningUIDs(HashMap<Long, ? extends UIDTag> runningUIDs, List<Long> list) {
        HashMap<Long, ? extends UIDTag> hashMap = runningUIDs;
        synchronized (hashMap) {
            list.addAll(runningUIDs.keySet());
        }
    }

    public int getTotalRunningUIDsAlt() {
        return this.runningCHKGetUIDsRT.size() + this.runningCHKPutUIDsRT.size() + this.runningSSKGetUIDsRT.size() + this.runningSSKPutUIDsRT.size() + this.runningSSKOfferReplyUIDsRT.size() + this.runningCHKOfferReplyUIDsRT.size() + this.runningCHKGetUIDsBulk.size() + this.runningCHKPutUIDsBulk.size() + this.runningSSKGetUIDsBulk.size() + this.runningSSKPutUIDsBulk.size() + this.runningSSKOfferReplyUIDsBulk.size() + this.runningCHKOfferReplyUIDsBulk.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completed(long id) {
        PeerNode[] peerNodeArray = this.completedBuffer;
        synchronized (this.completedBuffer) {
            this.completedBuffer.add(id);
            if (this.completedBuffer.size() < 128) {
                // ** MonitorExit[var4_2] (shouldn't be in output)
                return;
            }
            Long[] list = this.completedBuffer.toArray(new Long[this.completedBuffer.size()]);
            this.completedBuffer.clear();
            // ** MonitorExit[var4_2] (shouldn't be in output)
            for (PeerNode pn : this.peers.myPeers()) {
                if (!pn.isRoutingCompatible()) continue;
                pn.removeUIDsFromMessageQueues(list);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestSender getTransferringRequestSenderByKey(NodeCHK key, boolean realTimeFlag) {
        HashMap<NodeCHK, RequestSender> transferringRequestSenders;
        HashMap<NodeCHK, RequestSender> hashMap = transferringRequestSenders = realTimeFlag ? this.transferringRequestSendersRT : this.transferringRequestSendersBulk;
        synchronized (hashMap) {
            return transferringRequestSenders.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransferringSender(NodeCHK key, RequestSender sender) {
        HashMap<NodeCHK, RequestSender> transferringRequestSenders;
        HashMap<NodeCHK, RequestSender> hashMap = transferringRequestSenders = sender.realTimeFlag ? this.transferringRequestSendersRT : this.transferringRequestSendersBulk;
        synchronized (hashMap) {
            transferringRequestSenders.put(key, sender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTransferringRequestHandler(long id) {
        HashSet<Long> hashSet = this.transferringRequestHandlers;
        synchronized (hashSet) {
            this.transferringRequestHandlers.add(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTransferringRequestHandler(long id) {
        HashSet<Long> hashSet = this.transferringRequestHandlers;
        synchronized (hashSet) {
            this.transferringRequestHandlers.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransferringSender(NodeCHK key, RequestSender sender) {
        HashMap<NodeCHK, RequestSender> transferringRequestSenders;
        HashMap<NodeCHK, RequestSender> hashMap = transferringRequestSenders = sender.realTimeFlag ? this.transferringRequestSendersRT : this.transferringRequestSendersBulk;
        synchronized (hashMap) {
            if (transferringRequestSenders.get(key) == sender) {
                transferringRequestSenders.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumTransferringRequestSenders() {
        int total = 0;
        HashMap<NodeCHK, RequestSender> hashMap = this.transferringRequestSendersRT;
        synchronized (hashMap) {
            total += this.transferringRequestSendersRT.size();
        }
        hashMap = this.transferringRequestSendersBulk;
        synchronized (hashMap) {
        }
        return total += this.transferringRequestSendersBulk.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumTransferringRequestHandlers() {
        HashSet<Long> hashSet = this.transferringRequestHandlers;
        synchronized (hashSet) {
            return this.transferringRequestHandlers.size();
        }
    }

    static {
        Logger.registerClass(RequestTracker.class);
        TIMEOUT = TimeUnit.MINUTES.toMillis(21L);
    }

    public class WaitingForSlots {
        int local;
        int remote;
    }

    public static class CountedRequests {
        private int total;
        private int expectedTransfersOut;
        private int expectedTransfersIn;

        public int total() {
            return this.total;
        }

        public int expectedTransfersOut() {
            return this.expectedTransfersOut;
        }

        public int expectedTransfersIn() {
            return this.expectedTransfersIn;
        }
    }
}

