/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.Logger;
import freenet.support.io.FileUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class JarClassLoader
extends ClassLoader
implements Closeable {
    private static volatile boolean logMINOR;
    private JarFile tempJarFile;

    public JarClassLoader(String fileName) throws IOException {
        this(new File(fileName));
    }

    public JarClassLoader(URL fileUrl, long length) throws IOException {
        this.copyFileToTemp(fileUrl.openStream(), length);
    }

    public JarClassLoader(File file) throws IOException {
        this.tempJarFile = new JarFile(file);
    }

    private void copyFileToTemp(InputStream inputStream, long length) throws IOException {
        File tempFile = File.createTempFile("jar-", ".tmp");
        FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
        FileUtil.copy(inputStream, fileOutputStream, length);
        fileOutputStream.close();
        tempFile.deleteOnExit();
        this.tempJarFile = new JarFile(tempFile);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            String pathName = this.transformName(name);
            JarEntry jarEntry = this.tempJarFile.getJarEntry(pathName);
            if (jarEntry != null) {
                long size = jarEntry.getSize();
                InputStream jarEntryInputStream = this.tempJarFile.getInputStream(jarEntry);
                ByteArrayOutputStream classBytesOutputStream = new ByteArrayOutputStream((int)size);
                FileUtil.copy(jarEntryInputStream, classBytesOutputStream, size);
                classBytesOutputStream.close();
                jarEntryInputStream.close();
                byte[] classBytes = classBytesOutputStream.toByteArray();
                this.definePackage(name);
                Class<?> clazz = this.defineClass(name, classBytes, 0, classBytes.length);
                return clazz;
            }
            throw new ClassNotFoundException("could not find jar entry for class " + name);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(e.getMessage(), e);
        }
    }

    @Override
    protected URL findResource(String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        try {
            if (this.tempJarFile.getJarEntry(name) == null) {
                return null;
            }
            return new URL("jar:" + new File(this.tempJarFile.getName()).toURI().toURL() + "!/" + name);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    protected Enumeration<URL> findResources(final String name) {
        return new Enumeration<URL>(){
            private final Enumeration<JarEntry> jarFileEntries;
            private URL nextElement;
            {
                this.jarFileEntries = JarClassLoader.this.tempJarFile.entries();
                this.nextElement = null;
            }

            @Override
            public boolean hasMoreElements() {
                if (this.nextElement != null) {
                    return true;
                }
                while (this.nextElement == null && this.jarFileEntries.hasMoreElements()) {
                    JarEntry jarEntry = this.jarFileEntries.nextElement();
                    if (!jarEntry.getName().equals(name)) continue;
                    try {
                        this.nextElement = new URL("jar:" + new File(JarClassLoader.this.tempJarFile.getName()).toURI().toURL() + "!/" + name);
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                return this.nextElement != null;
            }

            @Override
            public URL nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                URL elementToReturn = this.nextElement;
                this.nextElement = null;
                return elementToReturn;
            }
        };
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        URL localUrl;
        URL url;
        if (logMINOR) {
            Logger.minor(this, "Requested resource: " + name, (Throwable)new Exception("debug"));
        }
        if ((url = this.getResource(name)) == null) {
            return null;
        }
        if (logMINOR) {
            Logger.minor(this, "Found resource at URL: " + url);
        }
        if ((localUrl = this.findResource(name)) == null || !url.toString().equals(localUrl.toString())) {
            try {
                return url.openStream();
            }
            catch (IOException e) {
                return null;
            }
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        ZipEntry entry = this.tempJarFile.getEntry(name);
        try {
            return entry != null ? this.tempJarFile.getInputStream(entry) : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private String transformName(String name) {
        return name.replace('.', '/') + ".class";
    }

    protected Package definePackage(String name) throws IllegalArgumentException {
        String pkgname;
        Package pkg = null;
        int i = name.lastIndexOf(46);
        if (i != -1 && (pkg = this.getPackage(pkgname = name.substring(0, i))) == null) {
            try {
                Manifest man = this.tempJarFile.getManifest();
                if (man == null) {
                    throw new IOException();
                }
                pkg = this.definePackage(pkgname, man);
            }
            catch (IOException e) {
                pkg = this.definePackage(pkgname, null, null, null, null, null, null, null);
            }
        }
        return pkg;
    }

    protected Package definePackage(String name, Manifest man) throws IllegalArgumentException {
        String path = name.replace('.', '/').concat("/");
        String specTitle = null;
        String specVersion = null;
        String specVendor = null;
        String implTitle = null;
        String implVersion = null;
        String implVendor = null;
        String sealed = null;
        URL sealBase = null;
        Attributes attr = man.getAttributes(path);
        if (attr != null) {
            specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if ((attr = man.getMainAttributes()) != null) {
            if (specTitle == null) {
                specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (specVersion == null) {
                specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (specVendor == null) {
                specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (implTitle == null) {
                implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (implVersion == null) {
                implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (implVendor == null) {
                implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (sealed == null) {
                sealed = attr.getValue(Attributes.Name.SEALED);
            }
        }
        return this.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    @Override
    public void close() throws IOException {
        this.tempJarFile.close();
    }

    static {
        Logger.registerClass(JarClassLoader.class);
    }
}

