/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.node.NodeStats;
import freenet.support.Fields;
import freenet.support.LRUCache;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Comparator;

public class InetAddressIpv6FirstComparator
implements Comparator<InetAddress> {
    public LRUCache<Integer, Boolean> reachabilityCache = new LRUCache(1000, 300000L);
    public static final InetAddressIpv6FirstComparator COMPARATOR = new InetAddressIpv6FirstComparator();

    @Override
    public int compare(InetAddress arg0, InetAddress arg1) {
        byte[] bytes1;
        if (arg0 == null && arg1 == null) {
            return 0;
        }
        if (arg0 == null) {
            return 1;
        }
        if (arg1 == null) {
            return -1;
        }
        if (arg0.equals(arg1)) {
            return 0;
        }
        if (!arg0.isAnyLocalAddress() && arg1.isAnyLocalAddress()) {
            return -1;
        }
        if (arg0.isAnyLocalAddress() && !arg1.isAnyLocalAddress()) {
            return 1;
        }
        if (!arg0.isLoopbackAddress() && arg1.isLoopbackAddress()) {
            return -1;
        }
        if (arg0.isLoopbackAddress() && !arg1.isLoopbackAddress()) {
            return 1;
        }
        if (!arg0.isLinkLocalAddress() && arg1.isLinkLocalAddress()) {
            return -1;
        }
        if (arg0.isLinkLocalAddress() && !arg1.isLinkLocalAddress()) {
            return 1;
        }
        int a = arg0.hashCode();
        int b = arg1.hashCode();
        Boolean reachable0 = this.reachabilityCache.get(a);
        Boolean reachable1 = this.reachabilityCache.get(b);
        if (reachable0 == null) {
            try {
                reachable0 = arg0.isReachable((int)NodeStats.DEFAULT_MAX_PING_TIME);
            }
            catch (IOException e) {
                reachable0 = false;
            }
            this.reachabilityCache.put(a, reachable0);
        }
        if (reachable1 == null) {
            try {
                reachable1 = arg1.isReachable((int)NodeStats.DEFAULT_MAX_PING_TIME);
            }
            catch (IOException e) {
                reachable1 = false;
            }
            this.reachabilityCache.put(b, reachable1);
        }
        if (reachable0.booleanValue() && !reachable1.booleanValue()) {
            return -1;
        }
        if (!reachable0.booleanValue() && reachable1.booleanValue()) {
            return 1;
        }
        if (!arg0.isSiteLocalAddress() && arg1.isSiteLocalAddress()) {
            return -1;
        }
        if (arg0.isSiteLocalAddress() && !arg1.isSiteLocalAddress()) {
            return 1;
        }
        byte[] bytes0 = arg0.getAddress();
        if (bytes0.length > (bytes1 = arg1.getAddress()).length) {
            return -1;
        }
        if (bytes1.length > bytes0.length) {
            return 1;
        }
        if (a > b) {
            return 1;
        }
        if (b > a) {
            return -1;
        }
        return Fields.compareBytes(bytes0, bytes1);
    }
}

