/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.async.BlockSet;
import freenet.client.async.ChosenBlock;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestSelector;
import freenet.client.async.ClientRequester;
import freenet.client.async.DatastoreChecker;
import freenet.client.async.HasKeyListener;
import freenet.client.async.KeyListener;
import freenet.client.async.KeyListenerTracker;
import freenet.client.async.KeySalter;
import freenet.client.async.OfferedKeysList;
import freenet.client.async.PersistenceDisabledException;
import freenet.client.async.PersistentJob;
import freenet.client.async.PersistentJobRunner;
import freenet.crypt.RandomSource;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.node.BaseSendableGet;
import freenet.node.KeysFetchingLocally;
import freenet.node.LowLevelGetException;
import freenet.node.LowLevelPutException;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.PrioRunnable;
import freenet.node.RequestScheduler;
import freenet.node.RequestStarter;
import freenet.node.SendableGet;
import freenet.node.SendableInsert;
import freenet.node.SendableRequest;
import freenet.node.SendableRequestItemKey;
import freenet.support.Fields;
import freenet.support.IdentityHashSet;
import freenet.support.Logger;
import freenet.support.io.NativeThread;

public class ClientRequestScheduler
implements RequestScheduler {
    private KeyListenerTracker schedCore;
    final KeyListenerTracker schedTransient;
    final transient ClientRequestSelector selector;
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private final OfferedKeysList offeredKeys;
    final boolean isInsertScheduler;
    final boolean isSSKScheduler;
    final boolean isRTScheduler;
    final RandomSource random;
    private final RequestStarter starter;
    private final Node node;
    public final String name;
    final DatastoreChecker datastoreChecker;
    public final ClientContext clientContext;
    final PersistentJobRunner jobRunner;
    public static final String PRIORITY_NONE = "NONE";
    public static final String PRIORITY_SOFT = "SOFT";
    public static final String PRIORITY_HARD = "HARD";
    private String choosenPriorityScheduler;
    static final int QUEUE_THRESHOLD = 100;
    private final transient IdentityHashSet<SendableRequest> runningPersistentRequests = new IdentityHashSet();
    static final int TRIP_PENDING_PRIORITY;

    public ClientRequestScheduler(boolean forInserts, boolean forSSKs, boolean forRT, RandomSource random, RequestStarter starter, Node node, NodeClientCore core, String name, ClientContext context) {
        this.isInsertScheduler = forInserts;
        this.isSSKScheduler = forSSKs;
        this.isRTScheduler = forRT;
        this.schedTransient = new KeyListenerTracker(forInserts, forSSKs, forRT, random, this, null, false);
        this.datastoreChecker = core.getStoreChecker();
        this.starter = starter;
        this.random = random;
        this.node = node;
        this.clientContext = context;
        this.selector = new ClientRequestSelector(forInserts, forSSKs, forRT, this);
        this.name = name;
        this.choosenPriorityScheduler = PRIORITY_HARD;
        this.offeredKeys = !forInserts ? new OfferedKeysList(core, random, 0, forSSKs, forRT) : null;
        this.jobRunner = this.clientContext.jobRunner;
    }

    public void startCore(byte[] globalSaltPersistent) {
        this.schedCore = new KeyListenerTracker(this.isInsertScheduler, this.isSSKScheduler, this.isRTScheduler, this.random, this, globalSaltPersistent, true);
    }

    public synchronized void setPriorityScheduler(String val) {
        this.choosenPriorityScheduler = val;
    }

    public void registerInsert(SendableRequest req, boolean persistent) {
        if (!this.isInsertScheduler) {
            throw new IllegalArgumentException("Adding a SendableInsert to a request scheduler!!");
        }
        this.selector.innerRegister(req, this.clientContext, null);
        this.starter.wakeUp();
    }

    public void register(HasKeyListener hasListener, SendableGet[] getters, boolean persistent, BlockSet blocks, boolean noCheckStore) {
        KeyListener listener;
        if (logMINOR) {
            Logger.minor(this, "register(" + persistent + "," + hasListener + "," + Fields.commaList(getters));
        }
        if (this.isInsertScheduler) {
            IllegalStateException e = new IllegalStateException("finishRegister on an insert scheduler");
            throw e;
        }
        if (hasListener != null) {
            listener = hasListener.makeKeyListener(this.clientContext, false);
            if (listener != null) {
                (persistent ? this.schedCore : this.schedTransient).addPendingKeys(listener);
            } else {
                Logger.normal(this, "No KeyListener for " + hasListener);
            }
        } else {
            listener = null;
        }
        if (getters != null && !noCheckStore) {
            for (SendableGet getter : getters) {
                this.datastoreChecker.queueRequest(getter, blocks);
            }
        } else {
            boolean anyValid = false;
            for (SendableGet getter : getters) {
                if (getter.isCancelled() || getter.getWakeupTime(this.clientContext, System.currentTimeMillis()) != 0L) continue;
                anyValid = true;
            }
            this.finishRegister(getters, false, anyValid);
        }
    }

    void finishRegister(SendableGet[] getters, boolean persistent, boolean anyValid) {
        if (logMINOR) {
            Logger.minor(this, "finishRegister for " + Fields.commaList(getters) + " anyValid=" + anyValid + " persistent=" + persistent);
        }
        if (this.isInsertScheduler) {
            IllegalStateException e = new IllegalStateException("finishRegister on an insert scheduler");
            for (SendableGet getter : getters) {
                getter.internalError(e, this, this.clientContext, persistent);
            }
            throw e;
        }
        if (persistent) {
            if (logMINOR) {
                Logger.minor(this, "finishRegister() for " + Fields.commaList(getters));
            }
            if (anyValid) {
                boolean wereAnyValid = false;
                for (SendableGet getter : getters) {
                    if (!getter.isCancelled()) {
                        wereAnyValid = true;
                        if (getter.preRegister(this.clientContext, true)) continue;
                        this.selector.innerRegister(getter, this.clientContext, getters);
                        continue;
                    }
                    getter.preRegister(this.clientContext, false);
                }
                if (!wereAnyValid) {
                    Logger.normal(this, "No requests valid");
                }
            } else {
                Logger.normal(this, "No valid requests passed in");
            }
        } else {
            for (SendableGet getter : getters) {
                if (!anyValid || getter.isCancelled()) {
                    getter.preRegister(this.clientContext, false);
                    continue;
                }
                if (getter.preRegister(this.clientContext, true) || getter.isCancelled()) continue;
                this.selector.innerRegister(getter, this.clientContext, getters);
            }
            this.starter.wakeUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRunningRequest(SendableRequest request) {
        IdentityHashSet<SendableRequest> identityHashSet = this.runningPersistentRequests;
        synchronized (identityHashSet) {
            if (this.runningPersistentRequests.remove(request) && logMINOR) {
                Logger.minor(this, "Removed running request " + request + " size now " + this.runningPersistentRequests.size());
            }
        }
        request.clearWakeupTime(this.clientContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRunningOrQueuedPersistentRequest(SendableRequest request) {
        IdentityHashSet<SendableRequest> identityHashSet = this.runningPersistentRequests;
        synchronized (identityHashSet) {
            if (this.runningPersistentRequests.contains(request)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public ChosenBlock grabRequest() {
        int fuzz = -1;
        if (PRIORITY_SOFT.equals(this.choosenPriorityScheduler)) {
            fuzz = -1;
        } else if (PRIORITY_HARD.equals(this.choosenPriorityScheduler)) {
            fuzz = 0;
        }
        return this.selector.chooseRequest(fuzz, this.random, this.offeredKeys, this.starter, this.isRTScheduler, this.clientContext);
    }

    public void removePendingKeys(KeyListener getter, boolean complain) {
        boolean found = this.schedTransient.removePendingKeys(getter);
        if (this.schedCore != null) {
            found |= this.schedCore.removePendingKeys(getter);
        }
        if (complain && !found) {
            Logger.error(this, "Listener not found when removing: " + getter);
        }
    }

    public void removePendingKeys(HasKeyListener getter, boolean complain) {
        boolean found = this.schedTransient.removePendingKeys(getter);
        if (this.schedCore != null) {
            found |= this.schedCore.removePendingKeys(getter);
        }
        if (complain && !found) {
            Logger.error(this, "Listener not found when removing: " + getter);
        }
    }

    public void reregisterAll(ClientRequester request, short oldPrio) {
        this.selector.reregisterAll(request, this, this.clientContext, oldPrio);
        this.starter.wakeUp();
    }

    public String getChoosenPriorityScheduler() {
        return this.choosenPriorityScheduler;
    }

    @Override
    public synchronized void succeeded(BaseSendableGet succeeded, boolean persistent) {
        this.selector.succeeded(succeeded);
    }

    public void tripPendingKey(final KeyBlock block) {
        Key key;
        if (logMINOR) {
            Logger.minor(this, "tripPendingKey(" + block.getKey() + ")");
        }
        if (this.offeredKeys != null) {
            this.offeredKeys.remove(block.getKey());
        }
        if (this.schedTransient.anyProbablyWantKey(key = block.getKey(), this.clientContext)) {
            this.clientContext.mainExecutor.execute(new PrioRunnable(){

                @Override
                public void run() {
                    ClientRequestScheduler.this.schedTransient.tripPendingKey(key, block, ClientRequestScheduler.this.clientContext);
                }

                @Override
                public int getPriority() {
                    return TRIP_PENDING_PRIORITY;
                }
            }, "Trip pending key (transient)");
        }
        if (this.schedCore == null) {
            return;
        }
        if (this.schedCore.anyProbablyWantKey(key, this.clientContext)) {
            try {
                this.jobRunner.queue(new PersistentJob(){

                    @Override
                    public boolean run(ClientContext context) {
                        if (logMINOR) {
                            Logger.minor(this, "tripPendingKey for " + key);
                        }
                        ClientRequestScheduler.this.schedCore.tripPendingKey(key, block, ClientRequestScheduler.this.clientContext);
                        return false;
                    }

                    public String toString() {
                        return "tripPendingKey";
                    }
                }, TRIP_PENDING_PRIORITY);
            }
            catch (PersistenceDisabledException persistenceDisabledException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean wantKey(Key key) {
        if (this.schedTransient.anyProbablyWantKey(key, this.clientContext)) {
            return true;
        }
        return this.schedCore != null && this.schedCore.anyProbablyWantKey(key, this.clientContext);
    }

    public void queueOfferedKey(Key key, boolean realTime) {
        if (logMINOR) {
            Logger.minor(this, "queueOfferedKey(" + key);
        }
        this.offeredKeys.queueKey(key);
        this.starter.wakeUp();
    }

    public void dequeueOfferedKey(Key key) {
        this.offeredKeys.remove(key);
    }

    @Override
    public long countQueuedRequests() {
        return this.selector.countQueuedRequests(this.clientContext);
    }

    @Override
    public KeysFetchingLocally fetchingKeys() {
        return this.selector;
    }

    @Override
    public void removeFetchingKey(Key key) {
        this.selector.removeFetchingKey(key);
    }

    @Override
    public void removeRunningInsert(SendableInsert insert, SendableRequestItemKey token) {
        this.selector.removeRunningInsert(token);
        insert.clearWakeupTime(this.clientContext);
    }

    @Override
    public void callFailure(final SendableGet get, final LowLevelGetException e, int prio, boolean persistent) {
        if (!persistent) {
            get.onFailure(e, null, this.clientContext);
        } else {
            try {
                this.jobRunner.queue(new PersistentJob(){

                    @Override
                    public boolean run(ClientContext context) {
                        get.onFailure(e, null, ClientRequestScheduler.this.clientContext);
                        return false;
                    }

                    public String toString() {
                        return "SendableGet onFailure";
                    }
                }, prio);
            }
            catch (PersistenceDisabledException e1) {
                Logger.error(this, "callFailure() on a persistent request but database disabled", (Throwable)new Exception("error"));
            }
        }
    }

    @Override
    public void callFailure(final SendableInsert insert, final LowLevelPutException e, int prio, boolean persistent) {
        if (!persistent) {
            insert.onFailure(e, null, this.clientContext);
        } else {
            try {
                this.jobRunner.queue(new PersistentJob(){

                    @Override
                    public boolean run(ClientContext context) {
                        insert.onFailure(e, null, context);
                        return false;
                    }

                    public String toString() {
                        return "SendableInsert onFailure";
                    }
                }, prio);
            }
            catch (PersistenceDisabledException e1) {
                Logger.error(this, "callFailure() on a persistent request but database disabled", (Throwable)new Exception("error"));
            }
        }
    }

    @Override
    public ClientContext getContext() {
        return this.clientContext;
    }

    @Override
    public boolean addToFetching(Key key) {
        return this.selector.addToFetching(key);
    }

    @Override
    public boolean addRunningInsert(SendableInsert insert, SendableRequestItemKey token) {
        return this.selector.addRunningInsert(token);
    }

    @Override
    public boolean hasFetchingKey(Key key, BaseSendableGet getterWaiting, boolean persistent) {
        return this.selector.hasKey(key, null);
    }

    public long countPersistentWaitingKeys() {
        if (this.schedCore == null) {
            return 0L;
        }
        return this.schedCore.countWaitingKeys();
    }

    public boolean isInsertScheduler() {
        return this.isInsertScheduler;
    }

    @Override
    public void wakeStarter() {
        this.starter.wakeUp();
    }

    public byte[] saltKey(boolean persistent, Key key) {
        return persistent ? this.schedCore.saltKey(key) : this.schedTransient.saltKey(key);
    }

    Node getNode() {
        return this.node;
    }

    public KeySalter getGlobalKeySalter(boolean persistent) {
        return persistent ? this.schedCore : this.schedTransient;
    }

    @Override
    public ClientRequestSelector getSelector() {
        return this.selector;
    }

    static {
        Logger.registerClass(ClientRequestScheduler.class);
        TRIP_PENDING_PRIORITY = NativeThread.HIGH_PRIORITY - 1;
    }
}

