/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.FetchException;
import freenet.client.HighLevelSimpleClient;
import freenet.clients.fcp.AddPeer;
import freenet.clients.http.HTTPRequestImpl;
import freenet.clients.http.PageNode;
import freenet.clients.http.RedirectException;
import freenet.clients.http.StatisticsToadlet;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.clients.http.complexhtmlnodes.PeerTrustInputForAddPeerBoxNode;
import freenet.clients.http.complexhtmlnodes.PeerVisibilityInputForAddPeerBoxNode;
import freenet.clients.http.geoip.IPConverter;
import freenet.config.ConfigException;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.io.xfer.PacketThrottle;
import freenet.keys.FreenetURI;
import freenet.l10n.NodeL10n;
import freenet.node.DarknetPeerNode;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.NodeFile;
import freenet.node.NodeStats;
import freenet.node.PeerManager;
import freenet.node.PeerNode;
import freenet.node.PeerNodeStatus;
import freenet.node.Version;
import freenet.support.Fields;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import freenet.support.SimpleFieldSet;
import freenet.support.SizeUtil;
import freenet.support.TimeUtil;
import freenet.support.api.HTTPRequest;
import freenet.support.io.Closer;
import freenet.support.io.FileUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class ConnectionsToadlet
extends Toadlet {
    protected final Node node;
    protected final NodeClientCore core;
    protected final NodeStats stats;
    protected final PeerManager peers;
    protected boolean isReversed = false;
    protected boolean showTrivialFoafConnections = false;
    final HTMLNode REF_LINK;
    final HTMLNode REFTEXT_LINK;

    protected ConnectionsToadlet(Node n, NodeClientCore core, HighLevelSimpleClient client) {
        super(client);
        this.node = n;
        this.core = core;
        this.stats = n.getNodeStats();
        this.peers = n.getPeers();
        this.REF_LINK = HTMLNode.link(this.path() + "myref.fref").setReadOnly();
        this.REFTEXT_LINK = HTMLNode.link(this.path() + "myref.txt").setReadOnly();
    }

    abstract SimpleColumn[] endColumnHeaders(boolean var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public void handleMethodGET(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        if (!ctx.checkFullAccess(this)) {
            return;
        }
        String path = uri.getPath();
        if (path.endsWith("myref.fref")) {
            SimpleFieldSet fs = this.getNoderef();
            String noderefString = fs.toOrderedStringWithBase64();
            MultiValueTable<String, String> extraHeaders = new MultiValueTable<String, String>();
            extraHeaders.put("Content-Disposition", "attachment; filename=myref.fref");
            this.writeReply(ctx, 200, "application/x-freenet-reference", "OK", extraHeaders, noderefString);
            return;
        }
        if (path.endsWith("myref.txt")) {
            SimpleFieldSet fs = this.getNoderef();
            String noderefString = fs.toOrderedStringWithBase64();
            this.writeTextReply(ctx, 200, "OK", noderefString);
            return;
        }
        DecimalFormat fix1 = new DecimalFormat("##0.0%");
        boolean fProxyJavascriptEnabled = this.node.isFProxyJavascriptEnabled();
        boolean drawMessageTypes = path.endsWith("displaymessagetypes.html");
        PeerNodeStatus[] peerNodeStatuses = this.getPeerNodeStatuses(!drawMessageTypes);
        Arrays.sort(peerNodeStatuses, this.comparator(request.getParam("sortBy", null), request.isParameterSet("reversed")));
        int numberOfConnected = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 1);
        int numberOfRoutingBackedOff = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 2);
        int numberOfTooNew = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 3);
        int numberOfTooOld = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 4);
        int numberOfDisconnected = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 5);
        int numberOfNeverConnected = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 6);
        int numberOfDisabled = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 7);
        int numberOfBursting = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 8);
        int numberOfListening = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 9);
        int numberOfListenOnly = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 10);
        int numberOfClockProblem = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 11);
        int numberOfConnError = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 12);
        int numberOfDisconnecting = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 13);
        int numberOfRoutingDisabled = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 14);
        int numberOfNoLoadStats = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 15);
        int numberOfSimpleConnected = numberOfConnected + numberOfRoutingBackedOff;
        int numberOfNotConnected = numberOfTooNew + numberOfTooOld + numberOfNoLoadStats + numberOfDisconnected + numberOfNeverConnected + numberOfDisabled + numberOfBursting + numberOfListening + numberOfListenOnly + numberOfClockProblem + numberOfConnError;
        String titleCountString = null;
        titleCountString = this.node.isAdvancedModeEnabled() ? "(" + numberOfConnected + '/' + numberOfRoutingBackedOff + '/' + numberOfTooNew + '/' + numberOfTooOld + '/' + numberOfNoLoadStats + '/' + numberOfRoutingDisabled + '/' + numberOfNotConnected + ')' : (numberOfNotConnected + numberOfSimpleConnected > 0 ? String.valueOf(numberOfSimpleConnected) : "");
        PageNode page = ctx.getPageMaker().getPageNode(this.getPageTitle(titleCountString), ctx);
        boolean advancedMode = ctx.isAdvancedModeEnabled();
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        long now = System.currentTimeMillis();
        if (ctx.isAllowedFullAccess()) {
            contentNode.addChild(ctx.getAlertManager().createSummary());
        }
        if (peerNodeStatuses.length > 0) {
            if (advancedMode) {
                long nodeUptimeSeconds = TimeUnit.SECONDS.convert(now - this.node.getStartupTime(), TimeUnit.MILLISECONDS);
                int bwlimitDelayTime = (int)this.stats.getBwlimitDelayTime();
                int nodeAveragePingTime = (int)this.stats.getNodeAveragePingTime();
                int networkSizeEstimateSession = this.stats.getDarknetSizeEstimate(-1L);
                int networkSizeEstimateRecent = 0;
                if (nodeUptimeSeconds > TimeUnit.HOURS.toSeconds(48L)) {
                    networkSizeEstimateRecent = this.stats.getDarknetSizeEstimate(now - TimeUnit.HOURS.toMillis(48L));
                }
                DecimalFormat fix4 = new DecimalFormat("0.0000");
                double routingMissDistanceLocal = this.stats.routingMissDistanceLocal.currentValue();
                double routingMissDistanceRemote = this.stats.routingMissDistanceRemote.currentValue();
                double routingMissDistanceOverall = this.stats.routingMissDistanceOverall.currentValue();
                double routingMissDistanceBulk = this.stats.routingMissDistanceBulk.currentValue();
                double routingMissDistanceRT = this.stats.routingMissDistanceRT.currentValue();
                double backedOffPercent = this.stats.backedOffPercent.currentValue();
                String nodeUptimeString = TimeUtil.formatTime(TimeUnit.MILLISECONDS.convert(nodeUptimeSeconds, TimeUnit.SECONDS));
                HTMLNode overviewTable = contentNode.addChild("table", "class", "column");
                HTMLNode overviewTableRow = overviewTable.addChild("tr");
                HTMLNode nextTableCell = overviewTableRow.addChild("td", "class", "first");
                HTMLNode overviewInfobox = nextTableCell.addChild("div", "class", "infobox");
                overviewInfobox.addChild("div", "class", "infobox-header", "Node status overview");
                HTMLNode overviewInfoboxContent = overviewInfobox.addChild("div", "class", "infobox-content");
                HTMLNode overviewList = overviewInfoboxContent.addChild("ul");
                overviewList.addChild("li", "bwlimitDelayTime:\u00a0" + bwlimitDelayTime + "ms");
                overviewList.addChild("li", "nodeAveragePingTime:\u00a0" + nodeAveragePingTime + "ms");
                overviewList.addChild("li", "darknetSizeEstimateSession:\u00a0" + networkSizeEstimateSession + "\u00a0nodes");
                if (nodeUptimeSeconds > TimeUnit.HOURS.toSeconds(48L)) {
                    overviewList.addChild("li", "darknetSizeEstimateRecent:\u00a0" + networkSizeEstimateRecent + "\u00a0nodes");
                }
                overviewList.addChild("li", "nodeUptime:\u00a0" + nodeUptimeString);
                overviewList.addChild("li", "routingMissDistanceLocal:\u00a0" + fix4.format(routingMissDistanceLocal));
                overviewList.addChild("li", "routingMissDistanceRemote:\u00a0" + fix4.format(routingMissDistanceRemote));
                overviewList.addChild("li", "routingMissDistanceOverall:\u00a0" + fix4.format(routingMissDistanceOverall));
                overviewList.addChild("li", "routingMissDistanceBulk:\u00a0" + fix4.format(routingMissDistanceBulk));
                overviewList.addChild("li", "routingMissDistanceRT:\u00a0" + fix4.format(routingMissDistanceRT));
                overviewList.addChild("li", "backedOffPercent:\u00a0" + fix1.format(backedOffPercent));
                overviewList.addChild("li", "pInstantReject:\u00a0" + fix1.format(this.stats.pRejectIncomingInstantly()));
                nextTableCell = overviewTableRow.addChild("td");
                int numARKFetchers = this.node.getNumARKFetchers();
                HTMLNode activityInfobox = nextTableCell.addChild("div", "class", "infobox");
                activityInfobox.addChild("div", "class", "infobox-header", ConnectionsToadlet.l10n("activityTitle"));
                HTMLNode activityInfoboxContent = activityInfobox.addChild("div", "class", "infobox-content");
                HTMLNode activityList = StatisticsToadlet.drawActivity(activityInfoboxContent, this.node);
                if (advancedMode && activityList != null) {
                    if (numARKFetchers > 0) {
                        activityList.addChild("li", "ARK\u00a0Fetch\u00a0Requests:\u00a0" + numARKFetchers);
                    }
                    StatisticsToadlet.drawBandwidth(activityList, this.node, nodeUptimeSeconds, advancedMode);
                }
                nextTableCell = overviewTableRow.addChild("td", "class", "last");
                HTMLNode peerStatsInfobox = nextTableCell.addChild("div", "class", "infobox");
                StatisticsToadlet.drawPeerStatsBox(peerStatsInfobox, advancedMode, numberOfConnected, numberOfRoutingBackedOff, numberOfTooNew, numberOfTooOld, numberOfDisconnected, numberOfNeverConnected, numberOfDisabled, numberOfBursting, numberOfListening, numberOfListenOnly, 0, 0, numberOfRoutingDisabled, numberOfClockProblem, numberOfConnError, numberOfDisconnecting, numberOfNoLoadStats, this.node);
                if (advancedMode) {
                    int reasonCount;
                    HTMLNode reasonList;
                    HTMLNode backoffReasonInfobox = nextTableCell.addChild("div", "class", "infobox");
                    HTMLNode title = backoffReasonInfobox.addChild("div", "class", "infobox-header", "Peer backoff reasons (realtime)");
                    HTMLNode backoffReasonContent = backoffReasonInfobox.addChild("div", "class", "infobox-content");
                    String[] routingBackoffReasons = this.peers.getPeerNodeRoutingBackoffReasons(true);
                    int total = 0;
                    if (routingBackoffReasons.length == 0) {
                        backoffReasonContent.addChild("#", NodeL10n.getBase().getString("StatisticsToadlet.notBackedOff"));
                    } else {
                        reasonList = backoffReasonContent.addChild("ul");
                        for (String routingBackoffReason : routingBackoffReasons) {
                            reasonCount = this.peers.getPeerNodeRoutingBackoffReasonSize(routingBackoffReason, true);
                            if (reasonCount <= 0) continue;
                            total += reasonCount;
                            reasonList.addChild("li", routingBackoffReason + '\u00a0' + reasonCount);
                        }
                    }
                    if (total > 0) {
                        title.addChild("#", ": " + total);
                    }
                    backoffReasonInfobox = nextTableCell.addChild("div", "class", "infobox");
                    title = backoffReasonInfobox.addChild("div", "class", "infobox-header", "Peer backoff reasons (bulk)");
                    backoffReasonContent = backoffReasonInfobox.addChild("div", "class", "infobox-content");
                    routingBackoffReasons = this.peers.getPeerNodeRoutingBackoffReasons(false);
                    total = 0;
                    if (routingBackoffReasons.length == 0) {
                        backoffReasonContent.addChild("#", NodeL10n.getBase().getString("StatisticsToadlet.notBackedOff"));
                    } else {
                        reasonList = backoffReasonContent.addChild("ul");
                        for (String routingBackoffReason : routingBackoffReasons) {
                            reasonCount = this.peers.getPeerNodeRoutingBackoffReasonSize(routingBackoffReason, false);
                            if (reasonCount <= 0) continue;
                            total += reasonCount;
                            reasonList.addChild("li", routingBackoffReason + '\u00a0' + reasonCount);
                        }
                    }
                    if (total > 0) {
                        title.addChild("#", ": " + total);
                    }
                }
            }
            boolean enablePeerActions = this.showPeerActionsBox();
            if (fProxyJavascriptEnabled) {
                String js = "  function peerNoteChange() {\n    document.getElementById(\"action\").value = \"update_notes\";    document.getElementById(\"peersForm\").doAction.click();\n  }\n";
                contentNode.addChild("script", "type", "text/javascript").addChild("%", js);
                contentNode.addChild("script", new String[]{"type", "src"}, new String[]{"text/javascript", "/static/js/checkall.js"});
            }
            HTMLNode peerTableInfobox = contentNode.addChild("div", "class", "infobox infobox-normal");
            HTMLNode peerTableInfoboxHeader = peerTableInfobox.addChild("div", "class", "infobox-header");
            peerTableInfoboxHeader.addChild("#", this.getPeerListTitle());
            if (advancedMode && !path.endsWith("displaymessagetypes.html")) {
                peerTableInfoboxHeader.addChild("#", " ");
                peerTableInfoboxHeader.addChild("a", "href", "displaymessagetypes.html", ConnectionsToadlet.l10n("bracketedMoreDetailed"));
            }
            HTMLNode peerTableInfoboxContent = peerTableInfobox.addChild("div", "class", "infobox-content");
            if (!this.isOpennet()) {
                HTMLNode myName = peerTableInfoboxContent.addChild("p");
                myName.addChild("span", NodeL10n.getBase().getString("DarknetConnectionsToadlet.myName", "name", this.node.getMyName()));
                myName.addChild("span", " [");
                myName.addChild("span").addChild("a", "href", "/config/node#name", NodeL10n.getBase().getString("DarknetConnectionsToadlet.changeMyName"));
                myName.addChild("span", "]");
            }
            if (peerNodeStatuses.length == 0) {
                NodeL10n.getBase().addL10nSubstitution(peerTableInfoboxContent, "DarknetConnectionsToadlet.noPeersWithHomepageLink", new String[]{"link"}, new HTMLNode[]{HTMLNode.link("/")});
            } else {
                PeerNodeStatus[] peerNodeStatusArray;
                SimpleColumn[] endCols;
                HTMLNode peerTable;
                HTMLNode peerForm = null;
                if (enablePeerActions) {
                    peerForm = ctx.addFormChild(peerTableInfoboxContent, ".", "peersForm");
                    peerTable = peerForm.addChild("table", "class", "darknet_connections");
                } else {
                    peerTable = peerTableInfoboxContent.addChild("table", "class", "darknet_connections");
                }
                PeerNodeStatus[] peerTableHeaderRow = peerTable.addChild("tr");
                if (enablePeerActions) {
                    if (fProxyJavascriptEnabled) {
                        peerTableHeaderRow.addChild("th").addChild("input", new String[]{"type", "onclick"}, new String[]{"checkbox", "checkAll(this, 'darknet_connections')"});
                    } else {
                        peerTableHeaderRow.addChild("th");
                    }
                }
                peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "status")).addChild("#", ConnectionsToadlet.l10n("statusTitle"));
                if (this.hasNameColumn()) {
                    peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "name")).addChild("span", new String[]{"title", "style"}, new String[]{ConnectionsToadlet.l10n("nameClickToMessage"), "border-bottom: 1px dotted; cursor: help;"}, ConnectionsToadlet.l10n("nameTitle"));
                }
                if (this.hasTrustColumn()) {
                    peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "trust")).addChild("span", new String[]{"title", "style"}, new String[]{ConnectionsToadlet.l10n("trustMessage"), "border-bottom: 1px dotted; cursor: help;"}, ConnectionsToadlet.l10n("trustTitle"));
                }
                if (this.hasVisibilityColumn()) {
                    peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "trust")).addChild("span", new String[]{"title", "style"}, new String[]{ConnectionsToadlet.l10n("visibilityMessage" + (advancedMode ? "Advanced" : "Simple")), "border-bottom: 1px dotted; cursor: help;"}, ConnectionsToadlet.l10n("visibilityTitle"));
                }
                peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "address")).addChild("span", new String[]{"title", "style"}, new String[]{ConnectionsToadlet.l10n("ipAddress"), "border-bottom: 1px dotted; cursor: help;"}, ConnectionsToadlet.l10n("ipAddressTitle"));
                peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "version")).addChild("#", ConnectionsToadlet.l10n("versionTitle"));
                if (advancedMode) {
                    peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "location")).addChild("#", ConnectionsToadlet.l10n("locationTitle"));
                    peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "backoffRT")).addChild("span", new String[]{"title", "style"}, new String[]{"Other node busy (realtime)? Display: Percentage of time the node is overloaded, Current wait time remaining (0=not overloaded)/total/last overload reason", "border-bottom: 1px dotted; cursor: help;"}, "Backoff (realtime)");
                    peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "backoffBulk")).addChild("span", new String[]{"title", "style"}, new String[]{"Other node busy (bulk)? Display: Percentage of time the node is overloaded, Current wait time remaining (0=not overloaded)/total/last overload reason", "border-bottom: 1px dotted; cursor: help;"}, "Backoff (bulk)");
                    peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "overload_p")).addChild("span", new String[]{"title", "style"}, new String[]{"Probability of the node rejecting a request due to overload or causing a timeout.", "border-bottom: 1px dotted; cursor: help;"}, "Overload Probability");
                }
                peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "idle")).addChild("span", new String[]{"title", "style"}, new String[]{ConnectionsToadlet.l10n("idleTime"), "border-bottom: 1px dotted; cursor: help;"}, ConnectionsToadlet.l10n("idleTimeTitle"));
                if (this.hasPrivateNoteColumn()) {
                    peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "privnote")).addChild("span", new String[]{"title", "style"}, new String[]{ConnectionsToadlet.l10n("privateNote"), "border-bottom: 1px dotted; cursor: help;"}, ConnectionsToadlet.l10n("privateNoteTitle"));
                }
                if (advancedMode) {
                    peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "time_routable")).addChild("#", "%\u00a0Time Routable");
                    peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "selection_percentage")).addChild("#", "%\u00a0Selection");
                    peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "total_traffic")).addChild("#", "Total\u00a0Traffic\u00a0(in/out/resent)");
                    peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "total_traffic_since_startup")).addChild("#", "Total\u00a0Traffic\u00a0(in/out) since startup");
                    peerTableHeaderRow.addChild("th", "Congestion\u00a0Control");
                    peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "time_delta")).addChild("#", "Time\u00a0Delta");
                    peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "uptime")).addChild("#", "Reported\u00a0Uptime");
                    peerTableHeaderRow.addChild("th", "Transmit\u00a0Queue");
                    peerTableHeaderRow.addChild("th", "Peer\u00a0Capacity\u00a0Bulk");
                    peerTableHeaderRow.addChild("th", "Peer\u00a0Capacity\u00a0Realtime");
                }
                if ((endCols = this.endColumnHeaders(advancedMode)) != null) {
                    void var43_104;
                    SimpleColumn[] simpleColumnArray = endCols;
                    int routingMissDistanceRemote = simpleColumnArray.length;
                    boolean bl = false;
                    while (var43_104 < routingMissDistanceRemote) {
                        SimpleColumn col = simpleColumnArray[var43_104];
                        HTMLNode header = peerTableHeaderRow.addChild("th");
                        String sortString = col.getSortString();
                        if (sortString != null) {
                            header = header.addChild("a", "href", this.sortString(this.isReversed, sortString));
                        }
                        header.addChild("span", new String[]{"title", "style"}, new String[]{NodeL10n.getBase().getString(col.getExplanationKey()), "border-bottom: 1px dotted; cursor: help;"}, NodeL10n.getBase().getString(col.getTitleKey()));
                        ++var43_104;
                    }
                }
                double totalSelectionRate = 0.0;
                for (PeerNodeStatus status : peerNodeStatusArray = this.node.getPeers().getPeerNodeStatuses(true)) {
                    totalSelectionRate += status.getSelectionRate();
                }
                for (PeerNodeStatus peerNodeStatus : peerNodeStatuses) {
                    this.drawRow(peerTable, peerNodeStatus, advancedMode, fProxyJavascriptEnabled, now, path, enablePeerActions, endCols, drawMessageTypes, totalSelectionRate, fix1);
                }
                if (peerForm != null) {
                    this.drawPeerActionSelectBox(peerForm, advancedMode);
                }
            }
            if (advancedMode) {
                ArrayList<Double> locations = new ArrayList<Double>();
                ArrayList peerGroups = new ArrayList();
                for (PeerNodeStatus peerNodeStatus : peerNodeStatuses) {
                    double[] dArray = peerNodeStatus.getPeersLocation();
                    if (dArray == null) continue;
                    for (double location : dArray) {
                        List<PeerNodeStatus> peerGroup;
                        int i;
                        int max = locations.size();
                        for (i = 0; i < max && (Double)locations.get(i) < location; ++i) {
                        }
                        if (i < max && (Double)locations.get(i) == location) {
                            peerGroup = (List)peerGroups.get(i);
                        } else {
                            peerGroup = new ArrayList();
                            locations.add(i, location);
                            peerGroups.add(i, peerGroup);
                        }
                        peerGroup.add(peerNodeStatus);
                    }
                }
                int trivialCount = 0;
                int nonTrivialCount = 0;
                int transitiveCount = 0;
                for (List list : peerGroups) {
                    if (list.size() == 1) {
                        ++trivialCount;
                        continue;
                    }
                    ++nonTrivialCount;
                }
                peerTableInfoboxContent.addChild("b", ConnectionsToadlet.l10n("secondDegreeConnectionsCountTitle", "count", Integer.toString(locations.size())));
                peerTableInfoboxContent.addChild("br");
                if (!this.showTrivialFoafConnections) {
                    peerTableInfoboxContent.addChild("i", ConnectionsToadlet.l10n("secondDegreeTrivialHiddenCount", "count", Integer.toString(trivialCount)));
                } else {
                    peerTableInfoboxContent.addChild("i", ConnectionsToadlet.l10n("secondDegreeNonTrivialCount", "count", Integer.toString(nonTrivialCount)));
                }
                HTMLNode foafTable = peerTableInfoboxContent.addChild("table", "class", "darknet_connections");
                HTMLNode hTMLNode = foafTable.addChild("tr");
                hTMLNode.addChild("th", ConnectionsToadlet.l10n("locationTitle"));
                hTMLNode.addChild("th", ConnectionsToadlet.l10n("countTitle"));
                hTMLNode.addChild("th", ConnectionsToadlet.l10n("foafReachableThroughTitle"));
                int max = locations.size();
                for (int i = 0; i < max; ++i) {
                    double location = (Double)locations.get(i);
                    List peersWithFriend = (List)peerGroups.get(i);
                    boolean isTransitivePeer = false;
                    for (PeerNodeStatus peerNodeStatus : peerNodeStatuses) {
                        if (location != peerNodeStatus.getLocation()) continue;
                        isTransitivePeer = true;
                        ++transitiveCount;
                        break;
                    }
                    if (peersWithFriend.size() == 1 && !this.showTrivialFoafConnections && !isTransitivePeer) continue;
                    HTMLNode hTMLNode2 = foafTable.addChild("tr");
                    if (isTransitivePeer) {
                        hTMLNode2.addChild("td").addChild("b", String.valueOf(location));
                    } else {
                        hTMLNode2.addChild("td", String.valueOf(location));
                    }
                    hTMLNode2.addChild("td", String.valueOf(peersWithFriend.size()));
                    HTMLNode locationCell = hTMLNode2.addChild("td", "class", "peer-location");
                    for (PeerNodeStatus peerNodeStatus : peersWithFriend) {
                        String address = peerNodeStatus.getPeerAddress() != null ? peerNodeStatus.getPeerAddress() + ':' + peerNodeStatus.getPeerPort() : ConnectionsToadlet.l10n("unknownAddress");
                        locationCell.addChild("i", address);
                        locationCell.addChild("br");
                    }
                }
                if (transitiveCount > 0) {
                    peerTableInfoboxContent.addChild("i", ConnectionsToadlet.l10n("secondDegreeAlsoOurs", "count", Integer.toString(transitiveCount)));
                }
            }
        } else if (!this.isOpennet()) {
            try {
                throw new RedirectException("/addfriend/");
            }
            catch (URISyntaxException e) {
                Logger.error(this, "Impossible: " + e + " for /addfriend/", (Throwable)e);
            }
        }
        if (this.shouldDrawNoderefBox(advancedMode)) {
            this.drawAddPeerBox(contentNode, ctx);
            this.drawNoderefBox(contentNode, this.getNoderef());
        }
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    protected abstract boolean acceptRefPosts();

    protected abstract String defaultRedirectLocation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMethodPOST(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException, ConfigException {
        boolean logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        if (!this.acceptRefPosts()) {
            this.sendUnauthorizedPage(ctx);
            return;
        }
        if (!ctx.checkFullAccess(this)) {
            return;
        }
        if (request.isPartSet("add")) {
            int idx;
            String urltext = request.getPartAsStringFailsafe("url", 200);
            urltext = urltext.trim();
            String reftext = request.getPartAsStringFailsafe("ref", Integer.MAX_VALUE);
            if ((reftext = reftext.trim()).length() < 200) {
                reftext = request.getPartAsStringFailsafe("reffile", Integer.MAX_VALUE);
                reftext = reftext.trim();
            }
            String privateComment = null;
            if (!this.isOpennet()) {
                privateComment = request.getPartAsStringFailsafe("peerPrivateNote", 250).trim();
            }
            if (Boolean.parseBoolean(request.getPartAsStringFailsafe("peers-offers-files", 5))) {
                File[] files = this.core.getNode().runDir().file("peers-offers").listFiles();
                if (files != null && files.length > 0) {
                    StringBuilder peersOffersFilesContent = new StringBuilder();
                    for (File file : files) {
                        String filename;
                        if (!file.isFile() || !(filename = file.getName()).endsWith(".fref")) continue;
                        peersOffersFilesContent.append((CharSequence)FileUtil.readUTF(file));
                    }
                    reftext = peersOffersFilesContent.toString();
                }
                this.node.getConfig().get("node").set("peersOffersDismissed", true);
            }
            String trustS = request.getPartAsStringFailsafe("trust", 10);
            DarknetPeerNode.FRIEND_TRUST trust = null;
            if (trustS != null && !trustS.isEmpty()) {
                trust = DarknetPeerNode.FRIEND_TRUST.valueOf(trustS);
            }
            String visibilityS = request.getPartAsStringFailsafe("visibility", 10);
            DarknetPeerNode.FRIEND_VISIBILITY visibility = null;
            if (visibilityS != null && !visibilityS.isEmpty()) {
                visibility = DarknetPeerNode.FRIEND_VISIBILITY.valueOf(visibilityS);
            }
            if (trust == null && !this.isOpennet()) {
                this.sendErrorPage(ctx, 200, ConnectionsToadlet.l10n("noTrustLevelAddingFriendTitle"), ConnectionsToadlet.l10n("noTrustLevelAddingFriend"), !this.isOpennet());
                return;
            }
            if (visibility == null && !this.isOpennet()) {
                this.sendErrorPage(ctx, 200, ConnectionsToadlet.l10n("noVisibilityLevelAddingFriendTitle"), ConnectionsToadlet.l10n("noVisibilityLevelAddingFriend"), !this.isOpennet());
                return;
            }
            StringBuilder ref = null;
            if (urltext.length() > 0) {
                Closeable in = null;
                try {
                    try {
                        FreenetURI refUri = new FreenetURI(urltext);
                        ref = AddPeer.getReferenceFromFreenetURI(refUri, this.client);
                    }
                    catch (FetchException | MalformedURLException e) {
                        Logger.warning(this, "Url cannot be used as Freenet URI, trying to fetch as URL: " + urltext);
                        URL url = new URL(urltext);
                        ref = AddPeer.getReferenceFromURL(url);
                    }
                }
                catch (IOException e) {
                    this.sendErrorPage(ctx, 200, ConnectionsToadlet.l10n("failedToAddNodeTitle"), NodeL10n.getBase().getString("DarknetConnectionsToadlet.cantFetchNoderefURL", new String[]{"url"}, new String[]{urltext}), !this.isOpennet());
                    return;
                }
                finally {
                    Closer.close(in);
                }
            } else if (reftext.length() > 0) {
                ref = new StringBuilder(reftext.replaceAll(".*?((?:[\\w,\\.]+\\=[^\r\n]+?)|(?:End))[ \\t]*(?:\\r?\\n)+", "$1\n"));
            } else {
                this.sendErrorPage(ctx, 200, ConnectionsToadlet.l10n("failedToAddNodeTitle"), ConnectionsToadlet.l10n("noRefOrURL"), !this.isOpennet());
                request.freeParts();
                return;
            }
            ref = new StringBuilder(ref.toString().trim());
            request.freeParts();
            while ((idx = ref.indexOf("\r\n")) > -1) {
                ref.deleteCharAt(idx);
            }
            while ((idx = ref.indexOf("\r")) > -1) {
                ref.setCharAt(idx, '\n');
            }
            String[] nodesToAdd = ref.toString().split("\nEnd\n");
            for (int i = 0; i < nodesToAdd.length; ++i) {
                String[] split = nodesToAdd[i].split("\n");
                StringBuffer sb = new StringBuffer(nodesToAdd[i].length());
                boolean first = true;
                for (String s : split) {
                    if (s.equals("End")) break;
                    if (s.indexOf(61) > -1 && !first) {
                        sb.append('\n');
                    }
                    sb.append(s);
                    first = false;
                }
                nodesToAdd[i] = sb.toString();
            }
            HashMap<PeerAdditionReturnCodes, Integer> results = new HashMap<PeerAdditionReturnCodes, Integer>();
            for (int i = 0; i < nodesToAdd.length; ++i) {
                PeerAdditionReturnCodes result = this.addNewNode(nodesToAdd[i].trim().concat("\nEnd"), privateComment, trust, visibility);
                Integer prev = (Integer)results.get((Object)result);
                if (prev == null) {
                    prev = 0;
                }
                results.put(result, prev + 1);
            }
            PageNode page = ctx.getPageMaker().getPageNode(ConnectionsToadlet.l10n("reportOfNodeAddition"), ctx);
            HTMLNode pageNode = page.outer;
            HTMLNode contentNode = page.content;
            HTMLNode detailedStatusBox = new HTMLNode("table");
            detailedStatusBox.addChild(new HTMLNode("tr")).addChildren(new HTMLNode[]{new HTMLNode("th", ConnectionsToadlet.l10n("resultName")), new HTMLNode("th", ConnectionsToadlet.l10n("numOfResults"))});
            HTMLNode statusBoxTable = detailedStatusBox.addChild(new HTMLNode("tbody"));
            for (PeerAdditionReturnCodes returnCode : PeerAdditionReturnCodes.values()) {
                if (!results.containsKey((Object)returnCode)) continue;
                statusBoxTable.addChild(new HTMLNode("tr", "style", "color:" + (returnCode == PeerAdditionReturnCodes.OK ? "green" : "red"))).addChildren(new HTMLNode[]{new HTMLNode("td", ConnectionsToadlet.l10n("peerAdditionCode." + returnCode.toString())), new HTMLNode("td", ((Integer)results.get((Object)returnCode)).toString())});
            }
            HTMLNode infoboxContent = ctx.getPageMaker().getInfobox("infobox", ConnectionsToadlet.l10n("reportOfNodeAddition"), contentNode, "node-added", true);
            infoboxContent.addChild(detailedStatusBox);
            if (!this.isOpennet()) {
                infoboxContent.addChild("p").addChild("a", "href", "/addfriend/", ConnectionsToadlet.l10n("addAnotherFriend"));
            }
            infoboxContent.addChild("p").addChild("a", "href", this.path(), ConnectionsToadlet.l10n("goFriendConnectionStatus"));
            ConnectionsToadlet.addHomepageLink(infoboxContent.addChild("p"));
            this.writeHTMLReply(ctx, 500, ConnectionsToadlet.l10n("reportOfNodeAddition"), pageNode.generate());
        } else {
            this.handleAltPost(uri, request, ctx, logMINOR);
        }
    }

    private PeerAdditionReturnCodes addNewNode(String nodeReference, String privateComment, DarknetPeerNode.FRIEND_TRUST trust, DarknetPeerNode.FRIEND_VISIBILITY visibility) {
        PeerNode pn;
        SimpleFieldSet fs;
        try {
            fs = ConnectionsToadlet.parseNoderefLiberally(nodeReference);
            if (!fs.getEndMarker().endsWith("End")) {
                Logger.error(this, "Trying to add noderef with end marker \"" + fs.getEndMarker() + "\"");
                return PeerAdditionReturnCodes.WRONG_ENCODING;
            }
            fs.setEndMarker("End");
        }
        catch (IOException e) {
            Logger.error(this, "IOException adding reference :" + e.getMessage(), (Throwable)e);
            return PeerAdditionReturnCodes.CANT_PARSE;
        }
        catch (Throwable t) {
            Logger.error(this, "Internal error adding reference :" + t.getMessage(), t);
            return PeerAdditionReturnCodes.INTERNAL_ERROR;
        }
        try {
            if (this.isOpennet()) {
                pn = this.node.createNewOpennetNode(fs);
            } else {
                pn = this.node.createNewDarknetNode(fs, trust, visibility);
                ((DarknetPeerNode)pn).setPrivateDarknetCommentNote(privateComment);
            }
        }
        catch (FSParseException e1) {
            return PeerAdditionReturnCodes.CANT_PARSE;
        }
        catch (PeerParseException e1) {
            return PeerAdditionReturnCodes.CANT_PARSE;
        }
        catch (ReferenceSignatureVerificationException e1) {
            return PeerAdditionReturnCodes.INVALID_SIGNATURE;
        }
        catch (Throwable t) {
            Logger.error(this, "Internal error adding reference :" + t.getMessage(), t);
            return PeerAdditionReturnCodes.INTERNAL_ERROR;
        }
        if (Arrays.equals(pn.peerECDSAPubKeyHash, this.node.getDarknetPubKeyHash())) {
            return PeerAdditionReturnCodes.TRY_TO_ADD_SELF;
        }
        if (!this.node.addPeerConnection(pn)) {
            return PeerAdditionReturnCodes.ALREADY_IN_REFERENCE;
        }
        return PeerAdditionReturnCodes.OK;
    }

    private static SimpleFieldSet parseNoderefLiberally(String nodeReference) throws IOException {
        SimpleFieldSet fs = new SimpleFieldSet(nodeReference = Fields.trimLines(nodeReference), false, true, true);
        if (fs.directKeys().contains("lastGoodVersion")) {
            return fs;
        }
        Logger.warning(null, "Cannot parse noderef: does not contain lastGoodVersion, trying to replace all spaces with newlines and parsing again.");
        return new SimpleFieldSet(nodeReference.replace(" ", "\n"), false, true, true);
    }

    protected abstract boolean isOpennet();

    protected void handleAltPost(URI uri, HTTPRequest request, ToadletContext ctx, boolean logMINOR) throws ToadletContextClosedException, IOException, RedirectException {
        this.handleMethodGET(uri, new HTTPRequestImpl(uri, "GET"), ctx);
    }

    protected abstract String getPeerListTitle();

    protected abstract boolean showPeerActionsBox();

    protected abstract void drawPeerActionSelectBox(HTMLNode var1, boolean var2);

    protected abstract boolean shouldDrawNoderefBox(boolean var1);

    void drawNoderefBox(HTMLNode contentNode, SimpleFieldSet fs) {
        HTMLNode referenceInfobox = contentNode.addChild("div", "class", "infobox infobox-normal");
        HTMLNode headerReferenceInfobox = referenceInfobox.addChild("div", "class", "infobox-header");
        NodeL10n.getBase().addL10nSubstitution(headerReferenceInfobox, "DarknetConnectionsToadlet.myReferenceHeader", new String[]{"linkref", "linktext"}, new HTMLNode[]{this.REF_LINK, this.REFTEXT_LINK});
        HTMLNode referenceInfoboxContent = referenceInfobox.addChild("div", "class", "infobox-content");
        if (!this.isOpennet()) {
            HTMLNode myName = referenceInfoboxContent.addChild("p");
            myName.addChild("span", NodeL10n.getBase().getString("DarknetConnectionsToadlet.myName", "name", fs.get("myName")));
            myName.addChild("span", " [");
            myName.addChild("span").addChild("a", "href", "/config/node#name", NodeL10n.getBase().getString("DarknetConnectionsToadlet.changeMyName"));
            myName.addChild("span", "]");
        }
        HTMLNode warningSentence = referenceInfoboxContent.addChild("p");
        NodeL10n.getBase().addL10nSubstitution(warningSentence, "DarknetConnectionsToadlet.referenceCopyWarning", new String[]{"bold"}, new HTMLNode[]{HTMLNode.STRONG});
        referenceInfoboxContent.addChild("pre", "id", "reference", fs.toOrderedStringWithBase64() + '\n');
        if (!this.isOpennet()) {
            HTMLNode myIps = referenceInfoboxContent.addChild("p");
            myIps.addChild("span", NodeL10n.getBase().getString("DarknetConnectionsToadlet.myIps", "ips", fs.get("physical.udp")));
        }
    }

    protected abstract String getPageTitle(String var1);

    protected void drawAddPeerBox(HTMLNode contentNode, ToadletContext ctx) {
        ConnectionsToadlet.drawAddPeerBox(contentNode, ctx, this.isOpennet(), this.path());
    }

    protected static void drawAddPeerBox(HTMLNode contentNode, ToadletContext ctx, boolean isOpennet, String formTarget) {
        HTMLNode peerAdditionInfobox = contentNode.addChild("div", "class", "infobox infobox-normal");
        peerAdditionInfobox.addChild("div", "class", "infobox-header", ConnectionsToadlet.l10n(isOpennet ? "addOpennetPeerTitle" : "addPeerTitle"));
        HTMLNode peerAdditionContent = peerAdditionInfobox.addChild("div", "class", "infobox-content");
        HTMLNode peerAdditionForm = ctx.addFormChild(peerAdditionContent, formTarget, "addPeerForm");
        peerAdditionForm.addChild("#", ConnectionsToadlet.l10n("pasteReference"));
        peerAdditionForm.addChild("br");
        peerAdditionForm.addChild("textarea", new String[]{"id", "name", "rows", "cols"}, new String[]{"reftext", "ref", "8", "74"});
        peerAdditionForm.addChild("br");
        peerAdditionForm.addChild("#", ConnectionsToadlet.l10n("urlReference") + ' ');
        peerAdditionForm.addChild("input", new String[]{"id", "type", "name"}, new String[]{"refurl", "text", "url"});
        peerAdditionForm.addChild("br");
        peerAdditionForm.addChild("#", ConnectionsToadlet.l10n("fileReference") + ' ');
        peerAdditionForm.addChild("input", new String[]{"id", "type", "name"}, new String[]{"reffile", "file", "reffile"});
        peerAdditionForm.addChild("br");
        if (!isOpennet) {
            peerAdditionForm.addChild(new PeerTrustInputForAddPeerBoxNode());
            peerAdditionForm.addChild(new PeerVisibilityInputForAddPeerBoxNode());
        }
        if (!isOpennet) {
            peerAdditionForm.addChild("#", ConnectionsToadlet.l10n("enterDescription") + ' ');
            peerAdditionForm.addChild("input", new String[]{"id", "type", "name", "size", "maxlength", "value"}, new String[]{"peerPrivateNote", "text", "peerPrivateNote", "16", "250", ""});
            peerAdditionForm.addChild("br");
        }
        peerAdditionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "add", ConnectionsToadlet.l10n("add")});
    }

    protected Comparator<PeerNodeStatus> comparator(String sortBy, boolean reversed) {
        return new ComparatorByStatus(sortBy, reversed);
    }

    protected abstract PeerNodeStatus[] getPeerNodeStatuses(boolean var1);

    protected abstract SimpleFieldSet getNoderef();

    private void drawRow(HTMLNode peerTable, PeerNodeStatus peerNodeStatus, boolean advancedModeEnabled, boolean fProxyJavascriptEnabled, long now, String path, boolean enablePeerActions, SimpleColumn[] endCols, boolean drawMessageTypes, double totalSelectionRate, DecimalFormat fix1) {
        byte[] addr;
        double selectionRate = peerNodeStatus.getSelectionRate();
        int peerSelectionPercentage = 0;
        if (totalSelectionRate > 0.0) {
            peerSelectionPercentage = (int)(selectionRate * 100.0 / totalSelectionRate);
        }
        HTMLNode peerRow = peerTable.addChild("tr", "class", "darknet_connections_" + (peerSelectionPercentage > 30 ? "warning" : "normal"));
        if (enablePeerActions) {
            peerRow.addChild("td", "class", "peer-marker").addChild("input", new String[]{"type", "name"}, new String[]{"checkbox", "node_" + peerNodeStatus.hashCode()});
        }
        String statusString = peerNodeStatus.getStatusName();
        if (!advancedModeEnabled && peerNodeStatus.getStatusValue() == 2) {
            statusString = "BUSY";
        }
        String key = "ConnectionsToadlet.nodeStatus." + statusString.replace(' ', '_');
        peerRow.addChild("td", "class", "peer-status").addChild("span", "class", peerNodeStatus.getStatusCSSName(), NodeL10n.getBase().getString(key) + (peerNodeStatus.isFetchingARK() ? "*" : ""));
        this.drawNameColumn(peerRow, peerNodeStatus, advancedModeEnabled);
        this.drawTrustColumn(peerRow, peerNodeStatus);
        this.drawVisibilityColumn(peerRow, peerNodeStatus, advancedModeEnabled);
        String pingTime = "";
        if (peerNodeStatus.isConnected()) {
            pingTime = " (" + (int)peerNodeStatus.getAveragePingTime() + "ms / " + (int)peerNodeStatus.getAveragePingTimeCorrected() + "ms)";
        }
        HTMLNode addressRow = peerRow.addChild("td", "class", "peer-address");
        IPConverter ipc = IPConverter.getInstance(NodeFile.IPv4ToCountry.getFile(this.node));
        IPConverter.Country country = ipc.locateIP(addr = peerNodeStatus.getPeerAddressBytes());
        if (country != null) {
            country.renderFlagIcon(addressRow);
        }
        addressRow.addChild("#", (peerNodeStatus.getPeerAddress() != null ? peerNodeStatus.getPeerAddress() + ':' + peerNodeStatus.getPeerPort() : ConnectionsToadlet.l10n("unknownAddress")) + pingTime);
        if (peerNodeStatus.getStatusValue() != 6 && (peerNodeStatus.isPublicInvalidVersion() || peerNodeStatus.isPublicReverseInvalidVersion())) {
            peerRow.addChild("td", "class", "peer-version").addChild("span", "class", "peer_version_problem", Integer.toString(peerNodeStatus.getSimpleVersion()));
        } else {
            peerRow.addChild("td", "class", "peer-version").addChild("#", Integer.toString(peerNodeStatus.getSimpleVersion()));
        }
        if (advancedModeEnabled) {
            HTMLNode locationNode = peerRow.addChild("td", "class", "peer-location");
            locationNode.addChild("b", String.valueOf(peerNodeStatus.getLocation()));
            locationNode.addChild("br");
            double[] peersLoc = peerNodeStatus.getPeersLocation();
            if (peersLoc != null) {
                locationNode.addChild("i", "+" + peersLoc.length + " friends");
            }
        }
        if (advancedModeEnabled) {
            HTMLNode backoffCell = peerRow.addChild("td", "class", "peer-backoff");
            backoffCell.addChild("#", fix1.format(peerNodeStatus.getBackedOffPercent(true)));
            int backoff = (int)Math.max(peerNodeStatus.getRoutingBackedOffUntil(true) - now, 0L);
            if (backoff > 0 && backoff < 1000) {
                backoff = 1000;
            }
            backoffCell.addChild("#", ' ' + String.valueOf(backoff / 1000) + '/' + String.valueOf(peerNodeStatus.getRoutingBackoffLength(true) / 1000L));
            backoffCell.addChild("#", peerNodeStatus.getLastBackoffReason(true) == null ? "" : '/' + peerNodeStatus.getLastBackoffReason(true));
            backoffCell = peerRow.addChild("td", "class", "peer-backoff");
            backoffCell.addChild("#", fix1.format(peerNodeStatus.getBackedOffPercent(false)));
            backoff = (int)Math.max(peerNodeStatus.getRoutingBackedOffUntil(false) - now, 0L);
            if (backoff > 0 && backoff < 1000) {
                backoff = 1000;
            }
            backoffCell.addChild("#", ' ' + String.valueOf(backoff / 1000) + '/' + String.valueOf(peerNodeStatus.getRoutingBackoffLength(false) / 1000L));
            backoffCell.addChild("#", peerNodeStatus.getLastBackoffReason(false) == null ? "" : '/' + peerNodeStatus.getLastBackoffReason(false));
            HTMLNode pRejectCell = peerRow.addChild("td", "class", "peer-backoff");
            pRejectCell.addChild("#", fix1.format(peerNodeStatus.getPReject()));
        }
        long idle = peerNodeStatus.getTimeLastRoutable();
        if (peerNodeStatus.isRoutable()) {
            idle = peerNodeStatus.getTimeLastConnectionCompleted();
        } else if (peerNodeStatus.getStatusValue() == 6) {
            idle = peerNodeStatus.getPeerAddedTime();
        }
        if (!peerNodeStatus.isConnected() && now - idle > 1209600000L) {
            peerRow.addChild("td", "class", "peer-idle").addChild("span", "class", "peer_idle_old", this.idleToString(now, idle));
        } else {
            peerRow.addChild("td", "class", "peer-idle", this.idleToString(now, idle));
        }
        if (this.hasPrivateNoteColumn()) {
            this.drawPrivateNoteColumn(peerRow, peerNodeStatus, fProxyJavascriptEnabled);
        }
        if (advancedModeEnabled) {
            peerRow.addChild("td", "class", "peer-idle").addChild("#", fix1.format(peerNodeStatus.getPercentTimeRoutableConnection()));
            peerRow.addChild("td", "class", "peer-idle").addChild("#", totalSelectionRate > 0.0 ? peerSelectionPercentage + "%" : "N/A");
            long sent = peerNodeStatus.getTotalOutputBytes();
            long resent = peerNodeStatus.getResendBytesSent();
            long received = peerNodeStatus.getTotalInputBytes();
            peerRow.addChild("td", "class", "peer-idle").addChild("#", SizeUtil.formatSize(received) + " / " + SizeUtil.formatSize(sent) + "/" + SizeUtil.formatSize(resent) + " (" + fix1.format((double)resent / (double)sent) + ")");
            peerRow.addChild("td", "class", "peer-idle").addChild("#", SizeUtil.formatSize(peerNodeStatus.getTotalInputSinceStartup()) + " / " + SizeUtil.formatSize(peerNodeStatus.getTotalOutputSinceStartup()));
            PacketThrottle t = peerNodeStatus.getThrottle();
            String val = t == null ? "none" : (int)t.getBandwidth() + "B/sec delay " + t.getDelay() + "ms (RTT " + t.getRoundTripTime() + "ms window " + t.getWindowSize() + ')';
            peerRow.addChild("td", "class", "peer-idle").addChild("#", val);
            peerRow.addChild("td", "class", "peer-idle").addChild("#", TimeUtil.formatTime(peerNodeStatus.getClockDelta()));
            peerRow.addChild("td", "class", "peer-idle").addChild("#", peerNodeStatus.getReportedUptimePercentage() + "%");
            peerRow.addChild("td", "class", "peer-idle").addChild("#", SizeUtil.formatSize(peerNodeStatus.getMessageQueueLengthBytes()) + ":" + TimeUtil.formatTime(peerNodeStatus.getMessageQueueLengthTime()));
            PeerNode.IncomingLoadSummaryStats loadStatsBulk = peerNodeStatus.incomingLoadStatsBulk;
            if (loadStatsBulk == null) {
                peerRow.addChild("td", "class", "peer-idle");
            } else {
                peerRow.addChild("td", "class", "peer-idle").addChild("#", loadStatsBulk.runningRequestsTotal + "reqs:out:" + SizeUtil.formatSize(loadStatsBulk.usedCapacityOutputBytes) + "/" + SizeUtil.formatSize(loadStatsBulk.othersUsedCapacityOutputBytes) + "/" + SizeUtil.formatSize(loadStatsBulk.peerCapacityOutputBytes) + "/" + SizeUtil.formatSize(loadStatsBulk.totalCapacityOutputBytes) + ":in:" + SizeUtil.formatSize(loadStatsBulk.usedCapacityInputBytes) + "/" + SizeUtil.formatSize(loadStatsBulk.othersUsedCapacityInputBytes) + "/" + SizeUtil.formatSize(loadStatsBulk.peerCapacityInputBytes) + "/" + SizeUtil.formatSize(loadStatsBulk.totalCapacityInputBytes));
            }
            PeerNode.IncomingLoadSummaryStats loadStatsRT = peerNodeStatus.incomingLoadStatsRealTime;
            if (loadStatsRT == null) {
                peerRow.addChild("td", "class", "peer-idle");
            } else {
                peerRow.addChild("td", "class", "peer-idle").addChild("#", loadStatsRT.runningRequestsTotal + "reqs:out:" + SizeUtil.formatSize(loadStatsRT.usedCapacityOutputBytes) + "/" + SizeUtil.formatSize(loadStatsRT.othersUsedCapacityOutputBytes) + "/" + SizeUtil.formatSize(loadStatsRT.peerCapacityOutputBytes) + "/" + SizeUtil.formatSize(loadStatsRT.totalCapacityOutputBytes) + ":in:" + SizeUtil.formatSize(loadStatsRT.usedCapacityInputBytes) + "/" + SizeUtil.formatSize(loadStatsRT.othersUsedCapacityInputBytes) + "/" + SizeUtil.formatSize(loadStatsRT.peerCapacityInputBytes) + "/" + SizeUtil.formatSize(loadStatsRT.totalCapacityInputBytes));
            }
        }
        if (endCols != null) {
            for (SimpleColumn col : endCols) {
                col.drawColumn(peerRow, peerNodeStatus);
            }
        }
        if (drawMessageTypes) {
            this.drawMessageTypes(peerTable, peerNodeStatus);
        }
    }

    protected boolean hasTrustColumn() {
        return false;
    }

    protected void drawTrustColumn(HTMLNode peerRow, PeerNodeStatus peerNodeStatus) {
    }

    protected boolean hasVisibilityColumn() {
        return false;
    }

    protected void drawVisibilityColumn(HTMLNode peerRow, PeerNodeStatus peerNodeStatus, boolean advancedModeEnabled) {
    }

    protected abstract boolean hasNameColumn();

    protected abstract void drawNameColumn(HTMLNode var1, PeerNodeStatus var2, boolean var3);

    protected abstract boolean hasPrivateNoteColumn();

    protected abstract void drawPrivateNoteColumn(HTMLNode var1, PeerNodeStatus var2, boolean var3);

    private void drawMessageTypes(HTMLNode peerTable, PeerNodeStatus peerNodeStatus) {
        Long messageCount;
        String messageName;
        HTMLNode messageCountRow = peerTable.addChild("tr", "class", "message-status");
        messageCountRow.addChild("td", "colspan", "2");
        HTMLNode messageCountCell = messageCountRow.addChild("td", "colspan", "9");
        HTMLNode messageCountTable = messageCountCell.addChild("table", "class", "message-count");
        HTMLNode countHeaderRow = messageCountTable.addChild("tr");
        countHeaderRow.addChild("th", "Message");
        countHeaderRow.addChild("th", "Incoming");
        countHeaderRow.addChild("th", "Outgoing");
        ArrayList<String> messageNames = new ArrayList<String>();
        HashMap<String, Long[]> messageCounts = new HashMap<String, Long[]>();
        for (Map.Entry<String, Long> entry : peerNodeStatus.getLocalMessagesReceived().entrySet()) {
            messageName = entry.getKey();
            messageCount = entry.getValue();
            messageNames.add(messageName);
            messageCounts.put(messageName, new Long[]{messageCount, 0L});
        }
        for (Map.Entry<String, Long> entry : peerNodeStatus.getLocalMessagesSent().entrySet()) {
            Long[] existingCounts;
            messageName = entry.getKey();
            messageCount = entry.getValue();
            if (!messageNames.contains(messageName)) {
                messageNames.add(messageName);
            }
            if ((existingCounts = (Long[])messageCounts.get(messageName)) == null) {
                messageCounts.put(messageName, new Long[]{0L, messageCount});
                continue;
            }
            existingCounts[1] = messageCount;
        }
        Collections.sort(messageNames, new Comparator<String>(){

            @Override
            public int compare(String first, String second) {
                return first.compareToIgnoreCase(second);
            }
        });
        for (String messageName2 : messageNames) {
            Long[] messageCount2 = (Long[])messageCounts.get(messageName2);
            HTMLNode messageRow = messageCountTable.addChild("tr");
            messageRow.addChild("td", messageName2);
            messageRow.addChild("td", "class", "right-align", String.valueOf(messageCount2[0]));
            messageRow.addChild("td", "class", "right-align", String.valueOf(messageCount2[1]));
        }
    }

    private String idleToString(long now, long idle) {
        if (idle <= 0L) {
            return " ";
        }
        long idleMilliseconds = now - idle;
        return TimeUtil.formatTime(idleMilliseconds);
    }

    private static String l10n(String string) {
        return NodeL10n.getBase().getString("DarknetConnectionsToadlet." + string);
    }

    private static String l10n(String string, String pattern, String value) {
        return NodeL10n.getBase().getString("DarknetConnectionsToadlet." + string, pattern, value);
    }

    private String sortString(boolean isReversed, String type) {
        return isReversed ? "?sortBy=" + type : "?sortBy=" + type + "&reversed";
    }

    protected void sendErrorPage(ToadletContext ctx, int code, String desc, String message, boolean returnToAddFriends) throws ToadletContextClosedException, IOException {
        PageNode page = ctx.getPageMaker().getPageNode(desc, ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        HTMLNode infoboxContent = ctx.getPageMaker().getInfobox("infobox-error", desc, contentNode, null, true);
        infoboxContent.addChild("#", message);
        if (returnToAddFriends) {
            infoboxContent.addChild("br");
            infoboxContent.addChild("a", "href", "/addfriend/", ConnectionsToadlet.l10n("returnToAddAFriendPage"));
            infoboxContent.addChild("br");
        } else {
            infoboxContent.addChild("br");
            infoboxContent.addChild("a", "href", ".", ConnectionsToadlet.l10n("returnToPrevPage"));
            infoboxContent.addChild("br");
        }
        ConnectionsToadlet.addHomepageLink(infoboxContent);
        this.writeHTMLReply(ctx, code, desc, pageNode.generate());
    }

    abstract class SimpleColumn {
        SimpleColumn() {
        }

        protected abstract void drawColumn(HTMLNode var1, PeerNodeStatus var2);

        public abstract String getSortString();

        public abstract String getTitleKey();

        public abstract String getExplanationKey();
    }

    public static enum PeerAdditionReturnCodes {
        OK,
        WRONG_ENCODING,
        CANT_PARSE,
        INTERNAL_ERROR,
        INVALID_SIGNATURE,
        TRY_TO_ADD_SELF,
        ALREADY_IN_REFERENCE;

    }

    protected class ComparatorByStatus
    implements Comparator<PeerNodeStatus> {
        protected final String sortBy;
        protected final boolean reversed;

        ComparatorByStatus(String sortBy, boolean reversed) {
            this.sortBy = sortBy;
            this.reversed = reversed;
        }

        @Override
        public int compare(PeerNodeStatus firstNode, PeerNodeStatus secondNode) {
            int result = 0;
            boolean isSet = true;
            isSet = this.sortBy != null ? (result = this.customCompare(firstNode, secondNode, this.sortBy)) != 0 : false;
            if (!isSet) {
                int statusDifference = firstNode.getStatusValue() - secondNode.getStatusValue();
                result = statusDifference != 0 ? (statusDifference < 0 ? -1 : 1) : this.lastResortCompare(firstNode, secondNode);
            }
            if (result == 0) {
                return 0;
            }
            if (this.reversed) {
                ConnectionsToadlet.this.isReversed = true;
                return result > 0 ? -1 : 1;
            }
            ConnectionsToadlet.this.isReversed = false;
            return result < 0 ? -1 : 1;
        }

        private int compareLongs(long long1, long long2) {
            int diff = Long.valueOf(long1).compareTo(long2);
            if (diff == 0) {
                return 0;
            }
            return diff > 0 ? 1 : -1;
        }

        private int compareInts(int int1, int int2) {
            int diff = Integer.valueOf(int1).compareTo(int2);
            if (diff == 0) {
                return 0;
            }
            return diff > 0 ? 1 : -1;
        }

        protected int customCompare(PeerNodeStatus firstNode, PeerNodeStatus secondNode, String sortBy2) {
            switch (this.sortBy) {
                case "address": {
                    return firstNode.getPeerAddress().compareToIgnoreCase(secondNode.getPeerAddress());
                }
                case "location": {
                    return this.compareLocations(firstNode, secondNode);
                }
                case "version": {
                    return Version.getArbitraryBuildNumber(firstNode.getVersion(), -1) - Version.getArbitraryBuildNumber(secondNode.getVersion(), -1);
                }
                case "backoffRT": {
                    return Double.compare(firstNode.getBackedOffPercent(true), secondNode.getBackedOffPercent(true));
                }
                case "backoffBulk": {
                    return Double.compare(firstNode.getBackedOffPercent(false), secondNode.getBackedOffPercent(false));
                }
                case "overload_p": {
                    return Double.compare(firstNode.getPReject(), secondNode.getPReject());
                }
                case "idle": {
                    return this.compareLongs(firstNode.getTimeLastConnectionCompleted(), secondNode.getTimeLastConnectionCompleted());
                }
                case "time_routable": {
                    return Double.compare(firstNode.getPercentTimeRoutableConnection(), secondNode.getPercentTimeRoutableConnection());
                }
                case "total_traffic": {
                    long total1 = firstNode.getTotalInputBytes() + firstNode.getTotalOutputBytes();
                    long total2 = secondNode.getTotalInputBytes() + secondNode.getTotalOutputBytes();
                    return this.compareLongs(total1, total2);
                }
                case "total_traffic_since_startup": {
                    long total1 = firstNode.getTotalInputSinceStartup() + firstNode.getTotalOutputSinceStartup();
                    long total2 = secondNode.getTotalInputSinceStartup() + secondNode.getTotalOutputSinceStartup();
                    return this.compareLongs(total1, total2);
                }
                case "selection_percentage": {
                    return Double.compare(firstNode.getSelectionRate(), secondNode.getSelectionRate());
                }
                case "time_delta": {
                    return this.compareLongs(firstNode.getClockDelta(), secondNode.getClockDelta());
                }
                case "uptime": {
                    return this.compareInts(firstNode.getReportedUptimePercentage(), secondNode.getReportedUptimePercentage());
                }
            }
            return 0;
        }

        private int compareLocations(PeerNodeStatus firstNode, PeerNodeStatus secondNode) {
            double diff = firstNode.getLocation() - secondNode.getLocation();
            if (9.9E-324 > Math.abs(diff)) {
                return 0;
            }
            return diff > 0.0 ? 1 : -1;
        }

        protected int lastResortCompare(PeerNodeStatus firstNode, PeerNodeStatus secondNode) {
            return this.compareLocations(firstNode, secondNode);
        }
    }
}

