/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.clients.http.Cookie;
import freenet.clients.http.ReceivedCookie;
import freenet.clients.http.ToadletContext;
import freenet.support.LRUMap;
import freenet.support.Logger;
import freenet.support.StringValidityChecker;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public final class SessionManager {
    public static final long MAX_SESSION_IDLE_TIME = TimeUnit.HOURS.toMillis(1L);
    public static final String SESSION_COOKIE_NAME = "SessionID";
    private final URI mCookiePath;
    private final String mCookieNamespace;
    private final String mCookieName;
    private final LRUMap<UUID, Session> mSessionsByID = new LRUMap();
    private final Hashtable<String, Session> mSessionsByUserID = new Hashtable();

    public SessionManager(URI myCookiePath) {
        if (myCookiePath.isAbsolute()) {
            throw new IllegalArgumentException("Illegal cookie path, must be relative: " + myCookiePath);
        }
        if (!myCookiePath.toString().startsWith("/")) {
            throw new IllegalArgumentException("Illegal cookie path, must start with /: " + myCookiePath);
        }
        this.mCookiePath = myCookiePath;
        this.mCookieNamespace = "";
        this.mCookieName = SESSION_COOKIE_NAME;
    }

    public SessionManager(String myCookieNamespace) {
        if (myCookieNamespace.length() == 0) {
            throw new IllegalArgumentException("You must specify a cookie namespace or use the constructor which allows specification of a cookie path.");
        }
        if (!StringValidityChecker.isLatinLettersAndNumbersOnly(myCookieNamespace)) {
            throw new IllegalArgumentException("The cookie namespace must be latin letters and numbers only.");
        }
        try {
            this.mCookiePath = new URI("/");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.mCookieNamespace = myCookieNamespace;
        this.mCookieName = myCookieNamespace + SESSION_COOKIE_NAME;
    }

    public URI getCookiePath() {
        return this.mCookiePath;
    }

    public String getCookieNamespace() {
        return this.mCookieNamespace;
    }

    public synchronized Session createSession(String userID, ToadletContext context) {
        long time = System.currentTimeMillis();
        this.removeExpiredSessions(time);
        this.deleteSessionByUserID(userID);
        Session session = new Session(userID, time);
        this.mSessionsByID.push(session.getID(), session);
        this.mSessionsByUserID.put(session.getUserID(), session);
        this.setSessionCookie(session, context);
        return session;
    }

    public synchronized boolean sessionExists(ToadletContext context) {
        UUID sessionID = this.getSessionID(context);
        if (sessionID == null) {
            return false;
        }
        this.removeExpiredSessions(System.currentTimeMillis());
        return this.mSessionsByID.containsKey(sessionID);
    }

    public synchronized Session useSession(ToadletContext context) {
        UUID sessionID = this.getSessionID(context);
        if (sessionID == null) {
            return null;
        }
        long time = System.currentTimeMillis();
        this.removeExpiredSessions(time);
        Session session = this.mSessionsByID.get(sessionID);
        if (session == null) {
            return null;
        }
        session.updateExpiresAtTime(time);
        this.mSessionsByID.push(session.getID(), session);
        this.setSessionCookie(session, context);
        return session;
    }

    public boolean deleteSession(ToadletContext context) {
        UUID sessionID = this.getSessionID(context);
        if (sessionID == null) {
            return false;
        }
        return this.deleteSession(sessionID);
    }

    private UUID getSessionID(ToadletContext context) {
        if (context == null) {
            return null;
        }
        try {
            ReceivedCookie sessionCookie = context.getCookie(null, this.mCookiePath, this.mCookieName);
            return sessionCookie == null ? null : UUID.fromString(sessionCookie.getValue());
        }
        catch (ParseException e) {
            Logger.error(this, "Getting session cookie failed", (Throwable)e);
            return null;
        }
        catch (IllegalArgumentException e) {
            Logger.error(this, "Getting the value of the session cookie failed", (Throwable)e);
            return null;
        }
    }

    private void setSessionCookie(Session session, ToadletContext context) {
        context.setCookie(new Cookie(this.mCookiePath, this.mCookieName, session.getID().toString(), new Date(session.getExpirationTime())));
    }

    private synchronized boolean deleteSession(UUID sessionID) {
        Session session = this.mSessionsByID.get(sessionID);
        if (session == null) {
            return false;
        }
        this.mSessionsByID.removeKey(sessionID);
        this.mSessionsByUserID.remove(session.getUserID());
        return true;
    }

    private synchronized boolean deleteSessionByUserID(String userID) {
        Session session = this.mSessionsByUserID.remove(userID);
        if (session == null) {
            return false;
        }
        this.mSessionsByID.removeKey(session.getID());
        return true;
    }

    private synchronized void removeExpiredSessions(long time) {
        Session session = this.mSessionsByID.peekValue();
        while (session != null && session.isExpired(time)) {
            this.mSessionsByID.popValue();
            this.mSessionsByUserID.remove(session.getUserID());
            session = this.mSessionsByID.peekValue();
        }
        this.verifySessionsByUserIDTable();
    }

    private synchronized void verifySessionsByUserIDTable() {
        Enumeration<Session> sessions = this.mSessionsByUserID.elements();
        while (sessions.hasMoreElements()) {
            Session session = sessions.nextElement();
            if (this.mSessionsByID.containsKey(session.getID())) continue;
            Logger.error(this, "Sessions by user ID hashtable contains deleted session, removing it: " + session);
            this.mSessionsByUserID.remove(session.getUserID());
        }
    }

    public static final class Session {
        private final UUID mID;
        private final String mUserID;
        private final Map<String, Object> mAttributes = new HashMap<String, Object>();
        private long mExpiresAtTime;

        private Session(String myUserID, long currentTime) {
            this.mID = UUID.randomUUID();
            this.mUserID = myUserID;
            this.mExpiresAtTime = currentTime + MAX_SESSION_IDLE_TIME;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Session)) {
                return false;
            }
            Session other = (Session)obj;
            return other.getID().equals(this.mID);
        }

        public int hashCode() {
            return this.mID.hashCode();
        }

        public UUID getID() {
            return this.mID;
        }

        public String getUserID() {
            return this.mUserID;
        }

        private long getExpirationTime() {
            return this.mExpiresAtTime;
        }

        private boolean isExpired(long time) {
            return time >= this.mExpiresAtTime;
        }

        private void updateExpiresAtTime(long currentTime) {
            this.mExpiresAtTime = currentTime + MAX_SESSION_IDLE_TIME;
        }

        public boolean hasAttribute(String name) {
            return this.mAttributes.containsKey(name);
        }

        public Object getAttribute(String name) {
            return this.mAttributes.get(name);
        }

        public void setAttribute(String name, Object value) {
            this.mAttributes.put(name, value);
        }

        public void removeAttribute(String name) {
            this.mAttributes.remove(name);
        }

        public Set<String> getAttributeNames() {
            return this.mAttributes.keySet();
        }
    }
}

