/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import freenet.client.ArchiveFailureException;
import freenet.client.ArchiveRestartException;
import freenet.client.FailureCodeTracker;
import freenet.client.MetadataParseException;
import freenet.client.filter.DataFilterException;
import freenet.keys.FreenetURI;
import freenet.l10n.NodeL10n;
import freenet.support.Logger;
import java.util.HashMap;

public class FetchException
extends Exception
implements Cloneable {
    private static volatile boolean logMINOR;
    private static final long serialVersionUID = -1106716067841151962L;
    public final FetchExceptionMode mode;
    public final FreenetURI newURI;
    public long expectedSize;
    String expectedMimeType;
    boolean finalizedSizeAndMimeType;
    public final FailureCodeTracker errorCodes;
    public final String extraMessage;
    private static final HashMap<Integer, FetchExceptionMode> modes;
    private static int MAX_ERROR_CODE;
    public static final int UPPER_LIMIT_ERROR_CODE = 1024;

    public String getExpectedMimeType() {
        return this.expectedMimeType;
    }

    public boolean finalizedSize() {
        return this.finalizedSizeAndMimeType;
    }

    public FetchExceptionMode getMode() {
        return this.mode;
    }

    public FetchException(FetchExceptionMode m) {
        super(FetchException.getMessage(m));
        this.extraMessage = null;
        this.mode = m;
        this.errorCodes = null;
        this.newURI = null;
        this.expectedSize = -1L;
        if (this.mode == FetchExceptionMode.INTERNAL_ERROR) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(this.mode) + ')', (Throwable)this);
        }
    }

    public FetchException(FetchExceptionMode m, long expectedSize, boolean finalizedSize, String expectedMimeType) {
        super(FetchException.getMessage(m));
        this.extraMessage = null;
        this.finalizedSizeAndMimeType = finalizedSize;
        this.mode = m;
        this.errorCodes = null;
        this.newURI = null;
        this.expectedSize = expectedSize;
        this.expectedMimeType = expectedMimeType;
        if (this.mode == FetchExceptionMode.INTERNAL_ERROR) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(this.mode) + ')', (Throwable)this);
        }
    }

    public FetchException(FetchExceptionMode m, long expectedSize, boolean finalizedSize, String expectedMimeType, FreenetURI uri) {
        super(FetchException.getMessage(m));
        this.extraMessage = null;
        this.finalizedSizeAndMimeType = finalizedSize;
        this.mode = m;
        this.errorCodes = null;
        this.newURI = uri;
        this.expectedSize = expectedSize;
        this.expectedMimeType = expectedMimeType;
        if (this.mode == FetchExceptionMode.INTERNAL_ERROR) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(this.mode) + ')', (Throwable)this);
        }
    }

    public FetchException(MetadataParseException e) {
        super(FetchException.getMessage(FetchExceptionMode.INVALID_METADATA) + ": " + e.getMessage());
        this.extraMessage = e.getMessage();
        this.mode = FetchExceptionMode.INVALID_METADATA;
        this.errorCodes = null;
        this.initCause(e);
        this.newURI = null;
        this.expectedSize = -1L;
        if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(this.mode) + ')', (Throwable)this);
        }
    }

    public FetchException(ArchiveFailureException e) {
        super(FetchException.getMessage(FetchExceptionMode.ARCHIVE_FAILURE) + ": " + e.getMessage());
        this.extraMessage = e.getMessage();
        this.mode = FetchExceptionMode.ARCHIVE_FAILURE;
        this.errorCodes = null;
        this.newURI = null;
        this.initCause(e);
        this.expectedSize = -1L;
        if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(this.mode) + ')', (Throwable)this);
        }
    }

    public FetchException(ArchiveRestartException e) {
        super(FetchException.getMessage(FetchExceptionMode.ARCHIVE_RESTART) + ": " + e.getMessage());
        this.extraMessage = e.getMessage();
        this.mode = FetchExceptionMode.ARCHIVE_FAILURE;
        this.errorCodes = null;
        this.initCause(e);
        this.newURI = null;
        this.expectedSize = -1L;
        if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(this.mode) + ')', (Throwable)this);
        }
    }

    public FetchException(FetchExceptionMode mode, Throwable t) {
        super(FetchException.getMessage(mode) + ": " + t.getMessage());
        this.extraMessage = t.getMessage();
        this.mode = mode;
        this.errorCodes = null;
        this.initCause(t);
        this.newURI = null;
        this.expectedSize = -1L;
        if (mode == FetchExceptionMode.INTERNAL_ERROR) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(mode) + ')', (Throwable)this);
        }
    }

    public FetchException(FetchExceptionMode mode, String reason, Throwable t) {
        super(reason + " : " + FetchException.getMessage(mode) + ": " + t.getMessage());
        this.extraMessage = t.getMessage();
        this.mode = mode;
        this.errorCodes = null;
        this.initCause(t);
        this.newURI = null;
        this.expectedSize = -1L;
        if (mode == FetchExceptionMode.INTERNAL_ERROR) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(mode) + ')', (Throwable)this);
        }
    }

    public FetchException(FetchExceptionMode mode, long expectedSize, String reason, Throwable t, String expectedMimeType) {
        super(reason + " : " + FetchException.getMessage(mode) + ": " + t.getMessage());
        this.extraMessage = t.getMessage();
        this.mode = mode;
        this.expectedSize = expectedSize;
        this.expectedMimeType = expectedMimeType;
        this.errorCodes = null;
        this.initCause(t);
        this.newURI = null;
        if (mode == FetchExceptionMode.INTERNAL_ERROR) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(mode) + ')', (Throwable)this);
        }
    }

    public FetchException(long expectedSize, DataFilterException t, String expectedMimeType) {
        super(FetchException.getMessage(FetchExceptionMode.CONTENT_VALIDATION_FAILED) + " " + NodeL10n.getBase().getString("FetchException.unsafeContentDetails") + " " + t.getMessage());
        this.extraMessage = t.getMessage();
        this.mode = FetchExceptionMode.CONTENT_VALIDATION_FAILED;
        this.expectedSize = expectedSize;
        this.expectedMimeType = expectedMimeType;
        this.errorCodes = null;
        this.initCause(t);
        this.newURI = null;
        if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(this.mode) + ')', (Throwable)this);
        }
    }

    public FetchException(FetchExceptionMode mode, long expectedSize, Throwable t, String expectedMimeType) {
        super(FetchException.getMessage(mode) + ": " + t.getMessage());
        this.extraMessage = t.getMessage();
        this.mode = mode;
        this.expectedSize = expectedSize;
        this.expectedMimeType = expectedMimeType;
        this.errorCodes = null;
        this.initCause(t);
        this.newURI = null;
        if (mode == FetchExceptionMode.INTERNAL_ERROR) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(mode) + ')', (Throwable)this);
        }
    }

    public FetchException(FetchExceptionMode mode, FailureCodeTracker errorCodes) {
        super(FetchException.getMessage(mode));
        if (errorCodes.isEmpty()) {
            Logger.error(this, "Failing with no error codes?!", (Throwable)new Exception("error"));
        }
        this.extraMessage = null;
        this.mode = mode;
        this.errorCodes = errorCodes;
        this.newURI = null;
        this.expectedSize = -1L;
        if (mode == FetchExceptionMode.INTERNAL_ERROR) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(mode) + ')', (Throwable)this);
        }
    }

    public FetchException(FetchExceptionMode mode, FailureCodeTracker errorCodes, String msg) {
        super(FetchException.getMessage(mode) + ": " + msg);
        if (errorCodes.isEmpty()) {
            Logger.error(this, "Failing with no error codes?!", (Throwable)new Exception("error"));
        }
        this.extraMessage = msg;
        this.mode = mode;
        this.errorCodes = errorCodes;
        this.newURI = null;
        this.expectedSize = -1L;
        if (mode == FetchExceptionMode.INTERNAL_ERROR) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(mode) + ')', (Throwable)this);
        }
    }

    public FetchException(FetchExceptionMode mode, String msg) {
        super(FetchException.getMessage(mode) + ": " + msg);
        this.extraMessage = msg;
        this.errorCodes = null;
        this.mode = mode;
        this.newURI = null;
        this.expectedSize = -1L;
        if (mode == FetchExceptionMode.INTERNAL_ERROR) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(mode) + ')', (Throwable)this);
        }
    }

    public FetchException(FetchExceptionMode mode, FreenetURI newURI) {
        super(FetchException.getMessage(mode));
        this.extraMessage = null;
        this.mode = mode;
        this.errorCodes = null;
        this.newURI = newURI;
        this.expectedSize = -1L;
        if (mode == FetchExceptionMode.INTERNAL_ERROR) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(mode) + ')', (Throwable)this);
        }
    }

    public FetchException(FetchExceptionMode mode, String msg, FreenetURI uri) {
        super(FetchException.getMessage(mode) + ": " + msg);
        this.extraMessage = msg;
        this.errorCodes = null;
        this.mode = mode;
        this.newURI = uri;
        this.expectedSize = -1L;
        if (mode == FetchExceptionMode.INTERNAL_ERROR) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(mode) + ')', (Throwable)this);
        }
    }

    public FetchException(FetchException e, FetchExceptionMode newMode) {
        super(FetchException.getMessage(newMode) + (e.extraMessage != null ? ": " + e.extraMessage : ""));
        this.mode = newMode;
        this.newURI = e.newURI;
        this.errorCodes = e.errorCodes;
        this.expectedMimeType = e.expectedMimeType;
        this.expectedSize = e.expectedSize;
        this.extraMessage = e.extraMessage;
        this.finalizedSizeAndMimeType = e.finalizedSizeAndMimeType;
        if (this.mode == FetchExceptionMode.INTERNAL_ERROR) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(this.mode) + ')', (Throwable)this);
        }
    }

    public FetchException(FetchException e, FreenetURI uri) {
        super(e.getMessage());
        if (e.getCause() != null) {
            this.initCause(e.getCause());
        }
        this.mode = e.mode;
        this.newURI = uri;
        this.errorCodes = e.errorCodes;
        this.expectedMimeType = e.expectedMimeType;
        this.expectedSize = e.expectedSize;
        this.extraMessage = e.extraMessage;
        this.finalizedSizeAndMimeType = e.finalizedSizeAndMimeType;
        if (this.mode == FetchExceptionMode.INTERNAL_ERROR) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(this.mode) + ')', (Throwable)this);
        }
    }

    public FetchException(FetchException e) {
        super(e.getMessage());
        this.initCause(e);
        this.mode = e.mode;
        this.newURI = e.newURI;
        this.errorCodes = e.errorCodes == null ? null : e.errorCodes.clone();
        this.expectedMimeType = e.expectedMimeType;
        this.expectedSize = e.expectedSize;
        this.extraMessage = e.extraMessage;
        this.finalizedSizeAndMimeType = e.finalizedSizeAndMimeType;
        if (this.mode == FetchExceptionMode.INTERNAL_ERROR) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(this.mode) + ')', (Throwable)this);
        }
    }

    protected FetchException() {
        this.mode = null;
        this.newURI = null;
        this.errorCodes = null;
        this.extraMessage = null;
    }

    public String getShortMessage() {
        if (this.getCause() == null) {
            return FetchException.getShortMessage(this.mode);
        }
        return this.getCause().toString();
    }

    public static String getShortMessage(FetchExceptionMode mode) {
        int code = mode.code;
        String ret = NodeL10n.getBase().getString("FetchException.shortError." + code);
        if (ret == null || ret.isEmpty()) {
            return "Unknown code " + (Object)((Object)mode);
        }
        return ret;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("FetchException:");
        sb.append(FetchException.getMessage(this.mode));
        sb.append(':');
        sb.append(this.newURI);
        sb.append(':');
        sb.append(this.expectedSize);
        sb.append(':');
        sb.append(this.expectedMimeType);
        sb.append(':');
        sb.append(this.finalizedSizeAndMimeType);
        sb.append(':');
        sb.append(this.errorCodes);
        sb.append(':');
        sb.append(this.extraMessage);
        return sb.toString();
    }

    public String toUserFriendlyString() {
        if (this.extraMessage == null) {
            return FetchException.getShortMessage(this.mode);
        }
        return FetchException.getShortMessage(this.mode) + " : " + this.extraMessage;
    }

    public static String getMessage(FetchExceptionMode mode) {
        if (mode == null) {
            throw new NullPointerException();
        }
        int code = mode.code;
        String ret = NodeL10n.getBase().getString("FetchException.longError." + code);
        if (ret == null) {
            return "Unknown fetch error code: " + (Object)((Object)mode);
        }
        return ret;
    }

    public boolean isFatal() {
        return FetchException.isFatal(this.mode);
    }

    public static boolean isFatal(FetchExceptionMode mode) {
        switch (mode) {
            case ARCHIVE_FAILURE: 
            case BLOCK_DECODE_ERROR: 
            case TOO_MANY_PATH_COMPONENTS: 
            case NOT_ENOUGH_PATH_COMPONENTS: 
            case INVALID_METADATA: 
            case NOT_IN_ARCHIVE: 
            case TOO_DEEP_ARCHIVE_RECURSION: 
            case TOO_MANY_ARCHIVE_RESTARTS: 
            case TOO_MANY_METADATA_LEVELS: 
            case TOO_MANY_REDIRECTS: 
            case TOO_MUCH_RECURSION: 
            case UNKNOWN_METADATA: 
            case UNKNOWN_SPLITFILE_METADATA: 
            case INVALID_URI: 
            case TOO_BIG: 
            case TOO_BIG_METADATA: 
            case TOO_MANY_BLOCKS_PER_SEGMENT: 
            case CONTENT_HASH_FAILED: 
            case SPLITFILE_DECODE_ERROR: {
                return true;
            }
            case DATA_NOT_FOUND: 
            case ROUTE_NOT_FOUND: 
            case REJECTED_OVERLOAD: 
            case TRANSFER_FAILED: 
            case ALL_DATA_NOT_FOUND: 
            case RECENTLY_FAILED: 
            case SPLITFILE_ERROR: {
                return false;
            }
            case BUCKET_ERROR: 
            case INTERNAL_ERROR: 
            case NOT_ENOUGH_DISK_SPACE: {
                return true;
            }
            case CONTENT_VALIDATION_FAILED: 
            case CONTENT_VALIDATION_UNKNOWN_MIME: 
            case CONTENT_VALIDATION_BAD_MIME: 
            case MIME_INCOMPATIBLE_WITH_EXTENSION: {
                return true;
            }
            case CANCELLED: 
            case ARCHIVE_RESTART: 
            case PERMANENT_REDIRECT: 
            case WRONG_MIME_TYPE: {
                return true;
            }
        }
        Logger.error(FetchException.class, "Do not know if error code is fatal: " + FetchException.getMessage(mode));
        return false;
    }

    public boolean isDefinitelyFatal() {
        return FetchException.isDefinitelyFatal(this.mode);
    }

    public static boolean isDefinitelyFatal(FetchExceptionMode mode) {
        switch (mode) {
            case ARCHIVE_FAILURE: 
            case BLOCK_DECODE_ERROR: 
            case TOO_MANY_PATH_COMPONENTS: 
            case NOT_ENOUGH_PATH_COMPONENTS: 
            case INVALID_METADATA: 
            case NOT_IN_ARCHIVE: 
            case TOO_DEEP_ARCHIVE_RECURSION: 
            case TOO_MANY_ARCHIVE_RESTARTS: 
            case TOO_MANY_METADATA_LEVELS: 
            case TOO_MANY_REDIRECTS: 
            case TOO_MUCH_RECURSION: 
            case UNKNOWN_METADATA: 
            case UNKNOWN_SPLITFILE_METADATA: 
            case INVALID_URI: 
            case TOO_BIG: 
            case TOO_BIG_METADATA: 
            case TOO_MANY_BLOCKS_PER_SEGMENT: 
            case CONTENT_HASH_FAILED: 
            case SPLITFILE_DECODE_ERROR: {
                return true;
            }
            case DATA_NOT_FOUND: 
            case ROUTE_NOT_FOUND: 
            case REJECTED_OVERLOAD: 
            case TRANSFER_FAILED: 
            case ALL_DATA_NOT_FOUND: 
            case RECENTLY_FAILED: 
            case SPLITFILE_ERROR: {
                return false;
            }
            case BUCKET_ERROR: 
            case INTERNAL_ERROR: 
            case NOT_ENOUGH_DISK_SPACE: {
                return false;
            }
            case CONTENT_VALIDATION_FAILED: 
            case CONTENT_VALIDATION_UNKNOWN_MIME: 
            case CONTENT_VALIDATION_BAD_MIME: 
            case MIME_INCOMPATIBLE_WITH_EXTENSION: {
                return true;
            }
            case CANCELLED: {
                return false;
            }
            case ARCHIVE_RESTART: 
            case PERMANENT_REDIRECT: 
            case WRONG_MIME_TYPE: {
                return true;
            }
        }
        Logger.error(FetchException.class, "Do not know if error code is fatal: " + FetchException.getMessage(mode));
        return false;
    }

    public void setNotFinalizedSize() {
        this.finalizedSizeAndMimeType = false;
    }

    public FetchException clone() {
        return new FetchException(this);
    }

    public boolean isDataFound() {
        return FetchException.isDataFound(this.mode, this.errorCodes);
    }

    public static boolean isDataFound(FetchExceptionMode mode, FailureCodeTracker errorCodes) {
        switch (mode) {
            case ARCHIVE_FAILURE: 
            case BLOCK_DECODE_ERROR: 
            case TOO_MANY_PATH_COMPONENTS: 
            case NOT_ENOUGH_PATH_COMPONENTS: 
            case INVALID_METADATA: 
            case NOT_IN_ARCHIVE: 
            case TOO_DEEP_ARCHIVE_RECURSION: 
            case TOO_MANY_ARCHIVE_RESTARTS: 
            case TOO_MANY_METADATA_LEVELS: 
            case TOO_MANY_REDIRECTS: 
            case TOO_MUCH_RECURSION: 
            case UNKNOWN_METADATA: 
            case UNKNOWN_SPLITFILE_METADATA: 
            case TOO_BIG: 
            case TOO_BIG_METADATA: 
            case TOO_MANY_BLOCKS_PER_SEGMENT: 
            case CONTENT_HASH_FAILED: 
            case SPLITFILE_DECODE_ERROR: 
            case NOT_ENOUGH_DISK_SPACE: 
            case CONTENT_VALIDATION_FAILED: 
            case CONTENT_VALIDATION_UNKNOWN_MIME: 
            case CONTENT_VALIDATION_BAD_MIME: 
            case ARCHIVE_RESTART: {
                return true;
            }
            case SPLITFILE_ERROR: {
                return errorCodes.isDataFound();
            }
        }
        return false;
    }

    public boolean isDNF() {
        switch (this.mode) {
            case DATA_NOT_FOUND: 
            case ALL_DATA_NOT_FOUND: 
            case RECENTLY_FAILED: {
                return true;
            }
        }
        return false;
    }

    public static boolean isErrorCode(int code) {
        return code >= 0 && code <= MAX_ERROR_CODE && code < 1024;
    }

    static {
        Logger.registerClass(FetchException.class);
        modes = new HashMap();
    }

    public static enum FetchExceptionMode {
        TOO_DEEP_ARCHIVE_RECURSION(1),
        UNKNOWN_SPLITFILE_METADATA(2),
        UNKNOWN_METADATA(3),
        INVALID_METADATA(4),
        ARCHIVE_FAILURE(5),
        BLOCK_DECODE_ERROR(6),
        TOO_MANY_METADATA_LEVELS(7),
        TOO_MANY_ARCHIVE_RESTARTS(8),
        TOO_MUCH_RECURSION(9),
        NOT_IN_ARCHIVE(10),
        TOO_MANY_PATH_COMPONENTS(11),
        BUCKET_ERROR(12),
        DATA_NOT_FOUND(13),
        ROUTE_NOT_FOUND(14),
        REJECTED_OVERLOAD(15),
        TOO_MANY_REDIRECTS(16),
        INTERNAL_ERROR(17),
        TRANSFER_FAILED(18),
        SPLITFILE_ERROR(19),
        INVALID_URI(20),
        TOO_BIG(21),
        TOO_BIG_METADATA(22),
        TOO_MANY_BLOCKS_PER_SEGMENT(23),
        NOT_ENOUGH_PATH_COMPONENTS(24),
        CANCELLED(25),
        ARCHIVE_RESTART(26),
        PERMANENT_REDIRECT(27),
        ALL_DATA_NOT_FOUND(28),
        WRONG_MIME_TYPE(29),
        RECENTLY_FAILED(30),
        CONTENT_VALIDATION_FAILED(31),
        CONTENT_VALIDATION_UNKNOWN_MIME(32),
        CONTENT_VALIDATION_BAD_MIME(33),
        CONTENT_HASH_FAILED(34),
        SPLITFILE_DECODE_ERROR(35),
        MIME_INCOMPATIBLE_WITH_EXTENSION(36),
        NOT_ENOUGH_DISK_SPACE(37);

        public final int code;

        private FetchExceptionMode(int code) {
            this.code = code;
            if (code < 0 || code >= 1024) {
                throw new IllegalArgumentException();
            }
            if (modes.containsKey(code)) {
                throw new IllegalArgumentException();
            }
            modes.put(code, this);
            if (code > MAX_ERROR_CODE) {
                MAX_ERROR_CODE = code;
            }
        }

        public static FetchExceptionMode getByCode(int code) {
            if (modes.get(code) == null) {
                throw new IllegalArgumentException();
            }
            return (FetchExceptionMode)((Object)modes.get(code));
        }
    }
}

