/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.CSSTokenizerFilter;
import freenet.client.filter.FilterCallback;
import freenet.support.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class FilterUtils {
    private static volatile boolean logDEBUG;
    private static final int MAX_NTH = 999999;
    private static final HashSet<String> allowedUnits;
    private static final HashSet<String> SVGcolorKeywords;
    private static final HashSet<String> CSScolorKeywords;
    private static final HashSet<String> CSSsystemColorKeywords;
    private static final HashSet<String> cssMedia;

    public static boolean isInteger(String strValue) {
        try {
            Integer.parseInt(strValue);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isNumber(String strNumber) {
        try {
            String strDecimal;
            boolean containsE = false;
            String strInteger = null;
            if (strNumber.indexOf(101) > 0) {
                containsE = true;
                strDecimal = strNumber.substring(0, strNumber.indexOf(101));
                strInteger = strNumber.substring(strDecimal.indexOf(101) + 1, strNumber.length());
            } else if (strNumber.indexOf(69) > 0) {
                containsE = true;
                strDecimal = strNumber.substring(0, strNumber.indexOf(69));
                strInteger = strNumber.substring(strDecimal.indexOf(69) + 1, strNumber.length());
            } else {
                strDecimal = strNumber;
            }
            Double.parseDouble(strDecimal);
            if (containsE) {
                return FilterUtils.isInteger(strInteger);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isPercentage(String value) {
        if (value.length() >= 2 && value.charAt(value.length() - 1) == '%') {
            try {
                Integer.parseInt(value.substring(0, value.length() - 1));
                return true;
            }
            catch (Exception exception) {
                try {
                    Double.parseDouble(value.substring(0, value.length() - 1));
                    return true;
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public static boolean isLength(String value, boolean isSVG) {
        String lengthValue = null;
        if ((value = value.trim()).length() == 0) {
            return false;
        }
        if (isSVG && value.charAt(value.length() - 1) == '%') {
            lengthValue = value.substring(0, value.length() - 1);
        }
        boolean units = false;
        if (lengthValue == null) {
            int pos = 0;
            int len = value.length();
            for (int i = len - 1; i >= 0; --i) {
                char c = value.charAt(i);
                if ((c < '0' || c > '9') && c != '.') continue;
                pos = i + 1;
                break;
            }
            if (len - pos > 0 && allowedUnits.contains(value.substring(pos))) {
                lengthValue = value.substring(0, pos);
                units = true;
            } else {
                lengthValue = value;
            }
        }
        try {
            int x = Integer.parseInt(lengthValue);
            return units || isSVG || x == 0;
        }
        catch (Exception x) {
            try {
                double dval = Double.parseDouble(lengthValue);
                if (!units && !isSVG && dval != 0.0) {
                    return false;
                }
                if (!Double.isInfinite(dval) && !Double.isNaN(dval)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    public static boolean isAngle(String value) {
        String secondpart;
        boolean isValid = true;
        int index = -1;
        if (value.contains("deg")) {
            index = value.indexOf("deg");
            secondpart = value.substring(index, value.length()).trim();
            if (!"deg".equals(secondpart)) {
                isValid = false;
            }
        } else if (value.contains("grad")) {
            index = value.indexOf("grad");
            secondpart = value.substring(index, value.length()).trim();
            if (!"grad".equals(secondpart)) {
                isValid = false;
            }
        } else if (value.contains("rad") && !"rad".equals(secondpart = value.substring(index = value.indexOf("rad"), value.length()).trim())) {
            isValid = false;
        }
        if (index != -1 && isValid) {
            String firstPart = value.substring(0, index);
            try {
                Float.parseFloat(firstPart);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isValidCSSShape(String value) {
        String[] shapeParts;
        if (value.indexOf("rect(") == 0 && value.indexOf(41) == value.length() - 1 && (shapeParts = value.substring(5, value.length() - 1).split(",")).length == 4) {
            for (String s : shapeParts) {
                if ((s = s.trim()).equalsIgnoreCase("auto") || FilterUtils.isLength(s, false)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isMedia(String media) {
        return cssMedia.contains(media);
    }

    public static boolean isColor(String value) {
        int i;
        boolean isValidColorParts;
        String[] colorParts;
        if (CSScolorKeywords.contains(value = value.trim()) || CSSsystemColorKeywords.contains(value) || SVGcolorKeywords.contains(value)) {
            return true;
        }
        if (value.indexOf(35) == 0) {
            if (value.length() == 4) {
                try {
                    Integer.valueOf(value.substring(1, 2), 16).intValue();
                    Integer.valueOf(value.substring(2, 3), 16).intValue();
                    Integer.valueOf(value.substring(3, 4), 16).intValue();
                    return true;
                }
                catch (Exception exception) {}
            } else if (value.length() == 7) {
                try {
                    Integer.valueOf(value.substring(1, 3), 16).intValue();
                    Integer.valueOf(value.substring(3, 5), 16).intValue();
                    Integer.valueOf(value.substring(5, 7), 16).intValue();
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (value.indexOf("rgb(") == 0 && value.indexOf(41) == value.length() - 1) {
            colorParts = value.substring(4, value.length() - 1).split(",");
            if (colorParts.length != 3) {
                return false;
            }
            isValidColorParts = true;
            for (i = 0; i < colorParts.length && isValidColorParts; ++i) {
                if (FilterUtils.isPercentage(colorParts[i].trim()) || FilterUtils.isInteger(colorParts[i].trim())) continue;
                isValidColorParts = false;
            }
            if (isValidColorParts) {
                return true;
            }
        }
        if (value.indexOf("rgba(") == 0 && value.indexOf(41) == value.length() - 1) {
            colorParts = value.substring(5, value.length() - 1).split(",");
            if (colorParts.length != 4) {
                return false;
            }
            isValidColorParts = true;
            for (i = 0; i < colorParts.length - 1 && isValidColorParts; ++i) {
                if (FilterUtils.isPercentage(colorParts[i].trim()) || FilterUtils.isInteger(colorParts[i].trim())) continue;
                isValidColorParts = false;
            }
            if (isValidColorParts && FilterUtils.isNumber(colorParts[3])) {
                return true;
            }
        }
        if (value.indexOf("hsl(") == 0 && value.indexOf(41) == value.length() - 1) {
            colorParts = value.substring(4, value.length() - 1).split(",");
            if (colorParts.length != 3) {
                return false;
            }
            if (FilterUtils.isNumber(colorParts[0]) && FilterUtils.isPercentage(colorParts[1]) && FilterUtils.isPercentage(colorParts[2])) {
                return true;
            }
        }
        if (value.indexOf("hsla(") == 0 && value.indexOf(41) == value.length() - 1) {
            colorParts = value.substring(5, value.length() - 1).split(",");
            if (colorParts.length != 4) {
                return false;
            }
            if (FilterUtils.isNumber(colorParts[0]) && FilterUtils.isPercentage(colorParts[1]) && FilterUtils.isPercentage(colorParts[2]) && FilterUtils.isNumber(colorParts[3])) {
                return true;
            }
        }
        return false;
    }

    public static boolean isCSSTransform(String value) {
        String part;
        String[] parts;
        value = value.trim();
        if (logDEBUG) {
            Logger.debug(FilterUtils.class, "isCSSTransform(\"" + value + "\")");
        }
        if (value.indexOf("matrix(") == 0 && value.indexOf(41) == value.length() - 1) {
            parts = value.substring(7, value.length() - 1).split(",");
            if (parts.length != 6) {
                return false;
            }
            boolean isValid = true;
            for (int i = 0; i < parts.length && isValid; ++i) {
                if (FilterUtils.isNumber(parts[i].trim())) continue;
                isValid = false;
            }
            if (isValid) {
                if (logDEBUG) {
                    Logger.debug(FilterUtils.class, "isCSSTransform found a matrix()");
                }
                return true;
            }
        }
        if (value.indexOf("translateX(") == 0 && value.indexOf(41) == value.length() - 1 && (FilterUtils.isPercentage((part = value.substring(11, value.length() - 1)).trim()) || FilterUtils.isLength(part.trim(), false))) {
            if (logDEBUG) {
                Logger.debug(FilterUtils.class, "isCSSTransform found a translateX()");
            }
            return true;
        }
        if (value.indexOf("translateY(") == 0 && value.indexOf(41) == value.length() - 1 && (FilterUtils.isPercentage((part = value.substring(11, value.length() - 1)).trim()) || FilterUtils.isLength(part.trim(), false))) {
            if (logDEBUG) {
                Logger.debug(FilterUtils.class, "isCSSTransform found a translateY()");
            }
            return true;
        }
        if (value.indexOf("translate(") == 0 && value.indexOf(41) == value.length() - 1) {
            parts = value.substring(10, value.length() - 1).split(",");
            if (parts.length == 1 && (FilterUtils.isPercentage(parts[0].trim()) || FilterUtils.isLength(parts[0].trim(), false))) {
                if (logDEBUG) {
                    Logger.debug(FilterUtils.class, "isCSSTransform found a translate()");
                }
                return true;
            }
            if (parts.length == 2 && (FilterUtils.isPercentage(parts[0].trim()) || FilterUtils.isLength(parts[0].trim(), false)) && (FilterUtils.isPercentage(parts[1].trim()) || FilterUtils.isLength(parts[1].trim(), false))) {
                if (logDEBUG) {
                    Logger.debug(FilterUtils.class, "isCSSTransform found a translate()");
                }
                return true;
            }
        }
        if (value.indexOf("scale(") == 0 && value.indexOf(41) == value.length() - 1) {
            parts = value.substring(6, value.length() - 1).split(",");
            if (parts.length == 1 && FilterUtils.isNumber(parts[0].trim())) {
                if (logDEBUG) {
                    Logger.debug(FilterUtils.class, "isCSSTransform found a scale()");
                }
                return true;
            }
            if (parts.length == 2 && FilterUtils.isNumber(parts[0].trim()) && FilterUtils.isNumber(parts[1].trim())) {
                if (logDEBUG) {
                    Logger.debug(FilterUtils.class, "isCSSTransform found a scale()");
                }
                return true;
            }
        }
        if (value.indexOf("scaleX(") == 0 && value.indexOf(41) == value.length() - 1 && FilterUtils.isNumber((part = value.substring(7, value.length() - 1)).trim())) {
            if (logDEBUG) {
                Logger.debug(FilterUtils.class, "isCSSTransform found a scaleX()");
            }
            return true;
        }
        if (value.indexOf("scaleY(") == 0 && value.indexOf(41) == value.length() - 1 && FilterUtils.isNumber((part = value.substring(7, value.length() - 1)).trim())) {
            if (logDEBUG) {
                Logger.debug(FilterUtils.class, "isCSSTransform found a scaleY()");
            }
            return true;
        }
        if (value.indexOf("rotate(") == 0 && value.indexOf(41) == value.length() - 1 && FilterUtils.isAngle((part = value.substring(7, value.length() - 1)).trim())) {
            if (logDEBUG) {
                Logger.debug(FilterUtils.class, "isCSSTransform found a rotate()");
            }
            return true;
        }
        if (value.indexOf("skewX(") == 0 && value.indexOf(41) == value.length() - 1 && (FilterUtils.isNumber((part = value.substring(6, value.length() - 1)).trim()) || FilterUtils.isAngle(part.trim()))) {
            if (logDEBUG) {
                Logger.debug(FilterUtils.class, "isCSSTransform found a skewX()");
            }
            return true;
        }
        if (value.indexOf("skewY(") == 0 && value.indexOf(41) == value.length() - 1 && (FilterUtils.isNumber((part = value.substring(6, value.length() - 1)).trim()) || FilterUtils.isAngle(part.trim()))) {
            if (logDEBUG) {
                Logger.debug(FilterUtils.class, "isCSSTransform found a skewY()");
            }
            return true;
        }
        if (value.indexOf("skew(") == 0 && value.indexOf(41) == value.length() - 1) {
            parts = value.substring(5, value.length() - 1).split(",");
            if (parts.length == 1 && (FilterUtils.isNumber(parts[0].trim()) || FilterUtils.isAngle(parts[0].trim()))) {
                if (logDEBUG) {
                    Logger.debug(FilterUtils.class, "isCSSTransform found a skew()");
                }
                return true;
            }
            if (parts.length == 2 && (FilterUtils.isNumber(parts[0].trim()) || FilterUtils.isAngle(parts[0].trim())) && (FilterUtils.isNumber(parts[1].trim()) || FilterUtils.isAngle(parts[0].trim()))) {
                if (logDEBUG) {
                    Logger.debug(FilterUtils.class, "isCSSTransform found a skew()");
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isFrequency(String value) {
        String firstPart;
        int index;
        value = value.trim().toLowerCase();
        boolean isValidFrequency = true;
        if (value.contains("khz")) {
            index = value.indexOf("khz");
            firstPart = value.substring(0, index).trim();
            if (!"khz".equals(value.substring(index, value.length()).trim())) {
                isValidFrequency = false;
            }
        } else if (value.contains("hz")) {
            index = value.indexOf("hz");
            firstPart = value.substring(0, index).trim();
            if (!"hz".equals(value.substring(index, value.length()).trim())) {
                isValidFrequency = false;
            }
        } else {
            firstPart = value.trim();
        }
        if (isValidFrequency) {
            try {
                float temp = Float.parseFloat(firstPart);
                if (temp > 0.0f) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isTime(String value) {
        String intValue;
        if ((value = value.toLowerCase()).contains("ms") && value.length() > 2) {
            intValue = value.substring(0, value.length() - 2);
        } else if (value.indexOf(115) > -1 && value.length() > 1) {
            intValue = value.substring(0, value.length() - 1);
        } else {
            return false;
        }
        return FilterUtils.isNumber(intValue);
    }

    public static String[] removeWhiteSpace(String[] values, boolean stripQuotes) {
        if (values == null) {
            return null;
        }
        ArrayList<String> arrayToReturn = new ArrayList<String>();
        for (String value : values) {
            value = value.trim();
            if (stripQuotes) {
                value = CSSTokenizerFilter.removeOuterQuotes(value).trim();
            }
            if (value == null || value.trim().isEmpty()) continue;
            arrayToReturn.add(value);
        }
        return arrayToReturn.toArray(new String[0]);
    }

    public static String sanitizeURI(FilterCallback cb, String URI2) {
        try {
            return cb.processURI(URI2, null);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static boolean isURI(FilterCallback cb, String URI2) {
        return URI2.equals(FilterUtils.sanitizeURI(cb, URI2));
    }

    public static String[] splitOnCharArray(String value, String splitOn) {
        int i;
        ArrayList<String> pointPairs = new ArrayList<String>();
        int prev = 0;
        for (i = 0; i < value.length(); ++i) {
            if (splitOn.indexOf(value.charAt(i)) == -1) continue;
            pointPairs.add(value.substring(prev, i));
            while (i < value.length() && splitOn.indexOf(value.charAt(i)) != -1) {
                ++i;
            }
            prev = i--;
        }
        boolean isLastElement = false;
        for (i = prev; i < value.length(); ++i) {
            if (splitOn.indexOf(value.charAt(i)) != -1) continue;
            isLastElement = true;
            break;
        }
        if (isLastElement) {
            pointPairs.add(value.substring(prev, value.length()));
        }
        return pointPairs.toArray(new String[0]);
    }

    public static boolean isPointPair(String value) {
        String[] pointPairs;
        for (String pointPair : pointPairs = FilterUtils.splitOnCharArray(value, " \n\t")) {
            String[] strParts = pointPair.split(",");
            if (strParts.length != 2) {
                return false;
            }
            try {
                Float.parseFloat(strParts[0]);
                Float.parseFloat(strParts[1]);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static boolean isIntegerInRange(String strValue, int min, int max) {
        try {
            int value;
            if (strValue.length() > 1 && strValue.charAt(0) == '+' && Character.isDigit(strValue.charAt(1))) {
                strValue = strValue.substring(1, strValue.length());
            }
            return (value = Integer.parseInt(strValue)) >= min && value <= max;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isNth(String value) {
        int aLength;
        if (value.equals("odd") || value.equals("even") || FilterUtils.isIntegerInRange(value, -999999, 999999)) {
            return true;
        }
        int nIndex = value.indexOf(110);
        if (nIndex != -1 && ((aLength = nIndex) == 0 || aLength == 1 && value.charAt(0) == '-' || FilterUtils.isIntegerInRange(value.substring(0, aLength), -999999, 999999))) {
            int bIndex = nIndex + 1;
            int bLength = value.length() - bIndex;
            if (bLength == 0 || (value.charAt(bIndex) == '+' || value.charAt(bIndex) == '-') && FilterUtils.isIntegerInRange(value.substring(bIndex, value.length()), -999999, 999999)) {
                return true;
            }
        }
        return false;
    }

    static {
        Logger.registerClass(FilterUtils.class);
        allowedUnits = new HashSet();
        allowedUnits.add("em");
        allowedUnits.add("ex");
        allowedUnits.add("ch");
        allowedUnits.add("rem");
        allowedUnits.add("cm");
        allowedUnits.add("mm");
        allowedUnits.add("in");
        allowedUnits.add("pt");
        allowedUnits.add("pc");
        allowedUnits.add("px");
        allowedUnits.add("vw");
        allowedUnits.add("vh");
        allowedUnits.add("vmin");
        allowedUnits.add("vmax");
        SVGcolorKeywords = new HashSet();
        SVGcolorKeywords.add("aliceblue");
        SVGcolorKeywords.add("antiquewhite");
        SVGcolorKeywords.add("aqua");
        SVGcolorKeywords.add("aquamarine");
        SVGcolorKeywords.add("azure");
        SVGcolorKeywords.add("beige");
        SVGcolorKeywords.add("bisque");
        SVGcolorKeywords.add("black");
        SVGcolorKeywords.add("blanchedalmond");
        SVGcolorKeywords.add("blue");
        SVGcolorKeywords.add("blueviolet");
        SVGcolorKeywords.add("brown");
        SVGcolorKeywords.add("burlywood");
        SVGcolorKeywords.add("cadetblue");
        SVGcolorKeywords.add("chartreuse");
        SVGcolorKeywords.add("chocolate");
        SVGcolorKeywords.add("coral");
        SVGcolorKeywords.add("cornflowerblue");
        SVGcolorKeywords.add("cornsilk");
        SVGcolorKeywords.add("crimson");
        SVGcolorKeywords.add("cyan");
        SVGcolorKeywords.add("darkblue");
        SVGcolorKeywords.add("darkcyan");
        SVGcolorKeywords.add("darkgoldenrod");
        SVGcolorKeywords.add("darkgray");
        SVGcolorKeywords.add("darkgreen");
        SVGcolorKeywords.add("darkgrey");
        SVGcolorKeywords.add("darkkhaki");
        SVGcolorKeywords.add("darkmagenta");
        SVGcolorKeywords.add("darkolivegreen");
        SVGcolorKeywords.add("darkorange");
        SVGcolorKeywords.add("darkorchid");
        SVGcolorKeywords.add("darkred");
        SVGcolorKeywords.add("darksalmon");
        SVGcolorKeywords.add("darkseagreen");
        SVGcolorKeywords.add("darkslateblue");
        SVGcolorKeywords.add("darkslategray");
        SVGcolorKeywords.add("darkslategrey");
        SVGcolorKeywords.add("darkturquoise");
        SVGcolorKeywords.add("darkviolet");
        SVGcolorKeywords.add("deeppink");
        SVGcolorKeywords.add("deepskyblue");
        SVGcolorKeywords.add("dimgray");
        SVGcolorKeywords.add("dimgrey");
        SVGcolorKeywords.add("dodgerblue");
        SVGcolorKeywords.add("firebrick");
        SVGcolorKeywords.add("floralwhite");
        SVGcolorKeywords.add("forestgreen");
        SVGcolorKeywords.add("fuchsia");
        SVGcolorKeywords.add("gainsboro");
        SVGcolorKeywords.add("ghostwhite");
        SVGcolorKeywords.add("gold");
        SVGcolorKeywords.add("goldenrod");
        SVGcolorKeywords.add("gray");
        SVGcolorKeywords.add("grey");
        SVGcolorKeywords.add("green");
        SVGcolorKeywords.add("greenyellow");
        SVGcolorKeywords.add("honeydew");
        SVGcolorKeywords.add("hotpink");
        SVGcolorKeywords.add("indianred");
        SVGcolorKeywords.add("indigo");
        SVGcolorKeywords.add("ivory");
        SVGcolorKeywords.add("khaki");
        SVGcolorKeywords.add("lavender");
        SVGcolorKeywords.add("lavenderblush");
        SVGcolorKeywords.add("lawngreen");
        SVGcolorKeywords.add("lemonchiffon");
        SVGcolorKeywords.add("lightblue");
        SVGcolorKeywords.add("lightcoral");
        SVGcolorKeywords.add("lightcyan");
        SVGcolorKeywords.add("lightgoldenrodyellow");
        SVGcolorKeywords.add("lightgray");
        SVGcolorKeywords.add("lightgreen");
        SVGcolorKeywords.add("lightgrey");
        SVGcolorKeywords.add("lightpink");
        SVGcolorKeywords.add("lightsalmon");
        SVGcolorKeywords.add("lightseagreen");
        SVGcolorKeywords.add("lightskyblue");
        SVGcolorKeywords.add("lightslategray");
        SVGcolorKeywords.add("lightslategrey");
        SVGcolorKeywords.add("lightsteelblue");
        SVGcolorKeywords.add("lightyellow");
        SVGcolorKeywords.add("lime");
        SVGcolorKeywords.add("limegreen");
        SVGcolorKeywords.add("linen");
        SVGcolorKeywords.add("magenta");
        SVGcolorKeywords.add("maroon");
        SVGcolorKeywords.add("mediumaquamarine");
        SVGcolorKeywords.add("mediumblue");
        SVGcolorKeywords.add("mediumorchid");
        SVGcolorKeywords.add("thistle");
        SVGcolorKeywords.add("tomato");
        SVGcolorKeywords.add("turquoise");
        SVGcolorKeywords.add("violet");
        SVGcolorKeywords.add("wheat");
        SVGcolorKeywords.add("white");
        SVGcolorKeywords.add("whitesmoke");
        SVGcolorKeywords.add("yellow");
        SVGcolorKeywords.add("yellowgreen");
        CSScolorKeywords = new HashSet();
        CSScolorKeywords.add("aqua");
        CSScolorKeywords.add("black");
        CSScolorKeywords.add("blue");
        CSScolorKeywords.add("fuchsia");
        CSScolorKeywords.add("gray");
        CSScolorKeywords.add("green");
        CSScolorKeywords.add("lime");
        CSScolorKeywords.add("maroon");
        CSScolorKeywords.add("navy");
        CSScolorKeywords.add("olive");
        CSScolorKeywords.add("orange");
        CSScolorKeywords.add("purple");
        CSScolorKeywords.add("red");
        CSScolorKeywords.add("silver");
        CSScolorKeywords.add("teal");
        CSScolorKeywords.add("white");
        CSScolorKeywords.add("yellow");
        CSScolorKeywords.add("transparent");
        CSSsystemColorKeywords = new HashSet();
        CSScolorKeywords.add("ActiveBorder");
        CSScolorKeywords.add("ActiveCaption");
        CSScolorKeywords.add("AppWorkspace");
        CSScolorKeywords.add("Background");
        CSScolorKeywords.add("ButtonFace");
        CSScolorKeywords.add("ButtonHighlight");
        CSScolorKeywords.add("ButtonShadow");
        CSScolorKeywords.add("ButtonText");
        CSScolorKeywords.add("CaptionText");
        CSScolorKeywords.add("GrayText");
        CSScolorKeywords.add("Highlight");
        CSScolorKeywords.add("HighlightText");
        CSScolorKeywords.add("InactiveBorder");
        CSScolorKeywords.add("InactiveCaption");
        CSScolorKeywords.add("InactiveCaptionText");
        CSScolorKeywords.add("InfoBackground");
        CSScolorKeywords.add("InfoText");
        CSScolorKeywords.add("Menu");
        CSScolorKeywords.add("MenuText");
        CSScolorKeywords.add("Scrollbar");
        CSScolorKeywords.add("ThreeDDarkShadow");
        CSScolorKeywords.add("ThreeDFace");
        CSScolorKeywords.add("ThreeDHighlight");
        CSScolorKeywords.add("ThreeDLightShadow");
        CSScolorKeywords.add("ThreeDShadow");
        CSScolorKeywords.add("Window");
        CSScolorKeywords.add("WindowFrame");
        CSScolorKeywords.add("WindowText");
        cssMedia = new HashSet();
        cssMedia.addAll(Arrays.asList("all", "aural", "braille", "embossed", "handheld", "print", "projection", "screen", "speech", "tty", "tv"));
    }
}

