/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.client.async.ClientRequester;
import freenet.clients.http.PageNode;
import freenet.clients.http.RedirectException;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.config.SubConfig;
import freenet.crypt.ciphers.Rijndael;
import freenet.io.comm.IncomingPacketFilterImpl;
import freenet.io.xfer.BlockReceiver;
import freenet.io.xfer.BlockTransmitter;
import freenet.keys.FreenetURI;
import freenet.l10n.NodeL10n;
import freenet.node.Location;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.NodeStarter;
import freenet.node.NodeStats;
import freenet.node.OpennetManager;
import freenet.node.PeerManager;
import freenet.node.PeerNodeStatus;
import freenet.node.RequestClient;
import freenet.node.RequestStarterGroup;
import freenet.node.RequestTracker;
import freenet.node.Version;
import freenet.node.stats.DataStoreInstanceType;
import freenet.node.stats.DataStoreStats;
import freenet.node.stats.StatsNotAvailableException;
import freenet.node.stats.StoreAccessStats;
import freenet.support.BandwidthStatsContainer;
import freenet.support.HTMLNode;
import freenet.support.SizeUtil;
import freenet.support.TimeUtil;
import freenet.support.api.HTTPRequest;
import freenet.support.io.NativeThread;
import java.io.IOException;
import java.net.URI;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class StatisticsToadlet
extends Toadlet {
    static final NumberFormat thousandPoint = NumberFormat.getInstance();
    private final Node node;
    private final NodeClientCore core;
    private final NodeStats stats;
    private final PeerManager peers;
    private final DecimalFormat fix1p1 = new DecimalFormat("0.0");
    private final DecimalFormat fix1p2 = new DecimalFormat("0.00");
    private final DecimalFormat fix1p4 = new DecimalFormat("0.0000");
    private final DecimalFormat fix1p6sci = new DecimalFormat("0.######E0");
    private final DecimalFormat fix3p1pct = new DecimalFormat("##0.0%");
    private final DecimalFormat fix3p1US = new DecimalFormat("##0.0", new DecimalFormatSymbols(Locale.US));
    private final DecimalFormat fix3pctUS = new DecimalFormat("##0%", new DecimalFormatSymbols(Locale.US));
    private final DecimalFormat fix6p6 = new DecimalFormat("#####0.0#####");
    private static final int PEER_CIRCLE_RADIUS = 100;
    private static final int PEER_CIRCLE_INNER_RADIUS = 60;
    private static final int PEER_CIRCLE_ADDITIONAL_FREE_SPACE = 10;
    private static final long MAX_CIRCLE_AGE_THRESHOLD = TimeUnit.HOURS.toMillis(24L);
    private static final int HISTOGRAM_LENGTH = 10;

    protected StatisticsToadlet(Node n, NodeClientCore core, HighLevelSimpleClient client) {
        super(client);
        this.node = n;
        this.core = core;
        this.stats = this.node.getNodeStats();
        this.peers = this.node.getPeers();
    }

    private int getPeerStatusCount(PeerNodeStatus[] peerNodeStatuses, int status) {
        int count = 0;
        for (PeerNodeStatus peerNodeStatus : peerNodeStatuses) {
            if (!peerNodeStatus.recordStatus() || peerNodeStatus.getStatusValue() != status) continue;
            ++count;
        }
        return count;
    }

    private int getCountSeedServers(PeerNodeStatus[] peerNodeStatuses) {
        int count = 0;
        for (PeerNodeStatus peerNodeStatus : peerNodeStatuses) {
            if (!peerNodeStatus.isSeedServer()) continue;
            ++count;
        }
        return count;
    }

    private int getCountSeedClients(PeerNodeStatus[] peerNodeStatuses) {
        int count = 0;
        for (PeerNodeStatus peerNodeStatus : peerNodeStatuses) {
            if (!peerNodeStatus.isSeedClient()) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMethodGET(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        HTMLNode pageNode;
        if (!ctx.checkFullAccess(this)) {
            return;
        }
        SubConfig nodeConfig = this.node.getConfig().get("node");
        String requestPath = request.getPath().substring(this.path().length());
        if (requestPath.length() > 0 && (requestPath.equals("requesters.html") || requestPath.equals("/requesters.html"))) {
            this.showRequesters(request, ctx);
            return;
        }
        this.node.getClientCore().getBandwidthStatsPutter().updateData(this.node);
        StatisticsToadlet statisticsToadlet = this;
        synchronized (statisticsToadlet) {
            PeerNodeStatus[] peerNodeStatuses = this.peers.getPeerNodeStatuses(true);
            Arrays.sort(peerNodeStatuses, new Comparator<PeerNodeStatus>(){

                @Override
                public int compare(PeerNodeStatus firstNode, PeerNodeStatus secondNode) {
                    int statusDifference = firstNode.getStatusValue() - secondNode.getStatusValue();
                    if (statusDifference != 0) {
                        return statusDifference;
                    }
                    return 0;
                }
            });
            int numberOfConnected = this.getPeerStatusCount(peerNodeStatuses, 1);
            int numberOfRoutingBackedOff = this.getPeerStatusCount(peerNodeStatuses, 2);
            int numberOfTooNew = this.getPeerStatusCount(peerNodeStatuses, 3);
            int numberOfTooOld = this.getPeerStatusCount(peerNodeStatuses, 4);
            int numberOfDisconnected = this.getPeerStatusCount(peerNodeStatuses, 5);
            int numberOfNeverConnected = this.getPeerStatusCount(peerNodeStatuses, 6);
            int numberOfDisabled = this.getPeerStatusCount(peerNodeStatuses, 7);
            int numberOfBursting = this.getPeerStatusCount(peerNodeStatuses, 8);
            int numberOfListening = this.getPeerStatusCount(peerNodeStatuses, 9);
            int numberOfListenOnly = this.getPeerStatusCount(peerNodeStatuses, 10);
            int numberOfSeedServers = this.getCountSeedServers(peerNodeStatuses);
            int numberOfSeedClients = this.getCountSeedClients(peerNodeStatuses);
            int numberOfRoutingDisabled = this.getPeerStatusCount(peerNodeStatuses, 14);
            int numberOfClockProblem = this.getPeerStatusCount(peerNodeStatuses, 11);
            int numberOfConnError = this.getPeerStatusCount(peerNodeStatuses, 12);
            int numberOfDisconnecting = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 13);
            int numberOfNoLoadStats = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 15);
            PageNode page = ctx.getPageMaker().getPageNode(StatisticsToadlet.l10n("fullTitle"), ctx);
            boolean advancedMode = ctx.isAdvancedModeEnabled();
            pageNode = page.outer;
            HTMLNode contentNode = page.content;
            long now = System.currentTimeMillis();
            double myLocation = this.node.getLocation();
            long nodeUptimeSeconds = (now - this.node.getStartupTime()) / 1000L;
            if (ctx.isAllowedFullAccess()) {
                contentNode.addChild(ctx.getAlertManager().createSummary());
            }
            double swaps = this.node.getSwaps();
            double noSwaps = this.node.getNoSwaps();
            HTMLNode overviewTable = contentNode.addChild("table", "class", "column");
            HTMLNode overviewTableRow = overviewTable.addChild("tr");
            HTMLNode nextTableCell = overviewTableRow.addChild("td", "class", "first");
            HTMLNode versionInfobox = nextTableCell.addChild("div", "class", "infobox");
            this.drawNodeVersionBox(versionInfobox);
            HTMLNode jvmStatsInfobox = nextTableCell.addChild("div", "class", "infobox");
            this.drawJVMStatsBox(jvmStatsInfobox, advancedMode);
            HTMLNode statGatheringContent = ctx.getPageMaker().getInfobox("#", StatisticsToadlet.l10n("statisticGatheringTitle"), nextTableCell, "statistics-generating", true);
            if (this.node.isUsingWrapper()) {
                HTMLNode threadDumpForm = ctx.addFormChild(statGatheringContent, "/", "threadDumpForm");
                threadDumpForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "getThreadDump", StatisticsToadlet.l10n("threadDumpButton")});
            }
            HTMLNode logsList = statGatheringContent.addChild("ul");
            if (nodeConfig.config.get("logger").getBoolean("enabled")) {
                logsList.addChild("li").addChild("a", new String[]{"href", "target"}, new String[]{"/?latestlog", "_blank"}, StatisticsToadlet.l10n("getLogs"));
            }
            logsList.addChild("li").addChild("a", "href", "/translation/?getOverrideTranlationFile").addChild("#", NodeL10n.getBase().getString("TranslationToadlet.downloadTranslationsFile"));
            logsList.addChild("li").addChild("a", "href", "/diagnostic/").addChild("#", NodeL10n.getBase().getString("FProxyToadlet.diagnostic"));
            if (advancedMode) {
                HTMLNode storeSizeInfobox = contentNode.addChild("div", "class", "infobox");
                this.drawStoreSizeBox(storeSizeInfobox, myLocation, nodeUptimeSeconds);
                if (numberOfConnected + numberOfRoutingBackedOff > 0) {
                    HTMLNode loadStatsInfobox = nextTableCell.addChild("div", "class", "infobox");
                    this.drawLoadBalancingBox(loadStatsInfobox, false);
                    loadStatsInfobox = nextTableCell.addChild("div", "class", "infobox");
                    this.drawLoadBalancingBox(loadStatsInfobox, true);
                    HTMLNode newLoadManagementBox = nextTableCell.addChild("div", "class", "infobox");
                    this.drawNewLoadManagementBox(newLoadManagementBox);
                    HTMLNode successRateBox = nextTableCell.addChild("div", "class", "infobox");
                    successRateBox.addChild("div", "class", "infobox-header", StatisticsToadlet.l10n("successRate"));
                    HTMLNode successRateContent = successRateBox.addChild("div", "class", "infobox-content");
                    this.stats.fillSuccessRateBox(successRateContent);
                    HTMLNode timeDetailBox = nextTableCell.addChild("div", "class", "infobox");
                    timeDetailBox.addChild("div", "class", "infobox-header", StatisticsToadlet.l10n("chkDetailTiming"));
                    HTMLNode hTMLNode = timeDetailBox.addChild("div", "class", "infobox-content");
                    this.stats.fillDetailedTimingsBox(hTMLNode);
                    HTMLNode byHTLBox = nextTableCell.addChild("div", "class", "infobox");
                    byHTLBox.addChild("div", "class", "infobox-header", StatisticsToadlet.l10n("successByHTLBulk"));
                    HTMLNode byHTLContent = byHTLBox.addChild("div", "class", "infobox-content");
                    this.stats.fillRemoteRequestHTLsBox(byHTLContent, false);
                    byHTLBox = nextTableCell.addChild("div", "class", "infobox");
                    byHTLBox.addChild("div", "class", "infobox-header", StatisticsToadlet.l10n("successByHTLRT"));
                    byHTLContent = byHTLBox.addChild("div", "class", "infobox-content");
                    this.stats.fillRemoteRequestHTLsBox(byHTLContent, true);
                }
            }
            if (advancedMode || numberOfConnected + numberOfRoutingBackedOff > 0) {
                nextTableCell = overviewTableRow.addChild("td", "class", "last");
                HTMLNode activityInfobox = nextTableCell.addChild("div", "class", "infobox");
                this.drawActivityBox(activityInfobox, advancedMode);
                if (advancedMode) {
                    HTMLNode overviewInfobox = nextTableCell.addChild("div", "class", "infobox");
                    this.drawOverviewBox(overviewInfobox, nodeUptimeSeconds, this.node.getClientCore().getBandwidthStatsPutter().getLatestUptimeData().totalUptime, now, swaps, noSwaps);
                }
                HTMLNode peerStatsInfobox = nextTableCell.addChild("div", "class", "infobox");
                StatisticsToadlet.drawPeerStatsBox(peerStatsInfobox, advancedMode, numberOfConnected, numberOfRoutingBackedOff, numberOfTooNew, numberOfTooOld, numberOfDisconnected, numberOfNeverConnected, numberOfDisabled, numberOfBursting, numberOfListening, numberOfListenOnly, numberOfSeedServers, numberOfSeedClients, numberOfRoutingDisabled, numberOfClockProblem, numberOfConnError, numberOfDisconnecting, numberOfNoLoadStats, this.node);
                HTMLNode bandwidthInfobox = nextTableCell.addChild("div", "class", "infobox");
                this.drawBandwidthBox(bandwidthInfobox, nodeUptimeSeconds, advancedMode);
            }
            if (advancedMode) {
                int reasonCount;
                HTMLNode reasonList;
                HTMLNode backoffReasonInfobox = nextTableCell.addChild("div", "class", "infobox");
                backoffReasonInfobox.addChild("div", "class", "infobox-header", "Peer Backoff");
                HTMLNode backoffReasonContent = backoffReasonInfobox.addChild("div", "class", "infobox-content");
                HTMLNode curBackoffReasonInfobox = backoffReasonContent.addChild("div", "class", "infobox");
                curBackoffReasonInfobox.addChild("div", "class", "infobox-header", "Current backoff reasons (bulk)");
                HTMLNode curBackoffReasonContent = curBackoffReasonInfobox.addChild("div", "class", "infobox-content");
                String[] routingBackoffReasons = this.peers.getPeerNodeRoutingBackoffReasons(false);
                if (routingBackoffReasons.length == 0) {
                    curBackoffReasonContent.addChild("#", StatisticsToadlet.l10n("notBackedOff"));
                } else {
                    reasonList = curBackoffReasonContent.addChild("ul");
                    for (String routingBackoffReason : routingBackoffReasons) {
                        reasonCount = this.peers.getPeerNodeRoutingBackoffReasonSize(routingBackoffReason, false);
                        if (reasonCount <= 0) continue;
                        reasonList.addChild("li", routingBackoffReason + '\u00a0' + reasonCount);
                    }
                }
                curBackoffReasonInfobox = backoffReasonContent.addChild("div", "class", "infobox");
                curBackoffReasonInfobox.addChild("div", "class", "infobox-header", "Current backoff reasons (realtime)");
                curBackoffReasonContent = curBackoffReasonInfobox.addChild("div", "class", "infobox-content");
                routingBackoffReasons = this.peers.getPeerNodeRoutingBackoffReasons(true);
                if (routingBackoffReasons.length == 0) {
                    curBackoffReasonContent.addChild("#", StatisticsToadlet.l10n("notBackedOff"));
                } else {
                    reasonList = curBackoffReasonContent.addChild("ul");
                    for (String routingBackoffReason : routingBackoffReasons) {
                        reasonCount = this.peers.getPeerNodeRoutingBackoffReasonSize(routingBackoffReason, true);
                        if (reasonCount <= 0) continue;
                        reasonList.addChild("li", routingBackoffReason + '\u00a0' + reasonCount);
                    }
                }
                HTMLNode mandatoryBackoffStatisticsTableBulk = backoffReasonInfobox.addChild("table", "border", "0");
                HTMLNode hTMLNode = mandatoryBackoffStatisticsTableBulk.addChild("tr");
                hTMLNode.addChild("th", StatisticsToadlet.l10n("mandatoryBackoffReason") + " (bulk)");
                hTMLNode.addChild("th", StatisticsToadlet.l10n("count"));
                hTMLNode.addChild("th", StatisticsToadlet.l10n("avgTime"));
                hTMLNode.addChild("th", StatisticsToadlet.l10n("totalTime"));
                for (NodeStats.TimedStats entry : this.stats.getMandatoryBackoffStatistics(false)) {
                    HTMLNode hTMLNode2 = mandatoryBackoffStatisticsTableBulk.addChild("tr");
                    hTMLNode2.addChild("td", entry.keyStr);
                    hTMLNode2.addChild("td", Long.toString(entry.count));
                    hTMLNode2.addChild("td", TimeUtil.formatTime(entry.avgTime, 2, true));
                    hTMLNode2.addChild("td", TimeUtil.formatTime(entry.totalTime, 2, true));
                }
                HTMLNode mandatoryBackoffStatisticsTableRT = backoffReasonInfobox.addChild("table", "border", "0");
                HTMLNode hTMLNode3 = mandatoryBackoffStatisticsTableRT.addChild("tr");
                hTMLNode3.addChild("th", StatisticsToadlet.l10n("mandatoryBackoffReason") + " (realtime)");
                hTMLNode3.addChild("th", StatisticsToadlet.l10n("count"));
                hTMLNode3.addChild("th", StatisticsToadlet.l10n("avgTime"));
                hTMLNode3.addChild("th", StatisticsToadlet.l10n("totalTime"));
                for (NodeStats.TimedStats entry : this.stats.getMandatoryBackoffStatistics(true)) {
                    HTMLNode hTMLNode4 = mandatoryBackoffStatisticsTableRT.addChild("tr");
                    hTMLNode4.addChild("td", entry.keyStr);
                    hTMLNode4.addChild("td", Long.toString(entry.count));
                    hTMLNode4.addChild("td", TimeUtil.formatTime(entry.avgTime, 2, true));
                    hTMLNode4.addChild("td", TimeUtil.formatTime(entry.totalTime, 2, true));
                }
                HTMLNode routingBackoffStatisticsTableBulk = backoffReasonInfobox.addChild("table", "border", "0");
                HTMLNode hTMLNode5 = routingBackoffStatisticsTableBulk.addChild("tr");
                hTMLNode5.addChild("th", StatisticsToadlet.l10n("routingBackoffReason") + " (bulk)");
                hTMLNode5.addChild("th", StatisticsToadlet.l10n("count"));
                hTMLNode5.addChild("th", StatisticsToadlet.l10n("avgTime"));
                hTMLNode5.addChild("th", StatisticsToadlet.l10n("totalTime"));
                for (NodeStats.TimedStats entry : this.stats.getRoutingBackoffStatistics(false)) {
                    HTMLNode hTMLNode6 = routingBackoffStatisticsTableBulk.addChild("tr");
                    hTMLNode6.addChild("td", entry.keyStr);
                    hTMLNode6.addChild("td", Long.toString(entry.count));
                    hTMLNode6.addChild("td", TimeUtil.formatTime(entry.avgTime, 2, true));
                    hTMLNode6.addChild("td", TimeUtil.formatTime(entry.totalTime, 2, true));
                }
                HTMLNode routingBackoffStatisticsTableRT = backoffReasonInfobox.addChild("table", "border", "0");
                HTMLNode hTMLNode7 = routingBackoffStatisticsTableRT.addChild("tr");
                hTMLNode7.addChild("th", StatisticsToadlet.l10n("routingBackoffReason") + " (realtime)");
                hTMLNode7.addChild("th", StatisticsToadlet.l10n("count"));
                hTMLNode7.addChild("th", StatisticsToadlet.l10n("avgTime"));
                hTMLNode7.addChild("th", StatisticsToadlet.l10n("totalTime"));
                for (NodeStats.TimedStats entry : this.stats.getRoutingBackoffStatistics(true)) {
                    HTMLNode hTMLNode8 = routingBackoffStatisticsTableRT.addChild("tr");
                    hTMLNode8.addChild("td", entry.keyStr);
                    hTMLNode8.addChild("td", Long.toString(entry.count));
                    hTMLNode8.addChild("td", TimeUtil.formatTime(entry.avgTime, 2, true));
                    hTMLNode8.addChild("td", TimeUtil.formatTime(entry.totalTime, 2, true));
                }
                HTMLNode transferBackoffStatisticsTableBulk = backoffReasonInfobox.addChild("table", "border", "0");
                HTMLNode hTMLNode9 = transferBackoffStatisticsTableBulk.addChild("tr");
                hTMLNode9.addChild("th", StatisticsToadlet.l10n("transferBackoffReason") + " (bulk)");
                hTMLNode9.addChild("th", StatisticsToadlet.l10n("count"));
                hTMLNode9.addChild("th", StatisticsToadlet.l10n("avgTime"));
                hTMLNode9.addChild("th", StatisticsToadlet.l10n("totalTime"));
                for (NodeStats.TimedStats entry : this.stats.getTransferBackoffStatistics(false)) {
                    HTMLNode hTMLNode10 = transferBackoffStatisticsTableBulk.addChild("tr");
                    hTMLNode10.addChild("td", entry.keyStr);
                    hTMLNode10.addChild("td", Long.toString(entry.count));
                    hTMLNode10.addChild("td", TimeUtil.formatTime(entry.avgTime, 2, true));
                    hTMLNode10.addChild("td", TimeUtil.formatTime(entry.totalTime, 2, true));
                }
                HTMLNode transferBackoffStatisticsTableRT = backoffReasonInfobox.addChild("table", "border", "0");
                HTMLNode hTMLNode11 = transferBackoffStatisticsTableRT.addChild("tr");
                hTMLNode11.addChild("th", StatisticsToadlet.l10n("transferBackoffReason") + " (realtime)");
                hTMLNode11.addChild("th", StatisticsToadlet.l10n("count"));
                hTMLNode11.addChild("th", StatisticsToadlet.l10n("avgTime"));
                hTMLNode11.addChild("th", StatisticsToadlet.l10n("totalTime"));
                for (NodeStats.TimedStats entry : this.stats.getTransferBackoffStatistics(true)) {
                    HTMLNode hTMLNode12 = transferBackoffStatisticsTableRT.addChild("tr");
                    hTMLNode12.addChild("td", entry.keyStr);
                    hTMLNode12.addChild("td", Long.toString(entry.count));
                    hTMLNode12.addChild("td", TimeUtil.formatTime(entry.avgTime, 2, true));
                    hTMLNode12.addChild("td", TimeUtil.formatTime(entry.totalTime, 2, true));
                }
                HTMLNode locationSwapInfobox = nextTableCell.addChild("div", "class", "infobox");
                this.drawSwapStatsBox(locationSwapInfobox, myLocation, nodeUptimeSeconds, swaps, noSwaps);
                HTMLNode unclaimedFIFOMessageCountsInfobox = nextTableCell.addChild("div", "class", "infobox");
                this.drawUnclaimedFIFOMessageCountsBox(unclaimedFIFOMessageCountsInfobox);
                HTMLNode threadsPriorityInfobox = nextTableCell.addChild("div", "class", "infobox");
                this.drawThreadPriorityStatsBox(threadsPriorityInfobox);
                nextTableCell = overviewTableRow.addChild("td");
                HTMLNode threadUsageInfobox = nextTableCell.addChild("div", "class", "infobox");
                threadUsageInfobox.addChild("div", "class", "infobox-header", "Thread usage");
                HTMLNode threadUsageContent = threadUsageInfobox.addChild("div", "class", "infobox-content");
                HTMLNode threadUsageList = threadUsageContent.addChild("ul");
                this.getThreadNames(threadUsageList);
                this.drawRejectReasonsBox(nextTableCell, false);
                this.drawRejectReasonsBox(nextTableCell, true);
                OpennetManager om = this.node.getOpennet();
                if (om != null) {
                    this.drawOpennetStatsBox(nextTableCell.addChild("div", "class", "infobox"), om);
                    if (this.node.isSeednode()) {
                        this.drawSeedStatsBox(nextTableCell.addChild("div", "class", "infobox"), om);
                    }
                }
                overviewTableRow = overviewTable.addChild("tr");
                nextTableCell = overviewTableRow.addChild("td", "class", "first");
                HTMLNode peerCircleInfobox = nextTableCell.addChild("div", "class", "infobox");
                peerCircleInfobox.addChild("div", "class", "infobox-header", "Peer\u00a0Location\u00a0Distribution (w/pReject)");
                HTMLNode peerCircleTable = peerCircleInfobox.addChild("div", "class", "infobox-content").addChild("table");
                this.addPeerCircle(peerCircleTable, peerNodeStatuses, myLocation);
                nextTableCell = overviewTableRow.addChild("td");
                HTMLNode nodeCircleInfobox = nextTableCell.addChild("div", "class", "infobox");
                nodeCircleInfobox.addChild("div", "class", "infobox-header", "Node\u00a0Location\u00a0Distribution (w/Swap\u00a0Age)");
                HTMLNode nodeCircleTable = nodeCircleInfobox.addChild("div", "class", "infobox-content").addChild("table");
                this.addNodeCircle(nodeCircleTable, myLocation);
                overviewTableRow = overviewTable.addChild("tr");
                nextTableCell = overviewTableRow.addChild("td", "class", "first");
                int[] incomingRequestCountArray = new int[1];
                int[] incomingRequestLocation = this.stats.getIncomingRequestLocation(incomingRequestCountArray);
                int incomingRequestsCount = incomingRequestCountArray[0];
                if (incomingRequestsCount > 0) {
                    HTMLNode nodeSpecialisationInfobox = nextTableCell.addChild("div", "class", "infobox");
                    nodeSpecialisationInfobox.addChild("div", "class", "infobox-header", "Incoming\u00a0Request\u00a0Distribution");
                    HTMLNode nodeSpecialisationTable = nodeSpecialisationInfobox.addChild("div", "class", "infobox-content").addChild("table");
                    this.addSpecialisation(nodeSpecialisationTable, myLocation, incomingRequestLocation);
                }
                nextTableCell = overviewTableRow.addChild("td");
                int[] outgoingLocalRequestCountArray = new int[1];
                int[] outgoingLocalRequestLocation = this.stats.getOutgoingLocalRequestLocation(outgoingLocalRequestCountArray);
                int outgoingLocalRequestsCount = outgoingLocalRequestCountArray[0];
                int[] outgoingRequestCountArray = new int[1];
                int[] outgoingRequestLocation = this.stats.getOutgoingRequestLocation(outgoingRequestCountArray);
                int outgoingRequestsCount = outgoingRequestCountArray[0];
                if (outgoingLocalRequestsCount > 0 && outgoingRequestsCount > 0) {
                    HTMLNode nodeSpecialisationInfobox = nextTableCell.addChild("div", "class", "infobox");
                    nodeSpecialisationInfobox.addChild("div", "class", "infobox-header", "Outgoing\u00a0Request\u00a0Distribution");
                    HTMLNode nodeSpecialisationTable = nodeSpecialisationInfobox.addChild("div", "class", "infobox-content").addChild("table");
                    this.addCombinedSpecialisation(nodeSpecialisationTable, myLocation, outgoingLocalRequestLocation, outgoingRequestLocation);
                }
                overviewTableRow = overviewTable.addChild("tr");
                nextTableCell = overviewTableRow.addChild("td", "class", "first");
                int[] locationSuccessRatesArray = this.stats.chkSuccessRatesByLocation.getPercentageArray(1000);
                HTMLNode nodeSpecialisationInfobox = nextTableCell.addChild("div", "class", "infobox");
                nodeSpecialisationInfobox.addChild("div", "class", "infobox-header", "Local\u00a0CHK\u00a0Success\u00a0Rates\u00a0By\u00a0Location");
                HTMLNode nodeSpecialisationTable = nodeSpecialisationInfobox.addChild("div", "class", "infobox-content").addChild("table");
                this.addSpecialisation(nodeSpecialisationTable, myLocation, locationSuccessRatesArray);
                nextTableCell = overviewTableRow.addChild("td");
                HTMLNode foafLinkInfobox = nextTableCell.addChild("div", "class", "infobox");
                foafLinkInfobox.addChild("div", "class", "infobox-header", "FOAF\u00a0Link-Length\u00a0Distribution");
                HTMLNode foafLinkTable = foafLinkInfobox.addChild("div", "class", "infobox-content").addChild("table");
                this.addFOAFLinkLengthHistogram(foafLinkTable, peerNodeStatuses);
            }
        }
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    private void showRequesters(HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        PageNode page = ctx.getPageMaker().getPageNode(StatisticsToadlet.l10n("fullTitle"), ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        this.drawClientRequestersBox(contentNode);
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    private void drawLoadBalancingBox(HTMLNode loadStatsInfobox, boolean realTime) {
        loadStatsInfobox.addChild("div", "class", "infobox-header", "Load limiting " + (realTime ? "RealTime" : "Bulk"));
        HTMLNode loadStatsContent = loadStatsInfobox.addChild("div", "class", "infobox-content");
        RequestStarterGroup starters = this.core.getRequestStarters();
        double window = starters.getWindow(realTime);
        double realWindow = starters.getRealWindow(realTime);
        HTMLNode loadStatsList = loadStatsContent.addChild("ul");
        loadStatsList.addChild("li", StatisticsToadlet.l10n("globalWindow") + ": " + window);
        loadStatsList.addChild("li", StatisticsToadlet.l10n("realGlobalWindow") + ": " + realWindow);
        loadStatsList.addChild("li", starters.statsPageLine(false, false, realTime));
        loadStatsList.addChild("li", starters.statsPageLine(true, false, realTime));
        loadStatsList.addChild("li", starters.statsPageLine(false, true, realTime));
        loadStatsList.addChild("li", starters.statsPageLine(true, true, realTime));
        loadStatsList.addChild("li", starters.diagnosticThrottlesLine(false));
        loadStatsList.addChild("li", starters.diagnosticThrottlesLine(true));
    }

    private void drawNewLoadManagementBox(HTMLNode infobox) {
        infobox.addChild("div", "class", "infobox-header", StatisticsToadlet.l10n("newLoadManagementTitle"));
        HTMLNode content = infobox.addChild("div", "class", "infobox-content");
        this.node.getNodeStats().drawNewLoadManagementDelayTimes(content);
    }

    private void drawRejectReasonsBox(HTMLNode nextTableCell, boolean local) {
        boolean success;
        HTMLNode rejectReasonsTable = new HTMLNode("table");
        NodeStats stats = this.node.getNodeStats();
        boolean bl = success = local ? stats.getLocalRejectReasonsTable(rejectReasonsTable) : stats.getRejectReasonsTable(rejectReasonsTable);
        if (!success) {
            return;
        }
        HTMLNode rejectReasonsInfobox = nextTableCell.addChild("div", "class", "infobox");
        rejectReasonsInfobox.addChild("div", "class", "infobox-header", (local ? "Local " : "") + "Preemptive Rejection Reasons");
        rejectReasonsInfobox.addChild("div", "class", "infobox-content").addChild(rejectReasonsTable);
    }

    private void drawNodeVersionBox(HTMLNode versionInfobox) {
        versionInfobox.addChild("div", "class", "infobox-header", StatisticsToadlet.l10n("versionTitle"));
        HTMLNode versionInfoboxContent = versionInfobox.addChild("div", "class", "infobox-content");
        HTMLNode versionInfoboxList = versionInfoboxContent.addChild("ul");
        versionInfoboxList.addChild("li", NodeL10n.getBase().getString("WelcomeToadlet.version", new String[]{"fullVersion", "build", "rev"}, new String[]{Version.publicVersion(), Integer.toString(Version.buildNumber()), Version.cvsRevision()}));
        versionInfoboxList.addChild("li", NodeL10n.getBase().getString("WelcomeToadlet.extVersion", new String[]{"build", "rev"}, new String[]{Integer.toString(NodeStarter.extBuildNumber), NodeStarter.extRevisionNumber}));
        this.node.getNodeUpdater().addChangelogLinks(Version.buildNumber(), versionInfobox);
    }

    private void drawJVMStatsBox(HTMLNode jvmStatsInfobox, boolean advancedModeEnabled) {
        jvmStatsInfobox.addChild("div", "class", "infobox-header", StatisticsToadlet.l10n("jvmInfoTitle"));
        HTMLNode jvmStatsInfoboxContent = jvmStatsInfobox.addChild("div", "class", "infobox-content");
        HTMLNode jvmStatsList = jvmStatsInfoboxContent.addChild("ul");
        Runtime rt = Runtime.getRuntime();
        long freeMemory = rt.freeMemory();
        long totalMemory = rt.totalMemory();
        long maxMemory = rt.maxMemory();
        long usedJavaMem = totalMemory - freeMemory;
        long allocatedJavaMem = totalMemory;
        long maxJavaMem = maxMemory;
        int availableCpus = rt.availableProcessors();
        int threadCount = this.stats.getActiveThreadCount();
        jvmStatsList.addChild("li", StatisticsToadlet.l10n("usedMemory", "memory", SizeUtil.formatSize(usedJavaMem, true)));
        jvmStatsList.addChild("li", StatisticsToadlet.l10n("allocMemory", "memory", SizeUtil.formatSize(allocatedJavaMem, true)));
        jvmStatsList.addChild("li", StatisticsToadlet.l10n("maxMemory", "memory", SizeUtil.formatSize(maxJavaMem, true)));
        jvmStatsList.addChild("li", StatisticsToadlet.l10n("threads", new String[]{"running", "max"}, new String[]{thousandPoint.format(threadCount), Integer.toString(this.stats.getThreadLimit())}));
        jvmStatsList.addChild("li", StatisticsToadlet.l10n("cpus", "count", Integer.toString(availableCpus)));
        jvmStatsList.addChild("li", StatisticsToadlet.l10n("javaVersion", "version", System.getProperty("java.version")));
        jvmStatsList.addChild("li", StatisticsToadlet.l10n("jvmVendor", "vendor", System.getProperty("java.vendor")));
        jvmStatsList.addChild("li", StatisticsToadlet.l10n("jvmName", "name", System.getProperty("java.vm.name")));
        jvmStatsList.addChild("li", StatisticsToadlet.l10n("jvmVersion", "version", System.getProperty("java.vm.version")));
        jvmStatsList.addChild("li", StatisticsToadlet.l10n("osName", "name", System.getProperty("os.name")));
        jvmStatsList.addChild("li", StatisticsToadlet.l10n("osVersion", "version", System.getProperty("os.version")));
        jvmStatsList.addChild("li", StatisticsToadlet.l10n("osArch", "arch", System.getProperty("os.arch")));
        if (advancedModeEnabled) {
            if (Rijndael.AesCtrProvider == null) {
                jvmStatsList.addChild("li", StatisticsToadlet.l10n("cryptoUsingBuiltin"));
            } else {
                jvmStatsList.addChild("li", StatisticsToadlet.l10n("cryptoUsingJCA", "provider", Rijndael.getProviderName()));
            }
        }
    }

    private void drawThreadPriorityStatsBox(HTMLNode node) {
        node.addChild("div", "class", "infobox-header", StatisticsToadlet.l10n("threadsByPriority"));
        HTMLNode threadsInfoboxContent = node.addChild("div", "class", "infobox-content");
        int[] activeThreadsByPriority = this.stats.getActiveThreadsByPriority();
        int[] waitingThreadsByPriority = this.stats.getWaitingThreadsByPriority();
        HTMLNode threadsByPriorityTable = threadsInfoboxContent.addChild("table", "border", "0");
        HTMLNode row = threadsByPriorityTable.addChild("tr");
        row.addChild("th", StatisticsToadlet.l10n("priority"));
        row.addChild("th", StatisticsToadlet.l10n("running"));
        row.addChild("th", StatisticsToadlet.l10n("waiting"));
        for (int i = 0; i < activeThreadsByPriority.length; ++i) {
            row = threadsByPriorityTable.addChild("tr");
            row.addChild("td", String.valueOf(i + 1));
            row.addChild("td", String.valueOf(activeThreadsByPriority[i]));
            row.addChild("td", String.valueOf(waitingThreadsByPriority[i]));
        }
    }

    private void drawOpennetStatsBox(HTMLNode box, OpennetManager om) {
        box.addChild("div", "class", "infobox-header", StatisticsToadlet.l10n("opennetStats"));
        HTMLNode opennetStatsContent = box.addChild("div", "class", "infobox-content");
        om.drawOpennetStatsBox(opennetStatsContent);
    }

    private void drawSeedStatsBox(HTMLNode box, OpennetManager om) {
        box.addChild("div", "class", "infobox-header", StatisticsToadlet.l10n("seedStats"));
        HTMLNode opennetStatsContent = box.addChild("div", "class", "infobox-content");
        om.drawSeedStatsBox(opennetStatsContent);
    }

    private void drawClientRequestersBox(HTMLNode box) {
        box.addChild("div", "class", "infobox-header", StatisticsToadlet.l10n("clientRequesterObjects"));
        HTMLNode masterContent = box.addChild("div", "class", "infobox-content");
        HTMLNode table = masterContent.addChild("table");
        HTMLNode row = table.addChild("tr");
        row.addChild("th", "RequestClient");
        row.addChild("th", StatisticsToadlet.l10n("clientRequesters.class"));
        row.addChild("th", StatisticsToadlet.l10n("clientRequesters.age"));
        row.addChild("th", StatisticsToadlet.l10n("clientRequesters.priorityClass"));
        row.addChild("th", StatisticsToadlet.l10n("clientRequesters.realtimeFlag"));
        row.addChild("th", StatisticsToadlet.l10n("clientRequesters.uri"));
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(0);
        nf.setMinimumIntegerDigits(2);
        ClientRequester[] requests = ClientRequester.getAll();
        Arrays.sort(requests, new Comparator<ClientRequester>(){

            @Override
            public int compare(ClientRequester a, ClientRequester b) {
                return -Long.signum(a.creationTime - b.creationTime);
            }
        });
        long now = System.currentTimeMillis();
        for (ClientRequester request : requests) {
            if (request.isFinished() || request.isCancelled()) continue;
            row = table.addChild("tr");
            RequestClient client = request.getClient();
            row.addChild("td", client.toString());
            try {
                String s = request.toString();
                if (s.indexOf(58) > s.indexOf(64)) {
                    s = s.substring(0, s.indexOf(58));
                }
                row.addChild("td", s);
            }
            catch (Throwable t) {
                row.addChild("td", "ERROR: " + request.getClass().toString());
            }
            long diff = now - request.creationTime;
            StringBuilder sb = new StringBuilder();
            sb.append(TimeUtil.formatTime(diff, 2));
            row.addChild("td", sb.toString());
            row.addChild("td", Short.toString(request.getPriorityClass()));
            row.addChild("td", client == null ? "?" : Boolean.toString(client.realTimeFlag()));
            FreenetURI uri = request.getURI();
            row.addChild("td", uri == null ? "null" : uri.toString());
        }
    }

    private void drawStoreSizeBox(HTMLNode storeSizeInfobox, double loc, long nodeUptimeSeconds) {
        storeSizeInfobox.addChild("div", "class", "infobox-header", StatisticsToadlet.l10n("datastore"));
        HTMLNode storeSizeInfoboxContent = storeSizeInfobox.addChild("div", "class", "infobox-content");
        HTMLNode scrollDiv = storeSizeInfoboxContent.addChild("div", "style", "overflow:scr");
        HTMLNode storeSizeTable = scrollDiv.addChild("table", "border", "0");
        HTMLNode row = storeSizeTable.addChild("tr");
        row.addChild("th", "");
        row.addChild("th", StatisticsToadlet.l10n("keys"));
        row.addChild("th", StatisticsToadlet.l10n("capacity"));
        row.addChild("th", StatisticsToadlet.l10n("datasize"));
        row.addChild("th", StatisticsToadlet.l10n("utilization"));
        row.addChild("th", StatisticsToadlet.l10n("readRequests"));
        row.addChild("th", StatisticsToadlet.l10n("successfulReads"));
        row.addChild("th", StatisticsToadlet.l10n("successRate"));
        row.addChild("th", StatisticsToadlet.l10n("writes"));
        row.addChild("th", StatisticsToadlet.l10n("accessRate"));
        row.addChild("th", StatisticsToadlet.l10n("writeRate"));
        row.addChild("th", StatisticsToadlet.l10n("falsePos"));
        row.addChild("th", StatisticsToadlet.l10n("avgLocation"));
        row.addChild("th", StatisticsToadlet.l10n("avgSuccessLoc"));
        row.addChild("th", StatisticsToadlet.l10n("furthestSuccess"));
        row.addChild("th", StatisticsToadlet.l10n("avgDist"));
        row.addChild("th", StatisticsToadlet.l10n("distanceStats"));
        Map<DataStoreInstanceType, DataStoreStats> storeStats = this.node.getDataStoreStats();
        for (Map.Entry<DataStoreInstanceType, DataStoreStats> entry : storeStats.entrySet()) {
            StoreAccessStats totalAccess;
            DataStoreInstanceType instance = entry.getKey();
            DataStoreStats stats = entry.getValue();
            StoreAccessStats sessionAccess = stats.getSessionAccessStats();
            long totalUptimeSeconds = 0L;
            try {
                totalAccess = stats.getTotalAccessStats();
                totalUptimeSeconds = this.node.getClientCore().getBandwidthStatsPutter().getLatestUptimeData().totalUptime;
            }
            catch (StatsNotAvailableException e) {
                totalAccess = null;
            }
            row = storeSizeTable.addChild("tr");
            row.addChild("th", StatisticsToadlet.l10n(instance.store.name()) + "\n (" + StatisticsToadlet.l10n(instance.key.name()) + ")");
            row.addChild("td", thousandPoint.format(stats.keys()));
            row.addChild("td", thousandPoint.format(stats.capacity()));
            row.addChild("td", SizeUtil.formatSize(stats.dataSize()));
            row.addChild("td", this.fix3p1pct.format(stats.utilization()));
            row.addChild("td", thousandPoint.format(sessionAccess.readRequests()) + (totalAccess == null ? "" : " (" + thousandPoint.format(totalAccess.readRequests()) + ")"));
            row.addChild("td", thousandPoint.format(sessionAccess.successfulReads()) + (totalAccess == null ? "" : " (" + thousandPoint.format(totalAccess.successfulReads()) + ")"));
            try {
                String rate = this.fix1p4.format(sessionAccess.successRate()) + "%";
                if (totalAccess != null) {
                    try {
                        rate = rate + " (" + this.fix1p4.format(totalAccess.successRate()) + "%)";
                    }
                    catch (StatsNotAvailableException statsNotAvailableException) {
                        // empty catch block
                    }
                }
                row.addChild("td", rate);
            }
            catch (StatsNotAvailableException e) {
                row.addChild("td", "N/A");
            }
            row.addChild("td", thousandPoint.format(sessionAccess.writes()) + (totalAccess == null ? "" : " (" + thousandPoint.format(totalAccess.writes()) + ")"));
            String access = this.fix1p2.format(sessionAccess.accessRate(nodeUptimeSeconds)) + " /s";
            if (totalAccess != null) {
                access = access + " (" + this.fix1p2.format(totalAccess.accessRate(totalUptimeSeconds)) + " /s)";
            }
            row.addChild("td", access);
            access = this.fix1p2.format(sessionAccess.writeRate(nodeUptimeSeconds)) + " /s";
            if (totalAccess != null) {
                access = access + " (" + this.fix1p2.format(totalAccess.writeRate(totalUptimeSeconds)) + " /s)";
            }
            row.addChild("td", access);
            row.addChild("td", thousandPoint.format(sessionAccess.falsePos()) + (totalAccess == null ? "" : " (" + thousandPoint.format(totalAccess.falsePos()) + ")"));
            try {
                row.addChild("td", this.fix1p4.format(stats.avgLocation()));
            }
            catch (StatsNotAvailableException e) {
                row.addChild("td", "N/A");
            }
            try {
                row.addChild("td", this.fix1p4.format(stats.avgSuccess()));
            }
            catch (StatsNotAvailableException e) {
                row.addChild("td", "N/A");
            }
            try {
                row.addChild("td", this.fix1p4.format(stats.furthestSuccess()));
            }
            catch (StatsNotAvailableException e) {
                row.addChild("td", "N/A");
            }
            try {
                row.addChild("td", this.fix1p4.format(stats.avgDist()));
            }
            catch (StatsNotAvailableException e) {
                row.addChild("td", "N/A");
            }
            try {
                row.addChild("td", this.fix3p1pct.format(stats.distanceStats()));
            }
            catch (StatsNotAvailableException e) {
                row.addChild("td", "N/A");
            }
        }
    }

    private void drawUnclaimedFIFOMessageCountsBox(HTMLNode unclaimedFIFOMessageCountsInfobox) {
        unclaimedFIFOMessageCountsInfobox.addChild("div", "class", "infobox-header", "unclaimedFIFO Message Counts");
        HTMLNode unclaimedFIFOMessageCountsInfoboxContent = unclaimedFIFOMessageCountsInfobox.addChild("div", "class", "infobox-content");
        HTMLNode unclaimedFIFOMessageCountsList = unclaimedFIFOMessageCountsInfoboxContent.addChild("ul");
        Map<String, Integer> unclaimedFIFOMessageCountsMap = this.node.getUSM().getUnclaimedFIFOMessageCounts();
        STMessageCount[] unclaimedFIFOMessageCountsArray = new STMessageCount[unclaimedFIFOMessageCountsMap.size()];
        int i = 0;
        int totalCount = 0;
        for (Map.Entry<String, Integer> e : unclaimedFIFOMessageCountsMap.entrySet()) {
            String messageName = e.getKey();
            int messageCount = e.getValue();
            totalCount += messageCount;
            unclaimedFIFOMessageCountsArray[i++] = new STMessageCount(messageName, messageCount);
        }
        Arrays.sort(unclaimedFIFOMessageCountsArray, new Comparator<STMessageCount>(){

            @Override
            public int compare(STMessageCount firstCount, STMessageCount secondCount) {
                return secondCount.messageCount - firstCount.messageCount;
            }
        });
        for (STMessageCount messageCountItem : unclaimedFIFOMessageCountsArray) {
            int thisMessageCount = messageCountItem.messageCount;
            double thisMessagePercentOfTotal = (double)thisMessageCount / (double)totalCount;
            unclaimedFIFOMessageCountsList.addChild("li", "" + messageCountItem.messageName + ":\u00a0" + thisMessageCount + "\u00a0(" + this.fix3p1pct.format(thisMessagePercentOfTotal) + ')');
        }
        unclaimedFIFOMessageCountsList.addChild("li", "Unclaimed Messages Considered:\u00a0" + totalCount);
    }

    private void drawSwapStatsBox(HTMLNode locationSwapInfobox, double location, long nodeUptimeSeconds, double swaps, double noSwaps) {
        locationSwapInfobox.addChild("div", "class", "infobox-header", "Location swaps");
        int startedSwaps = this.node.getStartedSwaps();
        int swapsRejectedAlreadyLocked = this.node.getSwapsRejectedAlreadyLocked();
        int swapsRejectedNowhereToGo = this.node.getSwapsRejectedNowhereToGo();
        int swapsRejectedRateLimit = this.node.getSwapsRejectedRateLimit();
        int swapsRejectedRecognizedID = this.node.getSwapsRejectedRecognizedID();
        double locChangeSession = this.node.getLocationChangeSession();
        int averageSwapTime = this.node.getAverageOutgoingSwapTime();
        long sendSwapInterval = this.node.getSendSwapInterval();
        HTMLNode locationSwapInfoboxContent = locationSwapInfobox.addChild("div", "class", "infobox-content");
        HTMLNode locationSwapList = locationSwapInfoboxContent.addChild("ul");
        locationSwapList.addChild("li", "location:\u00a0" + location);
        if (swaps > 0.0) {
            locationSwapList.addChild("li", "locChangeSession:\u00a0" + this.fix1p6sci.format(locChangeSession));
            locationSwapList.addChild("li", "locChangePerSwap:\u00a0" + this.fix1p6sci.format(locChangeSession / swaps));
        }
        if (swaps > 0.0 && nodeUptimeSeconds >= 60L) {
            locationSwapList.addChild("li", "locChangePerMinute:\u00a0" + this.fix1p6sci.format(locChangeSession / ((double)nodeUptimeSeconds / 60.0)));
        }
        if (swaps > 0.0 && nodeUptimeSeconds >= 60L) {
            locationSwapList.addChild("li", "swapsPerMinute:\u00a0" + this.fix1p6sci.format(swaps / ((double)nodeUptimeSeconds / 60.0)));
        }
        if (noSwaps > 0.0 && nodeUptimeSeconds >= 60L) {
            locationSwapList.addChild("li", "noSwapsPerMinute:\u00a0" + this.fix1p6sci.format(noSwaps / ((double)nodeUptimeSeconds / 60.0)));
        }
        if (swaps > 0.0 && noSwaps > 0.0) {
            locationSwapList.addChild("li", "swapsPerNoSwaps:\u00a0" + this.fix1p6sci.format(swaps / noSwaps));
        }
        if (swaps > 0.0) {
            locationSwapList.addChild("li", "swaps:\u00a0" + (int)swaps);
        }
        if (noSwaps > 0.0) {
            locationSwapList.addChild("li", "noSwaps:\u00a0" + (int)noSwaps);
        }
        if (startedSwaps > 0) {
            locationSwapList.addChild("li", "startedSwaps:\u00a0" + startedSwaps);
        }
        if (swapsRejectedAlreadyLocked > 0) {
            locationSwapList.addChild("li", "swapsRejectedAlreadyLocked:\u00a0" + swapsRejectedAlreadyLocked);
        }
        if (swapsRejectedNowhereToGo > 0) {
            locationSwapList.addChild("li", "swapsRejectedNowhereToGo:\u00a0" + swapsRejectedNowhereToGo);
        }
        if (swapsRejectedRateLimit > 0) {
            locationSwapList.addChild("li", "swapsRejectedRateLimit:\u00a0" + swapsRejectedRateLimit);
        }
        if (swapsRejectedRecognizedID > 0) {
            locationSwapList.addChild("li", "swapsRejectedRecognizedID:\u00a0" + swapsRejectedRecognizedID);
        }
        locationSwapList.addChild("li", "averageSwapTime:\u00a0" + TimeUtil.formatTime(averageSwapTime, 2, true));
        locationSwapList.addChild("li", "sendSwapInterval:\u00a0" + TimeUtil.formatTime(sendSwapInterval, 2, true));
    }

    protected static void drawPeerStatsBox(HTMLNode peerStatsInfobox, boolean advancedModeEnabled, int numberOfConnected, int numberOfRoutingBackedOff, int numberOfTooNew, int numberOfTooOld, int numberOfDisconnected, int numberOfNeverConnected, int numberOfDisabled, int numberOfBursting, int numberOfListening, int numberOfListenOnly, int numberOfSeedServers, int numberOfSeedClients, int numberOfRoutingDisabled, int numberOfClockProblem, int numberOfConnError, int numberOfDisconnecting, int numberOfNoLoadStats, Node node) {
        OpennetManager om;
        HTMLNode peerStatsRoutingDisabledListItem;
        HTMLNode peerStatsListenOnlyListItem;
        peerStatsInfobox.addChild("div", "class", "infobox-header", StatisticsToadlet.l10n("peerStatsTitle"));
        HTMLNode peerStatsContent = peerStatsInfobox.addChild("div", "class", "infobox-content");
        HTMLNode peerStatsList = peerStatsContent.addChild("ul");
        if (numberOfConnected > 0) {
            HTMLNode peerStatsConnectedListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsConnectedListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_connected", StatisticsToadlet.l10nDark("connected"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("connectedShort"));
            peerStatsConnectedListItem.addChild("span", ":\u00a0" + numberOfConnected);
        }
        if (numberOfRoutingBackedOff > 0) {
            HTMLNode peerStatsRoutingBackedOffListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsRoutingBackedOffListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_backed_off", StatisticsToadlet.l10nDark(advancedModeEnabled ? "backedOff" : "busy"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark((advancedModeEnabled ? "backedOff" : "busy") + "Short"));
            peerStatsRoutingBackedOffListItem.addChild("span", ":\u00a0" + numberOfRoutingBackedOff);
        }
        if (numberOfTooNew > 0) {
            HTMLNode peerStatsTooNewListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsTooNewListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_too_new", StatisticsToadlet.l10nDark("tooNew"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("tooNewShort"));
            peerStatsTooNewListItem.addChild("span", ":\u00a0" + numberOfTooNew);
        }
        if (numberOfTooOld > 0) {
            HTMLNode peerStatsTooOldListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsTooOldListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_too_old", StatisticsToadlet.l10nDark("tooOld"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("tooOldShort"));
            peerStatsTooOldListItem.addChild("span", ":\u00a0" + numberOfTooOld);
        }
        if (numberOfDisconnected > 0) {
            HTMLNode peerStatsDisconnectedListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsDisconnectedListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_disconnected", StatisticsToadlet.l10nDark("notConnected"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("notConnectedShort"));
            peerStatsDisconnectedListItem.addChild("span", ":\u00a0" + numberOfDisconnected);
        }
        if (numberOfNeverConnected > 0) {
            HTMLNode peerStatsNeverConnectedListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsNeverConnectedListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_never_connected", StatisticsToadlet.l10nDark("neverConnected"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("neverConnectedShort"));
            peerStatsNeverConnectedListItem.addChild("span", ":\u00a0" + numberOfNeverConnected);
        }
        if (numberOfDisabled > 0) {
            HTMLNode peerStatsDisabledListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsDisabledListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_disabled", StatisticsToadlet.l10nDark("disabled"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("disabledShort"));
            peerStatsDisabledListItem.addChild("span", ":\u00a0" + numberOfDisabled);
        }
        if (numberOfBursting > 0) {
            HTMLNode peerStatsBurstingListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsBurstingListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_bursting", StatisticsToadlet.l10nDark("bursting"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("burstingShort"));
            peerStatsBurstingListItem.addChild("span", ":\u00a0" + numberOfBursting);
        }
        if (numberOfListening > 0) {
            HTMLNode peerStatsListeningListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsListeningListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_listening", StatisticsToadlet.l10nDark("listening"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("listeningShort"));
            peerStatsListeningListItem.addChild("span", ":\u00a0" + numberOfListening);
        }
        if (numberOfListenOnly > 0) {
            peerStatsListenOnlyListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsListenOnlyListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_listen_only", StatisticsToadlet.l10nDark("listenOnly"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("listenOnlyShort"));
            peerStatsListenOnlyListItem.addChild("span", ":\u00a0" + numberOfListenOnly);
        }
        if (numberOfClockProblem > 0) {
            peerStatsRoutingDisabledListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsRoutingDisabledListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_clock_problem", StatisticsToadlet.l10nDark("clockProblem"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("clockProblemShort"));
            peerStatsRoutingDisabledListItem.addChild("span", ":\u00a0" + numberOfClockProblem);
        }
        if (numberOfConnError > 0) {
            peerStatsRoutingDisabledListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsRoutingDisabledListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_routing_disabled", StatisticsToadlet.l10nDark("connError"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("connErrorShort"));
            peerStatsRoutingDisabledListItem.addChild("span", ":\u00a0" + numberOfClockProblem);
        }
        if (numberOfDisconnecting > 0) {
            peerStatsListenOnlyListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsListenOnlyListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_disconnecting", StatisticsToadlet.l10nDark("disconnecting"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("disconnectingShort"));
            peerStatsListenOnlyListItem.addChild("span", ":\u00a0" + numberOfDisconnecting);
        }
        if (numberOfSeedServers > 0) {
            HTMLNode peerStatsSeedServersListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsSeedServersListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_listening", StatisticsToadlet.l10nDark("seedServers"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("seedServersShort"));
            peerStatsSeedServersListItem.addChild("span", ":\u00a0" + numberOfSeedServers);
        }
        if (numberOfSeedClients > 0) {
            HTMLNode peerStatsSeedClientsListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsSeedClientsListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_listening", StatisticsToadlet.l10nDark("seedClients"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("seedClientsShort"));
            peerStatsSeedClientsListItem.addChild("span", ":\u00a0" + numberOfSeedClients);
        }
        if (numberOfRoutingDisabled > 0) {
            peerStatsRoutingDisabledListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsRoutingDisabledListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_routing_disabled", StatisticsToadlet.l10nDark("routingDisabled"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("routingDisabledShort"));
            peerStatsRoutingDisabledListItem.addChild("span", ":\u00a0" + numberOfRoutingDisabled);
        }
        if (numberOfNoLoadStats > 0) {
            HTMLNode peerStatsNoLoadStatsListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsNoLoadStatsListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_no_load_stats", StatisticsToadlet.l10nDark("noLoadStats"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("noLoadStatsShort"));
            peerStatsNoLoadStatsListItem.addChild("span", ":\u00a0" + numberOfNoLoadStats);
        }
        if ((om = node.getOpennet()) != null) {
            peerStatsList.addChild("li", StatisticsToadlet.l10n("maxTotalPeers") + ": " + om.getNumberOfConnectedPeersToAimIncludingDarknet());
            peerStatsList.addChild("li", StatisticsToadlet.l10n("maxOpennetPeers") + ": " + om.getNumberOfConnectedPeersToAim());
        }
    }

    private static String l10n(String key) {
        return NodeL10n.getBase().getString("StatisticsToadlet." + key);
    }

    private static String l10nDark(String key) {
        return NodeL10n.getBase().getString("DarknetConnectionsToadlet." + key);
    }

    private static String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("StatisticsToadlet." + key, new String[]{pattern}, new String[]{value});
    }

    private static String l10n(String key, String[] patterns, String[] values) {
        return NodeL10n.getBase().getString("StatisticsToadlet." + key, patterns, values);
    }

    private void drawActivityBox(HTMLNode activityInfobox, boolean advancedModeEnabled) {
        activityInfobox.addChild("div", "class", "infobox-header", StatisticsToadlet.l10nDark("activityTitle"));
        HTMLNode activityInfoboxContent = activityInfobox.addChild("div", "class", "infobox-content");
        HTMLNode activityList = StatisticsToadlet.drawActivity(activityInfoboxContent, this.node);
        int numARKFetchers = this.node.getNumARKFetchers();
        if (advancedModeEnabled && activityList != null) {
            if (numARKFetchers > 0) {
                activityList.addChild("li", "ARK\u00a0Fetch\u00a0Requests:\u00a0" + numARKFetchers);
            }
            activityList.addChild("li", "BackgroundFetcherByUSKSize:\u00a0" + this.node.getClientCore().getUskManager().getBackgroundFetcherByUSKSize());
            activityList.addChild("li", "temporaryBackgroundFetchersLRUSize:\u00a0" + this.node.getClientCore().getUskManager().getTemporaryBackgroundFetchersLRU());
            activityList.addChild("li", "outputBandwidthLiabilityUsage:\u00a0" + this.fix3p1pct.format(this.node.getNodeStats().getBandwidthLiabilityUsage()));
        }
    }

    static void drawBandwidth(HTMLNode activityList, Node node, long nodeUptimeSeconds, boolean isAdvancedModeEnabled) {
        long[] total = node.getCollector().getTotalIO();
        if (total[0] == 0L || total[1] == 0L) {
            return;
        }
        long total_output_rate = total[0] / nodeUptimeSeconds;
        long total_input_rate = total[1] / nodeUptimeSeconds;
        long totalPayload = node.getTotalPayloadSent();
        long total_payload_rate = totalPayload / nodeUptimeSeconds;
        if (node.getClientCore() == null) {
            throw new NullPointerException();
        }
        BandwidthStatsContainer stats = node.getClientCore().getBandwidthStatsPutter().getLatestBWData();
        if (stats == null) {
            throw new NullPointerException();
        }
        long overall_total_out = stats.totalBytesOut;
        long overall_total_in = stats.totalBytesIn;
        int percent = (int)(100L * totalPayload / total[0]);
        long[] rate = node.getNodeStats().getNodeIOStats();
        long delta = (rate[5] - rate[2]) / 1000L;
        if (delta > 0L) {
            long output_rate = (rate[3] - rate[0]) / delta;
            long input_rate = (rate[4] - rate[1]) / delta;
            SubConfig nodeConfig = node.getConfig().get("node");
            int outputBandwidthLimit = nodeConfig.getInt("outputBandwidthLimit");
            int inputBandwidthLimit = nodeConfig.getInt("inputBandwidthLimit");
            if (inputBandwidthLimit == -1) {
                inputBandwidthLimit = outputBandwidthLimit * 4;
            }
            activityList.addChild("li", StatisticsToadlet.l10n("inputRate", new String[]{"rate", "max"}, new String[]{SizeUtil.formatSize(input_rate, true), SizeUtil.formatSize(inputBandwidthLimit, true)}));
            activityList.addChild("li", StatisticsToadlet.l10n("outputRate", new String[]{"rate", "max"}, new String[]{SizeUtil.formatSize(output_rate, true), SizeUtil.formatSize(outputBandwidthLimit, true)}));
        }
        activityList.addChild("li", StatisticsToadlet.l10n("totalInputSession", new String[]{"total", "rate"}, new String[]{SizeUtil.formatSize(total[1], true), SizeUtil.formatSize(total_input_rate, true)}));
        activityList.addChild("li", StatisticsToadlet.l10n("totalOutputSession", new String[]{"total", "rate"}, new String[]{SizeUtil.formatSize(total[0], true), SizeUtil.formatSize(total_output_rate, true)}));
        activityList.addChild("li", StatisticsToadlet.l10n("payloadOutput", new String[]{"total", "rate", "percent"}, new String[]{SizeUtil.formatSize(totalPayload, true), SizeUtil.formatSize(total_payload_rate, true), Integer.toString(percent)}));
        activityList.addChild("li", StatisticsToadlet.l10n("totalInput", new String[]{"total"}, new String[]{SizeUtil.formatSize(overall_total_in, true)}));
        activityList.addChild("li", StatisticsToadlet.l10n("totalOutput", new String[]{"total"}, new String[]{SizeUtil.formatSize(overall_total_out, true)}));
        if (isAdvancedModeEnabled) {
            long totalBytesSentCHKRequests = node.getNodeStats().getCHKRequestTotalBytesSent();
            long totalBytesSentSSKRequests = node.getNodeStats().getSSKRequestTotalBytesSent();
            long totalBytesSentCHKInserts = node.getNodeStats().getCHKInsertTotalBytesSent();
            long totalBytesSentSSKInserts = node.getNodeStats().getSSKInsertTotalBytesSent();
            long totalBytesSentOfferedKeys = node.getNodeStats().getOfferedKeysTotalBytesSent();
            long totalBytesSendOffers = node.getNodeStats().getOffersSentBytesSent();
            long totalBytesSentSwapOutput = node.getNodeStats().getSwappingTotalBytesSent();
            long totalBytesSentAuth = node.getNodeStats().getTotalAuthBytesSent();
            long totalBytesSentAckOnly = node.getNodeStats().getNotificationOnlyPacketsSentBytes();
            long totalBytesSentResends = node.getNodeStats().getResendBytesSent();
            long totalBytesSentUOM = node.getNodeStats().getUOMBytesSent();
            long totalBytesSentAnnounce = node.getNodeStats().getAnnounceBytesSent();
            long totalBytesSentAnnouncePayload = node.getNodeStats().getAnnounceBytesPayloadSent();
            long totalBytesSentRoutingStatus = node.getNodeStats().getRoutingStatusBytes();
            long totalBytesSentNetworkColoring = node.getNodeStats().getNetworkColoringSentBytes();
            long totalBytesSentPing = node.getNodeStats().getPingSentBytes();
            long totalBytesSentProbeRequest = node.getNodeStats().getProbeRequestSentBytes();
            long totalBytesSentRouted = node.getNodeStats().getRoutedMessageSentBytes();
            long totalBytesSentDisconn = node.getNodeStats().getDisconnBytesSent();
            long totalBytesSentInitial = node.getNodeStats().getInitialMessagesBytesSent();
            long totalBytesSentChangedIP = node.getNodeStats().getChangedIPBytesSent();
            long totalBytesSentNodeToNode = node.getNodeStats().getNodeToNodeBytesSent();
            long totalBytesSentAllocationNotices = node.getNodeStats().getAllocationNoticesBytesSent();
            long totalBytesSentFOAF = node.getNodeStats().getFOAFBytesSent();
            long totalBytesSentRemaining = total[0] - (totalPayload + totalBytesSentCHKRequests + totalBytesSentSSKRequests + totalBytesSentCHKInserts + totalBytesSentSSKInserts + totalBytesSentOfferedKeys + totalBytesSendOffers + totalBytesSentSwapOutput + totalBytesSentAuth + totalBytesSentAckOnly + totalBytesSentResends + totalBytesSentUOM + totalBytesSentAnnounce + totalBytesSentRoutingStatus + totalBytesSentNetworkColoring + totalBytesSentPing + totalBytesSentProbeRequest + totalBytesSentRouted + totalBytesSentDisconn + totalBytesSentInitial + totalBytesSentChangedIP + totalBytesSentNodeToNode + totalBytesSentAllocationNotices + totalBytesSentFOAF);
            activityList.addChild("li", StatisticsToadlet.l10n("requestOutput", new String[]{"chk", "ssk"}, new String[]{SizeUtil.formatSize(totalBytesSentCHKRequests, true), SizeUtil.formatSize(totalBytesSentSSKRequests, true)}));
            activityList.addChild("li", StatisticsToadlet.l10n("insertOutput", new String[]{"chk", "ssk"}, new String[]{SizeUtil.formatSize(totalBytesSentCHKInserts, true), SizeUtil.formatSize(totalBytesSentSSKInserts, true)}));
            activityList.addChild("li", StatisticsToadlet.l10n("offeredKeyOutput", new String[]{"total", "offered"}, new String[]{SizeUtil.formatSize(totalBytesSentOfferedKeys, true), SizeUtil.formatSize(totalBytesSendOffers, true)}));
            activityList.addChild("li", StatisticsToadlet.l10n("swapOutput", "total", SizeUtil.formatSize(totalBytesSentSwapOutput, true)));
            activityList.addChild("li", StatisticsToadlet.l10n("authBytes", "total", SizeUtil.formatSize(totalBytesSentAuth, true)));
            activityList.addChild("li", StatisticsToadlet.l10n("ackOnlyBytes", "total", SizeUtil.formatSize(totalBytesSentAckOnly, true)));
            activityList.addChild("li", StatisticsToadlet.l10n("resendBytes", new String[]{"total", "percent"}, new String[]{SizeUtil.formatSize(totalBytesSentResends, true), Long.toString(100L * totalBytesSentResends / Math.max(1L, total[0]))}));
            activityList.addChild("li", StatisticsToadlet.l10n("uomBytes", "total", SizeUtil.formatSize(totalBytesSentUOM, true)));
            activityList.addChild("li", StatisticsToadlet.l10n("announceBytes", new String[]{"total", "payload"}, new String[]{SizeUtil.formatSize(totalBytesSentAnnounce, true), SizeUtil.formatSize(totalBytesSentAnnouncePayload, true)}));
            activityList.addChild("li", StatisticsToadlet.l10n("adminBytes", new String[]{"routingStatus", "disconn", "initial", "changedIP"}, new String[]{SizeUtil.formatSize(totalBytesSentRoutingStatus, true), SizeUtil.formatSize(totalBytesSentDisconn, true), SizeUtil.formatSize(totalBytesSentInitial, true), SizeUtil.formatSize(totalBytesSentChangedIP, true)}));
            activityList.addChild("li", StatisticsToadlet.l10n("debuggingBytes", new String[]{"netColoring", "ping", "probe", "routed"}, new String[]{SizeUtil.formatSize(totalBytesSentNetworkColoring, true), SizeUtil.formatSize(totalBytesSentPing, true), SizeUtil.formatSize(totalBytesSentProbeRequest, true), SizeUtil.formatSize(totalBytesSentRouted, true)}));
            activityList.addChild("li", StatisticsToadlet.l10n("nodeToNodeBytes", "total", SizeUtil.formatSize(totalBytesSentNodeToNode, true)));
            activityList.addChild("li", StatisticsToadlet.l10n("loadAllocationNoticesBytes", "total", SizeUtil.formatSize(totalBytesSentAllocationNotices, true)));
            activityList.addChild("li", StatisticsToadlet.l10n("foafBytes", "total", SizeUtil.formatSize(totalBytesSentFOAF, true)));
            activityList.addChild("li", StatisticsToadlet.l10n("unaccountedBytes", new String[]{"total", "percent"}, new String[]{SizeUtil.formatSize(totalBytesSentRemaining, true), Integer.toString((int)(totalBytesSentRemaining * 100L / total[0]))}));
            double sentOverheadPerSecond = node.getNodeStats().getSentOverheadPerSecond();
            activityList.addChild("li", StatisticsToadlet.l10n("totalOverhead", new String[]{"rate", "percent"}, new String[]{SizeUtil.formatSize((long)sentOverheadPerSecond), Integer.toString((int)(100.0 * sentOverheadPerSecond / (double)total_output_rate))}));
        }
    }

    static HTMLNode drawActivity(HTMLNode activityInfoboxContent, Node node) {
        RequestTracker tracker = node.getTracker();
        int numLocalCHKInserts = tracker.getNumLocalCHKInserts();
        int numRemoteCHKInserts = tracker.getNumRemoteCHKInserts();
        int numLocalSSKInserts = tracker.getNumLocalSSKInserts();
        int numRemoteSSKInserts = tracker.getNumRemoteSSKInserts();
        int numLocalCHKRequests = tracker.getNumLocalCHKRequests();
        int numRemoteCHKRequests = tracker.getNumRemoteCHKRequests();
        int numLocalSSKRequests = tracker.getNumLocalSSKRequests();
        int numRemoteSSKRequests = tracker.getNumRemoteSSKRequests();
        int numTransferringRequests = tracker.getNumTransferringRequestSenders();
        int numTransferringRequestHandlers = tracker.getNumTransferringRequestHandlers();
        int numCHKOfferReplys = tracker.getNumCHKOfferReplies();
        int numSSKOfferReplys = tracker.getNumSSKOfferReplies();
        int numCHKRequests = numLocalCHKRequests + numRemoteCHKRequests;
        int numSSKRequests = numLocalSSKRequests + numRemoteSSKRequests;
        int numCHKInserts = numLocalCHKInserts + numRemoteCHKInserts;
        int numSSKInserts = numLocalSSKInserts + numRemoteSSKInserts;
        if (numTransferringRequests == 0 && numCHKRequests == 0 && numSSKRequests == 0 && numCHKInserts == 0 && numSSKInserts == 0 && numTransferringRequestHandlers == 0 && numCHKOfferReplys == 0 && numSSKOfferReplys == 0) {
            activityInfoboxContent.addChild("#", StatisticsToadlet.l10n("noRequests"));
            return null;
        }
        HTMLNode activityList = activityInfoboxContent.addChild("ul");
        if (numCHKInserts > 0 || numSSKInserts > 0) {
            activityList.addChild("li", NodeL10n.getBase().getString("StatisticsToadlet.activityInserts", new String[]{"CHKhandlers", "SSKhandlers", "local"}, new String[]{Integer.toString(numCHKInserts), Integer.toString(numSSKInserts), Integer.toString(numLocalCHKInserts) + "/" + Integer.toString(numLocalSSKInserts)}));
        }
        if (numCHKRequests > 0 || numSSKRequests > 0) {
            activityList.addChild("li", NodeL10n.getBase().getString("StatisticsToadlet.activityRequests", new String[]{"CHKhandlers", "SSKhandlers", "local"}, new String[]{Integer.toString(numCHKRequests), Integer.toString(numSSKRequests), Integer.toString(numLocalCHKRequests) + "/" + Integer.toString(numLocalSSKRequests)}));
        }
        if (numTransferringRequests > 0 || numTransferringRequestHandlers > 0) {
            activityList.addChild("li", NodeL10n.getBase().getString("StatisticsToadlet.transferringRequests", new String[]{"senders", "receivers", "turtles"}, new String[]{Integer.toString(numTransferringRequests), Integer.toString(numTransferringRequestHandlers), "0"}));
        }
        if (numCHKOfferReplys > 0 || numSSKOfferReplys > 0) {
            activityList.addChild("li", NodeL10n.getBase().getString("StatisticsToadlet.offerReplys", new String[]{"chk", "ssk"}, new String[]{Integer.toString(numCHKOfferReplys), Integer.toString(numSSKOfferReplys)}));
        }
        activityList.addChild("li", NodeL10n.getBase().getString("StatisticsToadlet.runningBlockTransfers", new String[]{"sends", "receives"}, new String[]{Integer.toString(BlockTransmitter.getRunningSends()), Integer.toString(BlockReceiver.getRunningReceives())}));
        return activityList;
    }

    private void drawOverviewBox(HTMLNode overviewInfobox, long nodeUptimeSeconds, long nodeUptimeTotal, long now, double swaps, double noSwaps) {
        overviewInfobox.addChild("div", "class", "infobox-header", "Node status overview");
        HTMLNode overviewInfoboxContent = overviewInfobox.addChild("div", "class", "infobox-content");
        HTMLNode overviewList = overviewInfoboxContent.addChild("ul");
        int bwlimitDelayTime = (int)this.stats.getBwlimitDelayTime();
        int bwlimitDelayTimeBulk = (int)this.stats.getBwlimitDelayTimeBulk();
        int bwlimitDelayTimeRT = (int)this.stats.getBwlimitDelayTimeRT();
        int nodeAveragePingTime = (int)this.stats.getNodeAveragePingTime();
        double numberOfRemotePeerLocationsSeenInSwaps = this.node.getNumberOfRemotePeerLocationsSeenInSwaps();
        int darknetSizeEstimateSession = this.stats.getDarknetSizeEstimate(-1L);
        int darknetSizeEstimate24h = 0;
        int darknetSizeEstimate48h = 0;
        if (nodeUptimeSeconds > TimeUnit.HOURS.toSeconds(24L)) {
            darknetSizeEstimate24h = this.stats.getDarknetSizeEstimate(now - TimeUnit.HOURS.toMillis(24L));
        }
        if (nodeUptimeSeconds > TimeUnit.HOURS.toSeconds(48L)) {
            darknetSizeEstimate48h = this.stats.getDarknetSizeEstimate(now - TimeUnit.HOURS.toMillis(48L));
        }
        int opennetSizeEstimateSession = this.stats.getOpennetSizeEstimate(-1L);
        int opennetSizeEstimate24h = 0;
        int opennetSizeEstimate48h = 0;
        if (nodeUptimeSeconds > TimeUnit.HOURS.toSeconds(24L)) {
            opennetSizeEstimate24h = this.stats.getOpennetSizeEstimate(now - TimeUnit.HOURS.toMillis(24L));
        }
        if (nodeUptimeSeconds > TimeUnit.HOURS.toSeconds(48L)) {
            opennetSizeEstimate48h = this.stats.getOpennetSizeEstimate(now - TimeUnit.HOURS.toMillis(48L));
        }
        double routingMissDistanceLocal = this.stats.routingMissDistanceLocal.currentValue();
        double routingMissDistanceRemote = this.stats.routingMissDistanceRemote.currentValue();
        double routingMissDistanceOverall = this.stats.routingMissDistanceOverall.currentValue();
        double routingMissDistanceBulk = this.stats.routingMissDistanceBulk.currentValue();
        double routingMissDistanceRT = this.stats.routingMissDistanceRT.currentValue();
        double backedOffPercent = this.stats.backedOffPercent.currentValue();
        overviewList.addChild("li", "bwlimitDelayTime:\u00a0" + bwlimitDelayTime + "ms");
        overviewList.addChild("li", "bwlimitDelayTimeBulk:\u00a0" + bwlimitDelayTimeBulk + "ms");
        overviewList.addChild("li", "bwlimitDelayTimeRT:\u00a0" + bwlimitDelayTimeRT + "ms");
        overviewList.addChild("li", "nodeAveragePingTime:\u00a0" + nodeAveragePingTime + "ms");
        overviewList.addChild("li", "darknetSizeEstimateSession:\u00a0" + darknetSizeEstimateSession + "\u00a0nodes");
        if (nodeUptimeSeconds > TimeUnit.DAYS.toSeconds(1L)) {
            overviewList.addChild("li", "darknetSizeEstimate24h:\u00a0" + darknetSizeEstimate24h + "\u00a0nodes");
        }
        if (nodeUptimeSeconds > TimeUnit.DAYS.toSeconds(2L)) {
            overviewList.addChild("li", "darknetSizeEstimate48h:\u00a0" + darknetSizeEstimate48h + "\u00a0nodes");
        }
        overviewList.addChild("li", "opennetSizeEstimateSession:\u00a0" + opennetSizeEstimateSession + "\u00a0nodes");
        if (nodeUptimeSeconds > TimeUnit.DAYS.toSeconds(1L)) {
            overviewList.addChild("li", "opennetSizeEstimate24h:\u00a0" + opennetSizeEstimate24h + "\u00a0nodes");
        }
        if (nodeUptimeSeconds > TimeUnit.DAYS.toSeconds(2L)) {
            overviewList.addChild("li", "opennetSizeEstimate48h:\u00a0" + opennetSizeEstimate48h + "\u00a0nodes");
        }
        if (numberOfRemotePeerLocationsSeenInSwaps > 0.0 && (swaps > 0.0 || noSwaps > 0.0)) {
            overviewList.addChild("li", "avrConnPeersPerNode:\u00a0" + this.fix6p6.format(numberOfRemotePeerLocationsSeenInSwaps / (swaps + noSwaps)) + "\u00a0peers");
        }
        overviewList.addChild("li", "nodeUptimeSession:\u00a0" + TimeUtil.formatTime(TimeUnit.MILLISECONDS.convert(nodeUptimeSeconds, TimeUnit.SECONDS)));
        overviewList.addChild("li", "nodeUptimeTotal:\u00a0" + TimeUtil.formatTime(nodeUptimeTotal));
        overviewList.addChild("li", "routingMissDistanceLocal:\u00a0" + this.fix1p4.format(routingMissDistanceLocal));
        overviewList.addChild("li", "routingMissDistanceRemote:\u00a0" + this.fix1p4.format(routingMissDistanceRemote));
        overviewList.addChild("li", "routingMissDistanceOverall:\u00a0" + this.fix1p4.format(routingMissDistanceOverall));
        overviewList.addChild("li", "routingMissDistanceBulk:\u00a0" + this.fix1p4.format(routingMissDistanceBulk));
        overviewList.addChild("li", "routingMissDistanceRT:\u00a0" + this.fix1p4.format(routingMissDistanceRT));
        overviewList.addChild("li", "backedOffPercent:\u00a0" + this.fix3p1pct.format(backedOffPercent));
        overviewList.addChild("li", "pInstantReject:\u00a0" + this.fix3p1pct.format(this.stats.pRejectIncomingInstantly()));
        overviewList.addChild("li", "pInstantRejectRequestBulk:\u00a0" + this.fix3p1pct.format(this.stats.pRejectIncomingInstantlyCHKRequestBulk()) + " (CHK) " + this.fix3p1pct.format(this.stats.pRejectIncomingInstantlySSKRequestBulk()) + " (SSK)");
        overviewList.addChild("li", "pInstantRejectInsertBulk:\u00a0" + this.fix3p1pct.format(this.stats.pRejectIncomingInstantlyCHKInsertBulk()) + " (CHK) " + this.fix3p1pct.format(this.stats.pRejectIncomingInstantlySSKInsertBulk()) + " (SSK)");
        overviewList.addChild("li", "pInstantRejectRequestRT:\u00a0" + this.fix3p1pct.format(this.stats.pRejectIncomingInstantlyCHKRequestRT()) + " (CHK) " + this.fix3p1pct.format(this.stats.pRejectIncomingInstantlySSKRequestRT()) + " (SSK)");
        overviewList.addChild("li", "pInstantRejectInsertRT:\u00a0" + this.fix3p1pct.format(this.stats.pRejectIncomingInstantlyCHKInsertRT()) + " (CHK) " + this.fix3p1pct.format(this.stats.pRejectIncomingInstantlySSKInsertRT()) + " (SSK)");
        overviewList.addChild("li", "unclaimedFIFOSize:\u00a0" + this.node.getUnclaimedFIFOSize());
        overviewList.addChild("li", "RAMBucketPoolSize:\u00a0" + SizeUtil.formatSize(this.core.getTempBucketFactory().getRamUsed()) + " / " + SizeUtil.formatSize(this.core.getTempBucketFactory().getMaxRamUsed()));
        overviewList.addChild("li", "uptimeAverage:\u00a0" + this.fix3p1pct.format(this.node.getUptimeEstimator().getUptime()));
        long[] decoded = IncomingPacketFilterImpl.getDecodedPackets();
        if (decoded != null) {
            overviewList.addChild("li", "packetsDecoded:\u00a0" + this.fix3p1pct.format((double)decoded[0] / (double)decoded[1]) + "\u00a0(" + decoded[1] + ")");
        }
    }

    private void drawBandwidthBox(HTMLNode bandwidthInfobox, long nodeUptimeSeconds, boolean isAdvancedModeEnabled) {
        bandwidthInfobox.addChild("div", "class", "infobox-header", StatisticsToadlet.l10n("bandwidthTitle"));
        HTMLNode bandwidthInfoboxContent = bandwidthInfobox.addChild("div", "class", "infobox-content");
        HTMLNode bandwidthList = bandwidthInfoboxContent.addChild("ul");
        StatisticsToadlet.drawBandwidth(bandwidthList, this.node, nodeUptimeSeconds, isAdvancedModeEnabled);
    }

    private void getThreadNames(HTMLNode threadUsageList) {
        Thread[] threads = this.stats.getThreads();
        LinkedHashMap<String, ThreadBunch> map = new LinkedHashMap<String, ThreadBunch>();
        int totalCount = 0;
        for (Thread thread : threads) {
            if (thread == null) break;
            String name = NativeThread.normalizeName(thread.getName());
            ThreadBunch bunch = (ThreadBunch)map.get(name);
            if (bunch != null) {
                ++bunch.count;
            } else {
                map.put(name, new ThreadBunch(name, 1));
            }
            ++totalCount;
        }
        ThreadBunch[] bunches = map.values().toArray(new ThreadBunch[map.size()]);
        Arrays.sort(bunches, new Comparator<ThreadBunch>(){

            @Override
            public int compare(ThreadBunch b0, ThreadBunch b1) {
                if (b0.count > b1.count) {
                    return -1;
                }
                if (b0.count < b1.count) {
                    return 1;
                }
                return b0.name.compareTo(b1.name);
            }
        });
        for (ThreadBunch bunch : bunches) {
            double thisThreadPercentOfTotal = (double)bunch.count / (double)totalCount;
            threadUsageList.addChild("li", "" + bunch.name + ":\u00a0" + Integer.toString(bunch.count) + "\u00a0(" + this.fix3p1pct.format(thisThreadPercentOfTotal) + ')');
        }
    }

    private int simpleHistogramDivisor(int[] a) {
        int max = 1;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] <= max) continue;
            max = a[i];
        }
        return max;
    }

    private int combinedHistogramDivisor(int[] a, int[] b) {
        int max = 1;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] + b[i] <= max) continue;
            max = a[i] + b[i];
        }
        return max;
    }

    private void addNodeCircle(HTMLNode circleTable, double myLocation) {
        int[] histogram = new int[10];
        for (int i = 0; i < 10; ++i) {
            histogram[i] = 0;
        }
        HTMLNode nodeCircleTableRow = circleTable.addChild("tr");
        HTMLNode nodeHistogramLegendTableRow = circleTable.addChild("tr");
        HTMLNode nodeHistogramGraphTableRow = circleTable.addChild("tr");
        HTMLNode nodeCircleTableCell = nodeCircleTableRow.addChild("td", new String[]{"class", "colspan"}, new String[]{"first", "10"});
        HTMLNode nodeCircleInfoboxContent = nodeCircleTableCell.addChild("div", new String[]{"style", "class"}, new String[]{"position: relative; height: 220px; width: 220px", "peercircle"});
        nodeCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.0, false, 1.0), "mark"}, "|");
        nodeCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.125, false, 1.0), "mark"}, "+");
        nodeCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.25, false, 1.0), "mark"}, "--");
        nodeCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.375, false, 1.0), "mark"}, "+");
        nodeCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.5, false, 1.0), "mark"}, "|");
        nodeCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.625, false, 1.0), "mark"}, "+");
        nodeCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.75, false, 1.0), "mark"}, "--");
        nodeCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.875, false, 1.0), "mark"}, "+");
        nodeCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{"position: absolute; top: 100px; left: 110px", "mark"}, "+");
        Object[] knownLocsCopy = this.stats.getKnownLocations(-1L);
        Double[] locations = (Double[])knownLocsCopy[0];
        Long[] timestamps = (Long[])knownLocsCopy[1];
        double strength = 1.0;
        long now = System.currentTimeMillis();
        long age = 1L;
        for (int i = 0; i < locations.length; ++i) {
            int histogramIndex;
            Double location = locations[i];
            Long locationTime = timestamps[i];
            age = now - locationTime;
            if (age > MAX_CIRCLE_AGE_THRESHOLD) {
                age = MAX_CIRCLE_AGE_THRESHOLD;
            }
            strength = 1.0 - (double)age / (double)MAX_CIRCLE_AGE_THRESHOLD;
            int n = histogramIndex = (int)Math.floor(location * 10.0);
            histogram[n] = histogram[n] + 1;
            nodeCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(location, false, strength), "connected"}, "x");
        }
        nodeCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(myLocation, true, 1.0), "me"}, "x");
        int histogramDiv = this.simpleHistogramDivisor(histogram);
        for (int i = 0; i < 10; ++i) {
            HTMLNode nodeHistogramLegendCell = nodeHistogramLegendTableRow.addChild("td");
            HTMLNode nodeHistogramGraphCell = nodeHistogramGraphTableRow.addChild("td", "style", "height: 100px;");
            nodeHistogramLegendCell.addChild("div", "class", "histogramLabel").addChild("#", this.fix1p1.format((double)i / 10.0));
            double histogramPercent = (double)histogram[i] / (double)histogramDiv;
            nodeHistogramGraphCell.addChild("%", "<div class=\"histogramConnected\" style=\"height: " + this.fix3pctUS.format(histogramPercent) + "; width: 100%;\">\u00a0</div>");
        }
    }

    private void addSpecialisation(HTMLNode table, double peerLocation, int[] incomingRequestLocation) {
        HTMLNode nodeHistogramLegendTableRow = table.addChild("tr");
        HTMLNode nodeHistogramGraphTableRow = table.addChild("tr");
        int myIndex = (int)(peerLocation * (double)incomingRequestLocation.length);
        int histogramDiv = this.simpleHistogramDivisor(incomingRequestLocation);
        for (int i = 0; i < incomingRequestLocation.length; ++i) {
            HTMLNode nodeHistogramLegendCell = nodeHistogramLegendTableRow.addChild("td");
            HTMLNode nodeHistogramGraphCell = nodeHistogramGraphTableRow.addChild("td", "style", "height: 100px;");
            HTMLNode nodeHistogramGraphCell2 = nodeHistogramLegendCell.addChild("div", "class", "histogramLabel");
            if (i == myIndex) {
                nodeHistogramGraphCell2 = nodeHistogramGraphCell2.addChild("span", "class", "me");
            }
            nodeHistogramGraphCell2.addChild("#", this.fix1p1.format((double)i / (double)incomingRequestLocation.length));
            nodeHistogramGraphCell.addChild("div", new String[]{"class", "style"}, new String[]{"histogramConnected", "height: " + this.fix3pctUS.format((double)incomingRequestLocation[i] / (double)histogramDiv) + "; width: 100%;"}, "\u00a0");
        }
    }

    private void addCombinedSpecialisation(HTMLNode table, double peerLocation, int[] locallyOriginatingRequests, int[] remotelyOriginatingRequests) {
        assert (locallyOriginatingRequests.length == remotelyOriginatingRequests.length);
        HTMLNode nodeHistogramLegendTableRow = table.addChild("tr");
        HTMLNode nodeHistogramGraphTableRow = table.addChild("tr");
        int myIndex = (int)(peerLocation * (double)locallyOriginatingRequests.length);
        int histogramDiv = this.combinedHistogramDivisor(locallyOriginatingRequests, remotelyOriginatingRequests);
        for (int i = 0; i < locallyOriginatingRequests.length; ++i) {
            HTMLNode nodeHistogramLegendCell = nodeHistogramLegendTableRow.addChild("td");
            HTMLNode nodeHistogramGraphCell = nodeHistogramGraphTableRow.addChild("td", "style", "height: 100px;");
            HTMLNode nodeHistogramGraphCell2 = nodeHistogramLegendCell.addChild("div", "class", "histogramLabel");
            if (i == myIndex) {
                nodeHistogramGraphCell2 = nodeHistogramGraphCell2.addChild("span", "class", "me");
            }
            nodeHistogramGraphCell2.addChild("#", this.fix1p1.format((double)i / (double)locallyOriginatingRequests.length));
            nodeHistogramGraphCell.addChild("div", new String[]{"class", "style"}, new String[]{"histogramConnected", "height: " + this.fix3pctUS.format((double)locallyOriginatingRequests[i] / (double)histogramDiv) + "; width: 100%;"}, "\u00a0");
            nodeHistogramGraphCell.addChild("div", new String[]{"class", "style"}, new String[]{"histogramDisconnected", "height: " + this.fix3pctUS.format((double)remotelyOriginatingRequests[i] / (double)histogramDiv) + "; width: 100%;"}, "\u00a0");
        }
    }

    private void addFOAFLinkLengthHistogram(HTMLNode circleTable, PeerNodeStatus[] peerNodeStatuses) {
        int[] peersLinkHistogram = new int[10];
        HTMLNode peerHistogramLegendTableRow = circleTable.addChild("tr");
        HTMLNode peerHistogramGraphTableRow = circleTable.addChild("tr");
        int peersLinkCount = 0;
        for (PeerNodeStatus pns : peerNodeStatuses) {
            double[] foafLocs;
            double peerLoc;
            if (!pns.isSearchable() || !pns.isRoutable() || !Location.isValid(peerLoc = pns.getLocation()) || (foafLocs = pns.getPeersLocation()) == null) continue;
            for (double foafLoc : foafLocs) {
                int idx;
                if (!Location.isValid(foafLoc)) continue;
                int n = idx = (int)Math.floor(Location.distance(peerLoc, foafLoc) * 10.0 / 0.5);
                peersLinkHistogram[n] = peersLinkHistogram[n] + 1;
                ++peersLinkCount;
            }
        }
        double cumulativeFraction = 0.0;
        for (int i = 0; i < 10; ++i) {
            HTMLNode peerHistogramLegendCell = peerHistogramLegendTableRow.addChild("td");
            HTMLNode peerHistogramGraphCell = peerHistogramGraphTableRow.addChild("td", "style", "height: 100px;");
            peerHistogramLegendCell.addChild("div", "class", "histogramLabel").addChild("#", this.fix1p2.format((double)i / 10.0 * 0.5));
            if (peersLinkCount == 0) continue;
            double histogramFraction = (double)peersLinkHistogram[i] / (double)peersLinkCount;
            peerHistogramGraphCell.addChild("div", new String[]{"class", "style"}, new String[]{"histogramConnected", "height: " + this.fix3pctUS.format(histogramFraction) + "; width: 100%;"}, "\u00a0");
            peerHistogramGraphCell.addChild("div", new String[]{"class", "style"}, new String[]{"histogramDisconnected", "height: " + this.fix3pctUS.format(cumulativeFraction) + "; width: 100%;"}, "\u00a0");
            cumulativeFraction += histogramFraction;
        }
    }

    private void addPeerCircle(HTMLNode circleTable, PeerNodeStatus[] peerNodeStatuses, double myLocation) {
        int[] histogramConnected = new int[10];
        int[] histogramDisconnected = new int[10];
        for (int i = 0; i < 10; ++i) {
            histogramConnected[i] = 0;
            histogramDisconnected[i] = 0;
        }
        HTMLNode peerCircleTableRow = circleTable.addChild("tr");
        HTMLNode peerHistogramLegendTableRow = circleTable.addChild("tr");
        HTMLNode peerHistogramGraphTableRow = circleTable.addChild("tr");
        HTMLNode peerCircleTableCell = peerCircleTableRow.addChild("td", new String[]{"class", "colspan"}, new String[]{"first", "10"});
        HTMLNode peerCircleInfoboxContent = peerCircleTableCell.addChild("div", new String[]{"style", "class"}, new String[]{"position: relative; height: 220px; width: 220px", "peercircle"});
        peerCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.0, false, 1.0), "mark"}, "|");
        peerCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.125, false, 1.0), "mark"}, "+");
        peerCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.25, false, 1.0), "mark"}, "--");
        peerCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.375, false, 1.0), "mark"}, "+");
        peerCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.5, false, 1.0), "mark"}, "|");
        peerCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.625, false, 1.0), "mark"}, "+");
        peerCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.75, false, 1.0), "mark"}, "--");
        peerCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.875, false, 1.0), "mark"}, "+");
        peerCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{"position: absolute; top: 100px; left: 110px", "mark"}, "+");
        for (PeerNodeStatus peerNodeStatus : peerNodeStatuses) {
            double peerLocation = peerNodeStatus.getLocation();
            if (!peerNodeStatus.isSearchable() || !Location.isValid(peerLocation)) continue;
            double[] foafLocations = peerNodeStatus.getPeersLocation();
            if (foafLocations != null && peerNodeStatus.isRoutable()) {
                for (double foafLocation : foafLocations) {
                    peerCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(foafLocation, false, 0.9), "disconnected"}, ".");
                }
            }
            int histogramIndex = (int)(peerLocation * 10.0);
            histogramIndex %= 10;
            if (peerNodeStatus.isConnected()) {
                int n = histogramIndex;
                histogramConnected[n] = histogramConnected[n] + 1;
            } else {
                int n = histogramIndex;
                histogramDisconnected[n] = histogramDisconnected[n] + 1;
            }
            peerCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(peerLocation, false, 1.0 - peerNodeStatus.getPReject()), peerNodeStatus.isConnected() ? "connected" : "disconnected"}, peerNodeStatus.isOpennet() ? "o" : "x");
        }
        peerCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(myLocation, true, 1.0), "me"}, "x");
        int histogramDiv = this.combinedHistogramDivisor(histogramConnected, histogramDisconnected);
        for (int i = 0; i < 10; ++i) {
            HTMLNode peerHistogramLegendCell = peerHistogramLegendTableRow.addChild("td");
            HTMLNode peerHistogramGraphCell = peerHistogramGraphTableRow.addChild("td", "style", "height: 100px;");
            peerHistogramLegendCell.addChild("div", "class", "histogramLabel").addChild("#", this.fix1p1.format((double)i / 10.0));
            double histogramPercent = (double)histogramConnected[i] / (double)histogramDiv;
            peerHistogramGraphCell.addChild("div", new String[]{"class", "style"}, new String[]{"histogramConnected", "height: " + this.fix3pctUS.format(histogramPercent) + "; width: 100%;"}, "\u00a0");
            histogramPercent = (double)histogramDisconnected[i] / (double)histogramDiv;
            peerHistogramGraphCell.addChild("div", new String[]{"class", "style"}, new String[]{"histogramDisconnected", "height: " + this.fix3pctUS.format(histogramPercent) + "; width: 100%;"}, "\u00a0");
        }
    }

    private String generatePeerCircleStyleString(double peerLocation, boolean offsetMe, double strength) {
        int offset = 0;
        offset = offsetMe ? -10 : (int)(60.0 * (1.0 - strength));
        double x = 110.0 + Math.sin(peerLocation *= Math.PI * 2) * (double)(100 - offset);
        double y = 100.0 - Math.cos(peerLocation) * (double)(100 - offset);
        return "position: absolute; top: " + this.fix3p1US.format(y) + "px; left: " + this.fix3p1US.format(x) + "px";
    }

    @Override
    public String path() {
        return "/stats/";
    }

    private static class ThreadBunch {
        String name;
        int count;

        public ThreadBunch(String name2, int i) {
            this.name = name2;
            this.count = i;
        }
    }

    private static class STMessageCount {
        public String messageName;
        public int messageCount;

        STMessageCount(String messageName, int messageCount) {
            this.messageName = messageName;
            this.messageCount = messageCount;
        }
    }
}

