/*
 * Decompiled with CFR 0.152.
 */
package freenet.io.comm;

import freenet.support.Logger;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class IOStatisticCollector {
    public static final int STATISTICS_ENTRIES = 10;
    public static final int STATISTICS_DURATION_S = 30;
    public static final int STATISTICS_DURATION = 30000;
    private long lastrotate;
    private static boolean logDEBUG;
    private long totalbytesin;
    private long totalbytesout;
    private final LinkedHashMap<String, StatisticEntry> targets = new LinkedHashMap();
    static boolean ENABLE_PER_ADDRESS_TRACKING;

    public IOStatisticCollector() {
        logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInfo(InetAddress addr, int port, int inbytes, int outbytes, boolean isLocal) {
        try {
            IOStatisticCollector iOStatisticCollector = this;
            synchronized (iOStatisticCollector) {
                this._addInfo(addr, port, inbytes, outbytes, isLocal);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addInfo(InetAddress addr, int port, int inbytes, int outbytes, boolean isLocal) {
        this.rotate();
        if (ENABLE_PER_ADDRESS_TRACKING) {
            String key = addr + ":" + port;
            StatisticEntry entry = this.targets.get(key);
            if (entry == null) {
                entry = new StatisticEntry();
                this.targets.put(key, entry);
            }
            entry.addData(Math.max(inbytes, 0), Math.max(outbytes, 0));
        }
        if (!isLocal) {
            IOStatisticCollector iOStatisticCollector = this;
            synchronized (iOStatisticCollector) {
                this.totalbytesout += (long)Math.max(outbytes, 0);
                this.totalbytesin += (long)Math.max(inbytes, 0);
                if (logDEBUG) {
                    Logger.debug(IOStatisticCollector.class, "Add(" + addr + ":" + port + ',' + inbytes + ',' + outbytes + " -> " + this.totalbytesin + " : " + this.totalbytesout);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpInfo() {
        IOStatisticCollector iOStatisticCollector = this;
        synchronized (iOStatisticCollector) {
            this._dumpInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getTotalIO() {
        IOStatisticCollector iOStatisticCollector = this;
        synchronized (iOStatisticCollector) {
            return this._getTotalIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] _getTotalIO() {
        long[] ret = new long[2];
        IOStatisticCollector iOStatisticCollector = this;
        synchronized (iOStatisticCollector) {
            ret[0] = this.totalbytesout;
            ret[1] = this.totalbytesin;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[][] getTotalStatistics() {
        IOStatisticCollector iOStatisticCollector = this;
        synchronized (iOStatisticCollector) {
            return this._getTotalStatistics();
        }
    }

    private int[][] _getTotalStatistics() {
        int[][] ret = new int[10][2];
        for (int i = 0; i < 10; ++i) {
            ret[i][1] = 0;
            ret[i][0] = 0;
        }
        for (Map.Entry<String, StatisticEntry> entry : this.targets.entrySet()) {
            int[] inres = entry.getValue().getRecieved();
            int[] outres = entry.getValue().getSent();
            for (int i = 0; i < 10; ++i) {
                int[] nArray = ret[i];
                nArray[1] = nArray[1] + inres[i];
                int[] nArray2 = ret[i];
                nArray2[0] = nArray2[0] + outres[i];
            }
        }
        return ret;
    }

    private void _dumpInfo() {
        this.rotate();
        System.err.println(new Date());
        double divby = 30720.0;
        for (Map.Entry<String, StatisticEntry> entry : this.targets.entrySet()) {
            String key = entry.getKey();
            int[] inres = entry.getValue().getRecieved();
            int[] outres = entry.getValue().getSent();
            System.err.print((key + "          ").substring(0, 22) + ": ");
            int tin = 0;
            int tout = 0;
            for (int i = 0; i < inres.length; ++i) {
                int in = (int)((double)(tin += inres[i]) * 10.0 / (30720.0 * (double)(i + 1)));
                int out = (int)((double)(tout += outres[i]) * 10.0 / (30720.0 * (double)(i + 1)));
                System.err.print("i:" + in / 10 + '.' + in % 10);
                System.err.print(" o:" + out / 10 + '.' + out % 10);
                System.err.print(" \t");
            }
            System.err.println();
        }
        System.err.println();
    }

    private void rotate() {
        long now = System.currentTimeMillis();
        if (now - this.lastrotate >= 30000L) {
            this.lastrotate = now;
            Object[] keys = this.targets.keySet().toArray();
            if (keys == null) {
                return;
            }
            for (int i = 0; i < keys.length; ++i) {
                Object key = keys[i];
                if (this.targets.get(key).rotate()) continue;
                this.targets.remove(key);
            }
        }
    }

    static {
        ENABLE_PER_ADDRESS_TRACKING = false;
    }

    private static class StatisticEntry {
        private int[] recieved = new int[11];
        private int[] sent = new int[11];

        public StatisticEntry() {
            for (int i = 0; i < this.recieved.length; ++i) {
                this.sent[i] = 0;
                this.recieved[i] = 0;
            }
        }

        public void addData(int inbytes, int outbytes) {
            this.recieved[0] = this.recieved[0] + inbytes;
            this.sent[0] = this.sent[0] + outbytes;
        }

        public boolean rotate() {
            boolean hasdata = false;
            for (int i = this.recieved.length - 1; i > 0; --i) {
                this.recieved[i] = this.recieved[i - 1];
                this.sent[i] = this.sent[i - 1];
                hasdata |= this.recieved[i] > 0 || this.sent[i] > 0;
            }
            this.sent[0] = 0;
            this.recieved[0] = 0;
            return hasdata;
        }

        public int[] getRecieved() {
            return Arrays.copyOfRange(this.recieved, 1, 11);
        }

        public int[] getSent() {
            return Arrays.copyOfRange(this.sent, 1, 11);
        }
    }
}

