/*
 * Decompiled with CFR 0.152.
 */
package freenet.keys;

import freenet.client.InsertException;
import freenet.keys.ClientCHK;
import freenet.keys.ClientSSK;
import freenet.keys.InsertableClientSSK;
import freenet.support.Base64;
import freenet.support.Fields;
import freenet.support.HexUtil;
import freenet.support.IllegalBase64Exception;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.URLDecoder;
import freenet.support.URLEncodedFormatException;
import freenet.support.URLEncoder;
import freenet.support.io.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FreenetURI
implements Cloneable,
Comparable<FreenetURI>,
Serializable {
    private static final transient long serialVersionUID = 1L;
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private final String keyType;
    private final String docName;
    private final String[] metaStr;
    private final byte[] routingKey;
    private final byte[] cryptoKey;
    private final byte[] extra;
    private final long suggestedEdition;
    private boolean hasHashCode;
    private int hashCode;
    static final String[] VALID_KEY_TYPES;
    boolean noCacheURI;
    public static final FreenetURI EMPTY_CHK_URI;
    protected static final Pattern URI_PREFIX;
    protected String toStringCache;
    static final byte CHK = 1;
    static final byte SSK = 2;
    static final byte KSK = 3;
    static final byte USK = 4;
    private static final Pattern docNameWithEditionPattern;
    public static final Comparator<FreenetURI> FAST_COMPARATOR;

    public synchronized int hashCode() {
        if (this.hasHashCode) {
            return this.hashCode;
        }
        int x = this.keyType.hashCode();
        if (this.docName != null) {
            x ^= this.docName.hashCode();
        }
        if (this.metaStr != null) {
            for (int i = 0; i < this.metaStr.length; ++i) {
                x ^= this.metaStr[i].hashCode();
            }
        }
        if (this.routingKey != null) {
            x ^= Fields.hashCode(this.routingKey);
        }
        if (this.cryptoKey != null) {
            x ^= Fields.hashCode(this.cryptoKey);
        }
        if (this.extra != null) {
            x ^= Fields.hashCode(this.extra);
        }
        if (this.keyType.equals("USK")) {
            x = (int)((long)x ^ this.suggestedEdition);
        }
        this.hashCode = x;
        this.hasHashCode = true;
        return x;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FreenetURI)) {
            return false;
        }
        FreenetURI f = (FreenetURI)o;
        if (!this.keyType.equals(f.keyType)) {
            return false;
        }
        if (this.keyType.equals("USK") && this.suggestedEdition != f.suggestedEdition) {
            return false;
        }
        if (this.docName == null ^ f.docName == null) {
            return false;
        }
        if ((this.metaStr == null || this.metaStr.length == 0) ^ (f.metaStr == null || f.metaStr.length == 0)) {
            return false;
        }
        if (this.routingKey == null ^ f.routingKey == null) {
            return false;
        }
        if (this.cryptoKey == null ^ f.cryptoKey == null) {
            return false;
        }
        if (this.extra == null ^ f.extra == null) {
            return false;
        }
        if (this.docName != null && !this.docName.equals(f.docName)) {
            return false;
        }
        if (this.metaStr != null && !Arrays.equals(this.metaStr, f.metaStr)) {
            return false;
        }
        if (this.routingKey != null && !Arrays.equals(this.routingKey, f.routingKey)) {
            return false;
        }
        if (this.cryptoKey != null && !Arrays.equals(this.cryptoKey, f.cryptoKey)) {
            return false;
        }
        return this.extra == null || Arrays.equals(this.extra, f.extra);
    }

    public boolean equalsKeypair(FreenetURI u2) {
        if (this.routingKey != null && this.cryptoKey != null) {
            return Arrays.equals(this.routingKey, u2.routingKey) && Arrays.equals(this.cryptoKey, u2.cryptoKey);
        }
        return false;
    }

    public final FreenetURI clone() {
        return new FreenetURI(this);
    }

    public FreenetURI(FreenetURI uri) {
        this.noCacheURI = false;
        if (uri.keyType == null) {
            throw new NullPointerException();
        }
        this.keyType = uri.keyType;
        this.docName = uri.docName;
        this.metaStr = uri.metaStr != null ? (String[])uri.metaStr.clone() : null;
        this.routingKey = (byte[])(uri.routingKey != null ? (byte[])uri.routingKey.clone() : null);
        this.cryptoKey = (byte[])(uri.cryptoKey != null ? (byte[])uri.cryptoKey.clone() : null);
        this.extra = (byte[])(uri.extra != null ? (byte[])uri.extra.clone() : null);
        this.suggestedEdition = uri.suggestedEdition;
        if (logDEBUG) {
            Logger.debug(this, "Copied: " + this.toString() + " from " + uri.toString(), (Throwable)new Exception("debug"));
        }
    }

    public FreenetURI intern() {
        String dn;
        boolean changedAnything = false;
        byte[] x = this.extra;
        x = this.keyType.equals("CHK") ? ClientCHK.internExtra(x) : ClientSSK.internExtra(x);
        if (x != this.extra) {
            changedAnything = true;
        }
        String[] newMetaStr = null;
        if (this.metaStr != null) {
            newMetaStr = new String[this.metaStr.length];
            for (int i = 0; i < this.metaStr.length; ++i) {
                newMetaStr[i] = this.metaStr[i].intern();
                if (this.metaStr[i] == newMetaStr[i]) continue;
                changedAnything = true;
            }
        }
        String string = dn = this.docName == null ? null : this.docName.intern();
        if (dn != this.docName) {
            changedAnything = true;
        }
        if (!changedAnything) {
            this.noCacheURI = true;
            return this;
        }
        FreenetURI u = new FreenetURI(this.keyType, dn, newMetaStr, this.routingKey, this.cryptoKey, this.extra, this.suggestedEdition);
        u.noCacheURI = true;
        return u;
    }

    public FreenetURI(String keyType, String docName) {
        this(keyType, docName, null, null, null, null);
    }

    public FreenetURI(String keyType, String docName, byte[] routingKey, byte[] cryptoKey, byte[] extra2) {
        this(keyType, docName, null, routingKey, cryptoKey, extra2);
    }

    public FreenetURI(String keyType, String docName, String metaStr, byte[] routingKey, byte[] cryptoKey) {
        String[] stringArray;
        if (metaStr == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = metaStr;
        }
        this(keyType, docName, stringArray, routingKey, cryptoKey, null);
    }

    public FreenetURI(String keyType, String docName, String[] metaStr, byte[] routingKey, byte[] cryptoKey, byte[] extra2) {
        this.noCacheURI = false;
        this.keyType = keyType.trim().toUpperCase().intern();
        this.docName = docName;
        this.metaStr = metaStr;
        this.routingKey = routingKey;
        if (routingKey != null && keyType.equals("CHK") && routingKey.length != 32) {
            throw new IllegalArgumentException("Bad URI: Routing key should be 32 bytes");
        }
        this.cryptoKey = cryptoKey;
        if (cryptoKey != null && cryptoKey.length != 32) {
            throw new IllegalArgumentException("Bad URI: Crypto key should be 32 bytes");
        }
        this.extra = extra2;
        this.suggestedEdition = -1L;
        if (logDEBUG) {
            Logger.minor(this, "Created from components: " + this.toString(), (Throwable)new Exception("debug"));
        }
    }

    public FreenetURI(String keyType, String docName, String[] metaStr, byte[] routingKey, byte[] cryptoKey, byte[] extra2, long suggestedEdition) {
        this.noCacheURI = false;
        this.keyType = keyType.trim().toUpperCase().intern();
        this.docName = docName;
        this.metaStr = metaStr;
        this.routingKey = routingKey;
        if (routingKey != null && keyType.equals("CHK") && routingKey.length != 32) {
            throw new IllegalArgumentException("Bad URI: Routing key should be 32 bytes");
        }
        this.cryptoKey = cryptoKey;
        if (cryptoKey != null && cryptoKey.length != 32) {
            throw new IllegalArgumentException("Bad URI: Crypto key should be 32 bytes");
        }
        this.extra = extra2;
        this.suggestedEdition = suggestedEdition;
        if (logDEBUG) {
            Logger.minor(this, "Created from components (B): " + this.toString(), (Throwable)new Exception("debug"));
        }
    }

    public FreenetURI(String URI2) throws MalformedURLException {
        this(URI2, false);
    }

    public FreenetURI(String URI2, boolean noTrim) throws MalformedURLException {
        int idx;
        int slash2;
        int atchar;
        int x;
        this.noCacheURI = false;
        if (URI2 == null) {
            throw new MalformedURLException("No URI specified");
        }
        if (!noTrim) {
            URI2 = URI2.trim();
        }
        if ((x = URI2.indexOf(63)) > -1) {
            URI2 = URI2.substring(0, x);
        }
        if (URI2.indexOf(64) < 0 || URI2.indexOf(47) < 0) {
            try {
                URI2 = URLDecoder.decode(URI2, false);
            }
            catch (URLEncodedFormatException e) {
                throw new MalformedURLException("Invalid URI: no @ or /, or @ or / is escaped but there are invalid escapes");
            }
        }
        if ((atchar = (URI2 = URI_PREFIX.matcher(URI2).replaceFirst("")).indexOf(64)) == -1) {
            throw new MalformedURLException("There is no @ in that URI! (" + URI2 + ')');
        }
        String _keyType = URI2.substring(0, atchar).toUpperCase();
        URI2 = URI2.substring(atchar + 1);
        boolean validKeyType = false;
        for (int i = 0; i < VALID_KEY_TYPES.length; ++i) {
            if (!_keyType.equals(VALID_KEY_TYPES[i])) continue;
            validKeyType = true;
            _keyType = VALID_KEY_TYPES[i];
            break;
        }
        this.keyType = _keyType;
        if (!validKeyType) {
            throw new MalformedURLException("Invalid key type: " + this.keyType);
        }
        boolean isSSK = "SSK".equals(this.keyType);
        boolean isUSK = "USK".equals(this.keyType);
        boolean isKSK = "KSK".equals(this.keyType);
        ArrayList<String> sv = null;
        sv = new ArrayList<String>();
        if (isKSK) {
            URI2 = "/" + URI2;
        }
        while ((slash2 = URI2.lastIndexOf(47)) != -1) {
            String s;
            try {
                s = URLDecoder.decode(URI2.substring(slash2 + 1), true);
            }
            catch (URLEncodedFormatException e) {
                throw (MalformedURLException)new MalformedURLException(e.toString()).initCause(e);
            }
            if (s != null) {
                sv.add(s);
            }
            URI2 = URI2.substring(0, slash2);
        }
        if (sv.isEmpty() && (isUSK || isKSK)) {
            throw new MalformedURLException("No docname for " + this.keyType);
        }
        if ((isSSK || isUSK || isKSK) && !sv.isEmpty()) {
            this.docName = (String)sv.remove(sv.size() - 1);
            if (isUSK) {
                if (sv.isEmpty()) {
                    throw new MalformedURLException("No suggested edition number for USK");
                }
                try {
                    this.suggestedEdition = Long.parseLong((String)sv.remove(sv.size() - 1));
                }
                catch (NumberFormatException e) {
                    throw (MalformedURLException)new MalformedURLException("Invalid suggested edition: " + e).initCause(e);
                }
            } else {
                this.suggestedEdition = -1L;
            }
        } else {
            this.docName = null;
            this.suggestedEdition = -1L;
        }
        if (!sv.isEmpty()) {
            this.metaStr = new String[sv.size()];
            for (int i = 0; i < this.metaStr.length; ++i) {
                this.metaStr[i] = ((String)sv.get(this.metaStr.length - 1 - i)).intern();
                if (this.metaStr[i] != null) continue;
                throw new NullPointerException();
            }
        } else {
            this.metaStr = null;
        }
        if (isKSK) {
            this.cryptoKey = null;
            this.extra = null;
            this.routingKey = null;
            return;
        }
        if ("CHK".equals(this.keyType) && (idx = URI2.lastIndexOf(46)) != -1) {
            URI2 = URI2.substring(0, idx);
        }
        StringTokenizer st = new StringTokenizer(URI2, ",");
        try {
            if (st.hasMoreTokens()) {
                this.routingKey = Base64.decode(st.nextToken());
                if (this.routingKey.length != 32 && this.keyType.equals("CHK")) {
                    throw new MalformedURLException("Bad URI: Routing key should be 32 bytes long");
                }
            } else {
                if (isUSK || isSSK && this.docName != null) {
                    throw new MalformedURLException("Bad URI: Routing key missing");
                }
                this.extra = null;
                this.cryptoKey = null;
                this.routingKey = null;
                return;
            }
            if (!st.hasMoreTokens()) {
                this.extra = null;
                this.cryptoKey = null;
                return;
            }
            String t = st.nextToken();
            this.cryptoKey = Base64.decode(t);
            if (this.cryptoKey.length != 32) {
                throw new MalformedURLException("Bad URI: Routing key should be 32 bytes long");
            }
            if (!st.hasMoreTokens()) {
                this.extra = null;
                return;
            }
            this.extra = Base64.decode(st.nextToken());
        }
        catch (IllegalBase64Exception e) {
            throw new MalformedURLException("Invalid Base64 quantity: " + e);
        }
        if (logDEBUG) {
            Logger.debug(this, "Created from parse: " + this.toString() + " from " + URI2, (Throwable)new Exception("debug"));
        }
    }

    public FreenetURI(byte[] pubKeyHash, byte[] cryptoKey, byte[] extra, String siteName, long suggestedEdition2) {
        this.noCacheURI = false;
        this.keyType = "USK";
        this.routingKey = pubKeyHash;
        this.cryptoKey = cryptoKey;
        if (cryptoKey != null && cryptoKey.length != 32) {
            throw new IllegalArgumentException("Bad URI: Crypto key should be 32 bytes");
        }
        this.extra = extra;
        this.docName = siteName;
        this.suggestedEdition = suggestedEdition2;
        this.metaStr = null;
        if (logDEBUG) {
            Logger.minor(this, "Created from components (USK): " + this.toString(), (Throwable)new Exception("debug"));
        }
    }

    protected FreenetURI() {
        this.noCacheURI = false;
        this.metaStr = null;
        this.keyType = null;
        this.routingKey = null;
        this.cryptoKey = null;
        this.extra = null;
        this.docName = null;
        this.suggestedEdition = 0L;
    }

    public void decompose() {
        String r = this.routingKey == null ? "none" : HexUtil.bytesToHex(this.routingKey);
        String k = this.cryptoKey == null ? "none" : HexUtil.bytesToHex(this.cryptoKey);
        String e = this.extra == null ? "none" : HexUtil.bytesToHex(this.extra);
        System.out.println("FreenetURI" + this);
        System.out.println("Key type   : " + this.keyType);
        System.out.println("Routing key: " + r);
        System.out.println("Crypto key : " + k);
        System.out.println("Extra      : " + e);
        System.out.println("Doc name   : " + (this.docName == null ? "none" : this.docName));
        System.out.print("Meta strings: ");
        if (this.metaStr == null) {
            System.out.println("none");
        } else {
            System.out.println(Arrays.asList(this.metaStr).toString());
        }
    }

    public String getGuessableKey() {
        return this.getDocName();
    }

    public String getDocName() {
        return this.docName;
    }

    public String getMetaString() {
        return this.metaStr == null || this.metaStr.length == 0 ? null : this.metaStr[0];
    }

    public String lastMetaString() {
        return this.metaStr == null || this.metaStr.length == 0 ? null : this.metaStr[this.metaStr.length - 1];
    }

    public String[] getAllMetaStrings() {
        return this.metaStr;
    }

    public boolean hasMetaStrings() {
        return this.metaStr != null && this.metaStr.length != 0;
    }

    public byte[] getRoutingKey() {
        return this.routingKey;
    }

    public byte[] getCryptoKey() {
        return this.cryptoKey;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public FreenetURI popMetaString() {
        int metaStrLength;
        String[] newMetaStr = null;
        if (this.metaStr != null && (metaStrLength = this.metaStr.length) > 1) {
            newMetaStr = Arrays.copyOf(this.metaStr, this.metaStr.length - 1);
        }
        return this.setMetaString(newMetaStr);
    }

    public FreenetURI dropLastMetaStrings(int i) {
        String[] newMetaStr = null;
        if (this.metaStr != null && this.metaStr.length > i) {
            newMetaStr = Arrays.copyOf(this.metaStr, this.metaStr.length - i);
        }
        return this.setMetaString(newMetaStr);
    }

    public FreenetURI pushMetaString(String name) {
        String[] newMetaStr;
        if (name == null) {
            throw new NullPointerException();
        }
        if (this.metaStr == null) {
            newMetaStr = new String[]{name};
        } else {
            newMetaStr = Arrays.copyOf(this.metaStr, this.metaStr.length + 1);
            newMetaStr[this.metaStr.length] = name.intern();
        }
        return this.setMetaString(newMetaStr);
    }

    public FreenetURI addMetaStrings(String[] strs) {
        if (strs == null) {
            return this;
        }
        for (int i = 0; i < strs.length; ++i) {
            if (strs[i] != null) continue;
            throw new NullPointerException("element " + i + " of " + strs.length + " is null");
        }
        if (this.metaStr == null) {
            return this.setMetaString(strs);
        }
        String[] newMetaStr = Arrays.copyOf(this.metaStr, this.metaStr.length + strs.length);
        System.arraycopy(strs, 0, newMetaStr, this.metaStr.length, strs.length);
        return this.setMetaString(newMetaStr);
    }

    public FreenetURI addMetaStrings(List<String> metaStrings) {
        return this.addMetaStrings(metaStrings.toArray(new String[metaStrings.size()]));
    }

    public FreenetURI setDocName(String name) {
        return new FreenetURI(this.keyType, name, this.metaStr, this.routingKey, this.cryptoKey, this.extra, this.suggestedEdition);
    }

    public FreenetURI setMetaString(String[] newMetaStr) {
        return new FreenetURI(this.keyType, this.docName, newMetaStr, this.routingKey, this.cryptoKey, this.extra, this.suggestedEdition);
    }

    public String toString() {
        if (this.toStringCache == null) {
            this.toStringCache = this.toString(false, false);
        }
        return this.toStringCache;
    }

    @Deprecated
    public String toACIIString() {
        return this.toASCIIString();
    }

    public String toASCIIString() {
        return this.toString(true, true);
    }

    public String toString(boolean prefix, boolean pureAscii) {
        if (this.keyType == null) {
            if (logMINOR) {
                Logger.minor(this, "Not activated?? in toString(" + prefix + "," + pureAscii + ")");
            }
            return null;
        }
        StringBuilder b = prefix ? new StringBuilder("freenet:") : new StringBuilder();
        b.append(this.keyType).append('@');
        if (!"KSK".equals(this.keyType)) {
            if (this.routingKey != null) {
                b.append(Base64.encode(this.routingKey));
            }
            if (this.cryptoKey != null) {
                b.append(',').append(Base64.encode(this.cryptoKey));
            }
            if (this.extra != null) {
                b.append(',').append(Base64.encode(this.extra));
            }
            if (this.docName != null) {
                b.append('/');
            }
        }
        if (this.docName != null) {
            b.append(URLEncoder.encode(this.docName, "/", pureAscii));
        }
        if (this.keyType.equals("USK")) {
            b.append('/');
            b.append(this.suggestedEdition);
        }
        if (this.metaStr != null) {
            for (int i = 0; i < this.metaStr.length; ++i) {
                b.append('/').append(URLEncoder.encode(this.metaStr[i], "/", pureAscii));
            }
        }
        return b.toString();
    }

    public String toShortString() {
        StringBuilder b = new StringBuilder();
        b.append(this.keyType).append('@');
        if (!"KSK".equals(this.keyType)) {
            b.append("...");
            if (this.docName != null) {
                b.append('/');
            }
        }
        if (this.docName != null) {
            b.append(URLEncoder.encode(this.docName, "/", false, " "));
        }
        if (this.keyType.equals("USK")) {
            b.append('/');
            b.append(this.suggestedEdition);
        }
        if (this.metaStr != null) {
            for (int i = 0; i < this.metaStr.length; ++i) {
                b.append('/').append(URLEncoder.encode(this.metaStr[i], "/", false, " "));
            }
        }
        return b.toString();
    }

    public static void main(String[] args) throws Exception {
        new FreenetURI(args[0]).decompose();
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public ArrayList<String> listMetaStrings() {
        if (this.metaStr != null) {
            ArrayList<String> l = new ArrayList<String>(this.metaStr.length);
            for (int i = 0; i < this.metaStr.length; ++i) {
                l.add(this.metaStr[i]);
            }
            return l;
        }
        return new ArrayList<String>(0);
    }

    public static FreenetURI readFullBinaryKeyWithLength(DataInputStream dis) throws IOException {
        short len = dis.readShort();
        byte[] buf = new byte[len];
        dis.readFully(buf);
        if (logMINOR) {
            Logger.minor(FreenetURI.class, "Read " + len + " bytes for key");
        }
        return FreenetURI.fromFullBinaryKey(buf);
    }

    public static FreenetURI fromFullBinaryKey(byte[] buf) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(bais);
        return FreenetURI.readFullBinaryKey(dis);
    }

    public static FreenetURI readFullBinaryKey(DataInputStream dis) throws IOException {
        String keyType;
        byte type = dis.readByte();
        if (type == 1) {
            keyType = "CHK";
        } else if (type == 2) {
            keyType = "SSK";
        } else if (type == 3) {
            keyType = "KSK";
        } else {
            throw new MalformedURLException("Unrecognized type " + type);
        }
        byte[] routingKey = null;
        byte[] cryptoKey = null;
        byte[] extra = null;
        if (type == 1 || type == 2) {
            routingKey = new byte[32];
            dis.readFully(routingKey);
            cryptoKey = new byte[32];
            dis.readFully(cryptoKey);
            int extraLen = type == 1 ? 5 : 5;
            extra = new byte[extraLen];
            dis.readFully(extra);
        }
        String docName = null;
        if (type != 1) {
            docName = dis.readUTF();
        }
        int count = dis.readInt();
        String[] metaStrings = new String[count];
        for (int i = 0; i < metaStrings.length; ++i) {
            metaStrings[i] = dis.readUTF();
        }
        return new FreenetURI(keyType, docName, metaStrings, routingKey, cryptoKey, extra);
    }

    public static void writeFullBinaryKeyWithLength(FreenetURI uri, DataOutputStream dos) throws IOException {
        if (uri == null) {
            dos.writeShort(0);
        } else {
            uri.writeFullBinaryKeyWithLength(dos);
        }
    }

    public void writeFullBinaryKeyWithLength(DataOutputStream dos) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream ndos = new DataOutputStream(baos);
        this.writeFullBinaryKey(ndos);
        ndos.close();
        byte[] data = baos.toByteArray();
        if (data.length > Short.MAX_VALUE) {
            throw new MalformedURLException("Full key too long: " + data.length + " - " + this);
        }
        dos.writeShort((short)data.length);
        if (logMINOR) {
            Logger.minor(this, "Written " + data.length + " bytes");
        }
        dos.write(data);
    }

    private void writeFullBinaryKey(DataOutputStream dos) throws IOException {
        switch (this.keyType) {
            case "CHK": {
                dos.writeByte(1);
                break;
            }
            case "SSK": {
                dos.writeByte(2);
                break;
            }
            case "KSK": {
                dos.writeByte(3);
                break;
            }
            case "USK": {
                throw new MalformedURLException("Cannot write USKs as binary keys");
            }
            default: {
                throw new MalformedURLException("Cannot write key of type " + this.keyType + " - do not know how");
            }
        }
        if (!this.keyType.equals("KSK")) {
            if (this.routingKey.length != 32) {
                throw new MalformedURLException("Routing key must be of length 32");
            }
            dos.write(this.routingKey);
            if (this.cryptoKey.length != 32) {
                throw new MalformedURLException("Crypto key must be of length 32");
            }
            dos.write(this.cryptoKey);
            if (this.keyType.equals("CHK") && this.extra.length != 5) {
                throw new MalformedURLException("Wrong number of extra bytes for CHK");
            }
            if (this.keyType.equals("SSK") && this.extra.length != 5) {
                throw new MalformedURLException("Wrong number of extra bytes for SSK");
            }
            dos.write(this.extra);
        }
        if (!this.keyType.equals("CHK")) {
            dos.writeUTF(this.docName);
        }
        if (this.metaStr != null) {
            dos.writeInt(this.metaStr.length);
            for (int i = 0; i < this.metaStr.length; ++i) {
                dos.writeUTF(this.metaStr[i]);
            }
        } else {
            dos.writeInt(0);
        }
    }

    public long getSuggestedEdition() {
        if (this.keyType.equals("USK")) {
            return this.suggestedEdition;
        }
        throw new IllegalArgumentException("Not a USK requesting suggested edition");
    }

    public String getPreferredFilename() {
        if (logMINOR) {
            Logger.minor(this, "Getting preferred filename for " + this);
        }
        ArrayList<String> names = new ArrayList<String>();
        if (this.keyType != null && (this.keyType.equals("KSK") || this.keyType.equals("SSK") || this.keyType.equals("USK"))) {
            if (logMINOR) {
                Logger.minor(this, "Adding docName: " + this.docName);
            }
            if (this.docName != null) {
                names.add(this.docName);
                if (this.keyType.equals("USK")) {
                    names.add(Long.toString(this.suggestedEdition));
                }
            } else if (!this.keyType.equals("SSK")) {
                throw new IllegalStateException("No docName for key of type " + this.keyType);
            }
        }
        if (this.metaStr != null) {
            for (String s : this.metaStr) {
                if (s == null || s.isEmpty()) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "metaString \"" + s + "\": was null or empty");
                    continue;
                }
                if (logMINOR) {
                    Logger.minor(this, "Adding metaString \"" + s + "\"");
                }
                names.add(s);
            }
        }
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < names.size(); ++i) {
            String s = (String)names.get(i);
            if (logMINOR) {
                Logger.minor(this, "name " + i + " = " + s);
            }
            s = FileUtil.sanitize(s);
            if (logMINOR) {
                Logger.minor(this, "Sanitized name " + i + " = " + s);
            }
            if (s.length() <= 0) continue;
            if (out.length() > 0) {
                out.append('-');
            }
            out.append(s);
        }
        if (logMINOR) {
            Logger.minor(this, "out = " + out.toString());
        }
        if (out.length() == 0) {
            if (this.routingKey != null) {
                if (logMINOR) {
                    Logger.minor(this, "Returning base64 encoded routing key");
                }
                return Base64.encode(this.routingKey);
            }
            return "unknown";
        }
        assert (out.toString().equals(FileUtil.sanitize(out.toString()))) : "Not sanitized? \"" + out.toString() + "\" -> \"" + FileUtil.sanitize(out.toString()) + "\"";
        return out.toString();
    }

    public FreenetURI setSuggestedEdition(long newEdition) {
        return new FreenetURI(this.keyType, this.docName, this.metaStr, this.routingKey, this.cryptoKey, this.extra, newEdition);
    }

    public FreenetURI setKeyType(String newKeyType) {
        return new FreenetURI(newKeyType, this.docName, this.metaStr, this.routingKey, this.cryptoKey, this.extra, this.suggestedEdition);
    }

    public FreenetURI setRoutingKey(byte[] newRoutingKey) {
        return new FreenetURI(this.keyType, this.docName, this.metaStr, newRoutingKey, this.cryptoKey, this.extra, this.suggestedEdition);
    }

    public void checkInsertURI() throws InsertException {
        if (this.metaStr != null && this.metaStr.length > 0) {
            throw new InsertException(InsertException.InsertExceptionMode.META_STRINGS_NOT_SUPPORTED, this);
        }
    }

    public static void checkInsertURI(FreenetURI uri) throws InsertException {
        uri.checkInsertURI();
    }

    public URI toRelativeURI() throws URISyntaxException {
        return new URI('/' + this.toString(false, false));
    }

    public URI toURI(String basePath) throws URISyntaxException {
        return new URI(basePath + this.toString(false, false));
    }

    public boolean isSSK() {
        return "SSK".equals(this.keyType);
    }

    public boolean isUSK() {
        return "USK".equals(this.keyType);
    }

    public boolean isCHK() {
        return "CHK".equals(this.keyType);
    }

    public boolean isKSK() {
        return "KSK".equals(this.keyType);
    }

    public FreenetURI sskForUSK() {
        if (!this.keyType.equalsIgnoreCase("USK")) {
            throw new IllegalStateException();
        }
        long edition = Math.abs(this.suggestedEdition);
        if (edition == Long.MIN_VALUE) {
            edition = Long.MAX_VALUE;
        }
        return new FreenetURI("SSK", this.docName + "-" + edition, this.metaStr, this.routingKey, this.cryptoKey, this.extra, 0L);
    }

    public boolean isSSKForUSK() {
        return this.keyType.equalsIgnoreCase("SSK") && this.docName != null && docNameWithEditionPattern.matcher(this.docName).matches();
    }

    public FreenetURI uskForSSK() {
        if (!this.keyType.equalsIgnoreCase("SSK")) {
            throw new IllegalStateException();
        }
        Matcher matcher = docNameWithEditionPattern.matcher(this.docName);
        if (!matcher.matches()) {
            throw new IllegalStateException();
        }
        int offset = matcher.start(1) - 1;
        String siteName = this.docName.substring(0, offset);
        long edition = Long.parseLong(this.docName.substring(offset + 1, this.docName.length()));
        return new FreenetURI("USK", siteName, this.metaStr, this.routingKey, this.cryptoKey, this.extra, edition);
    }

    public long getEdition() {
        if (this.keyType.equalsIgnoreCase("USK")) {
            return this.suggestedEdition;
        }
        if (this.keyType.equalsIgnoreCase("SSK")) {
            if (this.docName == null) {
                throw new IllegalStateException();
            }
            Matcher matcher = docNameWithEditionPattern.matcher(this.docName);
            if (!matcher.matches()) {
                throw new IllegalStateException();
            }
            return Long.parseLong(this.docName.substring(matcher.start(1), this.docName.length()));
        }
        throw new IllegalStateException();
    }

    @Override
    public int compareTo(FreenetURI o) {
        if (this == o) {
            return 0;
        }
        int cmp = this.keyType.compareTo(o.keyType);
        if (cmp != 0) {
            return cmp;
        }
        if (this.routingKey != null && (cmp = Fields.compareBytes(this.routingKey, o.routingKey)) != 0) {
            return cmp;
        }
        if (this.cryptoKey != null && (cmp = Fields.compareBytes(this.cryptoKey, o.cryptoKey)) != 0) {
            return cmp;
        }
        if (this.docName == null && o.docName != null) {
            return -1;
        }
        if (this.docName != null && o.docName == null) {
            return 1;
        }
        if (this.docName != null && o.docName != null && (cmp = this.docName.compareTo(o.docName)) != 0) {
            return cmp;
        }
        if (this.extra != null && (cmp = Fields.compareBytes(this.extra, o.extra)) != 0) {
            return cmp;
        }
        if (this.metaStr != null && o.metaStr == null) {
            return 1;
        }
        if (this.metaStr == null && o.metaStr != null) {
            return -1;
        }
        if (this.metaStr != null && o.metaStr != null) {
            if (this.metaStr.length > o.metaStr.length) {
                return 1;
            }
            if (this.metaStr.length < o.metaStr.length) {
                return -1;
            }
            for (int i = 0; i < this.metaStr.length; ++i) {
                cmp = this.metaStr[i].compareTo(o.metaStr[i]);
                if (cmp == 0) continue;
                return cmp;
            }
        }
        if (this.suggestedEdition > o.suggestedEdition) {
            return 1;
        }
        if (this.suggestedEdition < o.suggestedEdition) {
            return -1;
        }
        return 0;
    }

    public FreenetURI deriveRequestURIFromInsertURI() throws MalformedURLException {
        FreenetURI originalURI = this;
        if (originalURI.isCHK()) {
            return originalURI;
        }
        if (originalURI.isSSK() || originalURI.isUSK()) {
            FreenetURI newURI = originalURI;
            if (originalURI.isUSK()) {
                newURI = newURI.sskForUSK();
            }
            InsertableClientSSK issk = InsertableClientSSK.create(newURI);
            newURI = issk.getURI();
            if (originalURI.isUSK()) {
                newURI = newURI.uskForSSK();
                newURI = newURI.setSuggestedEdition(originalURI.getSuggestedEdition());
            }
            return newURI;
        }
        if (originalURI.isKSK()) {
            return originalURI;
        }
        throw new IllegalArgumentException("Not implemented yet for this key type: " + this.getKeyType());
    }

    public static FreenetURI generateRandomCHK(Random rand) {
        byte[] rkey = new byte[32];
        rand.nextBytes(rkey);
        byte[] ckey = new byte[32];
        rand.nextBytes(ckey);
        byte[] extra = ClientCHK.getExtra((byte)3, (short)-1, false);
        return new FreenetURI("CHK", null, rkey, ckey, extra);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
        VALID_KEY_TYPES = new String[]{"CHK", "SSK", "KSK", "USK"};
        EMPTY_CHK_URI = new FreenetURI("CHK", null, null, null, null, null);
        URI_PREFIX = Pattern.compile("^(https?://[^/]+/+)?(((ext|web)\\+)?(freenet|hyphanet|hypha):)?");
        docNameWithEditionPattern = Pattern.compile(".*\\-([0-9]+)");
        FAST_COMPARATOR = new Comparator<FreenetURI>(){

            @Override
            public int compare(FreenetURI uri0, FreenetURI uri1) {
                int hash1;
                int hash0 = uri0.hashCode();
                if (hash0 > (hash1 = uri1.hashCode())) {
                    return 1;
                }
                if (hash1 > hash0) {
                    return -1;
                }
                return uri0.compareTo(uri1);
            }
        };
    }
}

