/*
 * Decompiled with CFR 0.152.
 */
package freenet.pluginmanager;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.fcp.ClientPut;
import freenet.clients.http.ConfigToadlet;
import freenet.clients.http.PageMaker;
import freenet.clients.http.QueueToadlet;
import freenet.clients.http.Toadlet;
import freenet.config.InvalidConfigValueException;
import freenet.config.NodeNeedRestartException;
import freenet.config.SubConfig;
import freenet.crypt.SHA256;
import freenet.keys.FreenetURI;
import freenet.l10n.BaseL10n;
import freenet.l10n.NodeL10n;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.RequestClient;
import freenet.node.RequestClientBuilder;
import freenet.node.useralerts.AbstractUserAlert;
import freenet.pluginmanager.FredPlugin;
import freenet.pluginmanager.FredPluginBandwidthIndicator;
import freenet.pluginmanager.FredPluginBaseL10n;
import freenet.pluginmanager.FredPluginFCP;
import freenet.pluginmanager.FredPluginFCPMessageHandler;
import freenet.pluginmanager.FredPluginHTTP;
import freenet.pluginmanager.FredPluginIPDetector;
import freenet.pluginmanager.FredPluginL10n;
import freenet.pluginmanager.FredPluginPortForward;
import freenet.pluginmanager.FredPluginRealVersioned;
import freenet.pluginmanager.FredPluginThemed;
import freenet.pluginmanager.NotFoundPluginHTTPException;
import freenet.pluginmanager.OfficialPlugins;
import freenet.pluginmanager.PluginAlreadyLoaded;
import freenet.pluginmanager.PluginDownLoader;
import freenet.pluginmanager.PluginDownLoaderFile;
import freenet.pluginmanager.PluginDownLoaderFreenet;
import freenet.pluginmanager.PluginDownLoaderOfficialFreenet;
import freenet.pluginmanager.PluginDownLoaderURL;
import freenet.pluginmanager.PluginHTTPException;
import freenet.pluginmanager.PluginHandler;
import freenet.pluginmanager.PluginInfoWrapper;
import freenet.pluginmanager.PluginNotFoundException;
import freenet.pluginmanager.PluginTooOldException;
import freenet.support.HTMLNode;
import freenet.support.HexUtil;
import freenet.support.JarClassLoader;
import freenet.support.Logger;
import freenet.support.SerialExecutor;
import freenet.support.Ticker;
import freenet.support.api.BooleanCallback;
import freenet.support.api.HTTPRequest;
import freenet.support.api.StringArrCallback;
import freenet.support.io.Closer;
import freenet.support.io.FileUtil;
import freenet.support.io.NativeThread;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.tanukisoftware.wrapper.WrapperManager;

public class PluginManager {
    private final HashMap<String, FredPlugin> toadletList = new HashMap();
    private final OfficialPlugins officialPlugins = new OfficialPlugins();
    private final LoadedPlugins loadedPlugins = new LoadedPlugins();
    final Node node;
    private final NodeClientCore core;
    private boolean logMINOR;
    private boolean logDEBUG;
    private final HighLevelSimpleClient client;
    private static PluginManager selfinstance = null;
    private PageMaker.THEME fproxyTheme;
    private final SerialExecutor executor;
    private boolean alwaysLoadOfficialPluginsFromCentralServer = false;
    static final short PRIO = 1;
    private final boolean enabled;
    private boolean started;
    private boolean stopping;
    private String[] toStart;
    private final Object pluginLoadSyncObject = new Object();
    @Deprecated
    public final RequestClient singleUpdaterRequestClient = new RequestClientBuilder().build();

    public PluginManager(Node node, int lastVersion) {
        this.logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        this.logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
        this.node = node;
        this.core = node.getClientCore();
        if (this.logMINOR) {
            Logger.minor(this, "Starting Plugin Manager");
        }
        if (this.logDEBUG) {
            Logger.debug(this, "Initialize Plugin Manager config");
        }
        this.client = this.core.makeClient((short)1, true, false);
        this.executor = new SerialExecutor(NativeThread.PriorityLevel.NORM_PRIORITY.value);
        this.executor.start(node.getExecutor(), "PM callback executor");
        SubConfig pmconfig = node.getConfig().createSubConfig("pluginmanager");
        pmconfig.register("enabled", true, 0, true, true, "PluginManager.enabled", "PluginManager.enabledLong", new BooleanCallback(){

            @Override
            public synchronized Boolean get() {
                return PluginManager.this.enabled;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                if (PluginManager.this.enabled != val) {
                    throw new NodeNeedRestartException(PluginManager.l10n("changePluginManagerEnabledInConfig"));
                }
            }
        });
        this.enabled = pmconfig.getBoolean("enabled");
        pmconfig.register("loadplugin", null, 0, true, false, "PluginManager.loadedOnStartup", "PluginManager.loadedOnStartupLong", new StringArrCallback(){

            @Override
            public String[] get() {
                return PluginManager.this.getConfigLoadString();
            }

            @Override
            public void set(String[] val) throws InvalidConfigValueException {
                throw new InvalidConfigValueException(NodeL10n.getBase().getString("PluginManager.cannotSetOnceLoaded"));
            }

            @Override
            public boolean isReadOnly() {
                return true;
            }
        });
        this.toStart = pmconfig.getStringArr("loadplugin");
        if (lastVersion < 1237 && this.contains(this.toStart, "XMLLibrarian") && !this.contains(this.toStart, "Library")) {
            this.toStart = Arrays.copyOf(this.toStart, this.toStart.length + 1);
            this.toStart[this.toStart.length - 1] = "Library";
            System.err.println("Loading Library plugin, replaces XMLLibrarian, when upgrading from pre-1237");
        }
        if (this.contains(this.toStart, "KeyExplorer")) {
            for (int i = 0; i < this.toStart.length; ++i) {
                if (!"KeyExplorer".equals(this.toStart[i])) continue;
                this.toStart[i] = "KeyUtils";
            }
            System.err.println("KeyExplorer plugin renamed to KeyUtils");
        }
        pmconfig.registerIgnoredOption("alwaysLoadOfficialPluginsFromCentralServer");
        pmconfig.finishedInitialization();
        this.fproxyTheme = PageMaker.THEME.themeFromName(node.getConfig().get("fproxy").getString("css"));
        selfinstance = this;
    }

    private boolean contains(String[] array, String string) {
        for (String s : array) {
            if (!string.equals(s)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (!this.enabled) {
            return;
        }
        LoadedPlugins loadedPlugins = this.loadedPlugins;
        synchronized (loadedPlugins) {
            if (this.started) {
                return;
            }
        }
        final Semaphore startingPlugins = new Semaphore(0);
        for (final String name : this.toStart) {
            this.core.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    PluginManager.this.startPluginAuto(name, false);
                    startingPlugins.release();
                }
            });
        }
        this.core.getExecutor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                startingPlugins.acquireUninterruptibly(PluginManager.this.toStart.length);
                LoadedPlugins loadedPlugins = PluginManager.this.loadedPlugins;
                synchronized (loadedPlugins) {
                    PluginManager.this.started = true;
                    PluginManager.access$302(PluginManager.this, null);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(long maxWaitTime) {
        if (!this.enabled) {
            return;
        }
        Iterator<PluginInfoWrapper> iterator = this.loadedPlugins;
        synchronized (iterator) {
            this.stopping = true;
        }
        for (PluginProgress progress : this.loadedPlugins.getStartingPlugins()) {
            progress.kill();
        }
        for (PluginInfoWrapper pi : this.loadedPlugins.getLoadedPlugins()) {
            pi.startShutdownPlugin(this, false);
        }
        long now = System.currentTimeMillis();
        long deadline = now + maxWaitTime;
        while (true) {
            Object list;
            int delta;
            if ((delta = (int)(deadline - now)) <= 0) {
                list = PluginManager.pluginList(this.loadedPlugins.getLoadedPlugins());
                Logger.error(this, "Plugins still shutting down at timeout:\n" + (String)list);
                System.err.println("Plugins still shutting down at timeout:\n" + (String)list);
                continue;
            }
            for (PluginInfoWrapper pluginInfoWrapper : this.loadedPlugins.getLoadedPlugins()) {
                System.out.println("Waiting for plugin to finish shutting down: " + pluginInfoWrapper.getFilename());
                if (!pluginInfoWrapper.finishShutdownPlugin(this, delta, false)) continue;
                this.loadedPlugins.removeLoadedPlugin(pluginInfoWrapper);
            }
            if (!this.loadedPlugins.hasLoadedPlugins()) {
                Logger.normal(this, "All plugins unloaded");
                System.out.println("All plugins unloaded");
                return;
            }
            list = PluginManager.pluginList(this.loadedPlugins.getLoadedPlugins());
            Logger.error(this, "Plugins still shutting down:\n" + (String)list);
            System.err.println("Plugins still shutting down:\n" + (String)list);
        }
    }

    private static String pluginList(Collection<PluginInfoWrapper> wrappers) {
        StringBuffer sb = new StringBuffer();
        for (PluginInfoWrapper pi : wrappers) {
            sb.append(pi.getFilename());
            sb.append('\n');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getConfigLoadString() {
        LoadedPlugins loadedPlugins = this.loadedPlugins;
        synchronized (loadedPlugins) {
            if (!this.started) {
                return this.toStart;
            }
        }
        ArrayList<String> v = new ArrayList<String>();
        for (PluginInfoWrapper pi : this.loadedPlugins.getLoadedPlugins()) {
            v.add(pi.getFilename());
        }
        v.addAll(this.loadedPlugins.getFailedPluginNames());
        return v.toArray(new String[v.size()]);
    }

    public Set<PluginProgress> getStartingPlugins() {
        return new HashSet<PluginProgress>(this.loadedPlugins.getStartingPlugins());
    }

    public PluginInfoWrapper startPluginAuto(String pluginname, boolean store) {
        OfficialPlugins.OfficialPluginDescription desc = this.isOfficialPlugin(pluginname);
        if (desc != null) {
            return this.startPluginOfficial(pluginname, store, desc);
        }
        try {
            new FreenetURI(pluginname);
            return this.startPluginFreenet(pluginname, store);
        }
        catch (MalformedURLException malformedURLException) {
            File[] roots;
            for (File f : roots = File.listRoots()) {
                if (!pluginname.startsWith(f.getName()) || !new File(pluginname).exists()) continue;
                return this.startPluginFile(pluginname, store);
            }
            return this.startPluginURL(pluginname, store);
        }
    }

    public PluginInfoWrapper startPluginOfficial(String pluginname, boolean store) {
        return this.startPluginOfficial(pluginname, store, this.officialPlugins.get(pluginname));
    }

    @Deprecated
    public PluginInfoWrapper startPluginOfficial(String pluginname, boolean store, boolean force, boolean forceHTTPS) {
        return this.startPluginOfficial(pluginname, store);
    }

    public PluginInfoWrapper startPluginOfficial(String pluginname, boolean store, OfficialPlugins.OfficialPluginDescription desc) {
        return this.realStartPlugin(new PluginDownLoaderOfficialFreenet(this.client, this.node, false), pluginname, store, desc.alwaysFetchLatestVersion);
    }

    @Deprecated
    public PluginInfoWrapper startPluginOfficial(String pluginname, boolean store, OfficialPlugins.OfficialPluginDescription officialPluginDescription, boolean force, boolean forceHTTPS) {
        return this.startPluginOfficial(pluginname, store, officialPluginDescription);
    }

    public PluginInfoWrapper startPluginFile(String filename, boolean store) {
        return this.realStartPlugin(new PluginDownLoaderFile(), filename, store, false);
    }

    public PluginInfoWrapper startPluginURL(String filename, boolean store) {
        return this.realStartPlugin(new PluginDownLoaderURL(), filename, store, false);
    }

    public PluginInfoWrapper startPluginFreenet(String filename, boolean store) {
        return this.realStartPlugin(new PluginDownLoaderFreenet(this.client, this.node, false), filename, store, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginInfoWrapper realStartPlugin(PluginDownLoader<?> pdl, final String filename, final boolean store, boolean alwaysDownload) {
        if (!this.enabled) {
            throw new IllegalStateException("Plugins disabled");
        }
        if (filename.trim().length() == 0) {
            return null;
        }
        PluginProgress pluginProgress = new PluginProgress(filename, pdl);
        this.loadedPlugins.addStartingPlugin(pluginProgress);
        Logger.normal(this, "Loading plugin: " + filename);
        PluginInfoWrapper pi = null;
        try {
            FredPlugin plug = this.loadPlugin(pdl, filename, pluginProgress, alwaysDownload);
            pluginProgress.setProgress(PluginProgress.ProgressState.STARTING);
            pi = new PluginInfoWrapper(this.node, plug, filename, pdl.isOfficialPluginLoader());
            PluginHandler.startPlugin(this, pi);
            this.loadedPlugins.addLoadedPlugin(pi);
            this.loadedPlugins.removeFailedPlugin(filename);
            Logger.normal(this, "Plugin loaded: " + filename);
        }
        catch (PluginAlreadyLoaded e) {
            PluginInfoWrapper pluginInfoWrapper = null;
            return pluginInfoWrapper;
        }
        catch (PluginNotFoundException e) {
            PluginDownLoaderFreenet downloader;
            Logger.normal(this, "Loading plugin failed (" + filename + ')', (Throwable)e);
            boolean stillTrying = false;
            if (pdl.isLoadingFromFreenet() && !(downloader = (PluginDownLoaderFreenet)pdl).fatalFailure() && !downloader.desperate && !this.twoCopiesInStartingPlugins(filename)) {
                final PluginDownLoader<?> retry = pdl.getRetryDownloader();
                stillTrying = true;
                this.node.getTicker().queueTimedJob(new Runnable(){

                    @Override
                    public void run() {
                        PluginManager.this.realStartPlugin(retry, filename, store, true);
                    }
                }, 0L);
            }
            PluginLoadFailedUserAlert newAlert = new PluginLoadFailedUserAlert(filename, pdl.isOfficialPluginLoader(), stillTrying, e);
            PluginLoadFailedUserAlert oldAlert = this.loadedPlugins.replaceUserAlert(filename, newAlert);
            this.core.getAlerts().register(newAlert);
            this.core.getAlerts().unregister(oldAlert);
        }
        catch (UnsupportedClassVersionError e) {
            Logger.error(this, "Could not load plugin " + filename + " : " + e, (Throwable)e);
            System.err.println("Could not load plugin " + filename + " : " + e);
            e.printStackTrace();
            System.err.println("Plugin " + filename + " appears to require a later JVM");
            Logger.error(this, "Plugin " + filename + " appears to require a later JVM");
            PluginLoadFailedUserAlert newAlert = new PluginLoadFailedUserAlert(filename, pdl.isOfficialPluginLoader(), false, PluginManager.l10n("pluginReqNewerJVMTitle", "name", filename));
            PluginLoadFailedUserAlert oldAlert = this.loadedPlugins.replaceUserAlert(filename, newAlert);
            this.core.getAlerts().register(newAlert);
            this.core.getAlerts().unregister(oldAlert);
        }
        catch (Throwable e) {
            Logger.error(this, "Could not load plugin " + filename + " : " + e, e);
            System.err.println("Could not load plugin " + filename + " : " + e);
            e.printStackTrace();
            System.err.println("Plugin " + filename + " is broken, but we want to retry after next startup");
            Logger.error(this, "Plugin " + filename + " is broken, but we want to retry after next startup");
            PluginLoadFailedUserAlert newAlert = new PluginLoadFailedUserAlert(filename, pdl.isOfficialPluginLoader(), false, e);
            PluginLoadFailedUserAlert oldAlert = this.loadedPlugins.replaceUserAlert(filename, newAlert);
            this.core.getAlerts().register(newAlert);
            this.core.getAlerts().unregister(oldAlert);
        }
        finally {
            this.loadedPlugins.removeStartingPlugin(pluginProgress);
        }
        PluginManager pluginManager = this;
        synchronized (pluginManager) {
            if (store) {
                this.core.storeConfig();
            }
        }
        if (pi != null) {
            this.node.getNodeUpdater().startPluginUpdater(filename);
        }
        return pi;
    }

    private synchronized boolean twoCopiesInStartingPlugins(String filename) {
        int count = 0;
        for (PluginProgress progress : this.loadedPlugins.getStartingPlugins()) {
            if (!filename.equals(progress.name) || ++count != 2) continue;
            return true;
        }
        return false;
    }

    void register(PluginInfoWrapper pi) {
        FredPlugin plug = pi.getPlugin();
        if (pi.isPproxyPlugin()) {
            this.registerToadlet(plug);
        }
        if (pi.isConfigurablePlugin()) {
            boolean pluginIsTryingToHijackNodeConfig = false;
            for (SubConfig subconfig : this.node.getConfig().getConfigs()) {
                if (!pi.getPluginClassName().equals(subconfig.getPrefix())) continue;
                pluginIsTryingToHijackNodeConfig = true;
                break;
            }
            if (pluginIsTryingToHijackNodeConfig) {
                Logger.warning(this, "The plugin loaded from " + pi.getFilename() + " is attempting to hijack a node configuration page; refusing to register its ConfigToadlet");
            } else {
                ConfigToadlet toadlet = pi.getConfigToadlet();
                this.core.getToadletContainer().register(toadlet, "FProxyToadlet.categoryConfig", ((Toadlet)toadlet).path(), true, "ConfigToadlet." + pi.getPluginClassName() + ".label", "ConfigToadlet." + pi.getPluginClassName() + ".tooltip", true, null, (FredPluginL10n)((Object)pi.getPlugin()));
            }
        }
        if (pi.isIPDetectorPlugin()) {
            this.node.getIpDetector().registerIPDetectorPlugin((FredPluginIPDetector)((Object)plug));
        }
        if (pi.isPortForwardPlugin()) {
            this.node.getIpDetector().registerPortForwardPlugin((FredPluginPortForward)((Object)plug));
        }
        if (pi.isBandwidthIndicator()) {
            this.node.getIpDetector().registerBandwidthIndicatorPlugin((FredPluginBandwidthIndicator)((Object)plug));
        }
    }

    public void cancelRunningLoads(String filename, PluginProgress exceptFor) {
        Logger.normal(this, "Cancelling loads for plugin " + filename);
        for (PluginProgress progress : new ArrayList<PluginProgress>(this.loadedPlugins.getStartingPlugins())) {
            if (progress == exceptFor || !filename.equals(progress.name)) continue;
            progress.kill();
            this.loadedPlugins.removeStartingPlugin(progress);
        }
    }

    static String l10n(String key) {
        return NodeL10n.getBase().getString("PluginManager." + key);
    }

    private static String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("PluginManager." + key, pattern, value);
    }

    private String l10n(String key, String[] patterns, String[] values) {
        return NodeL10n.getBase().getString("PluginManager." + key, patterns, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerToadlet(FredPlugin pl) {
        HashMap<String, FredPlugin> hashMap = this.toadletList;
        synchronized (hashMap) {
            this.toadletList.put(pl.getClass().getName(), pl);
        }
        Logger.normal(this, "Added HTTP handler for /plugins/" + pl.getClass().getName() + '/');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlugin(PluginInfoWrapper pi) {
        LoadedPlugins loadedPlugins = this.loadedPlugins;
        synchronized (loadedPlugins) {
            if (!this.stopping && !this.loadedPlugins.hasLoadedPlugin(pi)) {
                return;
            }
        }
        this.loadedPlugins.removeLoadedPlugin(pi);
        this.core.storeConfig();
    }

    public void removeCachedCopy(String pluginSpecification) {
        if (pluginSpecification == null) {
            Logger.warning(this, "Can't remove null from cache. Ignoring");
            return;
        }
        int lastSlash = pluginSpecification.lastIndexOf(47);
        if (lastSlash == -1) {
            lastSlash = pluginSpecification.lastIndexOf(92);
        }
        File pluginDirectory = this.node.getPluginDir();
        String pluginFilename = lastSlash == -1 ? (pluginSpecification.toLowerCase().endsWith(".jar") ? pluginSpecification : pluginSpecification + ".jar") : pluginSpecification.substring(lastSlash + 1);
        if (this.logDEBUG) {
            Logger.minor(this, "Delete plugin - plugname: " + pluginSpecification + " filename: " + pluginFilename, (Throwable)new Exception("debug"));
        }
        List<File> cachedFiles = this.getPreviousInstances(pluginDirectory, pluginFilename);
        for (File cachedFile : cachedFiles) {
            if (cachedFile.delete() || !this.logMINOR) continue;
            Logger.minor(this, "Can't delete file " + cachedFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPluginToadlet(PluginInfoWrapper pi) {
        HashMap<String, FredPlugin> hashMap = this.toadletList;
        synchronized (hashMap) {
            try {
                this.toadletList.remove(pi.getPluginClassName());
                Logger.normal(this, "Removed HTTP handler for /plugins/" + pi.getPluginClassName() + '/', (Throwable)new Exception("debug"));
            }
            catch (Throwable ex) {
                Logger.error(this, "removing Plugin", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addToadletSymlinks(PluginInfoWrapper pi) {
        HashMap<String, FredPlugin> hashMap = this.toadletList;
        synchronized (hashMap) {
            try {
                String[] targets = pi.getPluginToadletSymlinks();
                if (targets == null) {
                    return;
                }
                for (String target : targets) {
                    this.toadletList.remove(target);
                    Logger.normal(this, "Removed HTTP symlink: " + target + " => /plugins/" + pi.getPluginClassName() + '/');
                }
            }
            catch (Throwable ex) {
                Logger.error(this, "removing Toadlet-link", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void removeToadletSymlinks(PluginInfoWrapper pi) {
        HashMap<String, FredPlugin> hashMap = this.toadletList;
        synchronized (hashMap) {
            String rm = null;
            try {
                String[] targets = pi.getPluginToadletSymlinks();
                if (targets == null) {
                    return;
                }
                String[] stringArray = targets;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String target;
                    rm = target = stringArray[i];
                    this.toadletList.remove(target);
                    pi.removePluginToadletSymlink(target);
                    Logger.normal(this, "Removed HTTP symlink: " + target + " => /plugins/" + pi.getPluginClassName() + '/');
                }
            }
            catch (Throwable ex) {
                Logger.error(this, "removing Toadlet-link: " + rm, ex);
            }
        }
    }

    public String dumpPlugins() {
        StringBuilder out = new StringBuilder();
        for (PluginInfoWrapper pluginInfoWrapper : this.loadedPlugins.getLoadedPlugins()) {
            out.append(pluginInfoWrapper.toString()).append('\n');
        }
        return out.toString();
    }

    public Set<PluginInfoWrapper> getPlugins() {
        return new TreeSet<PluginInfoWrapper>(this.loadedPlugins.getLoadedPlugins());
    }

    @Deprecated
    public PluginInfoWrapper getPluginInfo(String plugname) {
        for (PluginInfoWrapper pluginInfoWrapper : this.loadedPlugins.getLoadedPlugins()) {
            if (!pluginInfoWrapper.getPluginClassName().equals(plugname) && !pluginInfoWrapper.getFilename().equals(plugname)) continue;
            return pluginInfoWrapper;
        }
        return null;
    }

    public PluginInfoWrapper getPluginInfoByClassName(String pluginClassName) {
        for (PluginInfoWrapper pluginInfoWrapper : this.loadedPlugins.getLoadedPlugins()) {
            if (!pluginInfoWrapper.getPluginClassName().equals(pluginClassName)) continue;
            return pluginInfoWrapper;
        }
        return null;
    }

    @Deprecated
    public FredPluginFCP getFCPPlugin(String plugname) {
        for (PluginInfoWrapper pluginInfoWrapper : this.loadedPlugins.getLoadedPlugins()) {
            if (!pluginInfoWrapper.isFCPPlugin() || !pluginInfoWrapper.getPluginClassName().equals(plugname) || pluginInfoWrapper.isStopping()) continue;
            return (FredPluginFCP)((Object)pluginInfoWrapper.plug);
        }
        return null;
    }

    public FredPluginFCPMessageHandler.ServerSideFCPMessageHandler getPluginFCPServer(String pluginClassName) throws PluginNotFoundException {
        PluginInfoWrapper piw = this.getPluginInfoByClassName(pluginClassName);
        if (piw != null && piw.isFCPServerPlugin()) {
            return piw.getFCPServerPlugin();
        }
        throw new PluginNotFoundException(pluginClassName);
    }

    public boolean isPluginLoaded(String plugname) {
        for (PluginInfoWrapper pluginInfoWrapper : this.loadedPlugins.getLoadedPlugins()) {
            if (!pluginInfoWrapper.getPluginClassName().equals(plugname) && !pluginInfoWrapper.getFilename().equals(plugname)) continue;
            return true;
        }
        return false;
    }

    public boolean isPluginLoadedOrLoadingOrWantLoad(String plugname) {
        return this.loadedPlugins.isKnownPlugin(plugname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String handleHTTPGet(String plugin, HTTPRequest request) throws PluginHTTPException {
        FredPlugin handler = null;
        HashMap<String, FredPlugin> hashMap = this.toadletList;
        synchronized (hashMap) {
            handler = this.toadletList.get(plugin);
        }
        if (!(handler instanceof FredPluginHTTP)) {
            throw new NotFoundPluginHTTPException("Plugin not loaded!", "/plugins");
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader pluginClassLoader = handler.getClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(pluginClassLoader);
        try {
            String string = ((FredPluginHTTP)((Object)handler)).handleHTTPGet(request);
            return string;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String handleHTTPPost(String plugin, HTTPRequest request) throws PluginHTTPException {
        FredPlugin handler = null;
        HashMap<String, FredPlugin> hashMap = this.toadletList;
        synchronized (hashMap) {
            handler = this.toadletList.get(plugin);
        }
        if (handler == null) {
            throw new NotFoundPluginHTTPException("Plugin '" + plugin + "' not found!", "/plugins");
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader pluginClassLoader = handler.getClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(pluginClassLoader);
        try {
            if (handler instanceof FredPluginHTTP) {
                String string = ((FredPluginHTTP)((Object)handler)).handleHTTPPost(request);
                return string;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        throw new NotFoundPluginHTTPException("Plugin '" + plugin + "' not found!", "/plugins");
    }

    public void killPlugin(String name, long maxWaitTime, boolean reloading) {
        for (PluginInfoWrapper pluginInfoWrapper : this.loadedPlugins.getLoadedPlugins()) {
            if (!pluginInfoWrapper.getThreadName().equals(name)) continue;
            pluginInfoWrapper.stopPlugin(this, maxWaitTime, reloading);
            break;
        }
    }

    public void killPluginByFilename(String name, long maxWaitTime, boolean reloading) {
        for (PluginInfoWrapper pluginInfoWrapper : this.loadedPlugins.getLoadedPlugins()) {
            if (!pluginInfoWrapper.getFilename().equals(name)) continue;
            pluginInfoWrapper.stopPlugin(this, maxWaitTime, reloading);
            break;
        }
    }

    public void killPluginByClass(String name, long maxWaitTime) {
        for (PluginInfoWrapper pluginInfoWrapper : this.loadedPlugins.getLoadedPlugins()) {
            if (!pluginInfoWrapper.getPluginClassName().equals(name)) continue;
            pluginInfoWrapper.stopPlugin(this, maxWaitTime, false);
            break;
        }
    }

    public void killPlugin(FredPlugin plugin, long maxWaitTime) {
        for (PluginInfoWrapper pluginInfoWrapper : this.loadedPlugins.getLoadedPlugins()) {
            if (pluginInfoWrapper.plug != plugin) continue;
            pluginInfoWrapper.stopPlugin(this, maxWaitTime, false);
            break;
        }
    }

    public OfficialPlugins.OfficialPluginDescription getOfficialPlugin(String name) {
        return this.officialPlugins.get(name);
    }

    public Collection<OfficialPlugins.OfficialPluginDescription> getOfficialPlugins() {
        return this.officialPlugins.getAll();
    }

    public List<OfficialPlugins.OfficialPluginDescription> findAvailablePlugins() {
        ArrayList<OfficialPlugins.OfficialPluginDescription> availablePlugins = new ArrayList<OfficialPlugins.OfficialPluginDescription>();
        availablePlugins.addAll(this.officialPlugins.getAll());
        return availablePlugins;
    }

    public OfficialPlugins.OfficialPluginDescription isOfficialPlugin(String name) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        List<OfficialPlugins.OfficialPluginDescription> availablePlugins = this.findAvailablePlugins();
        for (OfficialPlugins.OfficialPluginDescription desc : availablePlugins) {
            if (!desc.name.equals(name)) continue;
            return desc;
        }
        return null;
    }

    public File getPluginFilename(String pluginName) {
        File pluginDirectory = this.node.getPluginDir();
        if (pluginDirectory.exists() && !pluginDirectory.isDirectory() || !pluginDirectory.exists() && !pluginDirectory.mkdirs()) {
            return null;
        }
        return new File(pluginDirectory, pluginName + ".jar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FredPlugin loadPlugin(PluginDownLoader<?> pdl, String name, PluginProgress progress, boolean alwaysDownload) throws PluginNotFoundException, PluginAlreadyLoaded {
        pdl.setSource(name);
        File pluginDirectory = this.getPluginDirectory();
        String filename = pdl.getPluginName(name);
        File pluginFile = this.getTargetFileForPluginDownload(pluginDirectory, filename, !pdl.isCachingProhibited() && !alwaysDownload);
        boolean downloadWasAttempted = false;
        if (this.logMINOR) {
            Logger.minor(this, "plugin file " + pluginFile.getAbsolutePath() + " exists: " + pluginFile.exists() + " downloader " + pdl + " name " + name);
        }
        int RETRIES = 5;
        for (int i = 0; i < RETRIES; ++i) {
            if (!pluginFile.exists() || pluginFile.length() == 0L) {
                try {
                    downloadWasAttempted = true;
                    System.err.println("Downloading plugin " + name);
                    WrapperManager.signalStarting((int)((int)TimeUnit.MINUTES.toMillis(5L)));
                    try {
                        this.downloadPluginFile(pdl, pluginDirectory, pluginFile, progress);
                        this.verifyDigest(pdl, pluginFile);
                    }
                    catch (IOException ioe1) {
                        Logger.error(this, "could not load plugin", (Throwable)ioe1);
                        throw new PluginNotFoundException("could not load plugin: " + ioe1.getMessage(), ioe1);
                    }
                }
                catch (PluginNotFoundException e) {
                    if (i < RETRIES - 1) {
                        Logger.normal(this, "Failed to load plugin: " + e, (Throwable)e);
                        continue;
                    }
                    throw e;
                }
            }
            this.cancelRunningLoads(name, progress);
            Object object = this.pluginLoadSyncObject;
            synchronized (object) {
                try {
                    String pluginMainClassName = this.verifyJarFileAndGetPluginMainClass(pluginFile);
                    FredPlugin object2 = this.loadPluginFromJarFile(name, pluginFile, pluginMainClassName, pdl.isOfficialPluginLoader());
                    if (object2 != null) {
                        return object2;
                    }
                }
                catch (PluginNotFoundException e) {
                    Logger.error(this, e.getMessage());
                    pluginFile.delete();
                    if (!downloadWasAttempted) {
                        continue;
                    }
                    throw e;
                }
            }
        }
        return null;
    }

    private File getPluginDirectory() throws PluginNotFoundException {
        File pluginDirectory = this.node.getPluginDir();
        if (pluginDirectory.exists() && !pluginDirectory.isDirectory() || !pluginDirectory.exists() && !pluginDirectory.mkdirs()) {
            Logger.error(this, "could not create plugin directory");
            throw new PluginNotFoundException("could not create plugin directory");
        }
        return pluginDirectory;
    }

    private File getTargetFileForPluginDownload(File pluginDirectory, String filename, boolean useCachedFile) {
        List<File> filesInPluginDirectory = this.getPreviousInstances(pluginDirectory, filename);
        this.cleanCacheDirectory(filesInPluginDirectory, useCachedFile);
        if (!filesInPluginDirectory.isEmpty() && useCachedFile) {
            return new File(pluginDirectory, filesInPluginDirectory.get(0).getName());
        }
        return new File(pluginDirectory, filename + "-" + System.currentTimeMillis());
    }

    private void cleanCacheDirectory(List<File> filesInPluginDirectory, boolean useCachedFile) {
        if (!useCachedFile) {
            this.deleteCachedVersions(filesInPluginDirectory);
        } else if (!filesInPluginDirectory.isEmpty()) {
            this.deleteCachedVersions(filesInPluginDirectory.subList(1, filesInPluginDirectory.size()));
        }
    }

    private void deleteCachedVersions(List<File> filesInPluginDirectory) {
        for (File cachedFile : filesInPluginDirectory) {
            cachedFile.delete();
        }
    }

    private void downloadPluginFile(PluginDownLoader<?> pluginDownLoader, File pluginDirectory, File pluginFile, PluginProgress pluginProgress) throws IOException, PluginNotFoundException {
        File tempPluginFile = File.createTempFile("plugin-", ".jar", pluginDirectory);
        tempPluginFile.deleteOnExit();
        FileOutputStream pluginOutputStream = null;
        InputStream pluginInputStream = null;
        try {
            pluginOutputStream = new FileOutputStream(tempPluginFile);
            pluginInputStream = pluginDownLoader.getInputStream(pluginProgress);
            FileUtil.copy(pluginInputStream, pluginOutputStream, -1L);
        }
        catch (IOException ioe1) {
            try {
                tempPluginFile.delete();
                throw ioe1;
            }
            catch (Throwable throwable) {
                Closer.close(pluginInputStream);
                Closer.close(pluginOutputStream);
                throw throwable;
            }
        }
        Closer.close(pluginInputStream);
        Closer.close(pluginOutputStream);
        if (tempPluginFile.length() == 0L) {
            throw new PluginNotFoundException("downloaded zero length file");
        }
        if (!FileUtil.renameTo(tempPluginFile, pluginFile)) {
            Logger.error(this, "could not rename temp file to plugin file");
            throw new PluginNotFoundException("could not rename temp file to plugin file");
        }
    }

    private void verifyDigest(PluginDownLoader<?> pluginDownLoader, File pluginFile) throws PluginNotFoundException {
        String digest = pluginDownLoader.getSHA1sum();
        if (digest == null) {
            return;
        }
        String testsum = this.getFileDigest(pluginFile, "SHA-1");
        if (!digest.equalsIgnoreCase(testsum)) {
            Logger.error(this, "Checksum verification failed, should be " + digest + " but was " + testsum);
            throw new PluginNotFoundException("Checksum verification failed, should be " + digest + " but was " + testsum);
        }
    }

    private String verifyJarFileAndGetPluginMainClass(File pluginFile) throws PluginNotFoundException, PluginAlreadyLoaded {
        String string;
        JarFile pluginJarFile = null;
        try {
            pluginJarFile = new JarFile(pluginFile);
            Manifest manifest = pluginJarFile.getManifest();
            if (manifest == null) {
                throw new PluginNotFoundException("could not load manifest from plugin file");
            }
            Attributes mainAttributes = manifest.getMainAttributes();
            if (mainAttributes == null) {
                throw new PluginNotFoundException("manifest does not contain attributes");
            }
            String pluginMainClassName = mainAttributes.getValue("Plugin-Main-Class");
            if (pluginMainClassName == null) {
                throw new PluginNotFoundException("manifest does not contain a Plugin-Main-Class attribute");
            }
            if (this.isPluginLoaded(pluginMainClassName)) {
                Logger.error(this, "Plugin already loaded: " + pluginFile.getName());
                throw new PluginAlreadyLoaded();
            }
            string = pluginMainClassName;
        }
        catch (IOException ioe1) {
            try {
                throw new PluginNotFoundException("error procesesing jar file", ioe1);
            }
            catch (Throwable throwable) {
                Closer.close(pluginJarFile);
                throw throwable;
            }
        }
        Closer.close(pluginJarFile);
        return string;
    }

    private FredPlugin loadPluginFromJarFile(String name, File pluginFile, String pluginMainClassName, boolean isOfficialPlugin) throws PluginNotFoundException {
        try {
            JarClassLoader jarClassLoader = new JarClassLoader(pluginFile);
            Class<?> pluginMainClass = jarClassLoader.loadClass(pluginMainClassName);
            Object object = pluginMainClass.newInstance();
            if (!(object instanceof FredPlugin)) {
                throw new PluginNotFoundException("plugin main class is not a plugin");
            }
            if (isOfficialPlugin) {
                this.verifyPluginVersion(name, jarClassLoader, (FredPlugin)object);
            }
            if (object instanceof FredPluginL10n) {
                ((FredPluginL10n)object).setLanguage(NodeL10n.getBase().getSelectedLanguage());
            }
            if (object instanceof FredPluginBaseL10n) {
                ((FredPluginBaseL10n)object).setLanguage(NodeL10n.getBase().getSelectedLanguage());
            }
            if (object instanceof FredPluginThemed) {
                ((FredPluginThemed)object).setTheme(this.fproxyTheme);
            }
            return (FredPlugin)object;
        }
        catch (IOException ioe1) {
            throw new PluginNotFoundException("could not load plugin", ioe1);
        }
        catch (ClassNotFoundException cnfe1) {
            throw new PluginNotFoundException("could not find plugin class: \"" + cnfe1.getMessage() + "\"", cnfe1);
        }
        catch (InstantiationException ie1) {
            throw new PluginNotFoundException("could not instantiate plugin", ie1);
        }
        catch (IllegalAccessException iae1) {
            throw new PluginNotFoundException("could not access plugin main class", iae1);
        }
        catch (NoClassDefFoundError ncdfe1) {
            throw new PluginNotFoundException("could not find class def, may a missing lib?", ncdfe1);
        }
        catch (Throwable t) {
            throw new PluginNotFoundException("unexpected error while plugin loading " + t, t);
        }
    }

    private void verifyPluginVersion(String name, JarClassLoader jarClassLoader, FredPlugin plugin) throws PluginTooOldException {
        System.err.println("Loading official plugin " + name);
        OfficialPlugins.OfficialPluginDescription desc = this.officialPlugins.get(name);
        long minVer = desc.minimumVersion;
        long ver = -1L;
        if (minVer != -1L && plugin instanceof FredPluginRealVersioned) {
            ver = ((FredPluginRealVersioned)((Object)plugin)).getRealVersion();
        }
        if (ver < minVer) {
            System.err.println("Failed to load plugin " + name + " : TOO OLD: need at least version " + minVer + " but is " + ver);
            Logger.error(this, "Failed to load plugin " + name + " : TOO OLD: need at least version " + minVer + " but is " + ver);
            try {
                jarClassLoader.close();
            }
            catch (Throwable t) {
                Logger.error(this, "Failed to close jar classloader for plugin: " + t, t);
            }
            throw new PluginTooOldException("plugin too old: need at least version " + minVer + " but is " + ver);
        }
    }

    private List<File> getPreviousInstances(File pluginDirectory, final String filename) {
        List<File> cachedFiles = Arrays.asList(pluginDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().startsWith(filename);
            }
        }));
        Collections.sort(cachedFiles, new Comparator<File>(){

            @Override
            public int compare(File file1, File file2) {
                return (int)Math.min(Integer.MAX_VALUE, Math.max(Integer.MIN_VALUE, this.extractTimestamp(file2.getName()) - this.extractTimestamp(file1.getName())));
            }

            private long extractTimestamp(String filename) {
                int lastIndexOfDash = filename.lastIndexOf(".jar-");
                if (lastIndexOfDash == -1) {
                    return 0L;
                }
                try {
                    return Long.parseLong(filename.substring(lastIndexOfDash + 5));
                }
                catch (NumberFormatException nfe1) {
                    return 0L;
                }
            }
        });
        return cachedFiles;
    }

    private String getFileDigest(File file, String digest) throws PluginNotFoundException {
        String result;
        int BUFFERSIZE = 4096;
        MessageDigest hash = null;
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        boolean wasFromDigest256Pool = false;
        try {
            if ("SHA-256".equals(digest)) {
                hash = SHA256.getMessageDigest();
                wasFromDigest256Pool = true;
            } else {
                hash = MessageDigest.getInstance(digest);
            }
            fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis);
            int len = 0;
            byte[] buffer = new byte[4096];
            while ((len = bis.read(buffer)) > -1) {
                hash.update(buffer, 0, len);
            }
            result = HexUtil.bytesToHex(hash.digest());
            if (wasFromDigest256Pool) {
                SHA256.returnMessageDigest(hash);
            }
        }
        catch (Exception e) {
            try {
                throw new PluginNotFoundException("Error while computing hash '" + digest + "' of the downloaded plugin: " + e, e);
            }
            catch (Throwable throwable) {
                Closer.close(bis);
                Closer.close(fis);
                throw throwable;
            }
        }
        Closer.close(bis);
        Closer.close(fis);
        return result;
    }

    Ticker getTicker() {
        return this.node.getTicker();
    }

    static String getOfficialPluginLocalisedName(String pluginName) {
        return PluginManager.l10n("pluginName." + pluginName);
    }

    public void setFProxyTheme(final PageMaker.THEME cssName) {
        this.fproxyTheme = cssName;
        for (PluginInfoWrapper pluginInfoWrapper : this.loadedPlugins.getLoadedPlugins()) {
            pluginInfoWrapper.pr.getPageMaker().setTheme(cssName);
            if (!pluginInfoWrapper.isThemedPlugin()) continue;
            final FredPluginThemed plug = (FredPluginThemed)((Object)pluginInfoWrapper.plug);
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        plug.setTheme(cssName);
                    }
                    catch (Throwable t) {
                        Logger.error(this, "Cought Trowable in Callback", t);
                    }
                }
            }, "Callback");
        }
    }

    public static void setLanguage(BaseL10n.LANGUAGE lang) {
        if (selfinstance == null) {
            return;
        }
        selfinstance.setPluginLanguage(lang);
    }

    private void setPluginLanguage(BaseL10n.LANGUAGE lang) {
        for (PluginInfoWrapper pluginInfoWrapper : this.loadedPlugins.getLoadedPlugins()) {
            Object plug;
            if (pluginInfoWrapper.isL10nPlugin()) {
                plug = (FredPluginL10n)((Object)pluginInfoWrapper.plug);
                this.executor.execute(new Runnable((FredPluginL10n)plug, lang){
                    final /* synthetic */ FredPluginL10n val$plug;
                    final /* synthetic */ BaseL10n.LANGUAGE val$lang;
                    {
                        this.val$plug = fredPluginL10n;
                        this.val$lang = lANGUAGE;
                    }

                    @Override
                    public void run() {
                        try {
                            this.val$plug.setLanguage(this.val$lang);
                        }
                        catch (Throwable t) {
                            Logger.error(this, "Cought Trowable in Callback", t);
                        }
                    }
                }, "Callback");
                continue;
            }
            if (!pluginInfoWrapper.isBaseL10nPlugin()) continue;
            plug = (FredPluginBaseL10n)((Object)pluginInfoWrapper.plug);
            this.executor.execute(new Runnable((FredPluginBaseL10n)plug, lang){
                final /* synthetic */ FredPluginBaseL10n val$plug;
                final /* synthetic */ BaseL10n.LANGUAGE val$lang;
                {
                    this.val$plug = fredPluginBaseL10n;
                    this.val$lang = lANGUAGE;
                }

                @Override
                public void run() {
                    try {
                        this.val$plug.setLanguage(this.val$lang);
                    }
                    catch (Throwable t) {
                        Logger.error(this, "Cought Trowable in Callback", t);
                    }
                }
            }, "Callback");
        }
    }

    @Deprecated
    public PageMaker.THEME getFProxyTheme() {
        return this.fproxyTheme;
    }

    public void unregisterPlugin(PluginInfoWrapper wrapper, FredPlugin plug, boolean reloading) {
        this.unregisterPluginToadlet(wrapper);
        if (wrapper.isConfigurablePlugin()) {
            this.core.getToadletContainer().unregister(wrapper.getConfigToadlet());
        }
        if (wrapper.isIPDetectorPlugin()) {
            this.node.getIpDetector().unregisterIPDetectorPlugin((FredPluginIPDetector)((Object)plug));
        }
        if (wrapper.isPortForwardPlugin()) {
            this.node.getIpDetector().unregisterPortForwardPlugin((FredPluginPortForward)((Object)plug));
        }
        if (wrapper.isBandwidthIndicator()) {
            this.node.getIpDetector().unregisterBandwidthIndicatorPlugin((FredPluginBandwidthIndicator)((Object)plug));
        }
        if (!reloading) {
            this.node.getNodeUpdater().stopPluginUpdater(wrapper.getFilename());
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public RequestClient getSingleUpdaterRequestClient() {
        return this.singleUpdaterRequestClient;
    }

    static /* synthetic */ String[] access$302(PluginManager x0, String[] x1) {
        x0.toStart = x1;
        return x1;
    }

    private static class LoadedPlugins {
        private final Set<PluginProgress> startingPlugins = new HashSet<PluginProgress>();
        private final Set<PluginInfoWrapper> loadedPlugins = new HashSet<PluginInfoWrapper>();
        private final Map<String, PluginLoadFailedUserAlert> failedPluginAlerts = new HashMap<String, PluginLoadFailedUserAlert>();

        private LoadedPlugins() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addStartingPlugin(PluginProgress pluginProgress) {
            LoadedPlugins loadedPlugins = this;
            synchronized (loadedPlugins) {
                this.startingPlugins.add(pluginProgress);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<PluginProgress> getStartingPlugins() {
            LoadedPlugins loadedPlugins = this;
            synchronized (loadedPlugins) {
                return this.startingPlugins;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeStartingPlugin(PluginProgress pluginProgress) {
            LoadedPlugins loadedPlugins = this;
            synchronized (loadedPlugins) {
                this.startingPlugins.remove(pluginProgress);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<PluginInfoWrapper> getLoadedPlugins() {
            LoadedPlugins loadedPlugins = this;
            synchronized (loadedPlugins) {
                return this.loadedPlugins;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeLoadedPlugin(PluginInfoWrapper pluginInfoWrapper) {
            LoadedPlugins loadedPlugins = this;
            synchronized (loadedPlugins) {
                this.loadedPlugins.remove(pluginInfoWrapper);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasLoadedPlugin(PluginInfoWrapper pluginInfoWrapper) {
            LoadedPlugins loadedPlugins = this;
            synchronized (loadedPlugins) {
                return this.loadedPlugins.contains(pluginInfoWrapper);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasLoadedPlugins() {
            LoadedPlugins loadedPlugins = this;
            synchronized (loadedPlugins) {
                return !this.loadedPlugins.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<String> getFailedPluginNames() {
            LoadedPlugins loadedPlugins = this;
            synchronized (loadedPlugins) {
                return this.failedPluginAlerts.keySet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLoadedPlugin(PluginInfoWrapper pluginInfoWrapper) {
            LoadedPlugins loadedPlugins = this;
            synchronized (loadedPlugins) {
                this.loadedPlugins.add(pluginInfoWrapper);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PluginLoadFailedUserAlert replaceUserAlert(String pluginName, PluginLoadFailedUserAlert pluginLoadFailedUserAlert) {
            LoadedPlugins loadedPlugins = this;
            synchronized (loadedPlugins) {
                return this.failedPluginAlerts.put(pluginName, pluginLoadFailedUserAlert);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isFailedPlugin(String filename) {
            LoadedPlugins loadedPlugins = this;
            synchronized (loadedPlugins) {
                return this.failedPluginAlerts.containsKey(filename);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeFailedPlugin(String pluginName) {
            LoadedPlugins loadedPlugins = this;
            synchronized (loadedPlugins) {
                this.failedPluginAlerts.remove(pluginName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isKnownPlugin(String pluginName) {
            LoadedPlugins loadedPlugins = this;
            synchronized (loadedPlugins) {
                if (this.failedPluginAlerts.containsKey(pluginName)) {
                    return true;
                }
                for (PluginProgress pluginProgress : this.startingPlugins) {
                    if (!pluginProgress.getName().equals(pluginName)) continue;
                    return true;
                }
                for (PluginInfoWrapper pluginInfoWrapper : this.loadedPlugins) {
                    if (!pluginInfoWrapper.getFilename().equals(pluginName)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class PluginProgress {
        private long startingTime = System.currentTimeMillis();
        private ProgressState pluginProgress;
        private String name;
        private int total;
        private int minSuccessful;
        private int current;
        private boolean finalisedTotal;
        private int failed;
        private int fatallyFailed;
        private final PluginDownLoader<?> loader;

        PluginProgress(String name, PluginDownLoader<?> pdl) {
            this.name = name;
            this.pluginProgress = ProgressState.DOWNLOADING;
            this.loader = pdl;
        }

        public void kill() {
            this.loader.tryCancel();
        }

        public long getTime() {
            return System.currentTimeMillis() - this.startingTime;
        }

        public String getName() {
            return this.name;
        }

        public ProgressState getProgress() {
            return this.pluginProgress;
        }

        void setProgress(ProgressState state) {
            this.pluginProgress = state;
        }

        public String toString() {
            return "PluginProgress[name=" + this.name + ",startingTime=" + this.startingTime + ",progress=" + (Object)((Object)this.pluginProgress) + "]";
        }

        public HTMLNode toLocalisedHTML() {
            if (this.pluginProgress == ProgressState.DOWNLOADING && this.total > 0) {
                return QueueToadlet.createProgressCell(false, true, ClientPut.COMPRESS_STATE.WORKING, this.current, this.failed, this.fatallyFailed, this.minSuccessful, this.total, this.finalisedTotal, false);
            }
            if (this.pluginProgress == ProgressState.DOWNLOADING) {
                return new HTMLNode("td", NodeL10n.getBase().getString("PproxyToadlet.startingPluginStatus.downloading"));
            }
            if (this.pluginProgress == ProgressState.STARTING) {
                return new HTMLNode("td", NodeL10n.getBase().getString("PproxyToadlet.startingPluginStatus.starting"));
            }
            return new HTMLNode("td", this.toString());
        }

        public void setDownloadProgress(int minSuccess, int current, int total, int failed, int fatallyFailed, boolean finalised) {
            this.pluginProgress = ProgressState.DOWNLOADING;
            this.total = total;
            this.current = current;
            this.minSuccessful = minSuccess;
            this.failed = failed;
            this.fatallyFailed = fatallyFailed;
            this.finalisedTotal = finalised;
        }

        public void setDownloading() {
            this.pluginProgress = ProgressState.DOWNLOADING;
        }

        public boolean isOfficialPlugin() {
            return this.loader.isOfficialPluginLoader();
        }

        public String getLocalisedPluginName() {
            String pluginName = this.getName();
            if (this.isOfficialPlugin()) {
                return PluginManager.getOfficialPluginLocalisedName(pluginName);
            }
            return pluginName;
        }

        static enum ProgressState {
            DOWNLOADING,
            STARTING;

        }
    }

    class PluginLoadFailedUserAlert
    extends AbstractUserAlert {
        final String filename;
        final String message;
        final StackTraceElement[] stacktrace;
        final boolean official;
        final boolean stillTrying;

        public PluginLoadFailedUserAlert(String filename, boolean official, boolean stillTrying, String message) {
            this.filename = filename;
            this.official = official;
            this.message = message;
            this.stacktrace = null;
            this.stillTrying = stillTrying;
        }

        public PluginLoadFailedUserAlert(String filename, boolean official, boolean stillTrying, Throwable e) {
            String msg;
            this.filename = filename;
            this.official = official;
            this.stillTrying = stillTrying;
            if (e instanceof PluginNotFoundException) {
                msg = e.getMessage();
                this.stacktrace = null;
            } else {
                msg = e.getClass() + ": " + e.getMessage();
                this.stacktrace = e.getStackTrace();
            }
            if (msg == null) {
                msg = e.toString();
            }
            this.message = msg;
        }

        @Override
        public String dismissButtonText() {
            return PluginManager.l10n("deleteFailedPluginButton");
        }

        @Override
        public void onDismiss() {
            PluginManager.this.loadedPlugins.removeFailedPlugin(this.filename);
            PluginManager.this.node.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    PluginManager.this.cancelRunningLoads(PluginLoadFailedUserAlert.this.filename, null);
                }
            });
        }

        @Override
        public String anchor() {
            return "pluginfailed:" + this.filename;
        }

        @Override
        public HTMLNode getHTMLText() {
            HTMLNode div = new HTMLNode("div");
            HTMLNode p = div.addChild("p");
            p.addChild("#", PluginManager.this.l10n("pluginLoadingFailedWithMessage", new String[]{"name", "message"}, new String[]{this.filename, this.message}));
            if (this.stacktrace != null) {
                for (StackTraceElement e : this.stacktrace) {
                    p.addChild("br");
                    p.addChild("%", "&nbsp; &nbsp; &nbsp; &nbsp;");
                    p.addChild("#", "at " + e);
                }
            }
            if (this.stillTrying) {
                div.addChild("p", PluginManager.l10n("pluginLoadingFailedStillTryingOverFreenet"));
            }
            if (this.official) {
                p = div.addChild("p");
                p.addChild("#", PluginManager.l10n("officialPluginLoadFailedSuggestTryAgain"));
                if (!this.stillTrying) {
                    HTMLNode reloadForm = div.addChild("form", new String[]{"action", "method"}, new String[]{"/plugins/", "post"});
                    reloadForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "formPassword", PluginManager.this.node.getClientCore().getFormPassword()});
                    reloadForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "plugin-name", this.filename});
                    reloadForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "submit-official", PluginManager.l10n("officialPluginLoadFailedTryAgainFreenet")});
                }
            }
            return div;
        }

        @Override
        public short getPriorityClass() {
            return 1;
        }

        @Override
        public String getShortText() {
            return PluginManager.l10n("pluginLoadingFailedShort", "name", this.filename);
        }

        @Override
        public String getText() {
            return PluginManager.this.l10n("pluginLoadingFailedWithMessage", new String[]{"name", "message"}, new String[]{this.filename, this.message});
        }

        @Override
        public String getTitle() {
            return PluginManager.l10n("pluginLoadingFailedTitle");
        }

        @Override
        public boolean isEventNotification() {
            return false;
        }

        @Override
        public boolean isValid() {
            boolean success = PluginManager.this.loadedPlugins.isFailedPlugin(this.filename);
            if (!success) {
                PluginManager.this.core.getAlerts().unregister(this);
            }
            return success;
        }

        @Override
        public void isValid(boolean validity) {
        }

        @Override
        public boolean shouldUnregisterOnDismiss() {
            return true;
        }

        @Override
        public boolean userCanDismiss() {
            return true;
        }
    }
}

