/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.FileLoggerHook;
import freenet.support.LogThresholdCallback;
import freenet.support.LoggerHook;
import freenet.support.LoggerHookChain;
import freenet.support.VoidLogger;
import freenet.support.io.Closer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.regex.PatternSyntaxException;

public abstract class Logger {
    @Deprecated
    public static final int ERROR = LogLevel.ERROR.ordinal();
    @Deprecated
    public static final int WARNING = LogLevel.WARNING.ordinal();
    @Deprecated
    public static final int NORMAL = LogLevel.NORMAL.ordinal();
    @Deprecated
    public static final int MINOR = LogLevel.MINOR.ordinal();
    @Deprecated
    public static final int DEBUG = LogLevel.DEBUG.ordinal();
    @Deprecated
    public static final int INTERNAL = LogLevel.NONE.ordinal();
    static Logger logger = new VoidLogger();

    public static synchronized FileLoggerHook setupStdoutLogging(LogLevel level, String detail) throws LoggerHook.InvalidThresholdException {
        FileLoggerHook fh;
        Logger.setupChain();
        logger.setThreshold(level);
        logger.setDetailedThresholds(detail);
        try {
            fh = new FileLoggerHook((OutputStream)System.out, "d (c, t, p): m", "MMM dd, yyyy HH:mm:ss:SSS", level.name());
        }
        catch (FileLoggerHook.IntervalParseException e) {
            throw new Error(e);
        }
        if (detail != null) {
            fh.setDetailedThresholds(detail);
        }
        ((LoggerHookChain)logger).addHook(fh);
        fh.start();
        return fh;
    }

    @Deprecated
    public static synchronized FileLoggerHook setupStdoutLogging(int level, String detail) throws LoggerHook.InvalidThresholdException {
        return Logger.setupStdoutLogging(LogLevel.fromOrdinal(level), detail);
    }

    public static synchronized void setupChain() {
        logger = new LoggerHookChain();
    }

    public static synchronized void debug(Class<?> c, String s) {
        logger.log(c, s, LogLevel.DEBUG);
    }

    public static synchronized void debug(Class<?> c, String s, Throwable t) {
        logger.log(c, s, t, LogLevel.DEBUG);
    }

    public static synchronized void debug(Object o, String s) {
        logger.log(o, s, LogLevel.DEBUG);
    }

    public static synchronized void debug(Object o, String s, Throwable t) {
        logger.log(o, s, t, LogLevel.DEBUG);
    }

    public static synchronized void error(Class<?> c, String s) {
        logger.log(c, s, LogLevel.ERROR);
    }

    public static synchronized void error(Class<?> c, String s, Throwable t) {
        logger.log(c, s, t, LogLevel.ERROR);
    }

    public static synchronized void error(Object o, String s) {
        logger.log(o, s, LogLevel.ERROR);
    }

    public static synchronized void error(Object o, String s, Throwable e) {
        logger.log(o, s, e, LogLevel.ERROR);
    }

    public static synchronized void minor(Class<?> c, String s) {
        logger.log(c, s, LogLevel.MINOR);
    }

    public static synchronized void minor(Object o, String s) {
        logger.log(o, s, LogLevel.MINOR);
    }

    public static synchronized void minor(Object o, String s, Throwable t) {
        logger.log(o, s, t, LogLevel.MINOR);
    }

    public static synchronized void minor(Class<?> class1, String string, Throwable t) {
        logger.log(class1, string, t, LogLevel.MINOR);
    }

    public static synchronized void normal(Object o, String s) {
        logger.log(o, s, LogLevel.NORMAL);
    }

    public static synchronized void normal(Object o, String s, Throwable t) {
        logger.log(o, s, t, LogLevel.NORMAL);
    }

    public static synchronized void normal(Class<?> c, String s) {
        logger.log(c, s, LogLevel.NORMAL);
    }

    public static synchronized void normal(Class<?> c, String s, Throwable t) {
        logger.log(c, s, t, LogLevel.NORMAL);
    }

    public static synchronized void warning(Class<?> c, String s) {
        logger.log(c, s, LogLevel.WARNING);
    }

    public static synchronized void warning(Class<?> c, String s, Throwable t) {
        logger.log(c, s, t, LogLevel.WARNING);
    }

    public static synchronized void warning(Object o, String s) {
        logger.log(o, s, LogLevel.WARNING);
    }

    public static synchronized void warning(Object o, String s, Throwable e) {
        logger.log(o, s, e, LogLevel.WARNING);
    }

    public static synchronized void logStatic(Object o, String s, LogLevel prio) {
        logger.log(o, s, prio);
    }

    public static synchronized void logStatic(Object o, String s, Throwable e, LogLevel prio) {
        logger.log(o, s, e, prio);
    }

    @Deprecated
    public static synchronized void logStatic(Object o, String s, int prio) {
        Logger.logStatic(o, s, LogLevel.fromOrdinal(prio));
    }

    public abstract void log(Object var1, Class<?> var2, String var3, Throwable var4, LogLevel var5);

    @Deprecated
    public void log(Object o, Class<?> source, String message, Throwable e, int priority) {
        this.log(o, source, message, e, LogLevel.fromOrdinal(priority));
    }

    public abstract void log(Object var1, String var2, LogLevel var3);

    @Deprecated
    public void log(Object source, String message, int priority) {
        this.log(source, message, LogLevel.fromOrdinal(priority));
    }

    public abstract void log(Object var1, String var2, Throwable var3, LogLevel var4);

    @Deprecated
    public void log(Object o, String message, Throwable e, int priority) {
        this.log(o, message, e, LogLevel.fromOrdinal(priority));
    }

    public abstract void log(Class<?> var1, String var2, LogLevel var3);

    @Deprecated
    public void log(Class<?> c, String message, int priority) {
        this.log(c, message, LogLevel.fromOrdinal(priority));
    }

    public abstract void log(Class<?> var1, String var2, Throwable var3, LogLevel var4);

    @Deprecated
    public void log(Class<?> c, String message, Throwable e, int priority) {
        this.log(c, message, e, LogLevel.fromOrdinal(priority));
    }

    public abstract boolean instanceShouldLog(LogLevel var1, Class<?> var2);

    @Deprecated
    public boolean instanceShouldLog(int priority, Class<?> c) {
        return this.instanceShouldLog(LogLevel.fromOrdinal(priority), c);
    }

    public static boolean shouldLog(LogLevel priority, Class<?> c) {
        return logger.instanceShouldLog(priority, c);
    }

    @Deprecated
    public static boolean shouldLog(int priority, Class<?> c) {
        return Logger.shouldLog(LogLevel.fromOrdinal(priority), c);
    }

    public static boolean shouldLog(LogLevel priority, Object o) {
        return Logger.shouldLog(priority, o.getClass());
    }

    @Deprecated
    public static boolean shouldLog(int priority, Object o) {
        return Logger.shouldLog(LogLevel.fromOrdinal(priority), o);
    }

    public abstract boolean instanceShouldLog(LogLevel var1, Object var2);

    @Deprecated
    public boolean instanceShouldLog(int prio, Object o) {
        return this.instanceShouldLog(LogLevel.fromOrdinal(prio), o);
    }

    public abstract void setThreshold(LogLevel var1);

    @Deprecated
    public void setThreshold(int thresh) {
        this.setThreshold(LogLevel.fromOrdinal(thresh));
    }

    public abstract void setThreshold(String var1) throws LoggerHook.InvalidThresholdException;

    public abstract LogLevel getThresholdNew();

    @Deprecated
    public int getThreshold() {
        return this.getThresholdNew().ordinal();
    }

    public abstract void setDetailedThresholds(String var1) throws LoggerHook.InvalidThresholdException;

    public static void registerLogThresholdCallback(LogThresholdCallback ltc) {
        logger.instanceRegisterLogThresholdCallback(ltc);
    }

    public abstract void instanceRegisterLogThresholdCallback(LogThresholdCallback var1);

    public static void unregisterLogThresholdCallback(LogThresholdCallback ltc) {
        logger.instanceUnregisterLogThresholdCallback(ltc);
    }

    public abstract void instanceUnregisterLogThresholdCallback(LogThresholdCallback var1);

    public static void registerClass(final Class<?> clazz) {
        LogThresholdCallback ltc = new LogThresholdCallback(){
            WeakReference<Class<?>> ref;
            {
                this.ref = new WeakReference<Class>(clazz);
            }

            @Override
            public void shouldUpdate() {
                Class clazz2 = (Class)this.ref.get();
                if (clazz2 == null) {
                    Logger.unregisterLogThresholdCallback(this);
                    return;
                }
                boolean done = false;
                try {
                    Field logMINOR_Field = clazz2.getDeclaredField("logMINOR");
                    if ((logMINOR_Field.getModifiers() & 8) != 0) {
                        logMINOR_Field.setAccessible(true);
                        logMINOR_Field.set(null, Logger.shouldLog(LogLevel.MINOR, clazz2));
                    }
                    done = true;
                }
                catch (SecurityException logMINOR_Field) {
                }
                catch (NoSuchFieldException logMINOR_Field) {
                }
                catch (IllegalArgumentException logMINOR_Field) {
                }
                catch (IllegalAccessException logMINOR_Field) {
                    // empty catch block
                }
                try {
                    Field logDEBUG_Field = clazz2.getDeclaredField("logDEBUG");
                    if ((logDEBUG_Field.getModifiers() & 8) != 0) {
                        logDEBUG_Field.setAccessible(true);
                        logDEBUG_Field.set(null, Logger.shouldLog(LogLevel.DEBUG, clazz2));
                    }
                    done = true;
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                if (!done) {
                    Logger.error(this, "No log level field for " + clazz2);
                }
            }
        };
        Logger.registerLogThresholdCallback(ltc);
    }

    public static void fatal(Object cause, int retcode, String message) {
        Logger.error(cause, message);
        System.exit(retcode);
    }

    public static synchronized void globalAddHook(LoggerHook logger2) {
        if (logger instanceof VoidLogger) {
            Logger.setupChain();
        }
        ((LoggerHookChain)logger).addHook(logger2);
    }

    public static synchronized void globalSetThreshold(LogLevel i) {
        logger.setThreshold(i);
    }

    @Deprecated
    public static synchronized void globalSetThreshold(int i) {
        logger.setThreshold(LogLevel.fromOrdinal(i));
    }

    public static synchronized LogLevel globalGetThresholdNew() {
        return logger.getThresholdNew();
    }

    @Deprecated
    public static synchronized int globalGetThreshold() {
        return Logger.globalGetThresholdNew().ordinal();
    }

    public static synchronized void globalRemoveHook(LoggerHook hook) {
        if (logger instanceof LoggerHookChain) {
            ((LoggerHookChain)logger).removeHook(hook);
        } else {
            System.err.println("Cannot remove hook: " + hook + " global logger is " + logger);
        }
    }

    public static synchronized void destroyChainIfEmpty() {
        if (logger instanceof VoidLogger) {
            return;
        }
        if (logger instanceof LoggerHookChain && ((LoggerHookChain)logger).getHooks().length == 0) {
            logger = new VoidLogger();
        }
    }

    public static synchronized LoggerHookChain getChain() {
        if (logger instanceof LoggerHookChain) {
            return (LoggerHookChain)logger;
        }
        Logger oldLogger = logger;
        if (!(oldLogger instanceof VoidLogger) && !(oldLogger instanceof LoggerHook)) {
            throw new IllegalStateException("The old logger is not a VoidLogger and is not a LoggerHook either!");
        }
        Logger.setupChain();
        if (!(oldLogger instanceof VoidLogger)) {
            ((LoggerHookChain)logger).addHook((LoggerHook)oldLogger);
        }
        return (LoggerHookChain)logger;
    }

    public static enum LogLevel {
        MINIMAL,
        DEBUG,
        MINOR,
        NORMAL,
        WARNING,
        ERROR,
        NONE;


        public boolean matchesThreshold(LogLevel threshold) {
            return this.ordinal() >= threshold.ordinal();
        }

        @Deprecated
        public static LogLevel fromOrdinal(int ordinal) {
            for (LogLevel level : LogLevel.values()) {
                if (level.ordinal() != ordinal) continue;
                return level;
            }
            throw new RuntimeException("Invalid ordinal: " + ordinal);
        }
    }

    public static final class OSThread {
        private static boolean getPIDEnabled = false;
        private static boolean getPPIDEnabled = false;
        private static boolean logToFileEnabled = false;
        private static LogLevel logToFileVerbosity = LogLevel.DEBUG;
        private static boolean logToStdOutEnabled = false;
        private static boolean procSelfStatEnabled = false;

        public static synchronized int getPID(Object o) {
            if (!getPIDEnabled) {
                return -1;
            }
            return OSThread.getPIDFromProcSelfStat(o);
        }

        public static synchronized int getPPID(Object o) {
            if (!getPPIDEnabled) {
                return -1;
            }
            return OSThread.getPPIDFromProcSelfStat(o);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static synchronized String getFieldFromProcSelfStat(int fieldNumber, Object o) {
            String readLine = null;
            if (!procSelfStatEnabled) {
                return null;
            }
            FileInputStream is = null;
            BufferedReader br = null;
            File procFile = new File("/proc/self/stat");
            if (procFile.exists()) {
                try {
                    is = new FileInputStream(procFile);
                    br = new BufferedReader(new InputStreamReader((InputStream)is, StandardCharsets.ISO_8859_1));
                }
                catch (FileNotFoundException e1) {
                    Logger.logStatic(o, "'/proc/self/stat' not found", logToFileVerbosity);
                    procSelfStatEnabled = false;
                    br = null;
                }
                if (null != br) {
                    try {
                        readLine = br.readLine();
                    }
                    catch (IOException e) {
                        Logger.error(o, "Caught IOException in br.readLine() of OSThread.getFieldFromProcSelfStat()", (Throwable)e);
                        readLine = null;
                    }
                    finally {
                        Closer.close(br);
                    }
                    if (null != readLine) {
                        try {
                            String[] procFields = readLine.trim().split(" ");
                            if (4 <= procFields.length) {
                                return procFields[fieldNumber];
                            }
                        }
                        catch (PatternSyntaxException e) {
                            Logger.error(o, "Caught PatternSyntaxException in readLine.trim().split(\" \") of OSThread.getFieldFromProcSelfStat() while parsing '" + readLine + "'", (Throwable)e);
                        }
                    }
                } else {
                    Closer.close(is);
                }
            }
            return null;
        }

        public static synchronized int getPIDFromProcSelfStat(Object o) {
            int pid = -1;
            if (!getPIDEnabled) {
                return -1;
            }
            if (!procSelfStatEnabled) {
                return -1;
            }
            String pidString = OSThread.getFieldFromProcSelfStat(0, o);
            if (null == pidString) {
                return -1;
            }
            try {
                pid = Integer.parseInt(pidString.trim());
            }
            catch (NumberFormatException e) {
                Logger.error(o, "Caught NumberFormatException in Integer.parseInt() of OSThread.getPIDFromProcSelfStat() while parsing '" + pidString + "'", (Throwable)e);
            }
            return pid;
        }

        public static synchronized int getPPIDFromProcSelfStat(Object o) {
            int ppid = -1;
            if (!getPPIDEnabled) {
                return -1;
            }
            if (!procSelfStatEnabled) {
                return -1;
            }
            String ppidString = OSThread.getFieldFromProcSelfStat(3, o);
            if (null == ppidString) {
                return -1;
            }
            try {
                ppid = Integer.parseInt(ppidString.trim());
            }
            catch (NumberFormatException e) {
                Logger.error(o, "Caught NumberFormatException in Integer.parseInt() of OSThread.getPPIDFromProcSelfStat() while parsing '" + ppidString + "'", (Throwable)e);
            }
            return ppid;
        }

        public static synchronized int logPID(Object o) {
            if (!getPIDEnabled) {
                return -1;
            }
            int pid = OSThread.getPID(o);
            String msg = -1 != pid ? "This thread's OS PID is " + pid : "This thread's OS PID could not be determined";
            if (logToStdOutEnabled) {
                System.out.println(msg + ": " + o);
            }
            if (logToFileEnabled) {
                Logger.logStatic(o, msg, logToFileVerbosity);
            }
            return pid;
        }

        public static synchronized int logPPID(Object o) {
            if (!getPPIDEnabled) {
                return -1;
            }
            int ppid = OSThread.getPPID(o);
            String msg = -1 != ppid ? "This thread's OS PPID is " + ppid : "This thread's OS PPID could not be determined";
            if (logToStdOutEnabled) {
                System.out.println(msg + ": " + o);
            }
            if (logToFileEnabled) {
                Logger.logStatic(o, msg, logToFileVerbosity);
            }
            return ppid;
        }
    }
}

