/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.config.InvalidConfigValueException;
import freenet.config.SubConfig;
import freenet.node.NodeStarter;
import freenet.support.Logger;
import freenet.support.api.BooleanCallback;
import freenet.support.api.IntCallback;
import freenet.support.api.StringCallback;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.ServerSocket;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public class SSL {
    private static final String KEY_ALGORITHM = "EC";
    private static final int KEY_SIZE = 256;
    private static final String SIG_ALGORITHM = "SHA256WithECDSA";
    private static final long CERTIFICATE_LIFETIME = 315360000L;
    private static final String CERTIFICATE_CN = "Freenet";
    private static final String CERTIFICATE_OU = "Freenet";
    private static final String CERTIFICATE_ON = "Freenet";
    private static final String CHAIN_ALIAS = "freenet";
    private static volatile boolean enable;
    private static KeyStore keystore;
    private static ServerSocketFactory ssf;
    private static String keyStore;
    private static String keyStorePass;
    private static String keyPass;
    private static int HSTSMaxAge;

    public static boolean available() {
        return ssf != null;
    }

    public static String getHSTSHeader() {
        if (SSL.available() && HSTSMaxAge > 0) {
            return "max-age=" + HSTSMaxAge;
        }
        return "";
    }

    public static void init(SubConfig sslConfig) {
        int configItemOrder = 0;
        sslConfig.register("sslEnable", false, configItemOrder++, true, true, "SSL.enable", "SSL.enable", new BooleanCallback(){

            @Override
            public Boolean get() {
                return enable;
            }

            @Override
            public void set(Boolean newValue) throws InvalidConfigValueException {
                if (!this.get().equals(newValue)) {
                    enable = newValue;
                    if (enable) {
                        try {
                            SSL.loadKeyStoreAndCreateCertificate();
                            SSL.createSSLContext();
                        }
                        catch (Exception e) {
                            enable = false;
                            e.printStackTrace(System.out);
                            SSL.throwConfigError("SSL could not be enabled", e);
                        }
                    } else {
                        ssf = null;
                        keyStore = null;
                    }
                }
            }
        });
        sslConfig.register("sslKeyStore", "datastore/certs", configItemOrder++, true, true, "SSL.keyStore", "SSL.keyStoreLong", new StringCallback(){

            @Override
            public String get() {
                return keyStore;
            }

            @Override
            public void set(String newKeyStore) throws InvalidConfigValueException {
                if (!newKeyStore.equals(this.get())) {
                    String oldKeyStore = keyStore;
                    keyStore = newKeyStore;
                    try {
                        SSL.loadKeyStore();
                    }
                    catch (Exception e) {
                        keyStore = oldKeyStore;
                        e.printStackTrace(System.out);
                        SSL.throwConfigError("Keystore file could not be changed", e);
                    }
                }
            }
        });
        sslConfig.register("sslKeyStorePass", CHAIN_ALIAS, configItemOrder++, true, true, "SSL.keyStorePass", "SSL.keyStorePass", new StringCallback(){

            @Override
            public String get() {
                return keyStorePass;
            }

            @Override
            public void set(String newKeyStorePass) throws InvalidConfigValueException {
                if (!newKeyStorePass.equals(this.get())) {
                    String oldKeyStorePass = keyStorePass;
                    keyStorePass = newKeyStorePass;
                    try {
                        SSL.storeKeyStore();
                    }
                    catch (Exception e) {
                        keyStorePass = oldKeyStorePass;
                        e.printStackTrace(System.out);
                        SSL.throwConfigError("Keystore password could not be changed", e);
                    }
                }
            }
        });
        sslConfig.register("sslKeyPass", CHAIN_ALIAS, configItemOrder++, true, true, "SSL.keyPass", "SSL.keyPass", new StringCallback(){

            @Override
            public String get() {
                return keyPass;
            }

            @Override
            public void set(String newKeyPass) throws InvalidConfigValueException {
                if (!newKeyPass.equals(this.get())) {
                    String oldKeyPass = keyPass;
                    keyPass = newKeyPass;
                    try {
                        Certificate[] chain = keystore.getCertificateChain(SSL.CHAIN_ALIAS);
                        Key privKey = keystore.getKey(SSL.CHAIN_ALIAS, oldKeyPass.toCharArray());
                        keystore.setKeyEntry(SSL.CHAIN_ALIAS, privKey, keyPass.toCharArray(), chain);
                        SSL.createSSLContext();
                    }
                    catch (Exception e) {
                        keyPass = oldKeyPass;
                        e.printStackTrace(System.out);
                        SSL.throwConfigError("Private key password could not be changed", e);
                    }
                }
            }
        });
        sslConfig.register("sslHSTS", 0, configItemOrder++, true, true, "SSL.HSTS", "SSL.HSTSLong", new IntCallback(){

            @Override
            public Integer get() {
                return HSTSMaxAge;
            }

            @Override
            public void set(Integer newHSTSMaxAge) throws InvalidConfigValueException {
                if (newHSTSMaxAge < 0) {
                    SSL.throwConfigError("HSTS Max age must be not less than 0", new IllegalArgumentException());
                } else {
                    HSTSMaxAge = newHSTSMaxAge;
                }
            }
        });
        enable = sslConfig.getBoolean("sslEnable");
        keyStore = sslConfig.getString("sslKeyStore");
        keyStorePass = sslConfig.getString("sslKeyStorePass");
        keyPass = sslConfig.getString("sslKeyPass");
        HSTSMaxAge = sslConfig.getInt("sslHSTS");
        try {
            keystore = KeyStore.getInstance("PKCS12");
            SSL.loadKeyStore();
            SSL.createSSLContext();
        }
        catch (Exception e) {
            Logger.error(SSL.class, "Keystore cannot be loaded, SSL will be disabled", (Throwable)e);
        }
        finally {
            if (enable && !SSL.available()) {
                Logger.error(SSL.class, "SSL cannot be enabled!");
            } else if (enable) {
                Logger.normal(SSL.class, "SSL is enabled.");
            }
            sslConfig.finishedInitialization();
        }
    }

    public static ServerSocket createServerSocket() throws IOException {
        if (ssf == null) {
            throw new IOException("SSL not initialized");
        }
        return ssf.createServerSocket();
    }

    private static void loadKeyStore() throws NoSuchAlgorithmException, CertificateException, IOException {
        if (enable) {
            try (FileInputStream fis = new FileInputStream(keyStore);){
                keystore.load(fis, keyStorePass.toCharArray());
            }
            catch (FileNotFoundException fnfe) {
                keystore.load(null, keyStorePass.toCharArray());
            }
        }
    }

    private static void loadKeyStoreAndCreateCertificate() throws NoSuchAlgorithmException, CertificateException, IOException, IllegalArgumentException, KeyStoreException, UnrecoverableKeyException, KeyManagementException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (enable) {
            try (FileInputStream fis = new FileInputStream(keyStore);){
                keystore.load(fis, keyStorePass.toCharArray());
            }
            catch (FileNotFoundException fnfe) {
                SSL.createSelfSignedCertificate();
            }
        }
    }

    private static void createSelfSignedCertificate() throws NoSuchAlgorithmException, CertificateException, IOException, IllegalArgumentException, KeyStoreException, UnrecoverableKeyException, KeyManagementException, InvalidKeyException, NoSuchProviderException, SignatureException {
        keystore.load(null, keyStorePass.toCharArray());
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM, "BC");
        keyPairGenerator.initialize(256, NodeStarter.getGlobalSecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        X500Principal dnName = new X500Principal("CN=Freenet, OU=Freenet");
        certGen.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
        certGen.setSubjectDN(new X509Name("dc=Freenet"));
        certGen.setIssuerDN(dnName);
        certGen.setNotBefore(new Date(System.currentTimeMillis()));
        certGen.setNotAfter(new Date(System.currentTimeMillis() + 315360000000L));
        certGen.setPublicKey(keyPair.getPublic());
        certGen.setSignatureAlgorithm(SIG_ALGORITHM);
        certGen.addExtension(X509Extensions.ExtendedKeyUsage, true, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_timeStamping));
        X509Certificate cert = certGen.generate(keyPair.getPrivate(), "BC");
        PrivateKey privKey = keyPair.getPrivate();
        Certificate[] chain = new Certificate[]{cert};
        keystore.setKeyEntry(CHAIN_ALIAS, privKey, keyPass.toCharArray(), chain);
        SSL.storeKeyStore();
        SSL.createSSLContext();
    }

    private static void storeKeyStore() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (enable) {
            try (FileOutputStream fos = new FileOutputStream(keyStore);){
                keystore.store(fos, keyStorePass.toCharArray());
            }
        }
    }

    private static void createSSLContext() throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, KeyManagementException {
        if (enable) {
            if (keystore.size() == 0) {
                return;
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(keystore, keyPass.toCharArray());
            SSLContext sslc = SSLContext.getInstance("TLSv1.2");
            sslc.init(kmf.getKeyManagers(), null, null);
            ssf = sslc.getServerSocketFactory();
        }
    }

    private static void throwConfigError(String message, Throwable cause) throws InvalidConfigValueException {
        String causeMsg = cause.getMessage();
        if (causeMsg == null) {
            causeMsg = cause.toString();
        }
        throw new InvalidConfigValueException(String.format("%s: %s", message, causeMsg));
    }
}

